/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.rts;

import java.awt.Color;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.FilteredImageSource;
import java.awt.image.MemoryImageSource;
import java.awt.image.RGBImageFilter;
import java.io.FileInputStream;
import java.io.InputStream;

public class BMPImage {
    private static final int BITMAPFILEHEADER = 14;
    private static final int BITMAPINFOHEADER = 40;

    public static Image createImage(InputStream inputStream) {
        return BMPImage.createImage(inputStream, true);
    }

    public static Image createImage(InputStream inputStream, boolean bl) {
        Image image = null;
        try {
            byte[] byArray = new byte[14];
            inputStream.read(byArray, 0, 14);
            if (byArray[0] != 66 || byArray[1] != 77) {
                return image;
            }
            byte[] byArray2 = new byte[40];
            inputStream.read(byArray2, 0, 40);
            int n2 = (byArray2[7] & 0xFF) << 24 | (byArray2[6] & 0xFF) << 16 | (byArray2[5] & 0xFF) << 8 | byArray2[4] & 0xFF;
            int n3 = (byArray2[11] & 0xFF) << 24 | (byArray2[10] & 0xFF) << 16 | (byArray2[9] & 0xFF) << 8 | byArray2[8] & 0xFF;
            int n4 = (byArray2[15] & 0xFF) << 8 | byArray2[14] & 0xFF;
            int n5 = (byArray2[23] & 0xFF) << 24 | (byArray2[22] & 0xFF) << 16 | (byArray2[21] & 0xFF) << 8 | byArray2[20] & 0xFF;
            if (n5 == 0) {
                n5 = (n2 * n4 + 31 & 0xFFFFFFE0) >> 3;
                n5 *= n3;
            }
            int n6 = (byArray2[35] & 0xFF) << 24 | (byArray2[34] & 0xFF) << 16 | (byArray2[33] & 0xFF) << 8 | byArray2[32] & 0xFF;
            if (n4 == 24) {
                int n7 = n5 / n3 - n2 * 3;
                int[] nArray = new int[n3 * n2];
                byte[] byArray3 = new byte[(n2 + n7) * 3 * n3];
                inputStream.read(byArray3, 0, (n2 + n7) * 3 * n3);
                int n8 = 0;
                for (int i2 = 0; i2 < n3; ++i2) {
                    for (int i3 = 0; i3 < n2; ++i3) {
                        nArray[n2 * (n3 - i2 - 1) + i3] = 0xFF000000 | (byArray3[n8 + 2] & 0xFF) << 16 | (byArray3[n8 + 1] & 0xFF) << 8 | byArray3[n8] & 0xFF;
                        n8 += 3;
                    }
                    n8 += n7;
                }
                image = Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(n2, n3, nArray, 0, n2));
            } else if (n4 == 8 || n4 == 4) {
                byte[] byArray4;
                int n9;
                int n10;
                int n11 = 0;
                n11 = n6 > 0 ? n6 : 1 << n4;
                int[] nArray = new int[n11];
                byte[] byArray5 = new byte[n11 * 4];
                inputStream.read(byArray5, 0, n11 * 4);
                int n12 = 0;
                for (n10 = 0; n10 < n11; ++n10) {
                    nArray[n10] = 0xFF000000 | (byArray5[n12 + 2] & 0xFF) << 16 | (byArray5[n12 + 1] & 0xFF) << 8 | byArray5[n12] & 0xFF;
                    n12 += 4;
                }
                if (n4 == 4) {
                    n9 = (n2 * n4 + 31 & 0xFFFFFFE0) >> 3;
                    byArray4 = new byte[((n9 + (n10 -= ((n10 = n5 / n3 * 2 - n2) & 1) > 0 ? 1 : 0)) * 2 * n3 + 1) / 2];
                } else {
                    n10 = n5 / n3 - n2;
                    byArray4 = new byte[(n2 + n10) * n3];
                }
                int[] nArray2 = new int[n2 * n3];
                inputStream.read(byArray4, 0, byArray4.length);
                n12 = 0;
                if (n4 == 4) {
                    for (n9 = 0; n9 < n3; ++n9) {
                        for (int i4 = 0; i4 < n2; ++i4) {
                            nArray2[n2 * (n3 - n9 - 1) + i4] = nArray[(byArray4[n12 / 2] & 0xF0) >> 4];
                            ++n12;
                            if (++i4 < n2) {
                                nArray2[n2 * (n3 - n9 - 1) + i4] = nArray[byArray4[n12 / 2] & 0xF];
                            }
                            ++n12;
                        }
                        n12 += n10;
                    }
                } else {
                    for (n9 = 0; n9 < n3; ++n9) {
                        for (int i5 = 0; i5 < n2; ++i5) {
                            nArray2[n2 * (n3 - n9 - 1) + i5] = nArray[byArray4[n12] & 0xFF];
                            ++n12;
                        }
                        n12 += n10;
                    }
                }
                image = Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(n2, n3, nArray2, 0, n2));
            }
            inputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (image != null && bl) {
            image = BMPImage.makeColorTransparent(image, Color.lightGray);
        }
        return image;
    }

    public static Image createImage(String string) {
        return BMPImage.createImage(string, true);
    }

    public static Image createImage(String string, boolean bl) {
        Image image = null;
        try {
            FileInputStream fileInputStream = new FileInputStream(string);
            image = BMPImage.createImage(fileInputStream, bl);
            fileInputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return image;
    }

    public static Image makeColorTransparent(Image image, final Color color) {
        RGBImageFilter rGBImageFilter = new RGBImageFilter(){
            public int markerRGB;
            {
                this.markerRGB = color.getRGB() | 0xFF000000;
            }

            @Override
            public final int filterRGB(int n2, int n3, int n4) {
                if ((n4 | 0xFF000000) == this.markerRGB) {
                    return 0xFFFFFF & n4;
                }
                return n4;
            }
        };
        FilteredImageSource filteredImageSource = new FilteredImageSource(image.getSource(), rGBImageFilter);
        return Toolkit.getDefaultToolkit().createImage(filteredImageSource);
    }
}

