/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.rts;

import com.iscobol.rts.LocalStorageProvider;

public class CallBiStack {
    private static final int INCR_SIZE = 32;
    private CallObj[] calls = new CallObj[32];
    private int allocated = 32;
    private int size;
    private int main;

    public void pushMain(Object object, Object[] objectArray, Object object2, String string) {
        this.main = 1;
        this.push(object, objectArray, object2, string);
    }

    public void push(Object object, Object[] objectArray, Object object2, String string) {
        if (this.size == this.allocated) {
            int n2 = this.calls.length;
            this.allocated = n2 + 32;
            CallObj[] callObjArray = new CallObj[this.allocated];
            System.arraycopy(this.calls, 0, callObjArray, 0, n2);
            this.calls = callObjArray;
        }
        CallObj callObj = new CallObj();
        callObj.call = object;
        callObj.argv = objectArray;
        callObj.tls = object2;
        callObj.name = string;
        if (object instanceof LocalStorageProvider) {
            callObj.ls = ((LocalStorageProvider)object).newLocalStorage();
        }
        this.calls[this.size] = callObj;
        ++this.size;
    }

    public void pop() {
        --this.size;
        this.calls[this.size] = null;
    }

    public int size() {
        return this.size;
    }

    public boolean isCalled() {
        return this.size - this.main > 0;
    }

    public Object peekCall() {
        if (this.size > 0) {
            return this.calls[this.size - 1].call;
        }
        return null;
    }

    public String peekName() {
        if (this.size > 0) {
            return this.calls[this.size - 1].name;
        }
        return null;
    }

    public Object[] peekArgv() {
        if (this.size > 0) {
            return this.calls[this.size - 1].argv;
        }
        return null;
    }

    public Object callAt(int n2) {
        return this.calls[n2].call;
    }

    public Object[] argvAt(int n2) {
        return this.calls[n2].argv;
    }

    public Object localStorageAt(int n2) {
        return this.calls[n2].ls;
    }

    public Object threadLocalStorageAt(int n2) {
        return this.calls[n2].tls;
    }

    public int searchCall(Object object) {
        for (int i2 = 0; i2 < this.size; ++i2) {
            if (this.calls[i2].call != object) continue;
            return i2;
        }
        return -1;
    }

    private static class CallObj {
        Object call;
        String name;
        Object[] argv;
        Object ls;
        Object tls;

        private CallObj() {
        }
    }
}

