/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.rts;

import com.iscobol.logger.Logger;
import com.iscobol.logger.LoggerFactory;
import com.iscobol.rts.Config;
import com.iscobol.rts.ICoverage;
import com.iscobol.rts.IscobolSystem;
import com.iscobol.rts.OSValidator;
import com.iscobol.rts.RuntimeInfo;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;

public class CallLoader {
    public static final String separator = File.separator;
    public static final char separatorChar = File.separatorChar;
    public static final String ext = ".class";
    public static final int RELOAD_ON_DEMAND = 0;
    public static final int RELOAD_WHEN_MODIFIED = 1;
    public static final int RELOAD_ALL_ON_DEMAND = 2;
    private static Map<String, LoaderWithTime> fastRepos = new ConcurrentHashMap<String, LoaderWithTime>();
    private static Map<String, LoaderWithTime> repos = new ConcurrentHashMap<String, LoaderWithTime>();
    private static int codePrefixReload;
    private static SharedClassLoader currentSharedClassLoader;
    private static final File DEFAULT_LOC;
    private final SharedClassLoader sharedClassLoader;
    private final PathItem[] callpath;
    private final boolean applyCodePath;

    private CallLoader(String[] stringArray, boolean bl, SharedClassLoader sharedClassLoader) {
        this.callpath = new PathItem[stringArray.length];
        for (int i2 = 0; i2 < this.callpath.length; ++i2) {
            this.callpath[i2] = new PathItem(stringArray[i2]);
        }
        this.applyCodePath = bl;
        this.sharedClassLoader = sharedClassLoader;
    }

    public Class loadClass(String string) throws ClassNotFoundException {
        File file;
        block20: {
            File file2;
            block21: {
                Object object;
                file = new File(string);
                Path path = file.toPath();
                Path path2 = path.getRoot();
                if (path2 != null) {
                    object = path2.toString();
                    if (((String)object).equals("\\")) {
                        if (!this.applyCodePath) {
                            string = path.toAbsolutePath().getRoot().toString() + path.subpath(0, path.getNameCount()).toString();
                            file = new File(string);
                        }
                    } else if (((String)object).equals("/") && this.applyCodePath) {
                        string = path.subpath(0, path.getNameCount()).toString();
                        file = new File(string);
                    }
                }
                switch (codePrefixReload) {
                    case 0: {
                        object = fastRepos.get(string);
                        if (object != null) {
                            return ((LoaderWithTime)object).clazz;
                        }
                    }
                    default: {
                        Logger logger = LoggerFactory.get(2);
                        if (this.callpath != null && this.callpath.length > 0 && !file.isAbsolute()) {
                            ClassNotFoundException classNotFoundException = null;
                            for (int i2 = 0; i2 < this.callpath.length; ++i2) {
                                if (this.callpath[i2].isJar) {
                                    try {
                                        if (logger != null) {
                                            logger.info("TRY LOADING:" + this.callpath[i2].path + "/" + string);
                                        }
                                        return this.loadClass(this.callpath[i2].path, string);
                                    }
                                    catch (ClassNotFoundException classNotFoundException2) {
                                        classNotFoundException = classNotFoundException2;
                                        if (logger == null) continue;
                                        logger.info(this.callpath[i2].path + "/" + string + " FAILED!");
                                        continue;
                                    }
                                }
                                StringBuffer stringBuffer = new StringBuffer(this.callpath[i2].path);
                                try {
                                    stringBuffer.append(separator);
                                    stringBuffer.append(string);
                                    stringBuffer.append(ext);
                                    if (logger != null) {
                                        logger.info("TRY LOADING:" + stringBuffer.toString());
                                    }
                                    return this.loadClass(this.callpath[i2].path, new File(stringBuffer.toString()), string);
                                }
                                catch (ClassNotFoundException classNotFoundException3) {
                                    classNotFoundException = classNotFoundException3;
                                    if (logger == null) continue;
                                    logger.info(stringBuffer.toString() + " FAILED!");
                                }
                            }
                            throw classNotFoundException;
                        }
                        return this.loadClass("", new File(string + ext), string);
                    }
                    case 2: 
                }
                file2 = file.getParentFile();
                if (file2 == null) break block20;
                if (!file2.isAbsolute()) break block21;
                if (!new File(string + ext).exists()) break block20;
                CallLoader.appendURLs(this.sharedClassLoader, new String[]{file2.getPath()});
                break block20;
            }
            for (int i3 = 0; i3 < this.callpath.length; ++i3) {
                if (this.callpath[i3].isJar || !new File(this.callpath[i3].path + separator + string + ext).exists()) continue;
                CallLoader.appendURLs(this.sharedClassLoader, new String[]{this.callpath[i3].path + separator + file2.getPath()});
                break;
            }
        }
        return CallLoader.intLoadClass(file.getName(), DEFAULT_LOC, this.sharedClassLoader);
    }

    private static void appendURLs(SharedClassLoader sharedClassLoader, String[] stringArray) {
        for (String string : stringArray) {
            File file = new File(string);
            try {
                file = file.getCanonicalFile();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                sharedClassLoader.addURL(file.toURI().toURL());
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
    }

    public static CallLoader getInstance(String string) {
        return CallLoader.getInstance(string, false);
    }

    public static CallLoader getInstance(String string, boolean bl) {
        CallLoader callLoader = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n" + File.pathSeparatorChar);
        int n2 = stringTokenizer.countTokens();
        if (n2 > 0) {
            File[] fileArray;
            Object object;
            ArrayList<String> arrayList = new ArrayList<String>();
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                File file = new File(string2);
                if ("*".equals(file.getName())) {
                    File file2 = file.getParentFile();
                    if (file2 == null || !file2.exists()) continue;
                    object = file2.getPath() + File.separator;
                    for (File file3 : file2.listFiles(new FilenameFilter(){

                        @Override
                        public boolean accept(File file, String string) {
                            return string.endsWith(".jar");
                        }
                    })) {
                        arrayList.add((String)object + file3.getName());
                    }
                    continue;
                }
                if (".".equals(file.getName())) {
                    arrayList.add(0, string2);
                    continue;
                }
                arrayList.add(string2);
            }
            object = arrayList.toArray(new String[arrayList.size()]);
            if (codePrefixReload == 2) {
                fileArray = (File[])IscobolSystem.get(SharedClassLoader.class);
                if (fileArray == null) {
                    if (currentSharedClassLoader == null) {
                        currentSharedClassLoader = new SharedClassLoader();
                    }
                    fileArray = currentSharedClassLoader;
                    IscobolSystem.set(SharedClassLoader.class, fileArray);
                }
                CallLoader.appendURLs((SharedClassLoader)fileArray, object);
            } else {
                fileArray = null;
            }
            callLoader = new CallLoader((String[])object, bl, (SharedClassLoader)fileArray);
        }
        return callLoader;
    }

    private Class loadClass(String string, String string2) throws ClassNotFoundException {
        String string3 = string + "!" + string2;
        File file = new File(string);
        LoaderWithTime loaderWithTime = repos.get(string3);
        if (loaderWithTime == null || codePrefixReload == 1 && file.lastModified() != loaderWithTime.timestamp) {
            if (loaderWithTime != null) {
                try {
                    loaderWithTime.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            try {
                loaderWithTime = new LoaderWithTime(file, string2);
            }
            catch (MalformedURLException malformedURLException) {
                throw new ClassNotFoundException(string2 + ", " + malformedURLException);
            }
            repos.put(string3, loaderWithTime);
            if (codePrefixReload == 0) {
                loaderWithTime.repId = string3;
                fastRepos.put(string2, loaderWithTime);
            }
            System.gc();
        } else if (loaderWithTime != null && codePrefixReload == 0) {
            fastRepos.put(string2, loaderWithTime);
            loaderWithTime.fastRepIds.add(string2);
        }
        return loaderWithTime.clazz;
    }

    private Class loadClass(String string, File file, String string2) throws ClassNotFoundException {
        File file2;
        String string3;
        try {
            string3 = file.getCanonicalPath();
            file = new File(string3);
            file2 = file.getParentFile();
        }
        catch (IOException iOException) {
            throw new ClassNotFoundException(file.getPath() + ", " + iOException);
        }
        LoaderWithTime loaderWithTime = repos.get(string3);
        if (loaderWithTime == null || codePrefixReload == 1 && file.lastModified() != loaderWithTime.timestamp) {
            if (loaderWithTime != null) {
                try {
                    loaderWithTime.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            try {
                loaderWithTime = new LoaderWithTime(string, file2, file);
            }
            catch (MalformedURLException malformedURLException) {
                throw new ClassNotFoundException(file.getPath() + ", " + malformedURLException);
            }
            repos.put(string3, loaderWithTime);
            if (codePrefixReload == 0) {
                loaderWithTime.repId = string3;
                fastRepos.put(string2, loaderWithTime);
            }
            System.gc();
        } else if (loaderWithTime != null && codePrefixReload == 0) {
            fastRepos.put(string2, loaderWithTime);
            loaderWithTime.fastRepIds.add(string2);
        }
        return loaderWithTime.clazz;
    }

    public static int unloadClass(String[] stringArray) {
        int n2;
        String[] stringArray2;
        boolean bl;
        switch (codePrefixReload) {
            case 1: {
                return 0;
            }
            case 2: {
                currentSharedClassLoader = new SharedClassLoader();
                RuntimeInfo runtimeInfo = (RuntimeInfo)IscobolSystem.get(RuntimeInfo.class);
                if (runtimeInfo != null) {
                    switch (runtimeInfo.getRuntimeEnvironmentType()) {
                        case STANDALONE: 
                        case STANDALONE_CHARVA: 
                        case MOBILE: {
                            return 0;
                        }
                    }
                    return 1;
                }
                return 0;
            }
        }
        boolean bl2 = bl = stringArray == null;
        if (bl) {
            stringArray2 = new String[1];
        } else {
            stringArray2 = new String[stringArray.length];
            for (n2 = 0; n2 < stringArray.length; ++n2) {
                StringBuilder stringBuilder = new StringBuilder();
                StringBuilder stringBuilder2 = new StringBuilder();
                for (char n3 : stringArray[n2].toCharArray()) {
                    if (n3 == '*') {
                        if (stringBuilder2.length() > 0) {
                            stringBuilder.append(Pattern.quote(stringBuilder2.toString()));
                        }
                        stringBuilder.append(".*");
                        stringBuilder2 = new StringBuilder();
                        continue;
                    }
                    stringBuilder2.append(n3);
                }
                if (stringBuilder2.length() > 0) {
                    stringBuilder.append(Pattern.quote(stringBuilder2.toString()));
                }
                stringArray2[n2] = stringBuilder.toString();
            }
        }
        n2 = 0;
        if (stringArray2.length > 0) {
            for (Object object : fastRepos.keySet().toArray()) {
                for (String string : stringArray2) {
                    LoaderWithTime loaderWithTime;
                    if (!bl && !object.toString().matches(string) || (loaderWithTime = fastRepos.remove(object)) == null) continue;
                    try {
                        loaderWithTime.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    for (String string2 : loaderWithTime.fastRepIds) {
                        fastRepos.remove(string2);
                    }
                    repos.remove(loaderWithTime.repId);
                    ++n2;
                }
            }
        }
        if (n2 > 0) {
            System.gc();
        }
        return n2;
    }

    public static void init() {
        String string = Config.a("iscobol.code_prefix.reload", Integer.toString(1));
        try {
            codePrefixReload = Integer.parseInt(string);
            if (codePrefixReload < 0 || codePrefixReload > 2) {
                codePrefixReload = 1;
            }
        }
        catch (NumberFormatException numberFormatException) {
            codePrefixReload = Config.c(string) ? 1 : 0;
        }
    }

    public static Vector<Vector<String>> getLoadedClasses() {
        Object object;
        Vector<Vector<String>> vector = new Vector<Vector<String>>();
        if (codePrefixReload == 2) {
            return vector;
        }
        final boolean bl = OSValidator.isWindows();
        Comparator<String> comparator = new Comparator<String>(){

            @Override
            public int compare(String string, String string2) {
                return bl ? string.compareToIgnoreCase(string2) : string.compareTo(string2);
            }
        };
        TreeMap<String, TreeSet<String>> treeMap = new TreeMap<String, TreeSet<String>>(comparator);
        Map<String, LoaderWithTime> map = codePrefixReload == 1 ? repos : fastRepos;
        for (String string : map.keySet()) {
            object = map.get(string);
            String string2 = ((LoaderWithTime)object).callPath;
            TreeSet<String> treeSet = (TreeSet<String>)treeMap.get(string2);
            if (treeSet == null) {
                treeSet = new TreeSet<String>(comparator);
                treeMap.put(string2, treeSet);
            }
            treeSet.add(string + "," + ((LoaderWithTime)object).timestamp);
        }
        for (String string : treeMap.keySet()) {
            object = new Vector();
            vector.addElement((Vector<String>)object);
            ((Vector)object).addElement(string);
            for (TreeSet<String> treeSet : (Set)treeMap.get(string)) {
                ((Vector)object).addElement(treeSet);
            }
        }
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Class intLoadClass(String string, File file, ClassLoader classLoader) throws ClassNotFoundException {
        Class clazz;
        ICoverage iCoverage;
        if (IscobolSystem.isUnitTest()) {
            classLoader.setDefaultAssertionStatus(true);
        }
        if ((iCoverage = IscobolSystem.getCoverage()) != null) {
            ICoverage iCoverage2 = iCoverage;
            synchronized (iCoverage2) {
                clazz = iCoverage.loadClass(file.getAbsolutePath(), string, false, classLoader);
            }
        } else {
            clazz = classLoader.loadClass(string);
        }
        return clazz;
    }

    private static ClassLoader getParentClassLoader() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        return classLoader;
    }

    static {
        DEFAULT_LOC = new File(".");
        CallLoader.init();
    }

    public static class LoaderWithTime
    extends URLClassLoader {
        final long timestamp;
        final Class clazz;
        private final File classLocation;
        private final String callPath;
        private Vector<String> fastRepIds = new Vector();
        private String repId;

        LoaderWithTime(String string, File file, File file2) throws ClassNotFoundException, MalformedURLException {
            super(new URL[]{file.toURI().toURL()}, CallLoader.getParentClassLoader());
            this.callPath = string;
            this.classLocation = file;
            String string2 = file2.getName();
            string2 = string2.substring(0, string2.length() - CallLoader.ext.length());
            this.timestamp = file2.lastModified();
            this.clazz = CallLoader.intLoadClass(string2, this.classLocation, this);
        }

        LoaderWithTime(File file, String string) throws ClassNotFoundException, MalformedURLException {
            super(new URL[]{file.toURI().toURL()}, CallLoader.getParentClassLoader());
            this.callPath = file.getPath();
            this.classLocation = file;
            this.timestamp = file.lastModified();
            this.clazz = CallLoader.intLoadClass(string, this.classLocation, this);
        }

        public File getClassLocation() {
            return this.classLocation;
        }

        public String toString() {
            return this.getClass().getName() + "[class location: " + this.classLocation + "]";
        }
    }

    public static class SharedClassLoader
    extends URLClassLoader {
        SharedClassLoader() {
            super(new URL[0], CallLoader.getParentClassLoader());
            if (IscobolSystem.isUnitTest()) {
                this.setDefaultAssertionStatus(true);
            }
        }

        @Override
        public void addURL(URL uRL) {
            super.addURL(uRL);
        }
    }

    static final class PathItem {
        final String path;
        final boolean isJar;

        PathItem(String string) {
            this.path = string;
            this.isJar = new File(string).isFile();
        }

        public final String toString() {
            return this.path;
        }
    }
}

