/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.rts;

import com.iscobol.logger.Logger;
import com.iscobol.logger.LoggerFactory;
import com.iscobol.rts.Config;
import com.iscobol.rts.EsqlCursor;
import com.iscobol.rts.EsqlRuntime;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Vector;

public class EsqlPrepare {
    private String name;
    private boolean statNoData;
    private boolean call = false;
    private PreparedStatement hstmt;
    private int rowCount;
    private Connection con;
    private int type;
    private int holdability;
    private String query;
    private final Logger log = LoggerFactory.get(2048);
    private Vector<String> nameBind = new Vector();

    public EsqlPrepare(String string, int n2, int n3) {
        this.name = string;
        this.type = n2;
        this.holdability = n3;
    }

    public void setQuery(Connection connection, String string) throws SQLException {
        this.query = string;
        this.con = connection;
        this.statNoData = EsqlRuntime.isStatNoData(this.query);
        this.call = EsqlRuntime.isCall(this.query);
        if (this.hstmt != null) {
            try {
                if (this.log != null) {
                    this.log.info("Developers log: EsqlPrepare: before close PS " + this.hstmt);
                }
                this.hstmt.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        if (this.query.contains(":")) {
            this.getHostVars();
        }
        this.hstmt = EsqlRuntime.getStatement(this.con, this.query, this.type, this.holdability);
        if (this.log != null) {
            this.log.info("Developers log: EsqlPrepare: after open PS " + this.hstmt);
        }
    }

    public ResultSet exec(int n2, int n3, EsqlCursor esqlCursor) throws SQLException {
        if (this.type != n2 || this.holdability != n3) {
            this.type = n2;
            this.holdability = n3;
            this.hstmt = EsqlRuntime.getStatement(this.con, this.query, this.type, this.holdability);
            if (this.log != null) {
                this.log.info("Developers log: EsqlPrepare: after open PS " + this.hstmt);
            }
            esqlCursor.setParams(this.hstmt);
        }
        esqlCursor.callExecuteHook(this.query, this.hstmt);
        this.rowCount = 0;
        if (this.hstmt != null) {
            if (!this.statNoData && Config.a(".jdbc.fetch_size", 0) != 0) {
                this.hstmt.setFetchSize(Config.a(".jdbc.fetch_size", 0));
            }
            if (this.hstmt.execute()) {
                this.rowCount = 0;
                ResultSet resultSet = this.hstmt.getResultSet();
                if (this.log != null) {
                    this.log.info("Developers log: EsqlPrepare: after open RS " + this.hstmt + " call=" + this.call + " query[" + this.query + "]");
                }
                if (this.call) {
                    while (this.hstmt.getMoreResults()) {
                        if (this.log == null) continue;
                        this.log.info("Developers log: EsqlPrepare in while moreResult " + this.hstmt + " call=" + this.call);
                    }
                    if (this.log != null) {
                        this.log.info("Developers log: EsqlPrepare moreResult " + this.hstmt + " call=" + this.call);
                    }
                }
                return resultSet;
            }
            this.rowCount = this.hstmt.getUpdateCount();
            return null;
        }
        EsqlRuntime.esqlError(7, "/Syntax error");
        return null;
    }

    void setParams(EsqlCursor esqlCursor) throws SQLException {
        esqlCursor.setParams(this.hstmt);
    }

    public void close() throws SQLException {
        if (this.hstmt != null) {
            if (this.log != null) {
                this.log.info("Developers log: EsqlPrepare: before close PS " + this.hstmt);
            }
            this.hstmt.close();
        }
    }

    public boolean isStatNoData() {
        return this.statNoData;
    }

    public boolean isCall() {
        return this.call;
    }

    public int getRowCount() {
        return this.rowCount;
    }

    public String getQuery() {
        return this.query;
    }

    public String getName() {
        return this.name;
    }

    public PreparedStatement getHstmt() {
        return this.hstmt;
    }

    public Vector getNameBind() {
        return this.nameBind;
    }

    void getHostVars() {
        String string = "";
        int n2 = this.query.length();
        boolean bl = false;
        boolean bl2 = false;
        String string2 = "";
        for (int i2 = 0; i2 < n2; ++i2) {
            if (!bl2 && !bl && this.query.charAt(i2) == ':' && i2 < n2 - 1 && (this.query.charAt(i2 + 1) >= 'a' && this.query.charAt(i2 + 1) <= 'z' || this.query.charAt(i2 + 1) >= 'A' && this.query.charAt(i2 + 1) <= 'Z')) {
                string = "";
                ++i2;
                string2 = string2 + "?";
                while (i2 < n2 && this.query.charAt(i2) != ' ' && this.query.charAt(i2) != '.' && this.query.charAt(i2) != ';' && this.query.charAt(i2) != ',' && this.query.charAt(i2) != '(' && this.query.charAt(i2) != ')' && this.query.charAt(i2) != '+' && this.query.charAt(i2) != '/') {
                    string = string + this.query.charAt(i2);
                    ++i2;
                }
                if (i2 < n2) {
                    string2 = string2 + this.query.charAt(i2);
                }
                this.nameBind.addElement(string);
                continue;
            }
            string2 = string2 + this.query.charAt(i2);
            if (this.query.charAt(i2) == '\'') {
                if (!bl) {
                    bl = true;
                    continue;
                }
                bl = false;
                continue;
            }
            if (this.query.charAt(i2) != '\"') continue;
            bl2 = !bl2;
        }
        this.query = string2;
    }
}

