/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.rts;

import com.iscobol.logger.Logger;
import com.iscobol.logger.LoggerFactory;
import com.iscobol.rts.Config;
import com.iscobol.rts.EsqlCursor;
import com.iscobol.rts.EsqlCursorHndl;
import com.iscobol.rts.EsqlHostVar;
import com.iscobol.rts.EsqlOraHostVar;
import com.iscobol.rts.EsqlOraPrepStat;
import com.iscobol.rts.EsqlPrepare;
import com.iscobol.rts.EsqlPrepareHandler;
import com.iscobol.rts.EsqlSqlcaHandler;
import com.iscobol.rts.Factory;
import com.iscobol.rts.IsInitial;
import com.iscobol.rts.IscobolCall;
import com.iscobol.rts.IscobolRuntimeException;
import com.iscobol.rts.IscobolSystem;
import com.iscobol.rts.MyDataSource;
import com.iscobol.rts.ThreadDependingData;
import com.iscobol.rts.UserHandles;
import com.iscobol.types.CobolVar;
import com.iscobol.types.NumericLiteralAll;
import com.iscobol.types.NumericVar;
import com.iscobol.types.ObjectVar;
import com.iscobol.types.PicX;
import java.lang.reflect.Method;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public class EsqlRuntime {
    public static final int SQL_SUCCESS = 0;
    public static final int SQL_NO_DATA_FOUND = 100;
    public static final int SQL_ERROR = -1;
    public static final int SQL_INVALID_HANDLE = -2;
    public static final int SQL_NULL_DATA = -1;
    public static final int DB2_BLOB = 404;
    public static final int DB2_CLOB = 408;
    public static final int DB2_DECIMAL = 484;
    public static final int DB2_CHAR = 452;
    public static final int DB2_VARCHAR = 448;
    public static final int DB2_LVARCHAR = 456;
    public static final int DB2_SMALLINT = 500;
    public static final int DB2_INTEGER = 496;
    public static final int DB2_BIGINT = 492;
    public static final int DB2_FLOAT = 480;
    private static NumericVar FLOAT;
    private static NumericVar REAL;
    private static NumericVar DECIMAL;
    private static NumericVar SMALLINT;
    private static NumericVar INTEGER;
    private static NumericVar BIGINT;
    private static PicX VARCHAR;
    private static NumericVar VARCHAR_LEN;
    private static PicX VARCHAR_ARR;
    private static PicX RECVAL;
    private static NumericVar MYIND;
    static Hashtable sqlTypes;
    static Hashtable sqlTypesOra;
    static Hashtable sqlTypesOraRev;
    static Method getDBRowDataAsBytes;
    static Method getDBRowDescriptor;
    static Method exec;
    static Class[] nullParamClass;
    static Object[] nullParam;
    Object[] rowObj;
    byte[] rowData;
    int[] rowOffs;
    int[] rowInfo;
    static final NumericLiteralAll ZERO;
    public static final int ESQL_SUCCESS = 0;
    public static final int ESQL_DUPLICATE_PREPARE = 1;
    public static final int ESQL_ALREADY_CONNECTED = 2;
    public static final int ESQL_INVALID_SEQUENCE = 3;
    public static final int ESQL_INVALID_PARAMETER = 4;
    public static final int ESQL_CURSOR_NOT_DECLARED = 5;
    public static final int ESQL_INVALID_HANDLE = 6;
    public static final int ESQL_NOT_SUPPORTED = 7;
    public static final int ESQL_INVALID_DRIVER = 8;
    public static final int ESQL_INVALID_DATASOURCE = 9;
    public static final int ESQL_INTERNAL_ERROR = 10;
    public static final int ESQL_CONN_EXCEPTION = 11;
    public static final int ESQL_CONN_UNABLE = 12;
    public static final int ESQL_CONN_NAME_IN_USE = 13;
    public static final int ESQL_CONN_NOT_FOUND = 14;
    public static final int ESQL_CONN_REJECTED = 15;
    public static final int ESQL_CONN_FAILURE = 16;
    public static final int ESQL_CONN_TRANS_UNKNOWN = 17;
    public static final int ESQL_DATA_TRUNCATION = 18;
    public static final int ESQL_JDBC = 19;
    public static final String[][] allErrors;
    public static final int CURS_INCR = 10;
    public static final int CURS_FORWARD_ONLY = 1;
    public static final int CURS_SCROLL_INSENSITIVE = 2;
    public static final int CURS_SCROLL_SENSITIVE = 3;
    public static final int DEFAULT_HOLD = 0;
    public static final int NO_TRUNC = 1;
    public static final int OPENSQL_TRUNC = 2;
    public static final int PROCOBOL_TRUNC = 3;
    private IscobolCall executeHook;
    private Connection defConn;
    private String defName;
    private Hashtable connectionPool;
    private Hashtable procedureTypes;
    private Hashtable procedureTypeNames;
    private Hashtable sqldaTable;
    private EsqlSqlca actSqlca;
    private static EsqlSqlca curSqlca;
    private EsqlSqlda actSqlda;
    private EsqlSqldaDb2 actSqldaDb2;
    private int numTdd;
    private final int cursorType;
    private Logger log;
    private Logger logDP;
    private static final int concurrency;
    private static final String modeIODef;
    private static final boolean warnings;
    private static final boolean automaticConnection;
    public static final int db2DataRowAsByteThreshold;
    public static final int picXHandling;
    public static final int codeNull;
    public static final int noData;
    public static final int tooManyRows;
    private static final int typeIndTrunk;
    private static final int errorFact;
    private static final String classSqlcaDecoderName;
    private static final Class classSqlcaDecoder;
    private static final Method methodSqlcaDecoder;
    private static final EsqlSqlcaHandler handlerSqlcaDecoder;
    private static final String classPrepareDecoderName;
    private static final Class classPrepareDecoder;
    private static final Method methodPrepareDecoder;
    private static final EsqlPrepareHandler handlerPrepareDecoder;
    private static final SQLWarning dataTruncation;

    public EsqlRuntime() {
        block8: {
            this.rowObj = null;
            this.rowData = null;
            this.rowOffs = null;
            this.rowInfo = null;
            this.connectionPool = new Hashtable();
            this.procedureTypes = new Hashtable();
            this.procedureTypeNames = new Hashtable();
            this.sqldaTable = new Hashtable();
            this.actSqldaDb2 = null;
            this.numTdd = 0;
            this.log = LoggerFactory.get(256);
            this.logDP = LoggerFactory.get(2048);
            switch (Config.a(".jdbc.cursor.type", 1)) {
                default: {
                    this.cursorType = 1003;
                    break;
                }
                case 2: {
                    this.cursorType = 1004;
                    break;
                }
                case 3: {
                    this.cursorType = 1005;
                }
            }
            String string = Config.a(".esql.execute.hook", (String)null);
            if (string != null) {
                try {
                    this.executeHook = (IscobolCall)Class.forName(string).newInstance();
                    if (this.log != null) {
                        this.log.info("Execute Hook enabled: " + string);
                    }
                }
                catch (Exception exception) {
                    if (this.log == null) break block8;
                    this.log.warning("Execute Hook disabled (" + exception + ")");
                }
            }
        }
    }

    boolean hasExecuteHook() {
        return this.executeHook != null;
    }

    public static EsqlRuntime get() {
        EsqlRuntime esqlRuntime = (EsqlRuntime)IscobolSystem.get(EsqlRuntime.class);
        if (esqlRuntime == null) {
            esqlRuntime = new EsqlRuntime();
            IscobolSystem.set(EsqlRuntime.class, esqlRuntime);
        }
        return esqlRuntime;
    }

    public static void stopRun(Thread thread) {
        EsqlRuntime esqlRuntime = (EsqlRuntime)IscobolSystem.getIfExists(EsqlRuntime.class, thread);
        if (esqlRuntime != null && esqlRuntime.connectionPool != null) {
            Logger logger = esqlRuntime.log;
            String string = Config.a(".jdbc.on_stop_run", null);
            Enumeration enumeration = esqlRuntime.connectionPool.elements();
            while (enumeration.hasMoreElements()) {
                Connection connection = (Connection)enumeration.nextElement();
                if (string != null) {
                    if (string.equalsIgnoreCase("commit")) {
                        try {
                            connection.commit();
                            if (logger != null) {
                                logger.info("EsqlRuntime: STOP RUN commit  connection [" + connection + ((EsqlSqlca)Factory.getCurrent().getTdd().sqlca).strNumTdd + "] driver [" + connection.getMetaData().getDriverName() + " " + connection.getMetaData().getDriverVersion() + "] user name [" + connection.getMetaData().getUserName() + "]");
                            }
                        }
                        catch (SQLException sQLException) {}
                    } else if (string.equalsIgnoreCase("rollback")) {
                        try {
                            connection.rollback();
                            if (logger != null) {
                                logger.info("EsqlRuntime: STOP RUN rollback  connection [" + connection + ((EsqlSqlca)Factory.getCurrent().getTdd().sqlca).strNumTdd + "] driver [" + connection.getMetaData().getDriverName() + " " + connection.getMetaData().getDriverVersion() + "] user name [" + connection.getMetaData().getUserName() + "]");
                            }
                        }
                        catch (SQLException sQLException) {
                            // empty catch block
                        }
                    }
                }
                try {
                    if (logger != null) {
                        logger.info("EsqlRuntime: STOP RUN close  connection [" + connection + ((EsqlSqlca)Factory.getCurrent().getTdd().sqlca).strNumTdd + "] driver [" + connection.getMetaData().getDriverName() + " " + connection.getMetaData().getDriverVersion() + "] user name [" + connection.getMetaData().getUserName() + "]");
                    }
                    connection.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    public static PreparedStatement getStatement(Connection connection, String string, int n2, int n3) throws SQLException {
        return EsqlRuntime.getStatement(connection, string, n2, n3, false);
    }

    public static PreparedStatement getStatement(Connection connection, String string, int n2, int n3, boolean bl) throws SQLException {
        PreparedStatement preparedStatement;
        if (string.trim().length() > 0 && string.trim().charAt(0) == '{') {
            preparedStatement = n3 != 0 ? connection.prepareCall(string, n2, concurrency, n3) : (n2 != 1003 ? connection.prepareCall(string, n2, concurrency) : connection.prepareCall(string));
        } else {
            int n4 = concurrency;
            if (bl) {
                n4 = 1008;
            }
            preparedStatement = n3 != 0 ? connection.prepareStatement(string, n2, n4, n3) : connection.prepareStatement(string, n2, n4);
        }
        return preparedStatement;
    }

    public static Object remove() {
        return IscobolSystem.get(EsqlRuntime.class);
    }

    public static boolean isStatNoData(String string) {
        String string2 = string.trim().toUpperCase();
        return string2.startsWith("DELETE") || string2.startsWith("UPDATE") || string2.startsWith("INSERT");
    }

    public static boolean isCall(String string) {
        return string.trim().toUpperCase().startsWith("{CALL");
    }

    public static boolean hasParameters(String string) {
        char[] cArray = string.toCharArray();
        for (int i2 = 0; i2 < cArray.length; ++i2) {
            if (cArray[i2] != '?') continue;
            return true;
        }
        return false;
    }

    public EsqlPrepare prepareFactory(String string, int n2, int n3) {
        EsqlPrepare esqlPrepare;
        if (string != null) {
            esqlPrepare = (EsqlPrepare)this.getSqlca().allPrepares.get(string);
            if (esqlPrepare == null) {
                esqlPrepare = new EsqlPrepare(string, n2, n3);
                this.getSqlca().allPrepares.put(string, esqlPrepare);
            }
        } else {
            esqlPrepare = new EsqlPrepare(string, n2, n3);
        }
        return esqlPrepare;
    }

    public synchronized EsqlCursor cursorFactory(String string, Object object) {
        return this.cursorFactory(string, object, 0, 0);
    }

    public synchronized EsqlCursor cursorFactory(String string, Object object, int n2, Object object2) {
        EsqlCursor esqlCursor = null;
        int n3 = this.cursorType;
        if (n2 == 2) {
            n3 = 1005;
        } else if (n2 == 3) {
            n3 = 1004;
        }
        if (string != null) {
            this.actSqlca = this.getSqlca();
            for (int i2 = this.actSqlca.allCursors.size() - 1; i2 >= 0; --i2) {
                esqlCursor = (EsqlCursor)this.actSqlca.allCursors.get(i2);
                if (!esqlCursor.is(string, object)) continue;
                return esqlCursor;
            }
            esqlCursor = new EsqlCursor(string, n3, object, object2);
            this.getSqlca().allCursors.addElement(esqlCursor);
        } else {
            esqlCursor = new EsqlCursor(string, n3, object, object2);
        }
        return esqlCursor;
    }

    static void esqlError(int n2, String string) throws SQLException {
        int n3;
        for (n3 = 0; n3 < 19 && n3 != n2; ++n3) {
        }
        throw new SQLException(allErrors[n3][1] + string, allErrors[n3][0], 32000 + n2);
    }

    private void clearSqlca(CobolVar cobolVar) {
        ThreadDependingData threadDependingData = Factory.getCurrent().getTdd();
        this.log = LoggerFactory.get(256);
        this.logDP = LoggerFactory.get(2048);
        if (threadDependingData.sqlca_n != null) {
            this.connectionPool = threadDependingData.connectionPool;
        } else {
            threadDependingData.connectionPool = this.connectionPool;
        }
        if (threadDependingData.sqlca == null) {
            threadDependingData.sqlca = new EsqlSqlca(cobolVar);
            if (threadDependingData.sqlca_n == null) {
                threadDependingData.numEsqlTdd = this.numTdd++;
            } else {
                this.numTdd = threadDependingData.numEsqlTdd + 1;
            }
            ((EsqlSqlca)threadDependingData.sqlca).errDecode = Config.g();
            ((EsqlSqlca)threadDependingData.sqlca).numTdd = this.numTdd;
            ((EsqlSqlca)threadDependingData.sqlca).currName = this.defName;
            ((EsqlSqlca)threadDependingData.sqlca).currConn = this.defConn;
            if (this.log != null) {
                this.log.info("EsqlRuntime NEW THREAD: [" + threadDependingData + "] strNumTdd [" + this.numTdd + "]");
            }
        }
        this.actSqlca = this.getSqlca();
        this.actSqlca.SQLCA.link(cobolVar);
        this.actSqlca.SQLCAID.set("SQLCA   ");
        this.actSqlca.SQLWARN.set("        ");
        this.actSqlca.SQLCABC.set(this.getSqlca().SQLCA.getLength());
        this.actSqlca.SQLCODE.set(this.decodeErr(0));
        this.actSqlca.SQLSTATE.set("00000");
        this.actSqlca.SQLERRML.set(0);
        this.actSqlca.SQLERRMC.set("");
        int n2 = 1;
        while (n2 <= 6) {
            this.actSqlca.SQLERRD.at(new int[]{n2++}).set(0);
        }
        curSqlca = this.actSqlca;
    }

    void fillSqlca(SQLException sQLException, CobolVar cobolVar) {
        block12: {
            this.actSqlca = this.getSqlca();
            this.actSqlca.SQLCA.link(cobolVar);
            if (sQLException != null) {
                String string = sQLException.getSQLState();
                if (string == null) {
                    string = "XXXXX";
                }
                this.actSqlca.SQLSTATE.set(string);
                this.actSqlca.SQLERRMC.set(sQLException.getMessage());
                this.actSqlca.SQLERRML.set(sQLException.getMessage().length());
                if (sQLException instanceof SQLWarning) {
                    if (warnings) {
                        this.actSqlca.SQLCODE.set(this.decodeErr(sQLException.getErrorCode()));
                    } else {
                        this.actSqlca.SQLCODE.set(this.decodeErr(0));
                    }
                    this.actSqlca.SQLWARN0.set("W");
                    if (string.charAt(4) == '4') {
                        this.actSqlca.SQLWARN1.set("W");
                    }
                } else {
                    int n2 = sQLException.getErrorCode();
                    n2 = errorFact * (n2 == 0 ? 99999 : n2);
                    this.actSqlca.SQLCODE.set(this.decodeErr(n2));
                }
            }
            if (methodSqlcaDecoder != null) {
                try {
                    if (this.log != null) {
                        this.log.info("EsqlRuntime: before invoke method sqlcaDecoder " + methodSqlcaDecoder.toString() + "SQLCODE=" + this.actSqlca.SQLCODE);
                    }
                    handlerSqlcaDecoder.sqlcaDecoder(sQLException, this.actSqlca.SQLCODE, this.actSqlca.SQLSTATE, this.actSqlca.SQLERRMC);
                    if (this.log != null) {
                        this.log.info("EsqlRuntime: after invoke method sqlcaDecoder " + methodSqlcaDecoder.toString() + "SQLCODE=" + this.actSqlca.SQLCODE);
                    }
                }
                catch (Exception exception) {
                    if (this.log == null) break block12;
                    this.log.info("EsqlRuntime: invoking method sqlcaDecoder of " + classSqlcaDecoderName + " there is the following exception " + exception);
                }
            }
        }
    }

    void fillSqlca(int n2, CobolVar cobolVar, EsqlCursor esqlCursor) {
        block12: {
            SQLWarning sQLWarning = warnings && esqlCursor != null ? esqlCursor.getWarnings() : null;
            this.actSqlca = this.getSqlca();
            switch (n2) {
                case 0: {
                    if (sQLWarning == null) break;
                    this.fillSqlca(sQLWarning, cobolVar);
                    break;
                }
                case 1: {
                    this.actSqlca.SQLCA.link(cobolVar);
                    if (sQLWarning != null) {
                        this.fillSqlca(sQLWarning, cobolVar);
                        break;
                    }
                    this.fillSqlca(dataTruncation, cobolVar);
                    break;
                }
                case -1: {
                    this.actSqlca.SQLCA.link(cobolVar);
                    this.actSqlca.SQLCODE.set(this.decodeErr(100));
                    this.actSqlca.SQLSTATE.set("02000");
                    break;
                }
                default: {
                    if (Config.a(".esql.value_too_many_rows", 0) != n2) {
                        throw new IscobolRuntimeException(3, "fillSqlca I");
                    }
                    this.actSqlca.SQLCA.link(cobolVar);
                    this.actSqlca.SQLCODE.set(this.decodeErr(n2));
                }
            }
            if (methodSqlcaDecoder != null) {
                try {
                    if (this.log != null) {
                        this.log.info("EsqlRuntime: before invoke method sqlcaDecoder " + methodSqlcaDecoder.toString() + "SQLCODE=" + this.actSqlca.SQLCODE);
                    }
                    handlerSqlcaDecoder.sqlcaDecoder(sQLWarning, this.actSqlca.SQLCODE, this.actSqlca.SQLSTATE, this.actSqlca.SQLERRMC);
                    if (this.log != null) {
                        this.log.info("EsqlRuntime: after invoke method sqlcaDecoder " + methodSqlcaDecoder.toString() + "SQLCODE=" + this.actSqlca.SQLCODE);
                    }
                }
                catch (Exception exception) {
                    if (this.log == null) break block12;
                    this.log.info("EsqlRuntime: invoking method sqlcaDecoder " + methodSqlcaDecoder.toString());
                    this.log.info("EsqlRuntime: invoking method sqlcaDecoder of " + classSqlcaDecoderName + " there is the following exception " + exception);
                }
            }
        }
    }

    public boolean connect(CobolVar cobolVar, String string, String string2, String string3) {
        return this.connect(cobolVar, string, string2, string3, "DEFAULT");
    }

    public synchronized boolean connect(CobolVar cobolVar, String string, String string2, String string3, String string4) {
        this.clearSqlca(cobolVar);
        String string5 = string2;
        String string6 = string3;
        String string7 = null;
        String string8 = Config.a(".jdbc.driver", "");
        String string9 = Config.a(".jdbc.url", "");
        if (string5 == null || string5.length() == 0) {
            string5 = Config.a(".jdbc.user", "");
        }
        if (string6 == null || string6.length() == 0) {
            string6 = Config.a(".jdbc.password", "");
        }
        try {
            Connection connection;
            Object object;
            int n2;
            this.actSqlca.strNumTdd = this.actSqlca.numTdd > 1 && Config.b(".jdbc.thread_connection", false) ? "_TH" + this.actSqlca.numTdd : "";
            if (this.connectionPool.get(string4.toUpperCase() + this.actSqlca.strNumTdd) != null) {
                EsqlRuntime.esqlError(2, "");
            }
            if (this.log != null) {
                this.log.info("EsqlRuntime: CONNECT id [" + string4 + this.actSqlca.strNumTdd + "]");
            }
            String string10 = Config.a(".jdbc.datasource", null);
            boolean bl = Config.b(".jdbc.autocommit", false);
            if ((string6 == null || string6.length() == 0) && string5 != null && (n2 = string5.indexOf(47)) > 0) {
                string6 = string5.substring(n2 + 1, string5.length());
                string5 = string5.substring(0, n2);
            }
            if (string10 != null) {
                try {
                    object = (MyDataSource)Class.forName(string10).newInstance();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new IscobolRuntimeException(3, "" + classNotFoundException);
                }
                catch (InstantiationException instantiationException) {
                    throw new IscobolRuntimeException(3, "" + instantiationException);
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new IscobolRuntimeException(3, "" + illegalAccessException);
                }
                catch (ClassCastException classCastException) {
                    throw new IscobolRuntimeException(3, "" + classCastException);
                }
                if (this.log != null) {
                    String string11 = "";
                    if (string6 != null && string6.length() != 0) {
                        string11 = "********Encrypted Value******";
                    }
                    String string12 = "EsqlRuntime: CONNECTING driver [" + string8 + "] dsn [" + string + "] user [" + string5 + "] password [" + string11 + "] with datasource [" + object + "]";
                    this.log.info(string12);
                }
                connection = object.connect(string, string5, string6);
            } else {
                String string13;
                String string14;
                if (!string4.equalsIgnoreCase("DEFAULT")) {
                    string8 = Config.a(".jdbc.driver." + string4.toLowerCase().trim(), string8);
                    string9 = Config.a(".jdbc.url." + string4.toLowerCase().trim(), string9);
                }
                try {
                    Class.forName(string8);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new IscobolRuntimeException(3, "" + classNotFoundException);
                }
                object = Config.a(".jdbc.connection.login.timeout", null);
                if (object != null) {
                    DriverManager.setLoginTimeout(Integer.parseInt((String)object));
                }
                if (this.log != null) {
                    string14 = "";
                    if (string6 != null && string6.length() != 0) {
                        string14 = "********Encrypted Value******";
                    }
                    string13 = "EsqlRuntime: CONNECTING driver [" + string8 + "] url [" + string9 + "] dsn [" + string + "] user [" + string5 + "] password [" + string14 + "]";
                    this.log.info(string13);
                }
                if (!(string5 != null && string5.length() != 0 || string6 != null && string6.length() != 0)) {
                    string7 = Config.a(".jdbc.options", null);
                    if (string7 == null) {
                        connection = DriverManager.getConnection(string9 + string);
                    } else {
                        StringTokenizer stringTokenizer = new StringTokenizer(string7, ",");
                        Properties properties = new Properties();
                        while (stringTokenizer.hasMoreElements()) {
                            string14 = stringTokenizer.nextToken();
                            int n3 = string14.indexOf(61);
                            if (n3 <= 0) continue;
                            string13 = string14.substring(n3 + 1);
                            string14 = string14.substring(0, n3);
                            properties.setProperty(string14, string13);
                        }
                        connection = DriverManager.getConnection(string9 + string, properties);
                    }
                } else {
                    string7 = "ignored";
                    connection = DriverManager.getConnection(string9 + string, string5, string6);
                }
            }
            if (connection == null) {
                EsqlRuntime.esqlError(12, string);
            }
            try {
                connection.setAutoCommit(bl);
                this.actSqlca.currConn = connection;
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            this.actSqlca.currName = string4;
            if (this.actSqlca.strNumTdd.equals("")) {
                this.defName = string4;
                this.defConn = connection;
            }
            this.connectionPool.put(string4.toUpperCase() + this.actSqlca.strNumTdd, connection);
            if (this.log != null) {
                object = "";
                if (string6 != null && string6.length() != 0) {
                    object = "********Encrypted Value******";
                }
                this.log.info("EsqlRuntime: CONNECT  connection [" + connection + "] connection ID [" + string4 + "] strNumTdd [" + this.actSqlca.strNumTdd + "] driver [" + connection.getMetaData().getDriverName() + " " + connection.getMetaData().getDriverVersion() + "] url [" + connection.getMetaData().getURL() + "] user name [" + connection.getMetaData().getUserName() + "] password[" + (String)object + "] SQLCA [" + this.actSqlca.sqlcaType + "]] SQLCODE [" + this.actSqlca.SQLCODE.toString() + "]");
            }
            return true;
        }
        catch (SQLException sQLException) {
            this.fillSqlca(sQLException, cobolVar);
            if (this.log != null) {
                this.log.info("EsqlRuntime: CONNECT  exception [" + sQLException + "] connection ID [" + string4 + "] SQLCA [" + this.actSqlca.sqlcaType + "]] SQLCODE [" + this.actSqlca.SQLCODE.toString() + "]");
            }
            return false;
        }
    }

    public boolean disconnect(CobolVar cobolVar) {
        return this.disconnect(cobolVar, true);
    }

    public synchronized boolean disconnect(CobolVar cobolVar, boolean bl) {
        boolean bl2 = true;
        this.clearSqlca(cobolVar);
        try {
            if (bl) {
                if (this.connectionPool.isEmpty()) {
                    EsqlRuntime.esqlError(14, "");
                }
                Enumeration enumeration = this.connectionPool.elements();
                while (enumeration.hasMoreElements()) {
                    ((Connection)enumeration.nextElement()).close();
                }
                this.connectionPool.clear();
                this.actSqlca.allSelect.clear();
                this.actSqlca.allSavepoint.clear();
                this.actSqlca.currConn = null;
                this.actSqlca.currName = null;
            } else {
                if (this.getCConn() == null) {
                    EsqlRuntime.esqlError(14, "");
                }
                if (this.log != null && this.getCConn() != null) {
                    this.log.info("EsqlRuntime: DISCONNECT  current  connection [" + this.getCName() + this.actSqlca.strNumTdd + "] driver [" + this.getCConn().getMetaData().getDriverName() + " " + this.getCConn().getMetaData().getDriverVersion() + "] user name [" + this.getCConn().getMetaData().getUserName() + "]");
                } else if (this.log != null) {
                    this.log.info("EsqlRuntime: DISCONNECT  current  connection null ");
                }
                this.getCConn().close();
                this.connectionPool.remove(this.getCName().toUpperCase() + this.actSqlca.strNumTdd);
                Enumeration enumeration = this.actSqlca.allSelect.keys();
                while (enumeration.hasMoreElements()) {
                    String string = (String)enumeration.nextElement();
                    if (!string.startsWith(this.getCName().trim() + "--")) continue;
                    this.actSqlca.allSelect.remove(string);
                }
                this.actSqlca.currConn = null;
                this.actSqlca.currName = null;
            }
            if (this.log != null && bl) {
                this.log.info("EsqlRuntime: DISCONNECT ALL, SQLCODE [" + this.actSqlca.SQLCODE.toString() + "]");
            }
        }
        catch (SQLException sQLException) {
            this.fillSqlca(sQLException, cobolVar);
            if (this.log != null && bl) {
                this.log.info("EsqlRuntime: DISCONNECT ALL, exception [" + sQLException + "]");
            } else if (this.log != null && this.getCConn() != null) {
                this.log.info("EsqlRuntime: DISCONNECT  current, exception [" + sQLException + "]");
            }
            return false;
        }
        return true;
    }

    public synchronized boolean disconnect(CobolVar cobolVar, String string) {
        this.clearSqlca(cobolVar);
        Connection connection = (Connection)this.connectionPool.get(string.toUpperCase() + this.actSqlca.strNumTdd);
        try {
            if (connection == null) {
                EsqlRuntime.esqlError(14, string);
            }
            if (this.log != null && connection != null) {
                this.log.info("EsqlRuntime: DISCONNECT  id [" + string + "] connection [" + connection + "] strNumTdd [" + this.actSqlca.strNumTdd + "] driver [" + connection.getMetaData().getDriverName() + " " + connection.getMetaData().getDriverVersion() + "] user name [" + connection.getMetaData().getUserName() + "]");
            } else if (this.log != null) {
                this.log.info("EsqlRuntime: DISCONNECT  id [" + string + "] connection NULL");
            }
            connection.close();
            this.connectionPool.remove(string.toUpperCase() + this.actSqlca.strNumTdd);
            Enumeration enumeration = this.actSqlca.allSelect.keys();
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                if (!string2.startsWith(this.getCName().trim() + "--")) continue;
                this.actSqlca.allSelect.remove(string2);
            }
            if (connection == this.getCConn()) {
                this.actSqlca.currConn = (Connection)this.connectionPool.get("DEFAULT" + this.actSqlca.strNumTdd);
                this.actSqlca.currName = this.actSqlca.currConn == null ? null : "DEFAULT";
            }
        }
        catch (SQLException sQLException) {
            this.fillSqlca(sQLException, cobolVar);
            if (this.log != null) {
                this.log.info("EsqlRuntime: DISCONNECT  id [" + string + "] exception [" + sQLException + "]");
            }
            return false;
        }
        return true;
    }

    public synchronized boolean setConnection(CobolVar cobolVar, String string) {
        this.clearSqlca(cobolVar);
        this.actSqlca.strNumTdd = this.actSqlca.numTdd > 1 && Config.b(".jdbc.thread_connection", false) ? "_TH" + this.actSqlca.numTdd : "";
        Connection connection = (Connection)this.connectionPool.get(string.toUpperCase() + this.actSqlca.strNumTdd);
        try {
            if (connection == null) {
                EsqlRuntime.esqlError(14, string);
                if (this.log != null) {
                    this.log.info("EsqlRuntime: SET CONNECT id [" + string + this.actSqlca.strNumTdd + "] not found");
                }
            } else if (connection != this.getCConn()) {
                this.actSqlca.currConn = connection;
                this.actSqlca.currName = string;
                if (this.actSqlca.strNumTdd.equals("")) {
                    this.defConn = connection;
                    this.defName = string;
                }
                if (this.log != null && connection != null) {
                    this.log.info("EsqlRuntime: SET CONNECT  id [" + string + this.actSqlca.strNumTdd + "] connection [" + connection + this.actSqlca.strNumTdd + "] driver [" + connection.getMetaData().getDriverName() + " " + connection.getMetaData().getDriverVersion() + "] user name [" + connection.getMetaData().getUserName() + "]");
                }
            }
        }
        catch (SQLException sQLException) {
            this.fillSqlca(sQLException, cobolVar);
            if (this.log != null) {
                this.log.info("EsqlRuntime: SET CONNECT id [" + string + this.actSqlca.strNumTdd + "] exception [" + sQLException + "]");
            }
            return false;
        }
        return true;
    }

    private int getHoldability(Object object) {
        int n2 = 0;
        if (object != null) {
            if ("1".equals(object)) {
                n2 = 1;
            } else if ("2".equals(object)) {
                n2 = 2;
            }
        }
        return n2;
    }

    public int declareStmt(CobolVar cobolVar, String string, String string2, Object object, Object object2) {
        return this.declareStmt(cobolVar, string, string2, object, object2, false);
    }

    public int declareStmt(CobolVar cobolVar, String string, String string2, Object object, Object object2, boolean bl) {
        return this.declareStmt(cobolVar, string, string2, object, object2, bl, 0, null);
    }

    public synchronized int declareStmt(CobolVar cobolVar, String string, String string2, Object object, Object object2, boolean bl, int n2, Object object3) {
        this.clearSqlca(cobolVar);
        EsqlCursor esqlCursor = this.cursorFactory(string, object2, n2, object3);
        esqlCursor.setQuery(string2.trim());
        esqlCursor.setHoldability(this.getHoldability(object));
        if (bl) {
            esqlCursor.setUpdatable();
        }
        if (this.log != null) {
            this.log.info("EsqlRuntime: DECLARE STMT connection [" + (this.getCName() == null ? "invalid --> NULL" : this.getCName()) + this.actSqlca.strNumTdd + "] name [" + string + "] sensitive [" + n2 + "] statement [" + string2 + "] SQLCODE [" + this.actSqlca.SQLCODE.toString() + "]");
        }
        return esqlCursor.getHandle();
    }

    public synchronized int declareStmtOracle(CobolVar cobolVar, String string, String string2, Object object, Object object2) {
        return this.declareStmtOracle(cobolVar, string, string2, object, object2, 0);
    }

    public synchronized int declareStmtOracle(CobolVar cobolVar, String string, String string2, Object object, Object object2, int n2) {
        this.clearSqlca(cobolVar);
        EsqlOraPrepStat esqlOraPrepStat = new EsqlOraPrepStat("callable", 0, 0);
        try {
            esqlOraPrepStat.setQuery(this.getCConn(), string2.trim());
            if (this.log != null) {
                this.log.info("EsqlRuntime: DECLARE STMTC ORACLE connection [" + (this.getCName() == null ? "invalid --> NULL" : this.getCName()) + this.actSqlca.strNumTdd + "] name [" + string + "] sensitive [" + n2 + "] statement [" + string2 + "] SQLCODE [" + this.actSqlca.SQLCODE.toString() + "]");
            }
        }
        catch (SQLException sQLException) {
            this.fillSqlca(sQLException, cobolVar);
            if (this.log != null) {
                this.log.info("EsqlRuntime: DECLARE STMC  ORACLE[" + this.actSqlca.strNumTdd + "] exception [" + sQLException + "]");
            }
            return 0;
        }
        return esqlOraPrepStat.getHandle();
    }

    public synchronized int declare(CobolVar cobolVar, String string, Object object, Object object2, Object object3) {
        return this.declare(cobolVar, string, object, object2, object3, null);
    }

    public synchronized int declare(CobolVar cobolVar, String string, Object object, Object object2, Object object3, Object object4) {
        this.clearSqlca(cobolVar);
        EsqlCursor esqlCursor = this.cursorFactory(string, object3, 0, object4);
        esqlCursor.setHoldability(this.getHoldability(object2));
        if (object instanceof String) {
            esqlCursor.setPrepName((String)object);
        } else {
            esqlCursor.setPrepName("" + object);
        }
        if (object instanceof ObjectVar) {
            Object object5 = ((ObjectVar)object).getId();
            if (this.actSqlca.allCursHndl.get(object) != null) {
                this.actSqlca.allCursHndl.remove(object);
            }
            if (string != null) {
                this.actSqlca.allCursHndl.put(object, esqlCursor);
            }
            if (object5 instanceof EsqlPrepare) {
                esqlCursor.setPrepare((EsqlPrepare)object5);
            } else {
                try {
                    EsqlRuntime.esqlError(6, object.toString());
                }
                catch (SQLException sQLException) {
                    this.fillSqlca(sQLException, cobolVar);
                    return 0;
                }
            }
        } else {
            esqlCursor.setPrepare(this.prepareFactory(object.toString(), esqlCursor.getType(), esqlCursor.getHoldability()));
        }
        if (this.log != null) {
            this.log.info("EsqlRuntime: DECLARE connection [" + (this.getCName() == null ? "invalid --> NULL" : this.getCName()) + this.actSqlca.strNumTdd + "] name [" + string + "] statement [" + (esqlCursor == null ? "invalid --> NULL" : esqlCursor.getQuery()) + "] SQLCODE [" + this.actSqlca.SQLCODE.toString() + "]");
        }
        return esqlCursor.getHandle();
    }

    public synchronized int getCursorHandle(String string, Object object) {
        this.actSqlca = this.getSqlca();
        for (int i2 = this.actSqlca.allCursors.size() - 1; i2 >= 0; --i2) {
            EsqlCursor esqlCursor = (EsqlCursor)this.actSqlca.allCursors.get(i2);
            if (!esqlCursor.is(string, object)) continue;
            return esqlCursor.getHandle();
        }
        return 0;
    }

    private synchronized EsqlCursor getCursor(ObjectVar objectVar) throws SQLException {
        return this.getCursor(objectVar, (Object)null);
    }

    private synchronized EsqlCursor getCursor(ObjectVar objectVar, Object object) throws SQLException {
        EsqlCursor esqlCursor = null;
        try {
            esqlCursor = (EsqlCursor)objectVar.getId();
            if (esqlCursor == null && object != null) {
                String string = objectVar.getName().substring(10);
                this.actSqlca = this.getSqlca();
                for (int i2 = this.actSqlca.allCursors.size() - 1; i2 >= 0; --i2) {
                    EsqlCursor esqlCursor2 = (EsqlCursor)this.actSqlca.allCursors.get(i2);
                    if (esqlCursor2 == null || !esqlCursor2.name.equalsIgnoreCase(string) || !esqlCursor2.owner.getClass().toString().equals(object.getClass().toString())) continue;
                    esqlCursor = esqlCursor2;
                }
            }
            if (esqlCursor == null) {
                EsqlRuntime.esqlError(6, "" + objectVar.toString());
            }
        }
        catch (ClassCastException classCastException) {
            EsqlRuntime.esqlError(6, "" + objectVar.getId());
        }
        return esqlCursor;
    }

    public synchronized boolean getCursor(CobolVar cobolVar, ObjectVar objectVar) {
        return this.getCursor(cobolVar, objectVar, null);
    }

    public synchronized boolean getCursor(CobolVar cobolVar, ObjectVar objectVar, Object object) {
        this.clearSqlca(cobolVar);
        try {
            EsqlCursor esqlCursor = this.getCursor(objectVar, object);
        }
        catch (SQLException sQLException) {
            this.fillSqlca(sQLException, cobolVar);
            return false;
        }
        return true;
    }

    public synchronized boolean closeCursor(CobolVar cobolVar, ObjectVar objectVar) {
        return this.closeCursor(cobolVar, objectVar, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean closeCursor(CobolVar cobolVar, ObjectVar objectVar, Object object) {
        EsqlCursor esqlCursor = null;
        this.clearSqlca(cobolVar);
        try {
            esqlCursor = this.getCursor(objectVar);
            if (this.log != null) {
                this.log.info("EsqlRuntime: CLOSE CURSOR connection [" + (this.getCName() == null ? "invalid --> NULL" : this.getCName()) + this.actSqlca.strNumTdd + "] name [" + esqlCursor.name + "]");
            }
            esqlCursor.close();
            if (this.actSqlca.allCursHndl.get(objectVar) != null) {
                Vector vector = this.actSqlca.allCursors;
                synchronized (vector) {
                    for (int i2 = this.actSqlca.allCursors.size() - 1; i2 >= 0; --i2) {
                        esqlCursor = (EsqlCursor)this.actSqlca.allCursors.get(i2);
                        if (esqlCursor != (EsqlCursor)this.actSqlca.allCursHndl.get(objectVar)) continue;
                        this.actSqlca.allCursors.remove(i2);
                        break;
                    }
                }
                this.actSqlca.allCursHndl.remove(objectVar);
            }
            objectVar.free();
        }
        catch (SQLException sQLException) {
            this.fillSqlca(sQLException, cobolVar);
            if (this.log != null) {
                this.log.info("EsqlRuntime: CLOSE CURSOR connection [" + (this.getCName() == null ? "invalid --> NULL" : this.getCName()) + this.actSqlca.strNumTdd + "]] exception [" + sQLException + "] SQLCODE [" + this.actSqlca.SQLCODE.toString() + "]");
            }
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean closeCursor(CobolVar cobolVar, String string, Object object) {
        EsqlCursor esqlCursor = null;
        this.clearSqlca(cobolVar);
        try {
            Vector vector = this.actSqlca.allCursors;
            synchronized (vector) {
                for (int i2 = this.actSqlca.allCursors.size() - 1; i2 >= 0; --i2) {
                    esqlCursor = (EsqlCursor)this.actSqlca.allCursors.get(i2);
                    if (!esqlCursor.is(string, object)) continue;
                    if (this.log != null) {
                        this.log.info("EsqlRuntime: CLOSE CURSOR connection [" + (this.getCName() == null ? "invalid --> NULL" : this.getCName()) + this.actSqlca.strNumTdd + "] name [" + esqlCursor.name + "]");
                    }
                    esqlCursor.close();
                    this.actSqlca.allCursors.remove(i2);
                    break;
                }
            }
        }
        catch (SQLException sQLException) {
            this.fillSqlca(sQLException, cobolVar);
            if (this.log != null) {
                this.log.info("EsqlRuntime: CLOSE CURSOR connection [" + (this.getCName() == null ? "invalid --> NULL" : this.getCName()) + this.actSqlca.strNumTdd + "] exception [" + sQLException + " name [" + (esqlCursor == null ? "invalid --> NULL" : esqlCursor.name) + "] SQLCODE [" + this.actSqlca.SQLCODE.toString() + "]");
            }
            return false;
        }
        return true;
    }

    public boolean bindCol(ObjectVar objectVar, CobolVar cobolVar, int n2, int n3, NumericVar numericVar, NumericVar numericVar2) {
        return this.bindCol(objectVar, cobolVar, n2, n3, numericVar, numericVar2, null);
    }

    public boolean bindCol(ObjectVar objectVar, CobolVar cobolVar, int n2, int n3, NumericVar numericVar, NumericVar numericVar2, Object object) {
        try {
            EsqlCursor esqlCursor = this.getCursor(objectVar, object);
            esqlCursor.bindCol(cobolVar, n2, n3, numericVar, numericVar2);
        }
        catch (SQLException sQLException) {
            return false;
        }
        return true;
    }

    public boolean bindColOra(ObjectVar objectVar, CobolVar cobolVar, int n2, int n3, NumericVar numericVar, NumericVar numericVar2) {
        try {
            EsqlOraPrepStat esqlOraPrepStat = (EsqlOraPrepStat)UserHandles.getId(objectVar.toint());
            esqlOraPrepStat.bindCol(cobolVar, n2, n3, numericVar, numericVar2);
        }
        catch (SQLException sQLException) {
            return false;
        }
        return true;
    }

    public boolean getObject(ObjectVar objectVar, CobolVar cobolVar, int n2, int n3, NumericVar numericVar, NumericVar numericVar2) {
        this.actSqlca = this.getSqlca();
        try {
            ResultSet resultSet = null;
            if (objectVar.getId() instanceof ResultSet) {
                resultSet = (ResultSet)objectVar.getId();
            } else {
                EsqlRuntime.esqlError(6, "" + objectVar.getId());
            }
            if (this.actSqlca.hv == null) {
                this.actSqlca.hv = new EsqlHostVar(cobolVar, n2, n3, numericVar, numericVar2);
            } else {
                this.actSqlca.hv.setHostVar(cobolVar, n2, n3, numericVar, numericVar2, null);
            }
            return this.actSqlca.hv.toVar(n3, resultSet);
        }
        catch (SQLException sQLException) {
            this.actSqlca.SQLCODE.set(this.decodeErr(100));
            this.actSqlca.SQLSTATE.set("02000");
            if (this.log != null) {
                this.log.info("EsqlRuntime: exception in getObject connection [" + (this.getCName() == null ? "invalid --> NULL" : this.getCName()) + this.actSqlca.strNumTdd + "] Exception [" + sQLException + "] var [" + cobolVar.getName() + "] thread [" + Factory.getCurrent().getTdd() + "] hndl [" + objectVar.getId() + "] SQLCODE [" + this.actSqlca.SQLCODE.toString() + "]");
            }
            return false;
        }
    }

    public boolean setParam(ObjectVar objectVar, CobolVar cobolVar, int n2, int n3, NumericVar numericVar, NumericVar numericVar2, String string) {
        return this.setParam(objectVar, cobolVar, n2, n3, numericVar, numericVar2, string, null);
    }

    public boolean setParam(ObjectVar objectVar, CobolVar cobolVar, int n2, int n3, NumericVar numericVar, NumericVar numericVar2, String string, Object object) {
        return this.setParam(objectVar, cobolVar, n2, n3, numericVar, numericVar2, string, object, (short)-1);
    }

    public boolean setParam(ObjectVar objectVar, CobolVar cobolVar, int n2, int n3, NumericVar numericVar, NumericVar numericVar2, String string, Object object, short s2) {
        try {
            EsqlCursor esqlCursor = this.getCursor(objectVar, object);
            esqlCursor.setParam(cobolVar, n2, n3, numericVar, numericVar2, string, s2);
        }
        catch (SQLException sQLException) {
            return false;
        }
        return true;
    }

    public boolean setParamOra(ObjectVar objectVar, CobolVar cobolVar, int n2, int n3, NumericVar numericVar, NumericVar numericVar2, String string) {
        return this.setParamOra(objectVar, cobolVar, n2, n3, numericVar, numericVar2, string, (short)-1);
    }

    public boolean setParamOra(ObjectVar objectVar, CobolVar cobolVar, int n2, int n3, NumericVar numericVar, NumericVar numericVar2, String string, short s2) {
        try {
            EsqlOraPrepStat esqlOraPrepStat = (EsqlOraPrepStat)UserHandles.getId(objectVar.toint());
            esqlOraPrepStat.setParam(cobolVar, n2, n3, numericVar, numericVar2, s2);
        }
        catch (SQLException sQLException) {
            return false;
        }
        return true;
    }

    public boolean setParamQ(ObjectVar objectVar, CobolVar cobolVar, int n2, int n3, NumericVar numericVar, NumericVar numericVar2, String string) {
        return this.setParamQ(objectVar, cobolVar, n2, n3, numericVar, numericVar2, string, (short)-1);
    }

    public boolean setParamQ(ObjectVar objectVar, CobolVar cobolVar, int n2, int n3, NumericVar numericVar, NumericVar numericVar2, String string, short s2) {
        int n4 = Config.a(".jdbc.kept_spaces", 1);
        this.actSqlca = this.getSqlca();
        try {
            PreparedStatement preparedStatement = (PreparedStatement)objectVar.getId();
            if (this.actSqlca.hv == null) {
                this.actSqlca.hv = new EsqlHostVar(cobolVar, n2, n3, numericVar, numericVar2, null, s2);
            } else {
                this.actSqlca.hv.setHostVar(cobolVar, n2, n3, numericVar, numericVar2, null, s2);
            }
            this.actSqlca.hv.fromVar(n3, preparedStatement, n4);
        }
        catch (Exception exception) {
            if (this.log != null) {
                this.log.info("EsqlRuntime: setParamq connection [" + (this.getCName() == null ? "invalid --> NULL" : this.getCName()) + this.actSqlca.strNumTdd + "] exception " + exception + "] SQLCODE [" + this.actSqlca.SQLCODE.toString() + "]");
            }
            return false;
        }
        return true;
    }

    public synchronized boolean open(CobolVar cobolVar, ObjectVar objectVar) {
        return this.open(cobolVar, objectVar, false);
    }

    public synchronized boolean open(CobolVar cobolVar, ObjectVar objectVar, boolean bl) {
        EsqlCursor esqlCursor = null;
        this.clearSqlca(cobolVar);
        try {
            if (this.getCConn() == null) {
                EsqlRuntime.esqlError(3, ": Missing connection");
            }
            esqlCursor = this.getCursor(objectVar);
            esqlCursor.setRowset(bl);
            esqlCursor.open(this.getCConn());
            esqlCursor.descr = null;
            if (warnings) {
                this.fillSqlca(esqlCursor.getWarnings(), cobolVar);
            }
            if (this.log != null) {
                this.log.info("EsqlRuntime: OPEN CURSOR connection [" + (this.getCName() == null ? "invalid --> NULL" : this.getCName()) + this.actSqlca.strNumTdd + "] name [" + esqlCursor.name + "] statement [" + esqlCursor.getQueryLog() + "] SQLCODE [" + this.actSqlca.SQLCODE.toString() + "]");
            }
        }
        catch (SQLException sQLException) {
            this.fillSqlca(sQLException, cobolVar);
            if (this.log != null) {
                this.log.info("EsqlRuntime: OPEN CURSOR connection [" + (this.getCName() == null ? "invalid --> NULL" : this.getCName()) + this.actSqlca.strNumTdd + "] name [" + (esqlCursor == null ? "invalid --> NULL" : esqlCursor.name) + "] statement [" + (esqlCursor == null ? "invalid --> NULL" : esqlCursor.getQueryLog()) + "] exception [" + sQLException + "] SQLCODE [" + this.actSqlca.SQLCODE.toString() + "]");
            }
            return false;
        }
        return true;
    }

    public synchronized boolean openDescr(CobolVar cobolVar, String string, ObjectVar objectVar, CobolVar cobolVar2, Object object) {
        PreparedStatement preparedStatement = null;
        ParameterMetaData parameterMetaData = null;
        ResultSetMetaData resultSetMetaData = null;
        int n2 = 0;
        this.clearSqlca(cobolVar);
        try {
            if (this.getCConn() == null) {
                EsqlRuntime.esqlError(3, ": Missing connection");
            }
            EsqlCursor esqlCursor = (EsqlCursor)objectVar.getId();
            preparedStatement = ((EsqlPrepare)this.getSqlca().allPrepares.get(esqlCursor.getPrepName())).getHstmt();
            parameterMetaData = preparedStatement.getParameterMetaData();
            resultSetMetaData = preparedStatement.getMetaData();
            this.linkSqlda(cobolVar2);
            if (this.actSqlda.allOpenDescr.containsKey(string)) {
                this.actSqlda.allOpenDescr.replace(string, cobolVar2);
            } else {
                this.actSqlda.allOpenDescr.put(string, cobolVar2);
            }
            Object var11_12 = null;
            CobolVar cobolVar3 = null;
            Vector<EsqlHostVar> vector = new Vector<EsqlHostVar>();
            n2 = parameterMetaData.getParameterCount();
            int n3 = 1;
            int n4 = 1;
            vector.addElement(null);
            for (int i2 = 1; i2 <= n2; ++i2) {
                n3 = sqlTypesOraRev.containsKey(this.actSqlda.DVTYP.atNC(i2).toint()) ? (Integer)sqlTypesOraRev.get(this.actSqlda.DVTYP.atNC(i2).toint()) : 1;
                n4 = this.actSqlda.DVLN.atNC(i2).toint();
                switch (n3) {
                    case 6: 
                    case 7: 
                    case 8: {
                        if (n4 <= 21) {
                            cobolVar3 = Factory.getVarFloat(Factory.getMem(4), 0, 4, false, null, null, null, "v" + i2, false, 18, 0, true, false, false);
                            break;
                        }
                        if (REAL != null) break;
                        cobolVar3 = Factory.getVarDouble(Factory.getMem(8), 0, 8, false, null, null, null, "v" + i2, false, 3, 0, true, false, false);
                        break;
                    }
                    case 5: {
                        cobolVar3 = Factory.getVarBinary(Factory.getMem(2), 0, 2, false, null, null, null, "v" + i2, false, 4, 0, true, false, false);
                        break;
                    }
                    case 4: {
                        cobolVar3 = Factory.getVarBinary(Factory.getMem(4), 0, 4, false, null, null, null, "v" + i2, false, 9, 0, true, false, false);
                        break;
                    }
                    case -5: {
                        cobolVar3 = Factory.getVarBinary(Factory.getMem(4), 0, 4, false, null, null, null, "v1", false, 18, 0, true, false, false);
                        break;
                    }
                    case 3: {
                        cobolVar3 = Factory.getVarPackedAcu(Factory.getMem(n4 / 2 + 1), 0, n4 / 2 + 1, false, null, null, null, "v" + i2, false, n4, resultSetMetaData.getScale(i2), true, false, false);
                        break;
                    }
                    default: {
                        cobolVar3 = Factory.getVarAlphanum(Factory.getMem(n4), 0, n4, false, null, null, null, "v" + i2, false, false);
                    }
                }
                cobolVar3.link((CobolVar)this.actSqlda.DV.atNC(i2).getOId());
                MYIND = Factory.getVarBinary(Factory.getMem(2), 0, 2, false, null, null, null, "MYIND", false, 4, 0, true, false, false, false);
                vector.addElement(new EsqlHostVar(cobolVar3, n3, i2, MYIND, Factory.getNumLiteral(n4, n4, 0, false)));
            }
            EsqlRuntime.setParams(preparedStatement, vector);
            esqlCursor.open(this.getCConn());
            if (this.log != null) {
                this.log.info("EsqlRuntime: OPEN DESCRIPTOR connection [" + (this.getCName() == null ? "invalid --> NULL" : this.getCName()) + this.actSqlca.strNumTdd + "]] stmt [" + preparedStatement + "] parCount [" + n2 + "] into variable [" + cobolVar2.getName() + "] SQLCODE [" + this.actSqlca.SQLCODE.toString() + "]] SQLERRMC [" + this.actSqlca.SQLERRMC.toString() + "]");
            }
        }
        catch (SQLException sQLException) {
            this.fillSqlca(sQLException, cobolVar);
            if (this.log != null) {
                this.log.info("EsqlRuntime: OPEN DESCRIPTOR connection [" + (this.getCName() == null ? "invalid --> NULL" : this.getCName()) + this.actSqlca.strNumTdd + "]] parCount [" + n2 + "] into variable [" + cobolVar2.getName() + "] SQLCODE [" + this.actSqlca.SQLCODE.toString() + "]] SQLERRMC [" + this.actSqlca.SQLERRMC.toString() + "]" + sQLException);
            }
            return false;
        }
        return true;
    }

    public synchronized boolean openRowset(CobolVar cobolVar, ObjectVar objectVar) {
        boolean bl = this.open(cobolVar, objectVar, true);
        return bl;
    }

    public synchronized boolean openDescrDb2(CobolVar cobolVar, ObjectVar objectVar, CobolVar cobolVar2) {
        PreparedStatement preparedStatement = null;
        ResultSetMetaData resultSetMetaData = null;
        int n2 = 0;
        this.clearSqlca(cobolVar);
        try {
            this.linkSqldaDb2(cobolVar2);
            if (this.getCConn() == null) {
                EsqlRuntime.esqlError(3, ": Missing connection");
            }
            EsqlCursor esqlCursor = this.getCursor(objectVar);
            esqlCursor.open(this.getCConn());
            if (warnings) {
                this.fillSqlca(esqlCursor.getWarnings(), cobolVar);
            }
            preparedStatement = esqlCursor.getPrep().getHstmt();
            resultSetMetaData = preparedStatement.getMetaData();
            n2 = resultSetMetaData.getColumnCount();
            if (esqlCursor.db2BindCols.size() == 0) {
                for (int i2 = 1; i2 <= n2; ++i2) {
                    esqlCursor.db2BindCols.add(null);
                }
            }
            esqlCursor.descr = cobolVar2;
            if (this.log != null) {
                this.log.info("EsqlRuntime: OPEN DESCRIPTOR DB2 connection [" + (this.getCName() == null ? "invalid --> NULL" : this.getCName()) + this.actSqlca.strNumTdd + "]] stmt [" + preparedStatement + "] parCount [" + n2 + "] into variable [" + cobolVar2.getName() + "] SQLCODE [" + this.actSqlca.SQLCODE.toString() + "]");
            }
        }
        catch (SQLException sQLException) {
            this.fillSqlca(sQLException, cobolVar);
            if (this.log != null) {
                this.log.info("EsqlRuntime: OPEN DESCRIPTOR DB2 connection [" + (this.getCName() == null ? "invalid --> NULL" : this.getCName()) + this.actSqlca.strNumTdd + "]] parCount [" + n2 + "] into variable [" + cobolVar2.getName() + "] SQLCODE [" + this.actSqlca.SQLCODE.toString() + "]");
            }
            return false;
        }
        return true;
    }

    public synchronized boolean execute(CobolVar cobolVar, ObjectVar objectVar) {
        this.clearSqlca(cobolVar);
        EsqlCursor esqlCursor = null;
        try {
            if (this.getCConn() == null) {
                EsqlRuntime.esqlError(3, ": Missing connection");
            }
            if ((esqlCursor = this.getCursor(objectVar)) == null) {
                EsqlRuntime.esqlError(6, ": Execute");
            }
            if (esqlCursor.open(this.getCConn())) {
                this.fillSqlca(esqlCursor.fetch(1, true, 0), cobolVar, esqlCursor);
                if (this.actSqlca.SQLCODE.toint() == this.decodeErr(100) && noData != 0) {
                    this.actSqlca.SQLCODE.set(noData);
                    this.actSqlca.SQLSTATE.set("02000");
                } else if (tooManyRows != 0 && esqlCursor.fetch(1, false, 0) == 0) {
                    this.actSqlca.SQLCODE.set(tooManyRows);
                    this.actSqlca.SQLSTATE.set("21000");
                }
            } else {
                if (warnings) {
                    this.fillSqlca(esqlCursor.getWarnings(), cobolVar);
                }
                this.actSqlca.SQLCA.link(cobolVar);
                this.actSqlca.SQLERRD.at(new int[]{3}).set(esqlCursor.getRowCount());
                if (esqlCursor.isStatNoData() && esqlCursor.getRowCount() == 0 && noData != 0) {
                    this.actSqlca.SQLCODE.set(noData);
                    this.actSqlca.SQLSTATE.set("02000");
                }
            }
            if (this.actSqlca.SQLCODE.num().compareTo(ZERO.num()) == 0 && esqlCursor.hasNullResult()) {
                this.setCodeNull();
            }
            esqlCursor.searchCallExc();
            if (this.log != null) {
                this.log.info("EsqlRuntime: EXECUTE  connection [" + (this.getCName() == null ? "invalid --> NULL" : this.getCName()) + this.actSqlca.strNumTdd + "] statement [" + esqlCursor.getQueryLog() + "] SQLCODE [" + this.actSqlca.SQLCODE.toString() + "]");
            }
            esqlCursor.close();
        }
        catch (SQLException sQLException) {
            this.fillSqlca(sQLException, cobolVar);
            if (this.log != null) {
                if (esqlCursor != null) {
                    this.log.info("EsqlRuntime: EXECUTE  connection [" + (this.getCName() == null ? "invalid --> NULL" : this.getCName()) + this.actSqlca.strNumTdd + "] statement [" + esqlCursor.getQueryLog() + "] SQLCODE [" + this.actSqlca.SQLCODE.toString() + "] exception [" + sQLException + "]");
                } else {
                    this.log.info("EsqlRuntime: EXECUTE  connection [" + (this.getCName() == null ? "invalid --> NULL" : this.getCName()) + this.actSqlca.strNumTdd + "]] SQLCODE [" + this.actSqlca.SQLCODE.toString() + "] exception [" + sQLException + "]");
                }
            }
            if (esqlCursor != null) {
                try {
                    esqlCursor.close();
                }
                catch (SQLException sQLException2) {
                    // empty catch block
                }
            }
            return false;
        }
        return true;
    }

    public synchronized boolean executeOracle(CobolVar cobolVar, ObjectVar objectVar) {
        this.clearSqlca(cobolVar);
        EsqlOraPrepStat esqlOraPrepStat = null;
        try {
            if (this.getCConn() == null) {
                EsqlRuntime.esqlError(3, ": Missing connection");
            }
            if ((esqlOraPrepStat = (EsqlOraPrepStat)UserHandles.getId(objectVar.toint())) == null) {
                EsqlRuntime.esqlError(6, ": Execute");
            }
            esqlOraPrepStat.exec();
            if (warnings) {
                this.fillSqlca(esqlOraPrepStat.getWarnings(), cobolVar);
            }
            this.actSqlca.SQLCA.link(cobolVar);
            this.actSqlca.SQLERRD.at(new int[]{3}).set(esqlOraPrepStat.getRowCount());
            if (this.actSqlca.SQLCODE.num().compareTo(ZERO.num()) == 0 && esqlOraPrepStat.hasNullResult()) {
                this.setCodeNull();
            }
            if (this.log != null) {
                this.log.info("EsqlRuntime: EXECUTEC ORACLE  connection [" + (this.getCName() == null ? "invalid --> NULL" : this.getCName()) + this.actSqlca.strNumTdd + "] statement [" + esqlOraPrepStat.getQueryLog() + "] SQLCODE [" + this.actSqlca.SQLCODE.toString() + "]");
            }
            UserHandles.free(objectVar.toint());
        }
        catch (SQLException sQLException) {
            this.fillSqlca(sQLException, cobolVar);
            if (this.log != null) {
                if (esqlOraPrepStat != null) {
                    this.log.info("EsqlRuntime: EXECUTE ORACLE  connection [" + (this.getCName() == null ? "invalid --> NULL" : this.getCName()) + this.actSqlca.strNumTdd + "] statement [" + esqlOraPrepStat.getQueryLog() + "] SQLCODE [" + this.actSqlca.SQLCODE.toString() + "] exception [" + sQLException + "]");
                } else {
                    this.log.info("EsqlRuntime: EXECUTEC ORACLE  connection [" + (this.getCName() == null ? "invalid --> NULL" : this.getCName()) + this.actSqlca.strNumTdd + "]] SQLCODE [" + this.actSqlca.SQLCODE.toString() + "] exception [" + sQLException + "]");
                }
            }
            if (esqlOraPrepStat != null) {
                UserHandles.free(objectVar.toint());
            }
            return false;
        }
        return true;
    }

    public synchronized boolean executeQuery(CobolVar cobolVar, ObjectVar objectVar) {
        this.clearSqlca(cobolVar);
        try {
            PreparedStatement preparedStatement = (PreparedStatement)objectVar.getId();
            if (this.getCConn() == null) {
                EsqlRuntime.esqlError(3, ": Missing connection");
            }
            if (preparedStatement == null) {
                EsqlRuntime.esqlError(6, ": Execute Query");
            }
            ResultSet resultSet = preparedStatement.executeQuery();
            if (warnings) {
                this.fillSqlca(resultSet.getWarnings(), cobolVar);
            }
            this.actSqlca.SQLCA.link(cobolVar);
            resultSet.next();
            objectVar.setId(resultSet);
            if (this.log != null) {
                this.log.info("EsqlRuntime: EXECUTE Query connection [" + (this.getCName() == null ? "invalid --> NULL" : this.getCName()) + this.actSqlca.strNumTdd + "]] stmt [" + resultSet + "] resultSet [" + resultSet + "] rows [" + resultSet.getRow() + "] SQLCODE [" + this.actSqlca.SQLCODE.toString() + "]");
            }
        }
        catch (SQLException sQLException) {
            this.fillSqlca(sQLException, cobolVar);
            if (this.log != null) {
                this.log.info("EsqlRuntime: EXECUTE query connection [" + (this.getCName() == null ? "invalid --> NULL" : this.getCName()) + this.actSqlca.strNumTdd + "]] SQLCODE [" + this.actSqlca.SQLCODE.toString() + "] exception [" + sQLException + "]");
            }
            return false;
        }
        return true;
    }

    public synchronized boolean closePreparedStatement(CobolVar cobolVar, ObjectVar objectVar) {
        this.actSqlca = this.getSqlca();
        try {
            if (this.getCConn() == null) {
                EsqlRuntime.esqlError(3, ": Missing connection");
            }
            ResultSet resultSet = null;
            if (objectVar.getId() instanceof ResultSet) {
                resultSet = (ResultSet)objectVar.getId();
            } else {
                EsqlRuntime.esqlError(6, ": Close Prepared Statement");
            }
            if (this.log != null) {
                this.log.info("EsqlRuntime: CLOSE PREPARED STATEMENT connection [" + (this.getCName() == null ? "invalid --> NULL" : this.getCName()) + this.actSqlca.strNumTdd + "] res [" + resultSet + "] SQLCODE [" + this.actSqlca.SQLCODE.toString() + "]");
            }
            if (this.logDP != null) {
                this.logDP.info("Developers log: EsqlRuntime: before close RS " + resultSet);
            }
            resultSet.close();
            objectVar.free();
        }
        catch (SQLException sQLException) {
            if (this.log != null) {
                this.log.info("EsqlRuntime: PREPARED CLOSE STATEMENT  connection [" + (this.getCName() == null ? "invalid --> NULL" : this.getCName()) + this.actSqlca.strNumTdd + "]] SQLCODE [" + this.actSqlca.SQLCODE.toString() + "] exception [" + sQLException + "]");
            }
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean executeImmediate(CobolVar cobolVar, String string) {
        this.clearSqlca(cobolVar);
        Statement statement = null;
        try {
            if (this.getCConn() == null) {
                EsqlRuntime.esqlError(3, ": Missing connection");
            }
            statement = this.getCConn().createStatement();
            if (this.logDP != null) {
                this.logDP.info("Developers log: EsqlRuntime: after open ST " + statement);
            }
            if (statement.execute(string)) {
                ResultSet resultSet = statement.getResultSet();
                if (warnings) {
                    this.fillSqlca(statement.getWarnings(), cobolVar);
                }
                if (!resultSet.next()) {
                    this.fillSqlca(-1, cobolVar, null);
                }
            } else if (warnings) {
                this.fillSqlca(statement.getWarnings(), cobolVar);
            }
            if (this.log != null) {
                this.log.info("EsqlRuntime: EXECUTE_IMMEDIATE  connection [" + (this.getCName() == null ? "invalid --> NULL" : this.getCName()) + this.actSqlca.strNumTdd + "] statement [" + string + "] SQLCODE [" + this.actSqlca.SQLCODE.toString() + "]");
            }
        }
        catch (SQLException sQLException) {
            this.fillSqlca(sQLException, cobolVar);
            if (this.log != null) {
                this.log.info("EsqlRuntime: EXECUTE_IMMEDIATE  connection [" + (this.getCName() == null ? "invalid --> NULL" : this.getCName()) + this.actSqlca.strNumTdd + "] statement [" + string + "] exception [" + sQLException + "] SQLCODE [" + this.actSqlca.SQLCODE.toString() + "]");
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (statement != null) {
                try {
                    if (this.logDP != null) {
                        this.logDP.info("Developers log: EsqlRuntime: before close ST " + statement);
                    }
                    statement.close();
                }
                catch (SQLException sQLException) {}
            }
        }
        return true;
    }

    public synchronized boolean executeDescriptorDb2(CobolVar cobolVar, String string, CobolVar cobolVar2, CobolVar cobolVar3, Object object) {
        this.clearSqlca(cobolVar);
        PreparedStatement preparedStatement = null;
        int n2 = 0;
        int n3 = 0;
        String string2 = "";
        try {
            int n4;
            Vector<CobolVar> vector;
            CobolVar cobolVar4;
            int n5;
            int n6;
            if (this.getCConn() == null) {
                EsqlRuntime.esqlError(3, ": Missing connection");
            }
            preparedStatement = ((EsqlPrepare)this.getSqlca().allPrepares.get(string)).getHstmt();
            ParameterMetaData parameterMetaData = preparedStatement.getParameterMetaData();
            ResultSetMetaData resultSetMetaData = preparedStatement.getMetaData();
            if (cobolVar2 != null) {
                this.linkSqldaDb2(cobolVar2);
                int n7 = parameterMetaData.getParameterCount();
                n6 = this.actSqldaDb2.SQLN.toint();
                if (n6 < n7) {
                    n7 = 0;
                }
                n5 = 1;
                Object var15_17 = null;
                cobolVar4 = null;
                vector = new Vector<CobolVar>();
                for (n4 = 1; n4 <= n7; ++n4) {
                    if (parameterMetaData.getParameterMode(n4) != 1 && parameterMetaData.getParameterMode(n4) != 2) continue;
                    n2 = this.actSqldaDb2.SQLTYPE.atNC(n4).toint();
                    n3 = this.actSqldaDb2.SQLLEN.atNC(n4).toint();
                    switch (n2) {
                        case 6: 
                        case 7: 
                        case 8: {
                            if (n3 <= 21) {
                                cobolVar4 = Factory.getVarFloat(Factory.getMem(4), 0, 4, false, null, null, null, "v" + n4, false, 18, 0, true, false, false);
                                break;
                            }
                            if (REAL != null) break;
                            cobolVar4 = Factory.getVarDouble(Factory.getMem(8), 0, 8, false, null, null, null, "v" + n4, false, 3, 0, true, false, false);
                            break;
                        }
                        case 5: {
                            cobolVar4 = Factory.getVarBinary(Factory.getMem(2), 0, 2, false, null, null, null, "v" + n4, false, 4, 0, true, false, false);
                            break;
                        }
                        case 4: {
                            cobolVar4 = Factory.getVarBinary(Factory.getMem(4), 0, 4, false, null, null, null, "v" + n4, false, 9, 0, true, false, false);
                            break;
                        }
                        case -5: {
                            cobolVar4 = Factory.getVarBinary(Factory.getMem(4), 0, 4, false, null, null, null, "v1", false, 18, 0, true, false, false);
                            break;
                        }
                        case 3: {
                            cobolVar4 = Factory.getVarPackedAcu(Factory.getMem(n3 / 2 + 1), 0, n3 / 2 + 1, false, null, null, null, "v" + n4, false, n3, resultSetMetaData.getScale(n4), true, false, false);
                            break;
                        }
                        default: {
                            n3 = this.actSqldaDb2.SQLLEN.atNC(n4).toint();
                            cobolVar4 = Factory.getVarAlphanum(Factory.getMem(n3), 0, n3, false, null, null, null, "v" + n4, false, false);
                        }
                    }
                    cobolVar4.link(((ObjectVar)this.actSqldaDb2.SQLDATA.atNC(n4)).getId());
                    vector.addElement(cobolVar4);
                }
                EsqlRuntime.setParams(preparedStatement, vector);
            }
            preparedStatement.execute();
            ResultSet resultSet = preparedStatement.getResultSet();
            if (cobolVar3 != null) {
                this.linkSqldaDb2(cobolVar3);
                n6 = parameterMetaData.getParameterCount();
                n5 = this.actSqldaDb2.SQLN.toint();
                if (n5 < n6) {
                    n6 = 0;
                }
                boolean bl = true;
                cobolVar4 = null;
                vector = null;
                block17: for (n4 = 1; n4 <= n6; ++n4) {
                    if (parameterMetaData.getParameterMode(n4) != 4 && parameterMetaData.getParameterMode(n4) != 2) continue;
                    switch (n2) {
                        case 6: 
                        case 7: 
                        case 8: {
                            if (n3 <= 21) {
                                if (FLOAT == null) {
                                    FLOAT = Factory.getVarFloat(Factory.getMem(4), 0, 4, false, null, null, null, "FLOAT", false, 18, 0, true, false, false);
                                }
                                FLOAT.link(((ObjectVar)this.actSqldaDb2.SQLDATA.at(n4)).getId());
                                FLOAT.set(resultSet.getFloat(n4));
                                continue block17;
                            }
                            if (REAL == null) {
                                REAL = Factory.getVarDouble(Factory.getMem(8), 0, 8, false, null, null, null, "REAL", false, 3, 0, true, false, false);
                            }
                            REAL.link(((ObjectVar)this.actSqldaDb2.SQLDATA.at(n4)).getId());
                            REAL.set(resultSet.getDouble(n4));
                            continue block17;
                        }
                        case 5: {
                            if (SMALLINT == null) {
                                SMALLINT = Factory.getVarBinary(Factory.getMem(2), 0, 2, false, null, null, null, "SMALLINT", false, 4, 0, true, false, false);
                            }
                            SMALLINT.link(((ObjectVar)this.actSqldaDb2.SQLDATA.at(n4)).getId());
                            SMALLINT.set(resultSet.getInt(n4));
                            continue block17;
                        }
                        case 4: {
                            if (INTEGER == null) {
                                INTEGER = Factory.getVarBinary(Factory.getMem(4), 0, 4, false, null, null, null, "INTEGER", false, 9, 0, true, false, false);
                            }
                            INTEGER.link(((ObjectVar)this.actSqldaDb2.SQLDATA.at(n4)).getId());
                            INTEGER.set(resultSet.getInt(n4));
                            continue block17;
                        }
                        case -5: {
                            if (BIGINT == null) {
                                BIGINT = Factory.getVarBinary(Factory.getMem(4), 0, 4, false, null, null, null, "BIGINT", false, 18, 0, true, false, false);
                            }
                            BIGINT.link(((ObjectVar)this.actSqldaDb2.SQLDATA.at(n4)).getId());
                            BIGINT.set(resultSet.getInt(n4));
                            continue block17;
                        }
                        case 3: {
                            DECIMAL = Factory.getVarPackedAcu(Factory.getMem(n3 / 2 + 1), 0, n3 / 2 + 1, false, null, null, null, "DECIMAL", false, n3, resultSetMetaData.getScale(n4), true, false, false);
                            DECIMAL.link(((ObjectVar)this.actSqldaDb2.SQLDATA.at(n4)).getId());
                            if (n3 <= 6) {
                                DECIMAL.set(resultSet.getFloat(n4));
                                continue block17;
                            }
                            if (n3 <= 15) {
                                DECIMAL.set(resultSet.getDouble(n4));
                                continue block17;
                            }
                            DECIMAL.set(resultSet.getBigDecimal(n4));
                            continue block17;
                        }
                        default: {
                            RECVAL = Factory.getVarAlphanum((byte[])null, 0, n3, false, null, null, null, "RECVAL", false, false);
                            if (string2 != null && string2.length() < n3) {
                                n3 = string2.length();
                            } else if (string2 == null) {
                                n3 = -1;
                            }
                            if (string2 == null) continue block17;
                            RECVAL.link(((ObjectVar)this.actSqldaDb2.SQLDATA.at(n4)).getId());
                            RECVAL.set(string2);
                        }
                    }
                }
            }
            if (this.log != null) {
                this.log.info("EsqlRuntime: EXECUTE DESCR :SQLDA connection [" + (this.getCName() == null ? "invalid --> NULL" : this.getCName()) + this.actSqlca.strNumTdd + "] name [" + string + "]] SQLCODE [" + this.actSqlca.SQLCODE.toString() + "]");
            }
        }
        catch (SQLException sQLException) {
            this.fillSqlca(sQLException, cobolVar);
            if (this.log != null) {
                this.log.info("EsqlRuntime: EXECUTE DESCR  connection [" + (this.getCName() == null ? "invalid --> NULL" : this.getCName()) + this.actSqlca.strNumTdd + "]] SQLCODE [" + this.actSqlca.SQLCODE.toString() + "] exception [" + sQLException + "]");
            }
            return false;
        }
        return true;
    }

    public synchronized boolean fetch(CobolVar cobolVar, ObjectVar objectVar, int n2) {
        return this.fetch(cobolVar, objectVar, n2, null);
    }

    public synchronized boolean fetch(CobolVar cobolVar, ObjectVar objectVar, int n2, Object object) {
        this.clearSqlca(cobolVar);
        EsqlCursor esqlCursor = null;
        try {
            esqlCursor = this.getCursor(objectVar, object);
            this.fillSqlca(esqlCursor.fetch(n2, true, 0), cobolVar, esqlCursor);
            this.actSqlca.SQLERRD.at(new int[]{3}).set(esqlCursor.getRowCount());
            if (this.log != null) {
                this.log.info("EsqlRuntime: FETCH  connection [" + (this.getCName() == null ? "invalid --> NULL" : this.getCName()) + this.actSqlca.strNumTdd + "] cursor [" + esqlCursor.name + "] SQLCODE [" + this.actSqlca.SQLCODE.toString() + "]");
            }
        }
        catch (SQLException sQLException) {
            this.fillSqlca(sQLException, cobolVar);
            if (this.log != null) {
                if (esqlCursor != null) {
                    this.log.info("EsqlRuntime: FETCH  connection [" + (this.getCName() == null ? "invalid --> NULL" : this.getCName()) + this.actSqlca.strNumTdd + "] cursor [" + esqlCursor.name + "] exception [" + sQLException + "] SQLCODE [" + this.actSqlca.SQLCODE.toString() + "]");
                } else {
                    this.log.info("EsqlRuntime: FETCH  connection [" + (this.getCName() == null ? "invalid --> NULL" : this.getCName()) + this.actSqlca.strNumTdd + "] cursor [null] exception [" + sQLException + "] SQLCODE [" + this.actSqlca.SQLCODE.toString() + "]");
                }
            }
            return false;
        }
        return true;
    }

    public synchronized boolean fetchDb2(CobolVar cobolVar, ObjectVar objectVar, int n2, Object object) {
        EsqlCursor esqlCursor = null;
        this.clearSqlca(cobolVar);
        try {
            esqlCursor = this.getCursor(objectVar, object);
            if (esqlCursor.descr == null) {
                return this.fetch(cobolVar, objectVar, n2, object);
            }
            return this.fetchDescrDb2(cobolVar, objectVar, esqlCursor.descr, n2);
        }
        catch (SQLException sQLException) {
            this.fillSqlca(sQLException, cobolVar);
            if (this.log != null) {
                if (esqlCursor != null) {
                    this.log.info("EsqlRuntime: FETCH_DB2  connection [" + (this.getCName() == null ? "invalid --> NULL" : this.getCName()) + this.actSqlca.strNumTdd + "] cursor [" + esqlCursor.name + "] exception [" + sQLException + "] SQLCODE [" + this.actSqlca.SQLCODE.toString() + "]");
                } else {
                    this.log.info("EsqlRuntime: FETCH_DB2  connection [" + (this.getCName() == null ? "invalid --> NULL" : this.getCName()) + this.actSqlca.strNumTdd + "] cursor [null] exception [" + sQLException + "] SQLCODE [" + this.actSqlca.SQLCODE.toString() + "]");
                }
            }
            return false;
        }
    }

    public synchronized boolean fetchInto(CobolVar cobolVar, ObjectVar objectVar, int n2) {
        return this.fetchInto(cobolVar, objectVar, n2, null);
    }

    public synchronized boolean fetchInto(CobolVar cobolVar, ObjectVar objectVar, int n2, Object object) {
        this.clearSqlca(cobolVar);
        EsqlCursor esqlCursor = null;
        try {
            esqlCursor = this.getCursor(objectVar, object);
            this.fillSqlca(esqlCursor.fetch(n2, true, 0), cobolVar, esqlCursor);
            this.actSqlca.SQLERRD.at(new int[]{3}).set(esqlCursor.getRowCount());
            if (noData != 0 && esqlCursor.isCursorOutEnd()) {
                this.actSqlca.SQLCODE.set(noData);
                this.actSqlca.SQLSTATE.set("02000");
            }
            if (this.log != null) {
                this.log.info("EsqlRuntime: FETCH INTO connection [" + (this.getCName() == null ? "invalid --> NULL" : this.getCName()) + this.actSqlca.strNumTdd + "] cursor [" + esqlCursor.name + "] SQLCODE [" + this.actSqlca.SQLCODE.toString() + "]");
            }
        }
        catch (SQLException sQLException) {
            this.fillSqlca(sQLException, cobolVar);
            if (this.log != null) {
                if (esqlCursor != null) {
                    this.log.info("EsqlRuntime: FETCH INTO connection [" + (this.getCName() == null ? "invalid --> NULL" : this.getCName()) + this.actSqlca.strNumTdd + "," + this.actSqlca.currConn + "] cursor [" + esqlCursor.name + "] exception [" + sQLException + "] SQLCODE [" + this.actSqlca.SQLCODE.toString() + "]");
                } else {
                    this.log.info("EsqlRuntime: FETCH INTO connection [" + (this.getCName() == null ? "invalid --> NULL" : this.getCName()) + this.actSqlca.strNumTdd + "] cursor [null] exception [" + sQLException + "] SQLCODE [" + this.actSqlca.SQLCODE.toString() + "]");
                }
            }
            return false;
        }
        return true;
    }

    public synchronized boolean fetchDescr(CobolVar cobolVar, ObjectVar objectVar, CobolVar cobolVar2, int n2) {
        this.clearSqlca(cobolVar);
        EsqlCursor esqlCursor = null;
        Object var6_6 = null;
        PreparedStatement preparedStatement = null;
        int n3 = 0;
        try {
            esqlCursor = this.getCursor(objectVar);
            this.fillSqlca(esqlCursor.fetch(n2, true, 0), cobolVar, esqlCursor);
            this.linkSqlda(cobolVar2);
            this.actSqlca.SQLERRD.at(new int[]{3}).set(esqlCursor.getRowCount());
            if (noData != 0 && esqlCursor.isCursorOutEnd()) {
                this.actSqlca.SQLCODE.set(noData);
                this.actSqlca.SQLSTATE.set("02000");
            }
            if (!esqlCursor.isCursorOutEnd()) {
                preparedStatement = esqlCursor.getPrep().getHstmt();
                ResultSetMetaData resultSetMetaData = preparedStatement.getMetaData();
                n3 = resultSetMetaData.getColumnCount();
                this.actSqlda.SQLDFND.set(n3);
                for (int i2 = 1; i2 <= n3; ++i2) {
                    String string = esqlCursor.getResultSet().getString(i2);
                    if ((CobolVar)this.actSqlda.DV.atNC(i2).getOId() != null) {
                        ((CobolVar)this.actSqlda.DV.atNC(i2).getOId()).set(string);
                    }
                    ((CobolVar)this.actSqlda.DVLN.atNC(i2)).set(string.length());
                    if ((CobolVar)this.actSqlda.DI.atNC(i2).getOId() == null) continue;
                    if (string == null) {
                        ((CobolVar)this.actSqlda.DI.atNC(i2).getOId()).set(1);
                        continue;
                    }
                    ((CobolVar)this.actSqlda.DI.atNC(i2).getOId()).set(0);
                }
            }
            if (this.log != null) {
                this.log.info("EsqlRuntime: FETCH USING DESCRIPTOR connection [" + (this.getCName() == null ? "invalid --> NULL" : this.getCName()) + this.actSqlca.strNumTdd + "] cursor [" + esqlCursor.name + "] SQLCODE [" + this.actSqlca.SQLCODE.toString() + "]");
            }
        }
        catch (SQLException sQLException) {
            this.fillSqlca(sQLException, cobolVar);
            if (this.log != null) {
                if (esqlCursor != null) {
                    this.log.info("EsqlRuntime: FETCH USING DESCRIPTOR connection [" + (this.getCName() == null ? "invalid --> NULL" : this.getCName()) + this.actSqlca.strNumTdd + "," + this.actSqlca.currConn + "] cursor [" + esqlCursor.name + "] exception [" + sQLException + "] SQLCODE [" + this.actSqlca.SQLCODE.toString() + "]");
                } else {
                    this.log.info("EsqlRuntime: FETCH USING DESCRIPTOR connection [" + (this.getCName() == null ? "invalid --> NULL" : this.getCName()) + this.actSqlca.strNumTdd + "] cursor [null] exception [" + sQLException + "] SQLCODE [" + this.actSqlca.SQLCODE.toString() + "]");
                }
            }
            return false;
        }
        return true;
    }

    public synchronized boolean fetchDescrDb2(CobolVar cobolVar, ObjectVar objectVar, CobolVar cobolVar2, int n2) {
        this.clearSqlca(cobolVar);
        EsqlCursor esqlCursor = null;
        Object var6_6 = null;
        PreparedStatement preparedStatement = null;
        int n3 = 0;
        int n4 = 0;
        int n5 = -1;
        byte[] byArray = null;
        int n6 = 0;
        try {
            esqlCursor = this.getCursor(objectVar);
            this.fillSqlca(esqlCursor.fetch(n2, true, 0), cobolVar, esqlCursor);
            this.actSqlca.SQLERRD.at(new int[]{3}).set(esqlCursor.getRowCount());
            if (noData != 0 && esqlCursor.isCursorOutEnd()) {
                this.actSqlca.SQLCODE.set(noData);
                this.actSqlca.SQLSTATE.set("02000");
            }
            if (!esqlCursor.isCursorOutEnd()) {
                int n7;
                preparedStatement = esqlCursor.getPrep().getHstmt();
                ResultSetMetaData resultSetMetaData = preparedStatement.getMetaData();
                n3 = resultSetMetaData.getColumnCount();
                this.linkSqldaDb2(cobolVar2);
                if (esqlCursor.db2BindCols.size() == 0) {
                    for (n7 = 1; n7 <= n3; ++n7) {
                        esqlCursor.db2BindCols.add(null);
                    }
                    MYIND = Factory.getVarBinary(Factory.getMem(2), 0, 2, false, null, null, null, "MYIND", false, 4, 0, true, false, false, false);
                }
                for (n7 = 1; n7 <= n3; ++n7) {
                    String string;
                    n5 = resultSetMetaData.getColumnType(n7);
                    byArray = null;
                    n4 = resultSetMetaData.getPrecision(n7);
                    if (this.log != null) {
                        this.log.info("EsqlRuntime: FETCH USING DB2 DESCRIPTOR setting " + n7 + " col len=" + n4 + " " + this.actSqldaDb2.SQLNAMEC.atNC(n7).toString() + " sqlType=" + n5 + " db2DataRowAsByteThreshold=" + db2DataRowAsByteThreshold);
                    }
                    if (db2DataRowAsByteThreshold > 0 && n4 >= db2DataRowAsByteThreshold && (n5 == 1 || n5 == 12)) {
                        block56: {
                            try {
                                this.rowObj = (Object[])getDBRowDataAsBytes.invoke((Object)esqlCursor.getResultSet(), nullParam);
                                this.rowData = (byte[])this.rowObj[0];
                                this.rowOffs = (int[])this.rowObj[1];
                            }
                            catch (Exception exception) {
                                if (this.log == null) break block56;
                                this.log.info("EsqlRuntime: exception invoke db2 " + exception);
                            }
                        }
                        byte[] byArray2 = new byte[2];
                        int n8 = this.rowOffs[n7 - 1] + 2;
                        if (n5 == 12) {
                            System.arraycopy(this.rowData, this.rowOffs[n7 - 1] + 2, byArray2, 0, 2);
                            n6 = byArray2[0] << 8 & 0xFF00 | byArray2[1] << 0 & 0xFF;
                            n8 += 2;
                        } else {
                            n6 = n4;
                        }
                        byArray = new byte[n6];
                        if (this.log != null && this.rowData != null) {
                            this.log.info("EsqlRuntime: doDb2Bytes rowData[" + EsqlHostVar.bytesToHex(this.rowData) + ", " + this.rowData.length + "]" + n8 + ", " + n6);
                        } else if (this.log != null) {
                            this.log.info("EsqlRuntime: doDb2Bytes rowData[null]" + this.rowOffs[n7 - 1] + ", " + n6);
                        }
                        if (this.rowData[this.rowOffs[n7 - 1]] == 0 && this.rowData[this.rowOffs[n7 - 1] + 1] == 0) {
                            System.arraycopy(this.rowData, n8, byArray, 0, byArray.length);
                        }
                        string = new String(byArray);
                        if (this.rowData[this.rowOffs[n7 - 1]] == 0 && this.rowData[this.rowOffs[n7 - 1] + 1] == 0 && this.log != null) {
                            this.log.info("arrayCopy(rowData," + n8 + ", bytearr, 0," + byArray.length + ") value(hex)[" + EsqlHostVar.bytesToHex(string.getBytes()) + "] bytearr(hex)[" + EsqlHostVar.bytesToHex(byArray) + "]");
                        }
                    } else {
                        string = esqlCursor.getResultSet().getString(n7);
                    }
                    if (this.log != null) {
                        this.log.info("EsqlRuntime: FETCH USING DB2 SQLDATA.getId" + n7 + "[" + ((ObjectVar)this.actSqldaDb2.SQLDATA.at(n7)).getId() + "]" + this.actSqldaDb2.SQLDATA.at(n7) + " [" + string + "]");
                    }
                    switch (n5) {
                        case 6: 
                        case 7: 
                        case 8: {
                            if (n4 <= 21) {
                                if (FLOAT == null) {
                                    FLOAT = Factory.getVarFloat(Factory.getMem(4), 0, 4, false, null, null, null, "FLOAT", false, 18, 0, true, false, false);
                                }
                                FLOAT.link(((ObjectVar)this.actSqldaDb2.SQLDATA.at(n7)).getId());
                                FLOAT.set(esqlCursor.getResultSet().getFloat(n7));
                                break;
                            }
                            if (REAL == null) {
                                REAL = Factory.getVarDouble(Factory.getMem(8), 0, 8, false, null, null, null, "REAL", false, 3, 0, true, false, false);
                            }
                            REAL.link(((ObjectVar)this.actSqldaDb2.SQLDATA.at(n7)).getId());
                            REAL.set(esqlCursor.getResultSet().getDouble(n7));
                            break;
                        }
                        case 5: {
                            if (SMALLINT == null) {
                                SMALLINT = Factory.getVarBinary(Factory.getMem(2), 0, 2, false, null, null, null, "SMALLINT", false, 4, 0, true, false, false);
                            }
                            SMALLINT.link(((ObjectVar)this.actSqldaDb2.SQLDATA.at(n7)).getId());
                            SMALLINT.set(esqlCursor.getResultSet().getInt(n7));
                            break;
                        }
                        case 4: {
                            if (INTEGER == null) {
                                INTEGER = Factory.getVarBinary(Factory.getMem(4), 0, 4, false, null, null, null, "INTEGER", false, 9, 0, true, false, false);
                            }
                            INTEGER.link(((ObjectVar)this.actSqldaDb2.SQLDATA.at(n7)).getId());
                            INTEGER.set(esqlCursor.getResultSet().getInt(n7));
                            break;
                        }
                        case -5: {
                            if (BIGINT == null) {
                                BIGINT = Factory.getVarBinary(Factory.getMem(4), 0, 4, false, null, null, null, "BIGINT", false, 18, 0, true, false, false);
                            }
                            BIGINT.link(((ObjectVar)this.actSqldaDb2.SQLDATA.at(n7)).getId());
                            BIGINT.set(esqlCursor.getResultSet().getInt(n7));
                            break;
                        }
                        case 3: {
                            if (esqlCursor.db2BindCols.get(n7 - 1) == null) {
                                DECIMAL = Factory.getVarPackedAcu(Factory.getMem(n4 / 2 + 1), 0, n4 / 2 + 1, false, null, null, null, "DECIMAL", false, n4, resultSetMetaData.getScale(n7), true, false, false);
                                esqlCursor.db2BindCols.set(n7 - 1, DECIMAL);
                            } else {
                                DECIMAL = (NumericVar)esqlCursor.db2BindCols.get(n7 - 1);
                            }
                            DECIMAL.link(((ObjectVar)this.actSqldaDb2.SQLDATA.at(n7)).getId());
                            if (n4 <= 6) {
                                DECIMAL.set(esqlCursor.getResultSet().getFloat(n7));
                                break;
                            }
                            if (n4 <= 15) {
                                DECIMAL.set(esqlCursor.getResultSet().getDouble(n7));
                                break;
                            }
                            DECIMAL.set(esqlCursor.getResultSet().getBigDecimal(n7));
                            break;
                        }
                        default: {
                            n4 = this.actSqldaDb2.SQLLEN.atNC(n7).toint();
                            if (esqlCursor.db2BindCols.get(n7 - 1) == null) {
                                RECVAL = Factory.getVarAlphanum(new byte[n4], 0, n4, false, null, null, null, "RECVAL", false, false);
                                esqlCursor.db2BindCols.set(n7 - 1, RECVAL);
                            } else {
                                RECVAL = (PicX)esqlCursor.db2BindCols.get(n7 - 1);
                            }
                            if (string != null && string.length() < n4) {
                                n4 = string.length();
                            } else if (string == null) {
                                n4 = -1;
                            }
                            if (string == null) break;
                            if (((ObjectVar)this.actSqldaDb2.SQLDATA.at(n7)).getId() != null) {
                                RECVAL.link(((ObjectVar)this.actSqldaDb2.SQLDATA.at(n7)).getId());
                            } else {
                                this.actSqldaDb2.SQLDATA.at(n7).setId(RECVAL.getOId());
                            }
                            if (RECVAL != null) {
                                if (byArray != null) {
                                    RECVAL.set(byArray);
                                } else {
                                    RECVAL.set(string);
                                }
                            }
                            if (RECVAL == null || this.log == null) break;
                            this.log.info("EsqlRuntime: FETCH USING DB2 DESCRIPTOR inp buf[" + RECVAL.toString() + "] hex[" + EsqlHostVar.bytesToHex(RECVAL.toString().getBytes()));
                        }
                    }
                    if (resultSetMetaData.isNullable(n7) == 1) {
                        MYIND.link(((ObjectVar)this.actSqldaDb2.SQLIND.at(n7)).getId());
                        MYIND.set(n4);
                        if (db2DataRowAsByteThreshold > 0 && n4 >= db2DataRowAsByteThreshold && (n5 == 1 || n5 == 12)) {
                            if (this.rowData[this.rowOffs[n7 - 1]] != 0 || this.rowData[this.rowOffs[n7 - 1] + 1] != 0) {
                                MYIND.set(-1);
                            }
                        } else if (esqlCursor.getResultSet().wasNull()) {
                            MYIND.set(-1);
                        }
                    }
                    if (this.log == null) continue;
                    this.log.info("EsqlRuntime: FETCH USING DB2 DESCRIPTOR after setting " + this.actSqldaDb2.SQLNAMEC.atNC(n7).toString() + " SQLIND(" + n7 + ")=" + this.actSqldaDb2.SQLIND.atNC(n7).tolong() + "," + n4);
                }
            }
            if (this.log != null) {
                this.log.info("EsqlRuntime: FETCH USING DB2 DESCRIPTOR connection [" + (this.getCName() == null ? "invalid --> NULL" : this.getCName()) + this.actSqlca.strNumTdd + "] cursor [" + esqlCursor.name + "] SQLCODE [" + this.actSqlca.SQLCODE.toString() + "]");
            }
        }
        catch (SQLException sQLException) {
            this.fillSqlca(sQLException, cobolVar);
            if (this.log != null) {
                if (esqlCursor != null) {
                    this.log.info("EsqlRuntime: FETCH USING DB2 DESCRIPTOR connection [" + (this.getCName() == null ? "invalid --> NULL" : this.getCName()) + this.actSqlca.strNumTdd + "," + this.actSqlca.currConn + "] cursor [" + esqlCursor.name + "] exception [" + sQLException + "] SQLCODE [" + this.actSqlca.SQLCODE.toString() + "]");
                } else {
                    this.log.info("EsqlRuntime: FETCH USING DB2 DESCRIPTOR connection [" + (this.getCName() == null ? "invalid --> NULL" : this.getCName()) + this.actSqlca.strNumTdd + "] cursor [null] exception [" + sQLException + "] SQLCODE [" + this.actSqlca.SQLCODE.toString() + "]");
                }
            }
            return false;
        }
        return true;
    }

    public synchronized boolean prepare(CobolVar cobolVar, Object object, String string) {
        this.clearSqlca(cobolVar);
        try {
            EsqlPrepare esqlPrepare;
            if (this.getCConn() == null) {
                EsqlRuntime.esqlError(3, ": Missing connection");
            }
            if (object instanceof ObjectVar) {
                esqlPrepare = this.prepareFactory(null, this.cursorType, 0);
                ((ObjectVar)object).setId(esqlPrepare);
            } else {
                esqlPrepare = this.prepareFactory(object.toString(), this.cursorType, 0);
            }
            esqlPrepare.setQuery(this.getCConn(), string);
            EsqlPrepare esqlPrepare2 = (EsqlPrepare)this.actSqlca.allPrepares.get(object);
            if (esqlPrepare2 == null) {
                this.actSqlca.allPrepares.put(object, esqlPrepare);
            }
            if (this.log != null) {
                this.log.info("EsqlRuntime: PREPARE connection [" + (this.getCName() == null ? "invalid --> NULL" : this.getCName()) + this.actSqlca.strNumTdd + "] name [" + esqlPrepare.getName() + "] statement [" + string + "]] SQLCODE [" + this.actSqlca.SQLCODE.toString() + "]");
            }
        }
        catch (SQLException sQLException) {
            this.fillSqlca(sQLException, cobolVar);
            if (this.log != null) {
                this.log.info("EsqlRuntime: PREPARE connection [" + (this.getCName() == null ? "invalid --> NULL" : this.getCName()) + this.actSqlca.strNumTdd + "] name [" + object + "] statement [" + string + "] exception [" + sQLException + "] SQLCODE [" + this.actSqlca.SQLCODE.toString() + "]");
            }
            return false;
        }
        return true;
    }

    public synchronized boolean prepareDb2Into(CobolVar cobolVar, Object object, String string, CobolVar cobolVar2) {
        int n2 = 452;
        this.clearSqlca(cobolVar);
        int n3 = 0;
        try {
            EsqlPrepare esqlPrepare;
            if (this.getCConn() == null) {
                EsqlRuntime.esqlError(3, ": Missing connection");
            }
            if (object instanceof ObjectVar) {
                esqlPrepare = this.prepareFactory(null, this.cursorType, 0);
                ((ObjectVar)object).setId(esqlPrepare);
            } else {
                esqlPrepare = this.prepareFactory(object.toString(), this.cursorType, 0);
            }
            esqlPrepare.setQuery(this.getCConn(), string);
            EsqlPrepare esqlPrepare2 = (EsqlPrepare)this.actSqlca.allPrepares.get(object);
            if (esqlPrepare2 == null) {
                this.actSqlca.allPrepares.put(object, esqlPrepare);
            } else {
                esqlPrepare = esqlPrepare2;
            }
            ResultSetMetaData resultSetMetaData = esqlPrepare.getHstmt().getMetaData();
            this.linkSqldaDb2(cobolVar2);
            int n4 = resultSetMetaData.getColumnCount();
            this.actSqldaDb2.SQLD.set(n4);
            for (int i2 = 1; i2 <= n4; ++i2) {
                n3 = resultSetMetaData.getColumnType(i2);
                if (sqlTypes.get(n3) != null) {
                    n3 = (Integer)sqlTypes.get(n3);
                } else {
                    n3 = n2;
                    if (this.log != null) {
                        this.log.info("EsqlRuntime: PREPARE INTO :SQLDA column " + i2 + " sqltype not found " + n3 + "default 452 USED");
                    }
                }
                this.actSqldaDb2.SQLTYPE.atNC(i2).set(n3);
                if (resultSetMetaData.getColumnType(i2) == 3) {
                    this.actSqldaDb2.SQLLEN.atNC(i2).set(256 * resultSetMetaData.getScale(i2) + resultSetMetaData.getPrecision(i2));
                } else {
                    this.actSqldaDb2.SQLLEN.atNC(i2).set(resultSetMetaData.getPrecision(i2));
                }
                this.actSqldaDb2.SQLNAMEC.atNC(i2).set(resultSetMetaData.getColumnName(i2));
                this.actSqldaDb2.SQLNAMEL.atNC(i2).set(resultSetMetaData.getColumnName(i2).trim().length());
            }
            if (this.log != null) {
                this.log.info("EsqlRuntime: PREPARE INTO :SQLDA connection [" + (this.getCName() == null ? "invalid --> NULL" : this.getCName()) + this.actSqlca.strNumTdd + "] name [" + esqlPrepare.getName() + "] statement [" + string + "]] SQLCODE [" + this.actSqlca.SQLCODE.toString() + "]");
            }
        }
        catch (SQLException sQLException) {
            this.fillSqlca(sQLException, cobolVar);
            if (this.log != null) {
                this.log.info("EsqlRuntime: PREPARE INTO :SQLDA connection [" + (this.getCName() == null ? "invalid --> NULL" : this.getCName()) + this.actSqlca.strNumTdd + "] name [" + object + "] statement [" + string + "] exception [" + sQLException + "] SQLCODE [" + this.actSqlca.SQLCODE.toString() + "]");
            }
            return false;
        }
        return true;
    }

    public synchronized boolean prepareQuery(CobolVar cobolVar, ObjectVar objectVar, CobolVar cobolVar2, String string, String string2) {
        this.clearSqlca(cobolVar);
        try {
            PreparedStatement preparedStatement;
            if (this.getCConn() == null) {
                EsqlRuntime.esqlError(3, ": Missing connection");
            }
            if (cobolVar2 != null) {
                string = string.replace("--isFromVar--", cobolVar2.toString());
                string2 = string2 + cobolVar2;
            }
            if ((preparedStatement = (PreparedStatement)this.actSqlca.allSelect.get(this.getCName().trim() + "--" + string2)) == null) {
                preparedStatement = this.getCConn().prepareStatement(string);
                this.actSqlca.allSelect.put(this.getCName().trim() + "--" + string2, preparedStatement);
            }
            if (this.log != null) {
                this.log.info("EsqlRuntime: PREPARE QUERY connection [" + (this.getCName() == null ? "invalid --> NULL" : this.getCName()) + this.actSqlca.strNumTdd + "] prep [" + preparedStatement + "] name [" + string2 + "] statement [" + string + "]] SQLCODE [" + this.actSqlca.SQLCODE.toString() + "]");
            }
            objectVar.setId(preparedStatement);
        }
        catch (SQLException sQLException) {
            this.fillSqlca(sQLException, cobolVar);
            if (this.log != null) {
                this.log.info("EsqlRuntime: PREPARE QUERY connection [" + (this.getCName() == null ? "invalid --> NULL" : this.getCName()) + this.actSqlca.strNumTdd + "] hndl [" + objectVar + "] statement [" + string + "] exception [" + sQLException + "] SQLCODE [" + this.actSqlca.SQLCODE.toString() + "]");
            }
            return false;
        }
        return true;
    }

    public synchronized boolean commit(CobolVar cobolVar) {
        this.clearSqlca(cobolVar);
        try {
            if (this.getCConn() == null) {
                EsqlRuntime.esqlError(3, ": Missing connection");
            }
            this.getCConn().commit();
            if (this.log != null) {
                this.log.info("EsqlRuntime: COMMIT connection [" + (this.getCName() == null ? "invalid --> NULL" : this.getCName()) + this.actSqlca.strNumTdd + "]] SQLCODE [" + this.actSqlca.SQLCODE.toString() + "]");
            }
        }
        catch (SQLException sQLException) {
            this.fillSqlca(sQLException, cobolVar);
            if (this.log != null) {
                this.log.info("EsqlRuntime: COMMIT connection [" + (this.getCName() == null ? "invalid --> NULL" : this.getCName()) + this.actSqlca.strNumTdd + "] exception [" + sQLException + "] SQLCODE [" + this.actSqlca.SQLCODE.toString() + "]");
            }
            return false;
        }
        return true;
    }

    public synchronized boolean rollback(CobolVar cobolVar) {
        return this.rollback(cobolVar, "");
    }

    public synchronized boolean rollback(CobolVar cobolVar, String string) {
        this.clearSqlca(cobolVar);
        try {
            if (this.getCConn() == null) {
                EsqlRuntime.esqlError(3, ": Missing connection");
            }
            if (string != null && string.length() > 0) {
                this.getCConn().rollback((Savepoint)this.actSqlca.allSavepoint.get(string));
            } else {
                this.getCConn().rollback();
            }
            if (this.log != null) {
                this.log.info("EsqlRuntime: ROLLBACK connection [" + (this.getCName() == null ? "invalid --> NULL" : this.getCName()) + this.actSqlca.strNumTdd + "] savepoint[" + string + "] SQLCODE [" + this.actSqlca.SQLCODE.toString() + "]");
            }
        }
        catch (SQLException sQLException) {
            this.fillSqlca(sQLException, cobolVar);
            if (this.log != null) {
                this.log.info("EsqlRuntime: ROLLBACK connection [" + (this.getCName() == null ? "invalid --> NULL" : this.getCName()) + this.actSqlca.strNumTdd + "] savepoint[" + string + "] exception [" + sQLException + "] SQLCODE [" + this.actSqlca.SQLCODE.toString() + "]");
            }
            return false;
        }
        return true;
    }

    public static void setParams(PreparedStatement preparedStatement, Vector vector) throws SQLException {
        EsqlHostVar esqlHostVar;
        int n2;
        int n3 = vector.size();
        int n4 = Config.a(".jdbc.kept_spaces", 1);
        for (n2 = 1; n2 < n3 && (esqlHostVar = (EsqlHostVar)vector.get(n2)) != null; ++n2) {
            esqlHostVar.fromVar(n2, preparedStatement, n4);
        }
        if (preparedStatement instanceof CallableStatement) {
            for (n2 = 1; n2 < n3 && (esqlHostVar = (EsqlHostVar)vector.get(n2)) != null; ++n2) {
                esqlHostVar.regOutVar(n2, (CallableStatement)preparedStatement);
            }
        }
    }

    public static boolean fillHostVars(CallableStatement callableStatement, Vector vector) throws SQLException {
        EsqlHostVar esqlHostVar;
        boolean bl = false;
        int n2 = vector.size();
        for (int i2 = 1; i2 < n2 && (esqlHostVar = (EsqlHostVar)vector.get(i2)) != null; ++i2) {
            bl |= esqlHostVar.toVar(i2, callableStatement, typeIndTrunk);
        }
        return bl;
    }

    public static boolean fillHostVars(ResultSet resultSet, Vector vector) throws SQLException {
        EsqlHostVar esqlHostVar;
        boolean bl = false;
        int n2 = vector.size();
        for (int i2 = 1; i2 < n2 && (esqlHostVar = (EsqlHostVar)vector.get(i2)) != null; ++i2) {
            bl |= esqlHostVar.toVar(i2, resultSet);
        }
        return bl;
    }

    static boolean searchNullWithoutInd(Vector vector) throws SQLException {
        EsqlHostVar esqlHostVar;
        boolean bl = false;
        int n2 = vector.size();
        for (int i2 = 1; i2 < n2 && !bl && (esqlHostVar = (EsqlHostVar)vector.get(i2)) != null; ++i2) {
            bl = esqlHostVar.isResultNull();
        }
        return bl;
    }

    protected void callExecuteHook(String string, Statement statement, Vector<EsqlHostVar> vector) {
        block6: {
            Vector<EsqlHostVar> vector2 = new Vector<EsqlHostVar>(vector);
            if (vector2.size() > 0 && vector2.elementAt(0) == null) {
                vector2.removeElementAt(0);
            }
            if (vector2.size() > 1) {
                Collections.sort(vector2, new Comparator(){

                    public int compare(Object object, Object object2) {
                        EsqlHostVar esqlHostVar = (EsqlHostVar)object;
                        EsqlHostVar esqlHostVar2 = (EsqlHostVar)object2;
                        return esqlHostVar.getCol() - esqlHostVar2.getCol();
                    }
                });
            }
            Object[] objectArray = new Object[vector2.size() + 2];
            int n2 = 0;
            objectArray[n2++] = string;
            objectArray[n2++] = statement;
            for (EsqlHostVar esqlHostVar : vector2) {
                objectArray[n2++] = esqlHostVar.getVar();
            }
            Object object = this.executeHook;
            try {
                if (object instanceof IsInitial) {
                    object = (IscobolCall)object.getClass().newInstance();
                }
                object.call(objectArray);
            }
            catch (Exception exception) {
                if (this.log == null) break block6;
                this.log.warning("Entering hook failed: " + exception);
            }
        }
    }

    public synchronized boolean procedure(CobolVar cobolVar, String string, Object[] objectArray) {
        Object var5_4 = null;
        Object var6_5 = null;
        this.clearSqlca(cobolVar);
        boolean bl = false;
        Vector<EsqlHostVar> vector = null;
        String string2 = modeIODef;
        String string3 = modeIODef;
        CallableStatement callableStatement = null;
        try {
            int n2;
            int n3;
            if (this.getCConn() == null) {
                EsqlRuntime.esqlError(3, ": Missing connection");
            }
            callableStatement = this.getCConn().prepareCall(string);
            if (objectArray != null && objectArray.length > 0) {
                vector = new Vector<EsqlHostVar>();
                vector.addElement(null);
                n3 = 0;
                n2 = 0;
                while (n3 < objectArray.length) {
                    EsqlHostVar esqlHostVar;
                    string3 = (String)objectArray[n3 + 3];
                    string2 = string3.equals("I") ? "IN" : (string3.equals("O") ? "OUT" : (string3.equals("D") ? modeIODef : "INOUT"));
                    if (objectArray[n3 + 2] != null && (Integer)objectArray[n3 + 2] == 2003) {
                        int n4 = 0;
                        String string4 = (String)this.procedureTypeNames.get(n2 + 1);
                        if (string4 != null) {
                            n4 = (Integer)this.procedureTypes.get(string4);
                        }
                        esqlHostVar = new EsqlOraHostVar((CobolVar)objectArray[n3], 0, n2 + 1, (NumericVar)objectArray[n3 + 1], null, string2);
                        vector.addElement(esqlHostVar);
                        esqlHostVar.setName(string4);
                        esqlHostVar.setSpecType(n4);
                    } else {
                        esqlHostVar = new EsqlHostVar((CobolVar)objectArray[n3], 0, n2 + 1, (NumericVar)objectArray[n3 + 1], null, string2);
                        vector.addElement(esqlHostVar);
                    }
                    n3 += 4;
                    ++n2;
                }
                EsqlRuntime.setParams(callableStatement, vector);
            }
            if (this.log != null) {
                int n5 = Config.a(".jdbc.kept_spaces", 1);
                String string5 = "] trimType[" + n5 + "] using[";
                if (vector != null && vector.size() > 0) {
                    for (n2 = 1; n2 < vector.size(); ++n2) {
                        if (n2 > 1) {
                            string5 = string5 + ", ";
                        }
                        if (vector.get(n2) != null) {
                            if (n5 == -1) {
                                string5 = string5 + "'" + vector.get(n2).getVar().toString() + "'";
                                continue;
                            }
                            string5 = string5 + "'" + EsqlHostVar.rtrim(vector.get(n2).getVar(), n5, n5) + "'";
                            continue;
                        }
                        string5 = string5 + "null";
                    }
                }
                this.log.info("EsqlRuntime: PROCEDURE before execute connection [" + (this.getCName() == null ? "invalid --> NULL" : this.getCName()) + this.actSqlca.strNumTdd + "] statement [" + string + string5 + "] SQLCODE [" + this.actSqlca.SQLCODE.toString() + "]");
            }
            if (this.hasExecuteHook()) {
                this.callExecuteHook(string, callableStatement, vector);
            }
            callableStatement.executeUpdate();
            if (vector != null) {
                bl = EsqlRuntime.fillHostVars(callableStatement, vector);
                if (bl) {
                    this.fillSqlca(1, cobolVar, null);
                } else if (EsqlRuntime.searchNullWithoutInd(vector)) {
                    this.setCodeNull();
                }
            }
            this.procedureTypes.clear();
            this.procedureTypeNames.clear();
            callableStatement.close();
            if (this.log != null) {
                String string6 = "] result[";
                if (vector != null && vector.size() > 0) {
                    for (n3 = 1; n3 < vector.size(); ++n3) {
                        if (n3 > 1) {
                            string6 = string6 + ", ";
                        }
                        string6 = vector.get(n3) != null ? string6 + "'" + vector.get(n3).getVar().toString() + "'" : string6 + "null";
                    }
                }
                this.log.info("EsqlRuntime: PROCEDURE connection [" + (this.getCName() == null ? "invalid --> NULL" : this.getCName()) + this.actSqlca.strNumTdd + "] statement [" + string + string6 + "] SQLCODE [" + this.actSqlca.SQLCODE.toString() + "]");
            }
        }
        catch (SQLException sQLException) {
            this.fillSqlca(sQLException, cobolVar);
            if (this.log != null) {
                int n6 = Config.a(".jdbc.kept_spaces", 1);
                String string7 = "] trimType[" + n6 + "] using[";
                if (vector != null && vector.size() > 0) {
                    for (int i2 = 1; i2 < vector.size(); ++i2) {
                        if (i2 > 1) {
                            string7 = string7 + ", ";
                        }
                        if (vector.get(i2) != null) {
                            if (n6 == -1) {
                                string7 = string7 + "'" + vector.get(i2).getVar().toString() + "'";
                                continue;
                            }
                            string7 = string7 + "'" + EsqlHostVar.rtrim(vector.get(i2).getVar(), n6, n6) + "'";
                            continue;
                        }
                        string7 = string7 + "null";
                    }
                }
                this.log.info("EsqlRuntime: PROCEDURE connection [" + (this.getCName() == null ? "invalid --> NULL" : this.getCName()) + this.actSqlca.strNumTdd + "] statement [" + string + string7 + "] exception [" + sQLException + "] SQLCODE [" + this.actSqlca.SQLCODE.toString() + "]");
            }
            this.procedureTypes.clear();
            this.procedureTypeNames.clear();
            try {
                if (callableStatement != null) {
                    callableStatement.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return false;
        }
        return true;
    }

    public synchronized boolean createType(CobolVar cobolVar, int n2, String string, int n3, Object object) {
        this.procedureTypes.put(string, Integer.valueOf((Integer)object));
        this.procedureTypeNames.put(n2 + 1, string);
        return true;
    }

    public int allocate(ObjectVar objectVar, Object object, int n2) {
        EsqlCursorHndl esqlCursorHndl = new EsqlCursorHndl(this.cursorType, n2, object, false);
        objectVar.set(esqlCursorHndl.getHandle());
        return esqlCursorHndl.getHandle();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized int free(ObjectVar objectVar) {
        this.actSqlca = this.getSqlca();
        EsqlPrepare esqlPrepare = (EsqlPrepare)this.actSqlca.allPrepares.get(objectVar);
        if (esqlPrepare != null) {
            try {
                if (this.actSqlca.allCursHndl.get(objectVar) != null) {
                    EsqlCursor esqlCursor = null;
                    Vector vector = this.actSqlca.allCursors;
                    synchronized (vector) {
                        for (int i2 = this.actSqlca.allCursors.size() - 1; i2 >= 0; --i2) {
                            esqlCursor = (EsqlCursor)this.actSqlca.allCursors.get(i2);
                            if (esqlCursor != (EsqlCursor)this.actSqlca.allCursHndl.get(objectVar)) continue;
                            this.actSqlca.allCursors.remove(i2);
                            break;
                        }
                    }
                    this.actSqlca.allCursHndl.remove(objectVar);
                }
                esqlPrepare.close();
                this.actSqlca.allPrepares.remove(objectVar);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        objectVar.free();
        return 0;
    }

    public static Connection getCurrConnection() {
        return EsqlRuntime.get().getCConn();
    }

    public static ResultSet getResultSet(String string) {
        return EsqlRuntime.get().getIResultSet(string);
    }

    public boolean rsUpdateCol(CobolVar cobolVar, ObjectVar objectVar, String string, CobolVar cobolVar2, int n2, int n3, NumericVar numericVar, NumericVar numericVar2) {
        EsqlCursor esqlCursor = null;
        try {
            esqlCursor = this.getCursor(objectVar);
            esqlCursor.updateCol(cobolVar2, string, n2, n3, numericVar, numericVar2);
        }
        catch (SQLException sQLException) {
            this.fillSqlca(sQLException, cobolVar);
            return false;
        }
        return true;
    }

    public boolean rsUpdColRowset(CobolVar cobolVar, ObjectVar objectVar, String string, CobolVar cobolVar2, int n2, int n3, NumericVar numericVar, NumericVar numericVar2) {
        EsqlCursor esqlCursor = null;
        try {
            esqlCursor = this.getCursor(objectVar);
            esqlCursor.updCol(cobolVar2, string, n2, n3, numericVar, numericVar2);
        }
        catch (SQLException sQLException) {
            this.fillSqlca(sQLException, cobolVar);
            return false;
        }
        return true;
    }

    public boolean rsUpdateColDb2Reg(CobolVar cobolVar, ObjectVar objectVar, String string, String string2, int n2, int n3, NumericVar numericVar, NumericVar numericVar2) {
        EsqlCursor esqlCursor = null;
        try {
            if (this.actSqlca.regDb2 == null) {
                this.actSqlca.regDb2 = this.actSqlca.currConn.createStatement();
            }
            ResultSet resultSet = this.actSqlca.regDb2.executeQuery(string2);
            resultSet.next();
            String string3 = resultSet.getObject(1).toString();
            esqlCursor = this.getCursor(objectVar);
            esqlCursor.updateColDb2Reg(string3, string, n2, n3, numericVar, numericVar2);
        }
        catch (SQLException sQLException) {
            this.fillSqlca(sQLException, cobolVar);
            return false;
        }
        return true;
    }

    public boolean rsUpdateRow(CobolVar cobolVar, ObjectVar objectVar) {
        EsqlCursor esqlCursor = null;
        this.clearSqlca(cobolVar);
        try {
            esqlCursor = this.getCursor(objectVar);
            if (esqlCursor.isRowset()) {
                return this.rsUpdateRowset(cobolVar, objectVar, 0);
            }
            esqlCursor.updateRow();
            if (this.log != null) {
                this.log.info("EsqlRuntime: UPDATE CURRENT [" + esqlCursor.name + "] connection [" + (this.getCName() == null ? "invalid --> NULL" : this.getCName()) + this.actSqlca.strNumTdd + "] SQLCODE [" + this.actSqlca.SQLCODE.toString() + "] SQLERRMC[" + this.actSqlca.SQLERRMC.toString() + "]");
            }
        }
        catch (SQLException sQLException) {
            this.fillSqlca(sQLException, cobolVar);
            if (this.log != null) {
                String string = "null";
                if (esqlCursor != null) {
                    // empty if block
                }
                string = esqlCursor.name;
                this.log.info("EsqlRuntime: UPDATE CURRENT [" + string + "] connection [" + (this.getCName() == null ? "invalid --> NULL" : this.getCName()) + this.actSqlca.strNumTdd + "] exception [" + sQLException + "] SQLCODE [" + this.actSqlca.SQLCODE.toString() + "]");
            }
            return false;
        }
        return true;
    }

    public boolean rsUpdateRowset(CobolVar cobolVar, ObjectVar objectVar, int n2) {
        EsqlCursor esqlCursor = null;
        int n3 = 0;
        this.clearSqlca(cobolVar);
        try {
            esqlCursor = this.getCursor(objectVar);
            if (esqlCursor.getResultSet() == null) {
                throw new SQLException(" Cursor null", " updateRowset");
            }
            if (n2 == 0) {
                esqlCursor.beforeFirst();
                while (esqlCursor.next()) {
                    esqlCursor.updateHostVars();
                    esqlCursor.updateRow();
                    ++n3;
                }
                this.actSqlca.SQLERRD.at(new int[]{3}).set(n3);
            } else {
                n3 = esqlCursor.getRow();
                esqlCursor.absolute(n2);
                if (!esqlCursor.absolute(n2)) {
                    throw new SQLException(" Invalid row ", " updateRowset");
                }
                esqlCursor.updateHostVars();
                esqlCursor.updateRow();
                if (n3 >= n2) {
                    --n3;
                }
                esqlCursor.absolute(n3);
                this.actSqlca.SQLERRD.at(new int[]{3}).set(1);
            }
            if (this.log != null) {
                this.log.info("EsqlRuntime: UPDATE CURRENT ROWSET [" + esqlCursor.name + "] row " + n2 + " connection [" + (this.getCName() == null ? "invalid --> NULL" : this.getCName()) + this.actSqlca.strNumTdd + "] SQLCODE [" + this.actSqlca.SQLCODE.toString() + "]");
            }
        }
        catch (SQLException sQLException) {
            this.fillSqlca(sQLException, cobolVar);
            if (this.log != null) {
                String string = "null";
                if (esqlCursor != null) {
                    // empty if block
                }
                string = esqlCursor.name;
                this.log.info("EsqlRuntime: UPDATE CURRENT ROWSET [" + string + "] connection [" + (this.getCName() == null ? "invalid --> NULL" : this.getCName()) + this.actSqlca.strNumTdd + "] exception [" + sQLException + "] SQLCODE [" + this.actSqlca.SQLCODE.toString() + "]");
            }
            return false;
        }
        return true;
    }

    public boolean rsUpdateNull(CobolVar cobolVar, ObjectVar objectVar, String string) {
        this.clearSqlca(cobolVar);
        try {
            EsqlCursor esqlCursor = this.getCursor(objectVar);
            esqlCursor.updateNull(string);
        }
        catch (SQLException sQLException) {
            this.fillSqlca(sQLException, cobolVar);
            return false;
        }
        return true;
    }

    public boolean rsDeleteRow(CobolVar cobolVar, ObjectVar objectVar) {
        EsqlCursor esqlCursor = null;
        try {
            esqlCursor = this.getCursor(objectVar);
            if (esqlCursor.isRowset()) {
                return this.rsDeleteRowset(cobolVar, objectVar, 0);
            }
            esqlCursor.deleteRow();
            if (this.log != null) {
                this.log.info("EsqlRuntime: DELETE CURRENT [" + esqlCursor.name + "] connection [" + (this.getCName() == null ? "invalid --> NULL" : this.getCName()) + this.actSqlca.strNumTdd + "] SQLCODE [" + this.actSqlca.SQLCODE.toString() + "]");
            }
        }
        catch (SQLException sQLException) {
            this.fillSqlca(sQLException, cobolVar);
            if (this.log != null) {
                String string = "null";
                if (esqlCursor != null) {
                    // empty if block
                }
                string = esqlCursor.name;
                this.log.info("EsqlRuntime: DELETE CURRENT [" + string + "] connection [" + (this.getCName() == null ? "invalid --> NULL" : this.getCName()) + this.actSqlca.strNumTdd + "] exception [" + sQLException + "] SQLCODE [" + this.actSqlca.SQLCODE.toString() + "]");
            }
            return false;
        }
        return true;
    }

    public boolean rsDeleteRowset(CobolVar cobolVar, ObjectVar objectVar, int n2) {
        EsqlCursor esqlCursor = null;
        int n3 = 0;
        this.clearSqlca(cobolVar);
        try {
            esqlCursor = this.getCursor(objectVar);
            if (esqlCursor.getResultSet() == null) {
                throw new SQLException(" Cursor null", " deleteRowset");
            }
            if (n2 == 0) {
                esqlCursor.beforeFirst();
                while (esqlCursor.next()) {
                    esqlCursor.deleteRow();
                    ++n3;
                }
            } else {
                n3 = esqlCursor.getRow();
                if (!esqlCursor.absolute(n2)) {
                    throw new SQLException(" Invalid row ", " deleteRowset");
                }
                esqlCursor.deleteRow();
                if (n3 >= n2) {
                    --n3;
                }
                esqlCursor.absolute(n3);
                this.actSqlca.SQLERRD.at(new int[]{3}).set(1);
            }
            if (this.log != null) {
                this.log.info("EsqlRuntime: DELETE CURRENT ROWSET [" + esqlCursor.name + "] row " + n2 + " connection [" + (this.getCName() == null ? "invalid --> NULL" : this.getCName()) + this.actSqlca.strNumTdd + "] SQLCODE [" + this.actSqlca.SQLCODE.toString() + "]");
            }
        }
        catch (SQLException sQLException) {
            this.fillSqlca(sQLException, cobolVar);
            if (this.log != null) {
                String string = "null";
                if (esqlCursor != null) {
                    // empty if block
                }
                string = esqlCursor.name;
                this.log.info("EsqlRuntime: DELETE CURRENT ROWSET [" + string + "] connection [" + (this.getCName() == null ? "invalid --> NULL" : this.getCName()) + this.actSqlca.strNumTdd + "] exception [" + sQLException + "] SQLCODE [" + this.actSqlca.SQLCODE.toString() + "]");
            }
            return false;
        }
        return true;
    }

    public synchronized boolean describe(CobolVar cobolVar, boolean bl, String string, CobolVar cobolVar2) {
        this.linkSqlda(cobolVar2);
        this.actSqlda.isSelect = bl;
        if (this.log != null) {
            this.log.info("EsqlRuntime: DESCRIBE " + (bl ? "SELECT LIST " : "BIND VARIABLES") + " FOR " + string + " INTO " + cobolVar2.getName() + " connection [" + (this.getCName() == null ? "invalid --> NULL" : this.getCName()) + "] SQLCODE [" + this.actSqlca.SQLCODE.toString() + "]");
        }
        try {
            EsqlPrepare esqlPrepare = (EsqlPrepare)this.actSqlca.allPrepares.get(string);
            if (esqlPrepare == null) {
                EsqlRuntime.esqlError(3, ": Missing prepare " + string);
            }
            int n2 = 0;
            String string2 = "";
            if (!bl) {
                int n3;
                ParameterMetaData parameterMetaData = esqlPrepare.getHstmt().getParameterMetaData();
                Vector vector = esqlPrepare.getNameBind();
                if (vector != null) {
                    n2 = vector.size();
                }
                this.actSqlda.SQLDFND.set(n2);
                for (n3 = 1; n3 <= n2; ++n3) {
                    this.actSqlda.DVTYP.atNC(n3).set(0);
                    this.actSqlda.DH_CUR_VNAMEL.atNC(n3).set(0);
                    this.actSqlda.DI_CUR_VNAMEL.atNC(n3).set(0);
                }
                for (n3 = 1; n3 <= n2; ++n3) {
                    string2 = (String)vector.get(n3 - 1);
                    this.actSqlda.DH_CUR_VNAMEL.atNC(n3).set(string2.length());
                    if (string2.length() > this.actSqlda.DH_MAX_VNAMEL.atNC(n3).toint()) {
                        string2 = string2.substring(0, this.actSqlda.DH_MAX_VNAMEL.atNC(n3).toint());
                    }
                    ((CobolVar)this.actSqlda.DH_VNAME.atNC(n3).getOId()).set(string2);
                }
            } else {
                ResultSetMetaData resultSetMetaData = esqlPrepare.getHstmt().getMetaData();
                n2 = resultSetMetaData.getColumnCount();
                this.actSqlda.SQLDFND.set(n2);
                for (int i2 = 1; i2 <= n2; ++i2) {
                    this.actSqlda.DVLN.atNC(i2).set(resultSetMetaData.getPrecision(i2));
                    this.actSqlda.DVTYP.atNC(i2).set(sqlTypesOra.get(resultSetMetaData.getColumnType(i2)));
                    string2 = resultSetMetaData.getColumnName(i2);
                    this.actSqlda.DH_CUR_VNAMEL.atNC(i2).set(string2.length());
                    if (string2.length() > this.actSqlda.DH_MAX_VNAMEL.atNC(i2).toint()) {
                        string2 = string2.substring(0, this.actSqlda.DH_MAX_VNAMEL.atNC(i2).toint());
                    }
                    if ((CobolVar)this.actSqlda.DH_VNAME.atNC(i2).getOId() == null) continue;
                    ((CobolVar)this.actSqlda.DH_VNAME.atNC(i2).getOId()).set(string2);
                }
            }
        }
        catch (SQLException sQLException) {
            this.fillSqlca(sQLException, cobolVar);
            if (this.log != null) {
                this.log.info("EsqlRuntime: DESCRIBE  name [" + string + "] exception [" + sQLException + "] SQLCODE [" + this.actSqlca.SQLCODE.toString() + "]");
            }
            return false;
        }
        return true;
    }

    public synchronized boolean describeDb2(CobolVar cobolVar, String string, String string2, CobolVar cobolVar2) {
        int n2 = 452;
        this.clearSqlca(cobolVar);
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        try {
            EsqlPrepare esqlPrepare;
            if (this.getCConn() == null) {
                EsqlRuntime.esqlError(3, ": Missing connection");
            }
            if ((esqlPrepare = (EsqlPrepare)this.actSqlca.allPrepares.get(string2)) == null) {
                EsqlRuntime.esqlError(3, ": Missing prepare " + string2);
            }
            this.linkSqldaDb2(cobolVar2);
            if (string.equalsIgnoreCase("INPUT")) {
                ParameterMetaData parameterMetaData = esqlPrepare.getHstmt().getParameterMetaData();
                n4 = parameterMetaData.getParameterCount();
                n5 = this.actSqldaDb2.SQLN.toint();
                this.actSqldaDb2.SQLD.set(n4);
                if (n5 < n4) {
                    n4 = 0;
                }
                for (int i2 = 1; i2 <= n4; ++i2) {
                    if (parameterMetaData.getParameterMode(i2) != 1) continue;
                    n3 = parameterMetaData.getParameterType(i2);
                    if (sqlTypes.get(n3) != null) {
                        n3 = (Integer)sqlTypes.get(n3);
                    } else {
                        n3 = n2;
                        if (this.log != null) {
                            this.log.info("EsqlRuntime: DESCRIBE INPUT :SQLDA column " + i2 + " sqltype not found " + n3 + "default 452 USED");
                        }
                    }
                    if (parameterMetaData.isNullable(i2) == 1) {
                        ++n3;
                    }
                    this.actSqldaDb2.SQLTYPE.atNC(i2).set(n3);
                    if (parameterMetaData.getParameterType(i2) == 3) {
                        this.actSqldaDb2.SQLLEN.atNC(i2).set(parameterMetaData.getPrecision(i2) + parameterMetaData.getScale(i2));
                        continue;
                    }
                    this.actSqldaDb2.SQLLEN.atNC(i2).set(parameterMetaData.getPrecision(i2));
                }
                if (this.log != null) {
                    this.log.info("EsqlRuntime: DESCRIBE INPUT  :SQLDA connection [" + (this.getCName() == null ? "invalid --> NULL" : this.getCName()) + this.actSqlca.strNumTdd + "] name [" + esqlPrepare.getName() + "]] SQLCODE [" + this.actSqlca.SQLCODE.toString() + "]");
                }
            } else {
                ResultSetMetaData resultSetMetaData = esqlPrepare.getHstmt().getMetaData();
                n4 = resultSetMetaData.getColumnCount();
                n5 = this.actSqldaDb2.SQLN.toint();
                this.actSqldaDb2.SQLD.set(n4);
                if (n5 < n4) {
                    n4 = 0;
                }
                for (int i3 = 1; i3 <= n4; ++i3) {
                    n3 = resultSetMetaData.getColumnType(i3);
                    if (sqlTypes.get(n3) != null) {
                        n3 = (Integer)sqlTypes.get(n3);
                    } else {
                        n3 = n2;
                        if (this.log != null) {
                            this.log.info("EsqlRuntime: DESCRIBE OUTPUT :SQLDA column " + i3 + " sqltype not found " + n3 + "default 452 USED");
                        }
                    }
                    if (resultSetMetaData.isNullable(i3) == 1) {
                        ++n3;
                    }
                    this.actSqldaDb2.SQLTYPE.atNC(i3).set(n3);
                    if (resultSetMetaData.getColumnType(i3) == 3) {
                        this.actSqldaDb2.SQLLEN.atNC(i3).set(resultSetMetaData.getPrecision(i3) + resultSetMetaData.getScale(i3));
                    } else {
                        this.actSqldaDb2.SQLLEN.atNC(i3).set(resultSetMetaData.getPrecision(i3));
                    }
                    this.actSqldaDb2.SQLNAMEC.atNC(i3).set(resultSetMetaData.getColumnName(i3));
                    this.actSqldaDb2.SQLNAMEL.atNC(i3).set(resultSetMetaData.getColumnName(i3).trim().length());
                }
                if (this.log != null) {
                    this.log.info("EsqlRuntime: DESCRIBE OUTPUT  :SQLDA connection [" + (this.getCName() == null ? "invalid --> NULL" : this.getCName()) + this.actSqlca.strNumTdd + "] name [" + esqlPrepare.getName() + "]] SQLCODE [" + this.actSqlca.SQLCODE.toString() + "]");
                }
            }
        }
        catch (SQLException sQLException) {
            this.fillSqlca(sQLException, cobolVar);
            if (this.log != null) {
                this.log.info("EsqlRuntime: DESCRIBE " + string + " :SQLDA connection [" + (this.getCName() == null ? "invalid --> NULL" : this.getCName()) + this.actSqlca.strNumTdd + "] name [" + string2 + "] exception [" + sQLException + "] SQLCODE [" + this.actSqlca.SQLCODE.toString() + "]");
            }
            return false;
        }
        return true;
    }

    public synchronized boolean startRowset(CobolVar cobolVar, ObjectVar objectVar, int n2, boolean bl) {
        EsqlCursor esqlCursor = null;
        this.clearSqlca(cobolVar);
        try {
            if (this.getCConn() == null) {
                EsqlRuntime.esqlError(3, ": Missing connection");
            }
            esqlCursor = this.getCursor(objectVar);
            esqlCursor.startRowset(n2, bl);
        }
        catch (SQLException sQLException) {
            return false;
        }
        return true;
    }

    public synchronized boolean savepoint(CobolVar cobolVar, String string, boolean bl, boolean bl2, boolean bl3) {
        this.clearSqlca(cobolVar);
        try {
            if (this.getCConn() == null) {
                EsqlRuntime.esqlError(3, ": Missing connection");
            }
            Savepoint savepoint = this.getCConn().setSavepoint(string);
            this.actSqlca.allSavepoint.put(string, savepoint);
            if (this.log != null) {
                this.log.info("EsqlRuntime: SAVEPOINT connection [" + (this.getCName() == null ? "invalid --> NULL" : this.getCName()) + this.actSqlca.strNumTdd + "] savepoint[" + string + "] SQLCODE [" + this.actSqlca.SQLCODE.toString() + "]");
            }
        }
        catch (SQLException sQLException) {
            this.fillSqlca(sQLException, cobolVar);
            if (this.log != null) {
                this.log.info("EsqlRuntime: SAVEPOINT connection [" + (this.getCName() == null ? "invalid --> NULL" : this.getCName()) + this.actSqlca.strNumTdd + "] savepoint[" + string + "] exception [" + sQLException + "] SQLCODE [" + this.actSqlca.SQLCODE.toString() + "]");
            }
            return false;
        }
        return true;
    }

    public synchronized boolean release(CobolVar cobolVar, String string) {
        this.clearSqlca(cobolVar);
        try {
            if (this.getCConn() == null) {
                EsqlRuntime.esqlError(3, ": Missing connection");
            }
            Savepoint savepoint = (Savepoint)this.actSqlca.allSavepoint.get(string);
            this.getCConn().releaseSavepoint(savepoint);
            this.actSqlca.allSavepoint.remove(string);
            if (this.log != null) {
                this.log.info("EsqlRuntime: RELEASE connection [" + (this.getCName() == null ? "invalid --> NULL" : this.getCName()) + this.actSqlca.strNumTdd + "] savepoint[" + string + "] SQLCODE [" + this.actSqlca.SQLCODE.toString() + "]");
            }
        }
        catch (SQLException sQLException) {
            this.fillSqlca(sQLException, cobolVar);
            if (this.log != null) {
                this.log.info("EsqlRuntime: RELEASE connection [" + (this.getCName() == null ? "invalid --> NULL" : this.getCName()) + this.actSqlca.strNumTdd + "] savepoint[" + string + "] exception [" + sQLException + "] SQLCODE [" + this.actSqlca.SQLCODE.toString() + "]");
            }
            return false;
        }
        return true;
    }

    public void setCodeNull() {
        this.actSqlca = this.getSqlca();
        this.actSqlca.SQLCODE.set(codeNull);
        this.actSqlca.SQLERRMC.set(" ");
    }

    private EsqlSqlca getSqlca() {
        return (EsqlSqlca)Factory.getCurrent().getTdd().sqlca;
    }

    private String getCName() {
        return this.getSqlca().currName;
    }

    public synchronized Connection getCConn() {
        EsqlSqlca esqlSqlca = this.getSqlca();
        Connection connection = esqlSqlca == null ? this.defConn : esqlSqlca.currConn;
        if (connection == null && automaticConnection) {
            if (esqlSqlca != null) {
                this.connect(esqlSqlca.SQLCA, "", "", "", "DEFAULT");
            } else {
                this.connect(null, "", "", "", "DEFAULT");
            }
            connection = esqlSqlca == null ? this.defConn : esqlSqlca.currConn;
        }
        return connection;
    }

    public synchronized ResultSet getIResultSet(String string) {
        ResultSet resultSet = null;
        EsqlCursor esqlCursor = null;
        if (string != null) {
            String string2 = string.toUpperCase();
            if (curSqlca != null && EsqlRuntime.curSqlca.allCursors != null) {
                for (int i2 = EsqlRuntime.curSqlca.allCursors.size() - 1; i2 >= 0; --i2) {
                    esqlCursor = (EsqlCursor)EsqlRuntime.curSqlca.allCursors.get(i2);
                    if (!esqlCursor.name.equalsIgnoreCase(string2)) continue;
                    return esqlCursor.getResultSet();
                }
            }
        }
        return resultSet;
    }

    public int decodeErr(int n2) {
        if (this.getSqlca().errDecode.get("" + n2) != null) {
            return Integer.parseInt((String)this.getSqlca().errDecode.get("" + n2));
        }
        return n2;
    }

    private void linkSqlda(CobolVar cobolVar) {
        if (this.actSqlda == null) {
            this.actSqlda = new EsqlSqlda();
        }
        this.actSqlda.DSC.link(cobolVar);
    }

    private void linkSqldaDb2(CobolVar cobolVar) {
        if (this.actSqldaDb2 == null) {
            this.actSqldaDb2 = new EsqlSqldaDb2();
        }
        this.actSqldaDb2.SQLDA.link(cobolVar);
    }

    public Connection getConn(CobolVar cobolVar) {
        this.clearSqlca(cobolVar);
        return this.getCConn();
    }

    public Connection getConn() {
        return this.getCConn();
    }

    public void logSqlj(String string) {
        if (this.log != null) {
            this.log.info(string);
        }
    }

    public int getErrorFact() {
        return errorFact;
    }

    public boolean isQueryToChange() {
        return methodPrepareDecoder != null;
    }

    public void changeQuery(CobolVar cobolVar) {
        block4: {
            if (this.log != null) {
                this.log.info("EsqlRuntime: before invoke method prepareDecoder " + methodPrepareDecoder.toString() + "query =" + cobolVar.toString());
            }
            try {
                handlerPrepareDecoder.queryDecoder(cobolVar);
            }
            catch (Exception exception) {
                if (this.log == null) break block4;
                this.log.info("EsqlRuntime: invoking method prepareDecoder of " + classPrepareDecoderName + " there is the following exception " + exception);
            }
        }
        if (this.log != null) {
            this.log.info("EsqlRuntime: after invoke method prepareDecoder " + methodPrepareDecoder.toString() + "query =" + cobolVar.toString());
        }
    }

    static {
        sqlTypes = new Hashtable();
        sqlTypes.put(2004, 404);
        sqlTypes.put(2005, 408);
        sqlTypes.put(-2, 912);
        sqlTypes.put(-3, 908);
        sqlTypes.put(-8, 904);
        sqlTypes.put(12, 448);
        sqlTypes.put(1, 452);
        sqlTypes.put(-1, 456);
        sqlTypes.put(-16, 464);
        sqlTypes.put(2011, 468);
        sqlTypes.put(6, 480);
        sqlTypes.put(3, 484);
        sqlTypes.put(4, 496);
        sqlTypes.put(-5, 492);
        sqlTypes.put(5, 500);
        sqlTypes.put(91, 384);
        sqlTypes.put(92, 388);
        sqlTypes.put(93, 392);
        sqlTypesOra = new Hashtable();
        sqlTypesOra.put(2004, 94);
        sqlTypesOra.put(2005, 95);
        sqlTypesOra.put(-2, 4);
        sqlTypesOra.put(-3, 4);
        sqlTypesOra.put(-8, 11);
        sqlTypesOra.put(12, 1);
        sqlTypesOra.put(1, 1);
        sqlTypesOra.put(-1, 94);
        sqlTypesOra.put(-16, 95);
        sqlTypesOra.put(2011, 95);
        sqlTypesOra.put(6, 4);
        sqlTypesOra.put(3, 7);
        sqlTypesOra.put(4, 3);
        sqlTypesOra.put(-5, 3);
        sqlTypesOra.put(5, 3);
        sqlTypesOra.put(91, 12);
        sqlTypesOra.put(92, 12);
        sqlTypesOra.put(93, 12);
        sqlTypesOraRev = new Hashtable();
        sqlTypesOraRev.put(11, -8);
        sqlTypesOraRev.put(1, 12);
        sqlTypesOraRev.put(94, -1);
        sqlTypesOraRev.put(95, -16);
        sqlTypesOraRev.put(4, 6);
        sqlTypesOraRev.put(7, 3);
        sqlTypesOraRev.put(3, 4);
        sqlTypesOraRev.put(12, 91);
        nullParamClass = new Class[0];
        nullParam = new Object[0];
        ZERO = Factory.getAllNumLiteral(0L, 1, 0, false);
        allErrors = new String[][]{{"00000", ""}, {"IN001", "Duplicate PREPARE name "}, {"IN002", "Already connected "}, {"IN003", "Invalid sequence "}, {"IN004", "Invalid paramater "}, {"IN005", "Cursor not declared "}, {"IN006", "Invalid handle "}, {"IN007", "Not supported call "}, {"IN008", "Invalid JDBC driver "}, {"IN009", "Invalid data source "}, {"IN999", "Internal error "}, {"08000", "Connection exception "}, {"08001", "Unable to establish connection "}, {"08002", "Connection name in use "}, {"08003", "Connection does not exist "}, {"08004", "Server rejected the connection "}, {"08006", "Connection failure "}, {"08007", "Transaction resolution unknown "}, {"01004", "String data, right truncation "}, {"00000", ""}};
        dataTruncation = new SQLWarning(allErrors[18][1], allErrors[18][0], 1004);
        IscobolSystem.setLoaded(EsqlRuntime.class);
        concurrency = Config.a(".jdbc.cursor.concurrency", 1007);
        errorFact = Config.b(".esql.error.negative", false) ? -1 : 1;
        warnings = Config.b(".esql.warnings", false);
        modeIODef = Config.a(".esql.default_param_type", "INOUT");
        typeIndTrunk = Config.b(".esql.indicator_trunc_on_call", true) ? 2 : 3;
        automaticConnection = Config.b(".jdbc.auto_connect", false);
        db2DataRowAsByteThreshold = Config.a(".jdbc.url", "").startsWith("jdbc:db2:") ? Config.a(".esql.db2.row_data_as_bytes_threshold", 0) : 0;
        picXHandling = Config.a(".esql.picx_handling", 0);
        codeNull = Config.a(".esql.value_sqlcode_on_null", 1405);
        noData = Config.a(".esql.value_sqlcode_on_no_data", 0);
        tooManyRows = Config.a(".esql.value_too_many_rows", 0);
        classSqlcaDecoderName = Config.a(".esql.sqlca_handler", "");
        if (classSqlcaDecoderName.length() > 0) {
            try {
                classSqlcaDecoder = Class.forName(classSqlcaDecoderName);
                handlerSqlcaDecoder = (EsqlSqlcaHandler)Class.forName(classSqlcaDecoderName).newInstance();
                methodSqlcaDecoder = classSqlcaDecoder.getMethod("sqlcaDecoder", SQLException.class, CobolVar.class, CobolVar.class, CobolVar.class);
            }
            catch (Exception exception) {
                throw new IscobolRuntimeException(exception);
            }
        } else {
            classSqlcaDecoder = null;
            methodSqlcaDecoder = null;
            handlerSqlcaDecoder = null;
        }
        classPrepareDecoderName = Config.a(".esql.prepare_handler", "");
        if (classPrepareDecoderName.length() > 0) {
            try {
                classPrepareDecoder = Class.forName(classPrepareDecoderName);
                handlerPrepareDecoder = (EsqlPrepareHandler)Class.forName(classPrepareDecoderName).newInstance();
                methodPrepareDecoder = classPrepareDecoder.getMethod("queryDecoder", CobolVar.class);
                methodPrepareDecoder.setAccessible(true);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw new IscobolRuntimeException(exception);
            }
        } else {
            classPrepareDecoder = null;
            methodPrepareDecoder = null;
            handlerPrepareDecoder = null;
        }
        if (db2DataRowAsByteThreshold > 0) {
            try {
                Class<?> clazz = Class.forName("com.ibm.db2.jcc.DB2ResultSet");
                getDBRowDataAsBytes = clazz.getMethod("getDBRowDataAsBytes", nullParamClass);
                getDBRowDescriptor = clazz.getMethod("getDBRowDescriptor", nullParamClass);
            }
            catch (Exception exception) {
                throw new IscobolRuntimeException(exception);
            }
        }
    }

    class EsqlSqldaDb2 {
        EsqlHostVar hv = null;
        String cursorName = "";
        Vector indicators = new Vector();
        Vector values = new Vector();
        NumericVar ind = Factory.getNumLiteral(750L, 3, 0, false);
        boolean isSelect = false;
        PicX SQLDA = Factory.getVarAlphanum(Factory.getMem(33016), 0, 33016, false, null, null, null, "SQLDA", false, false);
        PicX SQLDAID = Factory.getVarAlphanum(this.SQLDA, 0, 8, false, null, null, null, "SQLDAID", false, false);
        NumericVar SQLDABC = Factory.getVarBinary(this.SQLDA, 8, 4, false, null, null, null, "SQLDABC", false, 8, 0, true, false, false, false);
        NumericVar SQLN = Factory.getVarBinary(this.SQLDA, 12, 2, false, null, null, null, "SQLN", false, 4, 0, true, false, false, false);
        NumericVar SQLD = Factory.getVarBinary(this.SQLDA, 14, 2, false, null, null, null, "SQLD", false, 4, 0, true, false, false, false);
        PicX SQLVAR = Factory.getVarAlphanum(this.SQLDA, 16, 44, false, null, new int[]{44}, new int[]{750}, "SQLVAR", false, false);
        NumericVar SQLTYPE = Factory.getVarBinary(this.SQLVAR, 16, 2, false, null, new int[]{44}, new int[]{750}, "SQLTYPE", false, 4, 0, true, false, false, false);
        NumericVar SQLLEN = Factory.getVarBinary(this.SQLVAR, 18, 2, false, null, new int[]{44}, new int[]{750}, "SQLLEN", false, 4, 0, true, false, false, false);
        NumericVar SQLDATA = Factory.getVarObject(this.SQLVAR, 20, 4, false, null, new int[]{44}, new int[]{750}, "SQLDATA", false, 0, 0, false, false, false);
        NumericVar SQLIND = Factory.getVarObject(this.SQLVAR, 24, 4, false, null, new int[]{44}, new int[]{750}, "SQLIND", false, 0, 0, false, false, false);
        NumericVar SQLNAMEL = Factory.getVarBinary(this.SQLVAR, 28, 2, false, null, new int[]{44}, new int[]{750}, "SQLNAMEL", false, 4, 0, true, false, false, false);
        PicX SQLNAMEC = Factory.getVarAlphanum(this.SQLVAR, 30, 30, false, null, new int[]{44}, new int[]{750}, "SQLNAMEC", false, false);

        EsqlSqldaDb2() {
        }
    }

    class EsqlSqlda {
        EsqlHostVar hv = null;
        String cursorName = "";
        Hashtable allOpenDescr = new Hashtable();
        Vector names = new Vector();
        Vector values = new Vector();
        NumericVar ind = Factory.getNumLiteral(1000L, 3, 0, false);
        boolean isSelect = false;
        PicX DSC = Factory.getVarAlphanum((byte[])null, 0, 4408, false, null, null, null, "DSC", false, false);
        NumericVar SQLDNUM = Factory.getVarBinary(this.DSC, 0, 4, false, this.ind, null, null, "SQLDNUM", false, 9, 0, true, false, false, false);
        NumericVar SQLDFND = Factory.getVarBinary(this.DSC, 4, 4, false, null, null, null, "SQLDFND", false, 9, 0, true, false, false, false);
        PicX DVAR = Factory.getVarAlphanum(this.DSC, 8, 44, false, null, new int[]{44}, new int[]{1000}, "DVAR", false, false);
        NumericVar DV = Factory.getVarBinary(this.DVAR, 8, 4, false, null, new int[]{44}, new int[]{1000}, "DV", false, 9, 0, true, false, false, false);
        NumericVar DFTM = Factory.getVarBinary(this.DVAR, 12, 4, false, null, new int[]{44}, new int[]{1000}, "DFTM", false, 9, 0, true, false, false, false);
        NumericVar DVLN = Factory.getVarBinary(this.DVAR, 16, 4, false, null, new int[]{44}, new int[]{1000}, "DVLN", false, 9, 0, true, false, false, false);
        NumericVar DFMTL = Factory.getVarBinary(this.DVAR, 20, 2, false, null, new int[]{44}, new int[]{1000}, "DFMTL", false, 4, 0, true, false, false, false);
        NumericVar DVTYP = Factory.getVarBinary(this.DVAR, 22, 2, false, null, new int[]{44}, new int[]{1000}, "DVTYP", false, 4, 0, true, false, false, false);
        NumericVar DI = Factory.getVarBinary(this.DVAR, 24, 4, false, null, new int[]{44}, new int[]{1000}, "DI", false, 9, 0, true, false, false, false);
        NumericVar DH_VNAME = Factory.getVarBinary(this.DVAR, 28, 4, false, null, new int[]{44}, new int[]{1000}, "DH-VNAME", false, 9, 0, true, false, false, false);
        NumericVar DH_MAX_VNAMEL = Factory.getVarBinary(this.DVAR, 32, 2, false, null, new int[]{44}, new int[]{1000}, "DH-MAX-VNAMEL", false, 4, 0, true, false, false, false);
        NumericVar DH_CUR_VNAMEL = Factory.getVarBinary(this.DVAR, 34, 2, false, null, new int[]{44}, new int[]{1000}, "DH-CUR-VNAMEL", false, 4, 0, true, false, false, false);
        NumericVar DI_VNAME = Factory.getVarBinary(this.DVAR, 36, 4, false, null, new int[]{44}, new int[]{1000}, "DI-VNAME", false, 9, 0, true, false, false, false);
        NumericVar DI_MAX_VNAMEL = Factory.getVarBinary(this.DVAR, 40, 2, false, null, new int[]{44}, new int[]{1000}, "DI-MAX-VNAMEL", false, 4, 0, true, false, false, false);
        NumericVar DI_CUR_VNAMEL = Factory.getVarBinary(this.DVAR, 42, 2, false, null, new int[]{44}, new int[]{1000}, "DI-CUR-VNAMEL", false, 4, 0, true, false, false, false);
        NumericVar DFCLP = Factory.getVarBinary(this.DVAR, 44, 4, false, null, new int[]{44}, new int[]{1000}, "DFCLP", false, 9, 0, true, false, false, false);
        NumericVar DFCRCP = Factory.getVarBinary(this.DVAR, 48, 4, false, null, new int[]{44}, new int[]{1000}, "DFCRCP", false, 9, 0, true, false, false, false);

        EsqlSqlda() {
        }
    }

    class EsqlSqlca {
        EsqlHostVar hv = null;
        String strNumTdd = "";
        int numTdd = 0;
        Hashtable allPrepares = new Hashtable();
        Hashtable allCursHndl = new Hashtable();
        Hashtable allSelect = new Hashtable();
        Hashtable allSavepoint = new Hashtable();
        Hashtable errDecode;
        Connection currConn;
        String currName;
        Statement regDb2;
        Vector allCursors = new Vector();
        int sqlcaLen = 320;
        String sqlcaType = "noType";
        PicX SQLCA;
        PicX SQLCAID;
        NumericVar SQLCABC;
        NumericVar SQLCODE;
        NumericVar SQLERRML;
        PicX SQLERRM;
        PicX SQLERRMC;
        PicX SQLERRP;
        NumericVar SQLERRD;
        PicX SQLWARN;
        PicX SQLWARN0;
        PicX SQLWARN1;
        PicX SQLWARN2;
        PicX SQLWARN3;
        PicX SQLWARN4;
        PicX SQLWARN5;
        PicX SQLWARN6;
        PicX SQLWARN7;
        PicX SQLSTATE;
        NumericVar SQLEXT;
        PicX SQLWARN8;
        PicX SQLWARN9;
        PicX SQLWARNA;
        PicX SQLEXTP;

        public EsqlSqlca(CobolVar cobolVar) {
            this.sqlcaLen = cobolVar.getMaxLength();
            if (this.sqlcaLen == 136 && Factory.sqlcaDb2) {
                this.sqlcaType = "IBM";
                this.SQLCA = Factory.getVarAlphanum((byte[])null, 0, 136, false, null, null, null, "SQLCA", false, false);
                this.SQLCAID = Factory.getVarAlphanum(this.SQLCA, 0, 8, false, null, null, null, "SQLCAID", false, false);
                this.SQLCABC = Factory.getVarBinary(this.SQLCA, 8, 4, false, null, null, null, "SQLCABC", false, 9, 0, true, false, false, false);
                this.SQLCODE = Factory.getVarBinary(this.SQLCA, 12, 4, false, null, null, null, "SQLCODE", false, 9, 0, true, false, false, false);
                this.SQLERRM = Factory.getVarAlphanum(this.SQLCA, 16, 72, false, null, null, null, "SQLERRM", false, false);
                this.SQLERRML = Factory.getVarBinary(this.SQLERRM, 16, 2, false, null, null, null, "SQLERRML", false, 4, 0, true, false, false, false);
                this.SQLERRMC = Factory.getVarAlphanum(this.SQLERRM, 18, 70, false, null, null, null, "SQLERRMC", false, false);
                this.SQLERRP = Factory.getVarAlphanum(this.SQLCA, 88, 8, false, null, null, null, "SQLERRP", false, false);
                this.SQLERRD = Factory.getVarBinary(this.SQLCA, 96, 4, false, null, new int[]{4}, new int[]{6}, "SQLERRD", false, 9, 0, true, false, false, false);
                this.SQLWARN = Factory.getVarAlphanum(this.SQLCA, 120, 11, false, null, null, null, "SQLWARN", false, false);
                this.SQLWARN0 = Factory.getVarAlphanum(this.SQLWARN, 120, 1, false, null, null, null, "SQLWARN0", false, false);
                this.SQLWARN1 = Factory.getVarAlphanum(this.SQLWARN, 121, 1, false, null, null, null, "SQLWARN1", false, false);
                this.SQLWARN2 = Factory.getVarAlphanum(this.SQLWARN, 122, 1, false, null, null, null, "SQLWARN2", false, false);
                this.SQLWARN3 = Factory.getVarAlphanum(this.SQLWARN, 123, 1, false, null, null, null, "SQLWARN3", false, false);
                this.SQLWARN4 = Factory.getVarAlphanum(this.SQLWARN, 124, 1, false, null, null, null, "SQLWARN4", false, false);
                this.SQLWARN5 = Factory.getVarAlphanum(this.SQLWARN, 125, 1, false, null, null, null, "SQLWARN5", false, false);
                this.SQLWARN6 = Factory.getVarAlphanum(this.SQLWARN, 126, 1, false, null, null, null, "SQLWARN6", false, false);
                this.SQLWARN7 = Factory.getVarAlphanum(this.SQLWARN, 127, 1, false, null, null, null, "SQLWARN7", false, false);
                this.SQLWARN8 = Factory.getVarAlphanum(this.SQLWARN, 128, 1, false, null, null, null, "SQLWARN8", false, false);
                this.SQLWARN9 = Factory.getVarAlphanum(this.SQLWARN, 129, 1, false, null, null, null, "SQLWARN9", false, false);
                this.SQLWARNA = Factory.getVarAlphanum(this.SQLWARN, 130, 1, false, null, null, null, "SQLWARNA", false, false);
                this.SQLSTATE = Factory.getVarAlphanum(this.SQLCA, 131, 5, false, null, null, null, "SQLSTATE", false, false);
            } else if (this.sqlcaLen == 136) {
                this.sqlcaType = "PROCOB";
                this.SQLCA = Factory.getVarAlphanum((byte[])null, 0, 136, false, null, null, null, "SQLCA", false, false);
                this.SQLCAID = Factory.getVarAlphanum(this.SQLCA, 0, 8, false, null, null, null, "SQLCAID", false, false);
                this.SQLCABC = Factory.getVarNativeBinary(this.SQLCA, 8, 4, false, null, null, null, "SQLCABC", false, 9, 0, true, false, false, false);
                this.SQLCODE = Factory.getVarNativeBinary(this.SQLCA, 12, 4, false, null, null, null, "SQLCODE", false, 9, 0, true, false, false, false);
                this.SQLERRM = Factory.getVarAlphanum(this.SQLCA, 16, 72, false, null, null, null, "SQLERRM", false, false);
                this.SQLERRML = Factory.getVarNativeBinary(this.SQLERRM, 16, 2, false, null, null, null, "SQLERRML", false, 4, 0, true, false, false, false);
                this.SQLERRMC = Factory.getVarAlphanum(this.SQLERRM, 18, 70, false, null, null, null, "SQLERRMC", false, false);
                this.SQLERRP = Factory.getVarAlphanum(this.SQLCA, 88, 8, false, null, null, null, "SQLERRP", false, false);
                this.SQLERRD = Factory.getVarNativeBinary(this.SQLCA, 96, 4, false, null, new int[]{4}, new int[]{6}, "SQLERRD", false, 9, 0, true, false, false, false);
                this.SQLWARN = Factory.getVarAlphanum(this.SQLCA, 120, 8, false, null, null, null, "SQLWARN", false, false);
                this.SQLWARN0 = Factory.getVarAlphanum(this.SQLWARN, 120, 1, false, null, null, null, "SQLWARN0", false, false);
                this.SQLWARN1 = Factory.getVarAlphanum(this.SQLWARN, 121, 1, false, null, null, null, "SQLWARN1", false, false);
                this.SQLWARN2 = Factory.getVarAlphanum(this.SQLWARN, 122, 1, false, null, null, null, "SQLWARN2", false, false);
                this.SQLWARN3 = Factory.getVarAlphanum(this.SQLWARN, 123, 1, false, null, null, null, "SQLWARN3", false, false);
                this.SQLWARN4 = Factory.getVarAlphanum(this.SQLWARN, 124, 1, false, null, null, null, "SQLWARN4", false, false);
                this.SQLWARN5 = Factory.getVarAlphanum(this.SQLWARN, 125, 1, false, null, null, null, "SQLWARN5", false, false);
                this.SQLWARN6 = Factory.getVarAlphanum(this.SQLWARN, 126, 1, false, null, null, null, "SQLWARN6", false, false);
                this.SQLWARN7 = Factory.getVarAlphanum(this.SQLWARN, 127, 1, false, null, null, null, "SQLWARN7", false, false);
                this.SQLEXTP = Factory.getVarAlphanum(this.SQLCA, 128, 8, false, null, null, null, "SQLEXT", false, false);
                this.SQLSTATE = Factory.getVarAlphanum(new byte[5], 0, 5, false, null, null, null, "SQLSTATE", false, false);
            } else if (this.sqlcaLen == 320) {
                this.sqlcaType = "isCOBOL";
                this.SQLCA = Factory.getVarAlphanum((byte[])null, 0, 320, false, null, null, null, "SQLCA", false, false);
                this.SQLCAID = Factory.getVarAlphanum(this.SQLCA, 0, 8, false, null, null, null, "SQLCAID", false, false);
                this.SQLCABC = Factory.getVarNativeBinary(this.SQLCA, 8, 4, false, null, null, null, "SQLCABC", false, 9, 0, true, false, false);
                this.SQLCODE = Factory.getVarNativeBinary(this.SQLCA, 12, 4, false, null, null, null, "SQLCODE", false, 9, 0, true, false, false);
                this.SQLERRML = Factory.getVarNativeBinary(this.SQLCA, 16, 2, false, null, null, null, "SQLERRML", false, 4, 0, true, false, false);
                this.SQLERRMC = Factory.getVarAlphanum(this.SQLCA, 18, 254, false, null, null, null, "SQLERRMC", false, false);
                this.SQLERRP = Factory.getVarAlphanum(this.SQLCA, 272, 8, false, null, null, null, "SQLERRP", false, false);
                this.SQLERRD = Factory.getVarNativeBinary(this.SQLCA, 280, 4, false, null, new int[]{4}, new int[]{6}, "SQLERRD", false, 9, 0, true, false, false);
                this.SQLWARN = Factory.getVarAlphanum(this.SQLCA, 304, 8, false, null, null, null, "SQLWARN", false, false);
                this.SQLWARN0 = Factory.getVarAlphanum(this.SQLWARN, 304, 1, false, null, null, null, "SQLWARN0", false, false);
                this.SQLWARN1 = Factory.getVarAlphanum(this.SQLWARN, 305, 1, false, null, null, null, "SQLWARN1", false, false);
                this.SQLWARN2 = Factory.getVarAlphanum(this.SQLWARN, 306, 1, false, null, null, null, "SQLWARN2", false, false);
                this.SQLWARN3 = Factory.getVarAlphanum(this.SQLWARN, 307, 1, false, null, null, null, "SQLWARN3", false, false);
                this.SQLWARN4 = Factory.getVarAlphanum(this.SQLWARN, 308, 1, false, null, null, null, "SQLWARN4", false, false);
                this.SQLWARN5 = Factory.getVarAlphanum(this.SQLWARN, 309, 1, false, null, null, null, "SQLWARN5", false, false);
                this.SQLWARN6 = Factory.getVarAlphanum(this.SQLWARN, 310, 1, false, null, null, null, "SQLWARN6", false, false);
                this.SQLWARN7 = Factory.getVarAlphanum(this.SQLWARN, 311, 1, false, null, null, null, "SQLWARN7", false, false);
                this.SQLSTATE = Factory.getVarAlphanum(this.SQLCA, 312, 5, false, null, null, null, "SQLSTATE", false, false);
                this.SQLEXT = Factory.getVarPackedAcu(this.SQLCA, 317, 3, false, null, null, null, "SQLEXT", false, 5, 0, true, false, false);
            } else {
                throw new IscobolRuntimeException(3, "Invalid SQLCA length " + this.sqlcaLen);
            }
        }
    }
}

