/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.rts;

import com.iscobol.gui.GuiFactory;
import com.iscobol.gui.RemoteImage;
import com.iscobol.gui.ScreenUtility;
import com.iscobol.gui.SerializableImage;
import com.iscobol.gui.server.CobolGUIBitmap;
import com.iscobol.gui.server.FontCmp;
import com.iscobol.gui.server.ScrFactory;
import com.iscobol.rts.BitmapNotFoundException;
import com.iscobol.rts.Config;
import com.iscobol.rts.File;
import com.iscobol.rts.Handle;
import java.awt.Image;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;

public class FileImage
implements Handle,
Serializable,
Cloneable {
    private String filePathStr;
    private java.io.File filePath;
    private long fileTimestamp;
    private boolean replaced;
    private byte[] imgStream;
    private URL fileUrl;
    private RemoteImage imagePeer;
    private int imagePeerId = -1;
    private RemoteImage imagePeerDestroyed;
    private int imagePeerIdDestroyed = -1;
    private Image nativeImage;
    private CobolGUIBitmap guiBitmap;
    public int refCount;
    private FileImage clonesource;
    private boolean destroyed;
    private boolean loadedFromClient;
    private boolean lightGrayIsTransparent = Config.b("iscobol.gui.light_gray_is_transparent", true);

    public FileImage(String string) throws BitmapNotFoundException {
        this(string, false);
    }

    public FileImage(String string, boolean bl) throws BitmapNotFoundException {
        this.setFilePath(string, !bl);
        if (bl) {
            this.imagePeer = this.loadFromClient();
            this.loadedFromClient = bl;
        } else {
            this.imagePeer = this.loadFromFile();
        }
    }

    public FileImage(InputStream inputStream, String string) throws BitmapNotFoundException {
        this.setFilePath(string, true);
        this.imagePeer = this.loadFromInputStream(inputStream);
    }

    public FileImage(byte[] byArray) throws BitmapNotFoundException {
        this.setFilePath(null, false);
        this.imgStream = byArray;
        this.imagePeer = this.loadFromStream();
    }

    public FileImage(URL uRL) throws BitmapNotFoundException {
        this.setFilePath(uRL.toString(), false);
        this.fileUrl = uRL;
        try {
            this.imagePeer = this.loadFromInputStream(uRL.openStream());
        }
        catch (IOException iOException) {
            throw new BitmapNotFoundException(iOException.toString());
        }
    }

    public FileImage(int n2, FontCmp[] fontCmpArray, String[] stringArray, int[] nArray, String string) {
        this.setFilePath(string, false);
        this.imagePeer = this.loadFromFontSymbols(n2, fontCmpArray, stringArray, nArray);
    }

    public FileImage(int n2, int n3, FontCmp fontCmp, String string, int n4, int n5, int n6, int n7, String string2) {
        this.setFilePath(string2, false);
        this.imagePeer = this.loadTextBox(n2, n3, fontCmp, string, n4, n5, n6, n7);
    }

    public FileImage(RemoteImage remoteImage) {
        this.setFilePath(null, false);
        this.imagePeer = remoteImage;
    }

    private void setFilePath(String string, boolean bl) {
        this.filePathStr = string;
        if (this.filePathStr != null && bl) {
            this.filePath = File.get(this.filePathStr.trim());
            if (this.filePath.exists() && this.filePath.isFile()) {
                this.fileTimestamp = this.filePath.lastModified();
            }
        }
    }

    public boolean isLoadedFromClient() {
        return this.loadedFromClient;
    }

    public boolean isModified() {
        return this.filePath != null && this.fileTimestamp > 0L && this.fileTimestamp < this.filePath.lastModified();
    }

    private RemoteImage loadFromFontSymbols(int n2, FontCmp[] fontCmpArray, String[] stringArray, int[] nArray) {
        int[] nArray2 = new int[fontCmpArray.length];
        for (int i2 = 0; i2 < fontCmpArray.length; ++i2) {
            nArray2[i2] = fontCmpArray[i2].getFontId(false);
        }
        GuiFactory guiFactory = ScreenUtility.getGuiFactory();
        try {
            return guiFactory.loadImage(n2, nArray2, stringArray, nArray);
        }
        catch (IOException iOException) {
            ScreenUtility.handleIOException(iOException);
            return null;
        }
    }

    private RemoteImage loadTextBox(int n2, int n3, FontCmp fontCmp, String string, int n4, int n5, int n6, int n7) {
        GuiFactory guiFactory = ScreenUtility.getGuiFactory();
        try {
            return guiFactory.loadImage(n2, n3, fontCmp.getFontId(false), string, n4, n5, n6, n7);
        }
        catch (IOException iOException) {
            ScreenUtility.handleIOException(iOException);
            return null;
        }
    }

    private RemoteImage loadFromClient() {
        GuiFactory guiFactory = ScreenUtility.getGuiFactory();
        try {
            return guiFactory.loadClientImage(this.filePathStr);
        }
        catch (IOException iOException) {
            ScreenUtility.handleIOException(iOException);
            return null;
        }
    }

    private RemoteImage loadFromStream() {
        if (this.imgStream != null) {
            GuiFactory guiFactory = ScreenUtility.getGuiFactory();
            try {
                RemoteImage remoteImage = guiFactory.loadImage(this.imgStream);
                return remoteImage;
            }
            catch (IOException iOException) {
                ScreenUtility.handleIOException(iOException);
                return null;
            }
        }
        return null;
    }

    private RemoteImage loadFromFile() throws BitmapNotFoundException {
        if (this.filePath.exists()) {
            try {
                FileInputStream fileInputStream = new FileInputStream(this.filePath);
                return this.loadFromInputStream(fileInputStream);
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new BitmapNotFoundException(this.filePathStr);
            }
        }
        throw new BitmapNotFoundException(this.filePathStr);
    }

    private RemoteImage loadFromInputStream(InputStream inputStream) {
        try {
            this.imgStream = new byte[inputStream.available()];
            int n2 = 0;
            for (int i2 = 0; i2 < this.imgStream.length && (n2 = inputStream.read(this.imgStream, i2, this.imgStream.length - i2)) >= 0; i2 += n2) {
            }
            inputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.loadFromStream();
    }

    public Image getNativeImage() {
        if (this.nativeImage == null) {
            byte[] byArray = this.getImgStream();
            if (byArray != null) {
                this.nativeImage = ScreenUtility.createImage(this.getImgStream(), new int[]{0}, true, this.lightGrayIsTransparent, Config.a("iscobol.wbitmap.load_method", 1));
            } else if (this.imagePeer != null) {
                try {
                    SerializableImage serializableImage = this.imagePeer.getImage();
                    if (serializableImage != null) {
                        this.nativeImage = serializableImage.getImage();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return this.nativeImage;
    }

    public RemoteImage getImage() {
        return this.imagePeer;
    }

    public int getImageId() {
        try {
            if (this.imagePeerId == -1 && this.imagePeer != null && !this.destroyed) {
                this.imagePeerId = this.imagePeer.getTheObjectId();
            }
            return this.imagePeerId;
        }
        catch (IOException iOException) {
            ScreenUtility.handleIOException(iOException);
            return -1;
        }
    }

    public byte[] getStream() {
        return this.getImgStream();
    }

    public int getWidth() {
        if (this.imagePeer != null) {
            try {
                return this.imagePeer.getWidth();
            }
            catch (IOException iOException) {
                ScreenUtility.handleIOException(iOException);
                return 0;
            }
        }
        return 0;
    }

    public int getHeight() {
        if (this.imagePeer != null) {
            try {
                return this.imagePeer.getHeight();
            }
            catch (IOException iOException) {
                ScreenUtility.handleIOException(iOException);
                return 0;
            }
        }
        return 0;
    }

    public void destroy() {
        if (this.guiBitmap != null) {
            ScrFactory.getGUIEnviroment().destroy(this.guiBitmap);
        }
        try {
            if (this.getRefCount() <= 0 && this.imagePeer != null) {
                this.imagePeer.destroy();
                this.imagePeerDestroyed = null;
                this.imagePeerIdDestroyed = -1;
            } else if (this.clonesource == null && this.imgStream != null) {
                this.imagePeerDestroyed = this.imagePeer;
                this.imagePeerIdDestroyed = this.getImageId();
            }
            this.imagePeer = null;
            this.imagePeerId = -1;
            this.clonesource = null;
            this.destroyed = true;
        }
        catch (IOException iOException) {
            ScreenUtility.handleIOException(iOException);
        }
    }

    @Override
    public int type() {
        return 7;
    }

    public void setControl(CobolGUIBitmap cobolGUIBitmap) {
        this.guiBitmap = cobolGUIBitmap;
    }

    public String getFilePath() {
        return this.filePathStr;
    }

    public Object clone() {
        Object object = null;
        if (this.refCount > 1 && this.destroyed && this.imgStream != null && this.imagePeerDestroyed != null && this.imagePeerIdDestroyed >= 0) {
            object = this;
            this.imagePeer = this.imagePeerDestroyed;
            this.imagePeerId = this.imagePeerIdDestroyed;
            --this.refCount;
            this.destroyed = false;
            this.imagePeerDestroyed = null;
            this.imagePeerIdDestroyed = -1;
        } else {
            try {
                object = super.clone();
                ((FileImage)object).initClone(this);
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                // empty catch block
            }
        }
        return object;
    }

    public void initClone(FileImage fileImage) {
        this.imgStream = null;
        this.refCount = 0;
        this.clonesource = fileImage;
    }

    public int getRefCount() {
        if (this.clonesource != null) {
            return this.clonesource.getRefCount();
        }
        return this.refCount;
    }

    public void setRefCount(int n2) {
        if (this.clonesource != null) {
            this.clonesource.setRefCount(n2);
        } else {
            this.refCount = n2;
        }
    }

    public boolean isDestroyed() {
        return this.destroyed;
    }

    private byte[] getImgStream() {
        if (this.clonesource != null) {
            return this.clonesource.getStream();
        }
        return this.imgStream;
    }

    public FileImage getCloneSource() {
        return this.clonesource;
    }

    public static FileImage getBroken() {
        return new FileImage(new byte[]{-119, 80, 78, 71, 13, 10, 26, 10, 0, 0, 0, 13, 73, 72, 68, 82, 0, 0, 0, 16, 0, 0, 0, 16, 8, 2, 0, 0, 0, -112, -111, 104, 54, 0, 0, 0, 1, 115, 82, 71, 66, 0, -82, -50, 28, -23, 0, 0, 0, 4, 103, 65, 77, 65, 0, 0, -79, -113, 11, -4, 97, 5, 0, 0, 0, 9, 112, 72, 89, 115, 0, 0, 14, -61, 0, 0, 14, -61, 1, -57, 111, -88, 100, 0, 0, 0, 115, 73, 68, 65, 84, 56, 79, -91, -110, 9, 14, -128, 32, 12, 4, -47, 119, -15, -5, -14, 47, 93, -78, -92, -44, -46, 84, -116, -109, 32, 41, -35, -31, 72, 44, 34, 114, 109, -125, 112, -31, -60, 58, -121, -79, 46, 104, -111, -96, -127, 33, -128, -60, -79, -83, 41, -128, -48, 113, -117, 15, 1, -72, -10, -70, -123, 23, -128, -122, -62, 3, 15, -116, -78, -48, 90, -61, -73, -42, -54, -46, 114, -114, 121, 31, 30, 100, -55, -81, -12, -17, -47, -31, -106, 110, 113, 10, 97, -102, -40, -42, 16, -110, 52, -47, 64, 23, 94, -45, -124, -79, -113, -65, -73, -56, 13, 25, -33, -113, -49, 112, 100, 36, -64, 0, 0, 0, 0, 73, 69, 78, 68, -82, 66});
    }

    public boolean isReplaced() {
        return this.replaced;
    }

    public void setReplaced(boolean bl) {
        this.replaced = bl;
    }
}

