/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.rts;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.SpringLayout;

public class FindDialog
extends JDialog {
    private static final long serialVersionUID = 123L;
    private JTextField toSearch;
    private JCheckBox matchCase;
    private JCheckBox backSearch;
    private JCheckBox matchMinusUnderscore;
    private JButton find;
    private JButton close;
    private FindParam param;
    private FindListener listener;

    public FindDialog(JFrame jFrame, String string, boolean bl) {
        this(jFrame, string, bl, true);
    }

    public FindDialog(JFrame jFrame, String string, boolean bl, boolean bl2) {
        super(jFrame, string, bl);
        this.init(bl2);
    }

    public FindDialog(JDialog jDialog, String string, boolean bl) {
        this(jDialog, string, bl, true);
    }

    public FindDialog(JDialog jDialog, String string, boolean bl, boolean bl2) {
        super(jDialog, string, bl);
        this.init(bl2);
    }

    private void init(boolean bl) {
        this.addWindowListener(new WindowAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void windowClosed(WindowEvent windowEvent) {
                FindDialog findDialog = FindDialog.this;
                synchronized (findDialog) {
                    FindDialog.this.notify();
                }
            }
        });
        KeyAdapter keyAdapter = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 27) {
                    FindDialog.this.dispose();
                }
            }
        };
        SpringLayout springLayout = new SpringLayout();
        this.getContentPane().setLayout(springLayout);
        this.matchCase = new JCheckBox("Match Case");
        if (bl) {
            this.matchMinusUnderscore = new JCheckBox("Match -/_");
        }
        this.backSearch = new JCheckBox("Backward Search");
        this.getContentPane().add(this.matchCase);
        if (bl) {
            this.getContentPane().add(this.matchMinusUnderscore);
        }
        this.getContentPane().add(this.backSearch);
        this.find = new JButton("Find");
        this.find.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FindDialog.this.responseOnAction();
            }
        });
        this.close = new JButton("Close");
        this.close.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FindDialog.this.dispose();
            }
        });
        this.find.setMnemonic('f');
        this.close.setMnemonic('c');
        FindDialog.setButtonsPreferredSizes(new AbstractButton[]{this.find, this.close});
        this.getContentPane().add(this.find);
        this.getContentPane().add(this.close);
        JLabel jLabel = new JLabel("Find:");
        this.toSearch = new JTextField();
        this.getContentPane().add(this.toSearch);
        this.getContentPane().add(jLabel);
        this.toSearch.addKeyListener(keyAdapter);
        this.matchCase.addKeyListener(keyAdapter);
        if (bl) {
            this.matchMinusUnderscore.addKeyListener(keyAdapter);
        }
        this.backSearch.addKeyListener(keyAdapter);
        this.find.addKeyListener(keyAdapter);
        this.close.addKeyListener(keyAdapter);
        springLayout.putConstraint("North", (Component)jLabel, 12, "North", (Component)this.getContentPane());
        springLayout.putConstraint("West", (Component)jLabel, 10, "West", (Component)this.getContentPane());
        springLayout.putConstraint("North", (Component)this.toSearch, 10, "North", (Component)this.getContentPane());
        springLayout.putConstraint("West", (Component)this.toSearch, 10, "East", (Component)jLabel);
        springLayout.putConstraint("East", (Component)this.toSearch, 300, "West", (Component)this.toSearch);
        springLayout.putConstraint("South", (Component)this.toSearch, 28, "North", (Component)this.toSearch);
        springLayout.putConstraint("East", (Component)this.getContentPane(), 10, "East", (Component)this.toSearch);
        springLayout.putConstraint("North", (Component)this.matchCase, 15, "South", (Component)this.toSearch);
        springLayout.putConstraint("West", (Component)this.matchCase, 0, "West", (Component)jLabel);
        if (bl) {
            springLayout.putConstraint("North", (Component)this.matchMinusUnderscore, 15, "South", (Component)this.toSearch);
            springLayout.putConstraint("West", (Component)this.matchMinusUnderscore, 15, "East", (Component)this.matchCase);
        }
        springLayout.putConstraint("North", (Component)this.backSearch, 15, "South", (Component)this.matchCase);
        springLayout.putConstraint("West", (Component)this.backSearch, 0, "West", (Component)jLabel);
        springLayout.putConstraint("South", (Component)this.getContentPane(), 50, "South", (Component)this.backSearch);
        springLayout.putConstraint("East", (Component)this.close, 0, "East", (Component)this.toSearch);
        springLayout.putConstraint("South", (Component)this.close, -10, "South", (Component)this.getContentPane());
        springLayout.putConstraint("North", (Component)this.find, 0, "North", (Component)this.close);
        springLayout.putConstraint("East", (Component)this.find, -10, "West", (Component)this.close);
        this.getRootPane().setDefaultButton(this.find);
        this.setResizable(false);
        this.pack();
    }

    public void setMatchCaseSelected(boolean bl) {
        this.matchCase.setSelected(bl);
    }

    public void setMatchMinusUnderscoreSelected(boolean bl) {
        if (this.matchMinusUnderscore != null) {
            this.matchMinusUnderscore.setSelected(bl);
        }
    }

    public void setBackwardSearchSelected(boolean bl) {
        this.backSearch.setSelected(bl);
    }

    public boolean isMatchCaseSelected() {
        return this.matchCase.isSelected();
    }

    public boolean isMatchMinusUnderscoreSelected() {
        return this.matchMinusUnderscore != null ? this.matchMinusUnderscore.isSelected() : false;
    }

    public boolean isBackwardSearchSelected() {
        return this.backSearch.isSelected();
    }

    public void open() {
        this.getRootPane().setDefaultButton(this.find);
        this.toSearch.selectAll();
        this.setVisible(true);
        this.param = null;
        Container container = this.getParent();
        if (container != null) {
            this.setLocationRelativeTo(container);
        }
    }

    private void responseOnAction() {
        String string = this.toSearch.getText();
        if (string.length() > 0) {
            this.param = new FindParam();
            this.param.toSearch = string;
            this.param.matchCase = this.isMatchCaseSelected();
            this.param.matchMinusUnderscore = this.isMatchMinusUnderscoreSelected();
            this.param.backSearch = this.backSearch.isSelected();
            if (this.listener != null) {
                this.listener.find(this.param);
            }
        }
    }

    public static void setButtonsPreferredSizes(AbstractButton[] abstractButtonArray) {
        int n2;
        Dimension dimension = abstractButtonArray[0].getPreferredSize();
        for (n2 = 1; n2 < abstractButtonArray.length; ++n2) {
            Dimension dimension2 = abstractButtonArray[n2].getPreferredSize();
            if (dimension2.width > dimension.width) {
                dimension.width = dimension2.width;
            }
            if (dimension2.height <= dimension.height) continue;
            dimension.height = dimension2.height;
        }
        for (n2 = 0; n2 < abstractButtonArray.length; ++n2) {
            abstractButtonArray[n2].setPreferredSize(dimension);
        }
    }

    public void setFindListener(FindListener findListener) {
        this.listener = findListener;
    }

    public FindListener getFindListener() {
        return this.listener;
    }

    public static class FindParam {
        public String toSearch;
        public boolean matchCase;
        public boolean backSearch;
        public boolean matchMinusUnderscore;

        public FindParam() {
        }

        public FindParam(String string, boolean bl, boolean bl2, boolean bl3) {
            this.toSearch = string;
            this.matchCase = bl;
            this.backSearch = bl2;
            this.matchMinusUnderscore = bl3;
        }
    }

    public static interface FindListener {
        public void find(FindParam var1);
    }
}

