/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.rts;

import com.iscobol.rts.Config;
import com.iscobol.rts.CurrentDate;
import com.iscobol.rts.Factory;
import com.iscobol.rts.Handle;
import com.iscobol.rts.IscobolSystem;
import com.iscobol.rts.RuntimeErrorsNumbers;
import com.iscobol.rts.UserHandles;
import com.iscobol.types.CobolNum;
import com.iscobol.types.CobolVar;
import com.iscobol.types.NumericVar;
import com.iscobol.types.Pic1;
import com.iscobol.types.Pic9Comp_5;
import com.iscobol.types.PicN;
import com.iscobol.types.PicX;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;
import java.util.Arrays;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.TimeZone;

public class Functions
implements RuntimeErrorsNumbers {
    public static final Map<Integer, String> CCSIDs;
    private static final int[][] dayInMonth;
    private Random random;
    public static final CobolNum ZERO;
    public static final CobolNum ONE;
    public static final CobolNum TWO;
    public static final double LOG10;

    private static Functions get() {
        Functions functions = (Functions)IscobolSystem.get(Functions.class);
        if (functions == null) {
            functions = new Functions();
            IscobolSystem.set(Functions.class, functions);
        }
        return functions;
    }

    static int isLeapYear(int n2) {
        return n2 % 4 == 0 && n2 % 100 != 0 || n2 % 400 == 0 ? 1 : 0;
    }

    static int toJulian(int n2, int n3, int n4) {
        int n5;
        int n6 = 0;
        n6 = n4;
        if (n3 > 12) {
            n2 += n3 / 12;
            if ((n3 %= 12) == 0) {
                n3 = 12;
                --n2;
            }
        }
        for (n5 = 1; n5 < n3; ++n5) {
            n6 += dayInMonth[n5][Functions.isLeapYear(n2)];
        }
        for (n5 = 1601; n5 < n2; ++n5) {
            n6 += 365 + Functions.isLeapYear(n5);
        }
        return n6;
    }

    static int fromJulian(int n2, boolean bl) {
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        if (n2 > 0) {
            int n6 = 1601;
            while (true) {
                if (Functions.isLeapYear(n6) == 1) {
                    if ((n2 -= 366) <= 0) {
                        n5 = n6;
                        n2 += 366;
                        break;
                    }
                } else if ((n2 -= 365) <= 0) {
                    n5 = n6;
                    n2 += 365;
                    break;
                }
                ++n6;
            }
            if (bl) {
                return n5 * 1000 + n2;
            }
            n6 = 1;
            while (true) {
                if ((n2 -= dayInMonth[n6][Functions.isLeapYear(n5)]) <= 0) break;
                ++n6;
            }
            n4 = n6;
            n3 = n2 + dayInMonth[n6][Functions.isLeapYear(n5)];
            return n5 * 10000 + n4 * 100 + n3;
        }
        return 0;
    }

    public static Pic1 booleanOfInteger(CobolNum cobolNum, CobolNum cobolNum2) {
        return new Pic1(cobolNum.longValue(), cobolNum2.intValue());
    }

    public static NumericVar integerOfBoolean(Pic1 pic1, boolean bl) {
        long l2 = pic1.tolong();
        return NumericVar.literal(l2, CobolNum.getNumDigits(l2), 0, bl);
    }

    public static NumericVar integerOfBoolean(NumericVar numericVar, boolean bl) {
        long l2 = numericVar.tolong();
        return NumericVar.literal(l2, CobolNum.getNumDigits(l2), 0, bl);
    }

    public static NumericVar integerOfDate(CobolNum cobolNum) {
        return Functions.integerOfDate(cobolNum, false);
    }

    public static NumericVar integerOfDate(CobolNum cobolNum, boolean bl) {
        int n2 = cobolNum.intValue();
        int n3 = n2 > 16010100 ? Functions.toJulian(n2 / 10000, n2 % 10000 / 100, n2 % 100) : 0;
        return NumericVar.literal(n3, 10, 0, false);
    }

    public static NumericVar integerOfDay(CobolNum cobolNum, boolean bl) {
        int n2 = cobolNum.intValue();
        int n3 = n2 > 1601000 ? Functions.toJulian(n2 / 1000, 0, n2 % 1000) : 0;
        return NumericVar.literal(n3, 10, 0, false);
    }

    public static PicX currentDate() {
        long l2 = 0L;
        GregorianCalendar gregorianCalendar = CurrentDate.get();
        l2 += (long)gregorianCalendar.get(1) * 1000000000000L;
        l2 += (long)(gregorianCalendar.get(2) + 1) * 10000000000L;
        l2 += (long)gregorianCalendar.get(5) * 100000000L;
        l2 += (long)(gregorianCalendar.get(11) * 1000000);
        l2 += (long)(gregorianCalendar.get(12) * 10000);
        l2 += (long)(gregorianCalendar.get(13) * 100);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(l2 += (long)(gregorianCalendar.get(14) / 10));
        int n2 = TimeZone.getDefault().getRawOffset();
        if (n2 < 0) {
            stringBuffer.append("-");
            n2 *= -1;
        } else {
            stringBuffer.append("+");
        }
        int n3 = n2 / 3600000;
        int n4 = n2 % 3600000 / 60000;
        if (n3 < 10) {
            stringBuffer.append("0");
        }
        stringBuffer.append(n3);
        if (n4 < 10) {
            stringBuffer.append("0");
        }
        stringBuffer.append(n4);
        return Factory.getStrLiteral(stringBuffer.toString());
    }

    public static NumericVar dateOfInteger(CobolNum cobolNum) {
        return Functions.dateOfInteger(cobolNum, false);
    }

    public static NumericVar dateOfInteger(CobolNum cobolNum, boolean bl) {
        return NumericVar.literal(Functions.fromJulian(cobolNum.intValue(), false), 8, 0, bl);
    }

    public static NumericVar dayOfInteger(CobolNum cobolNum, boolean bl) {
        return NumericVar.literal(Functions.fromJulian(cobolNum.intValue(), true), 8, 0, bl);
    }

    private static int yearToYyyy(int n2, int n3) {
        GregorianCalendar gregorianCalendar = CurrentDate.get();
        int n4 = gregorianCalendar.get(1) + n3;
        int n5 = n4 % 100 >= n2 ? n2 + 100 * (n4 / 100) : n2 + 100 * (n4 / 100 - 1);
        return n5;
    }

    public static NumericVar yearToYyyy(CobolNum cobolNum, boolean bl) {
        return NumericVar.literal(Functions.yearToYyyy(cobolNum.intValue(), 50), 8, 0, bl);
    }

    public static NumericVar yearToYyyy(CobolNum cobolNum, CobolNum cobolNum2, boolean bl) {
        return NumericVar.literal(Functions.yearToYyyy(cobolNum.intValue(), cobolNum2.intValue()), 8, 0, bl);
    }

    private static int dateToYyyyMmDd(int n2, int n3) {
        return Functions.yearToYyyy(n2 / 10000, n3) * 10000 + n2 % 10000;
    }

    public static NumericVar dateToYyyyMmDd(CobolNum cobolNum, boolean bl) {
        return NumericVar.literal(Functions.dateToYyyyMmDd(cobolNum.intValue(), 50), 8, 0, bl);
    }

    public static NumericVar dateToYyyyMmDd(CobolNum cobolNum, CobolNum cobolNum2, boolean bl) {
        return NumericVar.literal(Functions.dateToYyyyMmDd(cobolNum.intValue(), cobolNum2.intValue()), 8, 0, bl);
    }

    private static int dayToYyyyDdd(int n2, int n3) {
        return Functions.yearToYyyy(n2 / 1000, n3) * 1000 + n2 % 1000;
    }

    public static NumericVar dayToYyyyDdd(CobolNum cobolNum, boolean bl) {
        return NumericVar.literal(Functions.dayToYyyyDdd(cobolNum.intValue(), 50), 8, 0, bl);
    }

    public static NumericVar dayToYyyyDdd(CobolNum cobolNum, CobolNum cobolNum2, boolean bl) {
        return NumericVar.literal(Functions.dayToYyyyDdd(cobolNum.intValue(), cobolNum2.intValue()), 8, 0, bl);
    }

    public static NumericVar length(CobolVar cobolVar) {
        if (cobolVar.getMemory() != null) {
            return NumericVar.literal(cobolVar.getLength(), 10, 0, false);
        }
        if (cobolVar instanceof PicN) {
            return NumericVar.literal(cobolVar.length() / 2, 10, 0, false);
        }
        return NumericVar.literal(cobolVar.length(), 10, 0, false);
    }

    public static NumericVar lengthComp_5(CobolVar cobolVar) {
        if (cobolVar.getMemory() != null) {
            return Pic9Comp_5.literal(cobolVar.getLength());
        }
        if (cobolVar instanceof PicN) {
            return Pic9Comp_5.literal(cobolVar.length() / 2);
        }
        return Pic9Comp_5.literal(cobolVar.length());
    }

    public static NumericVar byteLength(CobolVar cobolVar) {
        if (cobolVar.getMemory() != null) {
            return NumericVar.literal(cobolVar.length(), 10, 0, false);
        }
        return NumericVar.literal(cobolVar.getMaxLength(), 10, 0, false);
    }

    public static PicX upperCase(CobolVar cobolVar) {
        return PicX.literal(Factory.toUpperCase(cobolVar.toString()));
    }

    public static PicX lowerCase(CobolVar cobolVar) {
        return PicX.literal(Factory.toLowerCase(cobolVar.toString()));
    }

    public static PicX trim(CobolVar cobolVar) {
        return PicX.literal(cobolVar.toString().trim());
    }

    public static final String trimLeft(String string) {
        int n2;
        int n3 = string.length();
        for (n2 = 0; n2 < n3 && string.charAt(n2) == ' '; ++n2) {
        }
        if (n2 == 0) {
            return string;
        }
        if (n2 == n3) {
            return "";
        }
        return string.substring(n2);
    }

    public static final String trimRight(String string) {
        int n2;
        int n3;
        for (n3 = n2 = string.length() - 1; n3 >= 0 && string.charAt(n3) == ' '; --n3) {
        }
        if (n3 < 0) {
            return "";
        }
        if (n3 == n2) {
            return string;
        }
        return string.substring(0, n3 + 1);
    }

    public static PicX triml(CobolVar cobolVar) {
        return PicX.literal(Functions.trimLeft(cobolVar.toString()));
    }

    public static PicX trimr(CobolVar cobolVar) {
        return PicX.literal(Functions.trimRight(cobolVar.toString()));
    }

    public static PicX reverse(CobolVar cobolVar) {
        StringBuffer stringBuffer = new StringBuffer(cobolVar.toString());
        if (stringBuffer.length() > 1) {
            stringBuffer.reverse();
        }
        return PicX.literal(stringBuffer.toString());
    }

    public static PicX min(CobolVar[] cobolVarArray) {
        CobolVar cobolVar = cobolVarArray[0];
        for (int i2 = 1; i2 < cobolVarArray.length; ++i2) {
            if (cobolVar.compareTo(cobolVarArray[i2]) <= 0) continue;
            cobolVar = cobolVarArray[i2];
        }
        return PicX.literal(cobolVar.toString());
    }

    public static NumericVar min(NumericVar[] numericVarArray) {
        NumericVar numericVar = numericVarArray[0];
        for (int i2 = 1; i2 < numericVarArray.length; ++i2) {
            if (numericVar.num().compareTo(numericVarArray[i2].num()) <= 0) continue;
            numericVar = numericVarArray[i2];
        }
        return numericVar.copy();
    }

    public static NumericVar min(CobolNum[] cobolNumArray, boolean bl) {
        CobolNum cobolNum = cobolNumArray[0];
        for (int i2 = 1; i2 < cobolNumArray.length; ++i2) {
            if (cobolNum.compareTo(cobolNumArray[i2]) <= 0) continue;
            cobolNum = cobolNumArray[i2];
        }
        return NumericVar.literal(cobolNum, bl);
    }

    public static PicX max(CobolVar[] cobolVarArray) {
        CobolVar cobolVar = cobolVarArray[0];
        for (int i2 = 1; i2 < cobolVarArray.length; ++i2) {
            if (cobolVar.compareTo(cobolVarArray[i2]) >= 0) continue;
            cobolVar = cobolVarArray[i2];
        }
        if (cobolVar instanceof PicN) {
            return PicN.literal(cobolVar.toString());
        }
        return PicX.literal(cobolVar.toString());
    }

    public static NumericVar max(NumericVar[] numericVarArray) {
        NumericVar numericVar = numericVarArray[0];
        for (int i2 = 1; i2 < numericVarArray.length; ++i2) {
            if (numericVar.num().compareTo(numericVarArray[i2].num()) >= 0) continue;
            numericVar = numericVarArray[i2];
        }
        return numericVar.copy();
    }

    public static NumericVar max(CobolNum[] cobolNumArray, boolean bl) {
        CobolNum cobolNum = cobolNumArray[0];
        for (int i2 = 1; i2 < cobolNumArray.length; ++i2) {
            if (cobolNum.compareTo(cobolNumArray[i2]) >= 0) continue;
            cobolNum = cobolNumArray[i2];
        }
        return NumericVar.literal(cobolNum, bl);
    }

    public static NumericVar ordMax(CobolVar[] cobolVarArray) {
        CobolVar cobolVar = cobolVarArray[0];
        long l2 = 0L;
        for (int i2 = 1; i2 < cobolVarArray.length; ++i2) {
            if (cobolVar.compareTo(cobolVarArray[i2]) >= 0) continue;
            cobolVar = cobolVarArray[i2];
            l2 = i2;
        }
        return NumericVar.literal(l2 + 1L, 18, 0, cobolVar.isDecimalPointComma());
    }

    public static NumericVar ordMax(CobolNum[] cobolNumArray, boolean bl) {
        CobolNum cobolNum = cobolNumArray[0];
        long l2 = 0L;
        for (int i2 = 1; i2 < cobolNumArray.length; ++i2) {
            if (cobolNum.compareTo(cobolNumArray[i2]) >= 0) continue;
            cobolNum = cobolNumArray[i2];
            l2 = i2;
        }
        return NumericVar.literal(l2 + 1L, 18, 0, bl);
    }

    public static NumericVar ordMin(CobolVar[] cobolVarArray) {
        CobolVar cobolVar = cobolVarArray[0];
        long l2 = 0L;
        for (int i2 = 1; i2 < cobolVarArray.length; ++i2) {
            if (cobolVar.compareTo(cobolVarArray[i2]) <= 0) continue;
            cobolVar = cobolVarArray[i2];
            l2 = i2;
        }
        return NumericVar.literal(l2 + 1L, 18, 0, cobolVar.isDecimalPointComma());
    }

    public static NumericVar ordMin(CobolNum[] cobolNumArray, boolean bl) {
        CobolNum cobolNum = cobolNumArray[0];
        long l2 = 0L;
        for (int i2 = 1; i2 < cobolNumArray.length; ++i2) {
            if (cobolNum.compareTo(cobolNumArray[i2]) <= 0) continue;
            cobolNum = cobolNumArray[i2];
            l2 = i2;
        }
        return NumericVar.literal(l2 + 1L, 18, 0, bl);
    }

    public static NumericVar random() {
        return Functions.random(false);
    }

    public static NumericVar random(boolean bl) {
        Functions functions = Functions.get();
        if (functions.random == null) {
            functions.random = new Random();
        }
        return NumericVar.literal(functions.random.nextDouble(), bl);
    }

    public static NumericVar random(CobolNum cobolNum) {
        return Functions.random(cobolNum, false);
    }

    public static NumericVar random(CobolNum cobolNum, boolean bl) {
        Functions functions = Functions.get();
        functions.random = new Random(cobolNum.longValue());
        return NumericVar.literal(functions.random.nextDouble(), bl);
    }

    public static NumericVar mod(CobolNum cobolNum, CobolNum cobolNum2) {
        return Functions.mod(cobolNum, cobolNum2, false);
    }

    public static NumericVar mod(CobolNum cobolNum, CobolNum cobolNum2, boolean bl) {
        return NumericVar.literal(cobolNum.subtract(cobolNum2.multiply(cobolNum.divide(cobolNum2).integerFunc())), bl);
    }

    public static NumericVar testNumVal(CobolVar cobolVar) {
        int n2 = CobolNum.test(cobolVar.toString(), cobolVar.isDecimalPointComma(), 'N', '\u0000');
        return NumericVar.literal(Integer.toString(n2), cobolVar.isDecimalPointComma());
    }

    public static NumericVar testNumValF(CobolVar cobolVar) {
        int n2 = CobolNum.test(cobolVar.toString(), cobolVar.isDecimalPointComma(), 'F', '\u0000');
        return NumericVar.literal(Integer.toString(n2), cobolVar.isDecimalPointComma());
    }

    public static NumericVar testNumValC(CobolVar cobolVar) {
        int n2 = CobolNum.test(cobolVar.toString(), cobolVar.isDecimalPointComma(), 'C', '$');
        return NumericVar.literal(Integer.toString(n2), cobolVar.isDecimalPointComma());
    }

    public static NumericVar testNumValC(CobolVar cobolVar, CobolVar cobolVar2) {
        char c2 = cobolVar2.toString().charAt(0);
        int n2 = CobolNum.test(cobolVar.toString(), cobolVar.isDecimalPointComma(), 'C', c2);
        return NumericVar.literal(Integer.toString(n2), cobolVar.isDecimalPointComma());
    }

    public static NumericVar numValF(CobolVar cobolVar) {
        return Functions.numVal(cobolVar);
    }

    public static NumericVar numVal(CobolVar cobolVar) {
        return Functions.numVal(cobolVar.toString(), cobolVar.isDecimalPointComma());
    }

    public static NumericVar numVal(String string, boolean bl) {
        return NumericVar.literal(string, bl);
    }

    public static NumericVar numValC(CobolVar cobolVar) {
        return Functions.numValC(cobolVar.toString(), cobolVar.isDecimalPointComma(), '\u0000');
    }

    public static NumericVar numValC(CobolVar cobolVar, CobolVar cobolVar2) {
        return Functions.numValC(cobolVar.toString(), cobolVar.isDecimalPointComma(), cobolVar2 != null ? cobolVar2.toString().charAt(0) : (char)'\u0000');
    }

    public static NumericVar numValC(String string, boolean bl, char c2) {
        if (c2 > '\u0000') {
            string = string.replace(c2, ' ');
        }
        return NumericVar.literal(string, bl);
    }

    public static NumericVar handleType(CobolVar cobolVar) {
        Object object = UserHandles.getId(cobolVar.toint());
        if (object != null) {
            if (object instanceof Handle) {
                return NumericVar.literal(((Handle)object).type(), 9, 0, false);
            }
            return NumericVar.literal(9L, 9, 0, false);
        }
        return NumericVar.literal(0L, 9, 0, false);
    }

    public static PicX chr(CobolNum cobolNum) {
        return Functions.chr(cobolNum, false);
    }

    public static PicX chr(CobolNum cobolNum, boolean bl) {
        return PicX.literal("" + (char)(cobolNum.intValue() - 1));
    }

    public static NumericVar ord(CobolVar cobolVar) {
        String string = cobolVar.toString();
        long l2 = -1L;
        if (string.length() > 0) {
            l2 = (long)string.charAt(0) + 1L;
        }
        return NumericVar.literal("" + l2, false);
    }

    public static PicX dec2Hex(CobolNum cobolNum) {
        return Functions.dec2Hex(cobolNum, false);
    }

    public static PicX dec2Hex(CobolNum cobolNum, boolean bl) {
        long l2 = cobolNum.longValue();
        if (l2 < 0L) {
            return PicX.literal("-" + Long.toHexString(-l2));
        }
        return PicX.literal(Long.toHexString(l2));
    }

    public static NumericVar hex2Dec(CobolVar cobolVar) {
        long l2;
        try {
            l2 = Long.parseLong(cobolVar.toString().trim(), 16);
        }
        catch (NumberFormatException numberFormatException) {
            l2 = 0L;
        }
        return NumericVar.literal(l2, cobolVar.isDecimalPointComma());
    }

    public static PicX dec2Oct(CobolNum cobolNum) {
        return Functions.dec2Oct(cobolNum, false);
    }

    public static PicX dec2Oct(CobolNum cobolNum, boolean bl) {
        long l2 = cobolNum.longValue();
        if (l2 < 0L) {
            return PicX.literal("-" + Long.toOctalString(-l2));
        }
        return PicX.literal(Long.toOctalString(l2));
    }

    public static NumericVar oct2Dec(CobolVar cobolVar) {
        long l2;
        try {
            l2 = Long.parseLong(cobolVar.toString().trim(), 8);
        }
        catch (NumberFormatException numberFormatException) {
            l2 = 0L;
        }
        return NumericVar.literal(l2, cobolVar.isDecimalPointComma());
    }

    public static PicX dec2Bin(CobolNum cobolNum) {
        return Functions.dec2Bin(cobolNum, false);
    }

    public static PicX dec2Bin(CobolNum cobolNum, boolean bl) {
        long l2 = cobolNum.longValue();
        if (l2 < 0L) {
            return PicX.literal("-" + Long.toBinaryString(-l2));
        }
        return PicX.literal(Long.toBinaryString(l2));
    }

    public static NumericVar bin2Dec(CobolVar cobolVar) {
        long l2;
        try {
            l2 = Long.parseLong(cobolVar.toString().trim(), 2);
        }
        catch (NumberFormatException numberFormatException) {
            l2 = 0L;
        }
        return NumericVar.literal(l2, cobolVar.isDecimalPointComma());
    }

    public static NumericVar integer(CobolNum cobolNum) {
        return Functions.integer(cobolNum, false);
    }

    public static NumericVar integer(CobolNum cobolNum, boolean bl) {
        return NumericVar.literal(cobolNum.integerFunc(), bl);
    }

    public static NumericVar integerPart(CobolNum cobolNum) {
        return Functions.integerPart(cobolNum, false);
    }

    public static NumericVar integerPart(CobolNum cobolNum, boolean bl) {
        return NumericVar.literal(cobolNum.integerPart(), bl);
    }

    public static NumericVar rem(CobolNum cobolNum, CobolNum cobolNum2) {
        return Functions.rem(cobolNum, cobolNum2, false);
    }

    public static NumericVar rem(CobolNum cobolNum, CobolNum cobolNum2, boolean bl) {
        return NumericVar.literal(cobolNum.remainder(cobolNum2, 0), bl);
    }

    public static PicX vsCurrentDate() {
        int n2;
        int n3;
        GregorianCalendar gregorianCalendar = CurrentDate.get();
        StringBuffer stringBuffer = new StringBuffer(8);
        int n4 = gregorianCalendar.get(1) % 100;
        if (Config.b(".current_date", false)) {
            n3 = gregorianCalendar.get(5);
            n2 = gregorianCalendar.get(2) + 1;
        } else {
            n3 = gregorianCalendar.get(2) + 1;
            n2 = gregorianCalendar.get(5);
        }
        if (n3 < 10) {
            stringBuffer.append('0');
        }
        stringBuffer.append(n3);
        stringBuffer.append('/');
        if (n2 < 10) {
            stringBuffer.append('0');
        }
        stringBuffer.append(n2);
        stringBuffer.append('/');
        if (n4 < 10) {
            stringBuffer.append('0');
        }
        stringBuffer.append(n4);
        return PicX.literal(stringBuffer.toString());
    }

    public static PicX vsTimeOfDay() {
        GregorianCalendar gregorianCalendar = CurrentDate.get();
        StringBuffer stringBuffer = new StringBuffer(6);
        int n2 = gregorianCalendar.get(11);
        if (n2 < 10) {
            stringBuffer.append('0');
        }
        stringBuffer.append(n2);
        n2 = gregorianCalendar.get(12);
        if (n2 < 10) {
            stringBuffer.append('0');
        }
        stringBuffer.append(n2);
        n2 = gregorianCalendar.get(13);
        if (n2 < 10) {
            stringBuffer.append('0');
        }
        stringBuffer.append(n2);
        return PicX.literal(stringBuffer.toString());
    }

    public static PicX vsUseGiving(int n2) {
        String string;
        switch (n2) {
            case 100: {
                string = "00010000";
                break;
            }
            case 101: {
                string = "10000000";
                break;
            }
            case 102: {
                string = "01000000";
                break;
            }
            case 103: {
                string = "10000000";
                break;
            }
            case 104: 
            case 105: {
                string = "01000000";
                break;
            }
            case 106: 
            case 107: 
            case 108: 
            case 109: {
                string = "10000000";
                break;
            }
            case 110: 
            case 111: 
            case 112: {
                string = "01000000";
                break;
            }
            case 113: 
            case 114: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 124: 
            case 125: 
            case 126: {
                string = "10000000";
                break;
            }
            case 127: {
                string = "00100000";
                break;
            }
            case 128: 
            case 129: 
            case 130: 
            case 131: 
            case 132: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 137: 
            case 138: {
                string = "10000000";
                break;
            }
            case 139: {
                string = "00100000";
                break;
            }
            case 140: 
            case 141: 
            case 142: {
                string = "10000000";
                break;
            }
            case 143: {
                string = "01000000";
                break;
            }
            case 200: {
                string = "00010000";
                break;
            }
            default: {
                string = "10000000";
            }
        }
        return PicX.literal(string);
    }

    public static NumericVar abs(CobolNum cobolNum, boolean bl) {
        if (cobolNum.isNegative()) {
            return NumericVar.literal(cobolNum.negate(), bl);
        }
        return NumericVar.literal(cobolNum, bl);
    }

    public static NumericVar acos(CobolNum cobolNum, boolean bl) {
        return NumericVar.literal(Math.acos(cobolNum.doubleValue()), bl);
    }

    public static NumericVar asin(CobolNum cobolNum, boolean bl) {
        return NumericVar.literal(Math.asin(cobolNum.doubleValue()), bl);
    }

    public static NumericVar atan(CobolNum cobolNum, boolean bl) {
        return NumericVar.literal(Math.atan(cobolNum.doubleValue()), bl);
    }

    public static NumericVar cos(CobolNum cobolNum, boolean bl) {
        return NumericVar.literal(Math.cos(cobolNum.doubleValue()), bl);
    }

    public static NumericVar sin(CobolNum cobolNum, boolean bl) {
        return NumericVar.literal(Math.sin(cobolNum.doubleValue()), bl);
    }

    public static NumericVar tan(CobolNum cobolNum, boolean bl) {
        return NumericVar.literal(Math.tan(cobolNum.doubleValue()), bl);
    }

    public static NumericVar annuity(CobolNum cobolNum, CobolNum cobolNum2, boolean bl) {
        if (cobolNum.compareTo(ZERO) == 0) {
            return NumericVar.literal(ONE.divide(cobolNum2), bl);
        }
        return NumericVar.literal(cobolNum.divide(ONE.subtract(ONE.add(cobolNum).pow(cobolNum2.negate()))), bl);
    }

    public static NumericVar factorial(CobolNum cobolNum, boolean bl) {
        double d2 = 1.0;
        for (long i2 = cobolNum.longValue(); i2 > 1L; --i2) {
            d2 *= (double)i2;
        }
        return NumericVar.literal(d2, bl);
    }

    public static NumericVar log(CobolNum cobolNum, boolean bl) {
        return NumericVar.literal(Math.log(cobolNum.doubleValue()), bl);
    }

    public static NumericVar log10(CobolNum cobolNum, boolean bl) {
        return NumericVar.literal(Math.log(cobolNum.doubleValue()) / LOG10, bl);
    }

    public static NumericVar sqrt(CobolNum cobolNum, boolean bl) {
        return NumericVar.literal(Math.sqrt(cobolNum.doubleValue()), bl);
    }

    public static NumericVar mean(CobolNum[] cobolNumArray, boolean bl) {
        double d2 = 0.0;
        for (int i2 = cobolNumArray.length - 1; i2 >= 0; --i2) {
            d2 += cobolNumArray[i2].doubleValue();
        }
        return NumericVar.literal(d2 / (double)cobolNumArray.length, bl);
    }

    public static NumericVar median(CobolNum[] cobolNumArray, boolean bl) {
        int n2;
        double[] dArray = new double[cobolNumArray.length];
        for (n2 = cobolNumArray.length - 1; n2 >= 0; --n2) {
            dArray[n2] = cobolNumArray[n2].doubleValue();
        }
        Arrays.sort(dArray);
        n2 = dArray.length / 2;
        if ((dArray.length & 1) == 1) {
            return NumericVar.literal(dArray[n2], bl);
        }
        return NumericVar.literal((dArray[n2] + dArray[n2 - 1]) / 2.0, bl);
    }

    public static NumericVar midrange(CobolNum[] cobolNumArray, boolean bl) {
        CobolNum cobolNum = cobolNumArray[0];
        CobolNum cobolNum2 = cobolNumArray[0];
        for (int i2 = 1; i2 < cobolNumArray.length; ++i2) {
            if (cobolNum.compareTo(cobolNumArray[i2]) < 0) {
                cobolNum = cobolNumArray[i2];
                continue;
            }
            if (cobolNum2.compareTo(cobolNumArray[i2]) <= 0) continue;
            cobolNum2 = cobolNumArray[i2];
        }
        return NumericVar.literal(cobolNum.add(cobolNum2).divide(TWO), bl);
    }

    public static NumericVar presentValue(CobolNum[] cobolNumArray, boolean bl) {
        double d2 = 0.0;
        double d3 = cobolNumArray[0].doubleValue();
        for (int i2 = 1; i2 < cobolNumArray.length; ++i2) {
            d2 += cobolNumArray[i2].doubleValue() / Math.pow(1.0 + d3, i2);
        }
        return NumericVar.literal(d2, bl);
    }

    public static NumericVar variance(CobolNum[] cobolNumArray, boolean bl) {
        int n2;
        double d2 = 0.0;
        double d3 = 0.0;
        double[] dArray = new double[cobolNumArray.length];
        double d4 = cobolNumArray.length;
        for (n2 = cobolNumArray.length - 1; n2 >= 0; --n2) {
            dArray[n2] = cobolNumArray[n2].doubleValue();
            d2 += dArray[n2];
        }
        d2 /= d4;
        for (n2 = cobolNumArray.length - 1; n2 >= 0; --n2) {
            d3 += Math.pow(dArray[n2] - d2, 2.0);
        }
        return NumericVar.literal(d3 /= d4, bl);
    }

    public static NumericVar standardDeviation(CobolNum[] cobolNumArray, boolean bl) {
        return NumericVar.literal(Math.sqrt(Functions.variance(cobolNumArray, bl).num().doubleValue()), bl);
    }

    public static NumericVar sum(CobolNum[] cobolNumArray, boolean bl) {
        if (cobolNumArray.length > 0) {
            CobolNum cobolNum = cobolNumArray[cobolNumArray.length - 1];
            for (int i2 = cobolNumArray.length - 2; i2 >= 0; --i2) {
                cobolNum = cobolNum.add(cobolNumArray[i2]);
            }
            return NumericVar.literal(cobolNum, bl);
        }
        return NumericVar.literal(0L, 1, 0, bl);
    }

    public static NumericVar range(CobolNum[] cobolNumArray, boolean bl) {
        CobolNum cobolNum = cobolNumArray[0];
        CobolNum cobolNum2 = cobolNumArray[0];
        for (int i2 = 1; i2 < cobolNumArray.length; ++i2) {
            if (cobolNum.compareTo(cobolNumArray[i2]) < 0) {
                cobolNum = cobolNumArray[i2];
                continue;
            }
            if (cobolNum2.compareTo(cobolNumArray[i2]) <= 0) continue;
            cobolNum2 = cobolNumArray[i2];
        }
        return NumericVar.literal(cobolNum.subtract(cobolNum2), bl);
    }

    public static NumericVar e(boolean bl) {
        return NumericVar.literal(Math.E, bl);
    }

    public static NumericVar exp(CobolNum cobolNum, boolean bl) {
        return NumericVar.literal(Math.exp(cobolNum.doubleValue()), bl);
    }

    public static NumericVar exp10(CobolNum cobolNum, boolean bl) {
        return NumericVar.literal(Math.pow(10.0, cobolNum.doubleValue()), bl);
    }

    public static NumericVar fractionPart(CobolNum cobolNum, boolean bl) {
        return NumericVar.literal(cobolNum.subtract(cobolNum.integerPart()), bl);
    }

    public static NumericVar pi(boolean bl) {
        return NumericVar.literal(Math.PI, bl);
    }

    public static NumericVar sign(CobolNum cobolNum, boolean bl) {
        return NumericVar.literal(CobolNum.noo(cobolNum.signum(), 0), bl);
    }

    public static PicX displayOf(PicN picN) {
        return Functions.displayOf(picN, (PicX)null);
    }

    public static PicX displayOf(PicN picN, NumericVar numericVar) {
        Object object;
        Charset charset = null;
        if (numericVar != null && (object = CCSIDs.get(numericVar.toint())) != null) {
            try {
                charset = Charset.forName((String)object);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (charset != null) {
            try {
                object = charset.newEncoder().onUnmappableCharacter(CodingErrorAction.REPLACE);
                ((CharsetEncoder)object).replaceWith("?".getBytes(charset));
                ByteBuffer byteBuffer = ((CharsetEncoder)object).encode(CharBuffer.wrap(picN.toString()));
                byte[] byArray = new byte[byteBuffer.limit()];
                byteBuffer.get(byArray, byteBuffer.position(), byteBuffer.limit());
                return new PicX(byArray);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return Functions.displayOf(picN, (PicX)null);
    }

    public static PicX displayOf(PicN picN, PicX picX) {
        String string = picN.toString();
        if (picX != null) {
            try {
                CharsetEncoder charsetEncoder = Charset.forName(CobolVar.encoding).newEncoder().onUnmappableCharacter(CodingErrorAction.REPLACE);
                charsetEncoder.replaceWith(picX.getBytes());
                ByteBuffer byteBuffer = charsetEncoder.encode(CharBuffer.wrap(string));
                byte[] byArray = new byte[byteBuffer.limit()];
                byteBuffer.get(byArray, byteBuffer.position(), byteBuffer.limit());
                return new PicX(byArray);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return new PicX(string);
    }

    public static PicN nationalOf(PicX picX) {
        return Functions.nationalOf(picX, (PicN)null);
    }

    public static PicN nationalOf(PicX picX, NumericVar numericVar) {
        Object object;
        Charset charset = null;
        if (numericVar != null && (object = CCSIDs.get(numericVar.toint())) != null) {
            try {
                charset = Charset.forName((String)object);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (charset != null) {
            try {
                object = charset.newDecoder().onUnmappableCharacter(CodingErrorAction.REPLACE);
                ((CharsetDecoder)object).replaceWith("?");
                CharBuffer charBuffer = ((CharsetDecoder)object).decode(ByteBuffer.wrap(picX.getBytes()));
                return new PicN(charBuffer.toString());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return Functions.nationalOf(picX, (PicN)null);
    }

    public static PicN nationalOf(PicX picX, PicN picN) {
        byte[] byArray = picX.getBytes();
        if (picN != null) {
            try {
                CharsetDecoder charsetDecoder = Charset.forName(CobolVar.encoding).newDecoder().onUnmappableCharacter(CodingErrorAction.REPLACE);
                charsetDecoder.replaceWith(picN.toString());
                CharBuffer charBuffer = charsetDecoder.decode(ByteBuffer.wrap(byArray));
                return new PicN(charBuffer.toString());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return new PicN(picX.toString());
    }

    public static PicX compiledInfo(Class clazz) {
        String string;
        try {
            string = Factory.info(clazz);
        }
        catch (IllegalAccessException | InstantiationException reflectiveOperationException) {
            int n2 = clazz.getName().lastIndexOf(46);
            String string2 = n2 >= 0 ? clazz.getName().substring(n2 + 1) + ".class" : clazz.getName() + ".class";
            string = string2 + ": Unknown file type";
        }
        return PicX.literal(string);
    }

    public static PicX compiledInfo(Object object) {
        return PicX.literal(Factory.info(object));
    }

    static {
        HashMap<Integer, String> hashMap = new HashMap<Integer, String>();
        hashMap.put(37, "IBM037");
        hashMap.put(273, "IBM273");
        hashMap.put(277, "IBM277");
        hashMap.put(278, "IBM278");
        hashMap.put(280, "IBM280");
        hashMap.put(284, "IBM284");
        hashMap.put(285, "IBM285");
        hashMap.put(297, "IBM290");
        hashMap.put(300, "x-IBM300");
        hashMap.put(420, "IBM420");
        hashMap.put(424, "IBM424");
        hashMap.put(437, "IBM437");
        hashMap.put(500, "IBM500");
        hashMap.put(775, "IBM775");
        hashMap.put(819, "ISO-8859-1");
        hashMap.put(850, "IBM850");
        hashMap.put(852, "IBM852");
        hashMap.put(855, "IBM855");
        hashMap.put(857, "IBM857");
        hashMap.put(860, "IBM860");
        hashMap.put(861, "IBM861");
        hashMap.put(862, "IBM862");
        hashMap.put(863, "IBM863");
        hashMap.put(864, "IBM864");
        hashMap.put(865, "IBM865");
        hashMap.put(866, "IBM866");
        hashMap.put(868, "IBM868");
        hashMap.put(869, "IBM869");
        hashMap.put(870, "IBM870");
        hashMap.put(871, "IBM871");
        hashMap.put(874, "x-IBM874");
        hashMap.put(875, "x-IBM875");
        hashMap.put(912, "ISO-8859-2");
        hashMap.put(914, "ISO-8859-4");
        hashMap.put(915, "ISO-8859-5");
        hashMap.put(916, "ISO-8859-8");
        hashMap.put(918, "IBM918");
        hashMap.put(921, "x-IBM921");
        hashMap.put(922, "x-IBM922");
        hashMap.put(930, "x-IBM930");
        hashMap.put(933, "x-IBM933");
        hashMap.put(935, "x-IBM935");
        hashMap.put(937, "x-IBM937");
        hashMap.put(939, "x-IBM939");
        hashMap.put(942, "x-IBM942");
        hashMap.put(943, "x-IBM943");
        hashMap.put(948, "x-IBM948");
        hashMap.put(949, "x-IBM949");
        hashMap.put(950, "x-IBM950");
        hashMap.put(964, "x-IBM964");
        hashMap.put(970, "x-IBM970");
        hashMap.put(1025, "x-IBM1025");
        hashMap.put(1046, "x-IBM1046");
        hashMap.put(1097, "x-IBM1097");
        hashMap.put(1098, "x-IBM1098");
        hashMap.put(1112, "x-IBM1112");
        hashMap.put(1122, "x-IBM1122");
        hashMap.put(1123, "x-IBM1123");
        hashMap.put(1124, "x-IBM1124");
        hashMap.put(1166, "x-IBM1166");
        hashMap.put(1364, "x-IBM1364");
        hashMap.put(1381, "x-IBM1381");
        hashMap.put(1383, "x-IBM1383");
        CCSIDs = Collections.unmodifiableMap(hashMap);
        dayInMonth = new int[][]{{0, 0}, {31, 31}, {28, 29}, {31, 31}, {30, 30}, {31, 31}, {30, 30}, {31, 31}, {31, 31}, {30, 30}, {31, 31}, {30, 30}, {31, 31}};
        ZERO = CobolNum.noo(0L, 0);
        ONE = CobolNum.noo(1L, 0);
        TWO = CobolNum.noo(2L, 0);
        LOG10 = Math.log(10.0);
    }
}

