/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.rts;

import java.util.ArrayList;

public class FuzzyRegexp {
    private static final char WC_INT_CHAR = '\u0000';
    private static final char WC_CHAR = '?';
    private static final char WC_STRING = '*';
    private static final char WC_ESC = '\\';
    private final String pattern;
    private final String shortestString;
    private final int shortestLen;
    private final boolean hasWCString;
    private final boolean caseInsensitive;
    private ArrayList expByLen = new ArrayList();

    public FuzzyRegexp(String string, boolean bl) {
        int n2;
        this.caseInsensitive = bl;
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl2 = false;
        for (int i2 = 0; i2 < string.length(); ++i2) {
            n2 = string.charAt(i2);
            if (n2 == 42) {
                if (bl2) continue;
                stringBuffer.append((char)n2);
                bl2 = true;
                continue;
            }
            if (bl) {
                stringBuffer.append(Character.toUpperCase((char)n2));
            } else {
                stringBuffer.append((char)n2);
            }
            bl2 = false;
        }
        this.pattern = stringBuffer.toString();
        this.shortestString = this.getShortestString();
        this.shortestLen = this.shortestString.length();
        this.hasWCString = this.shortestLen < string.length();
        ArrayList<WCString> arrayList = new ArrayList<WCString>();
        if (this.hasWCString) {
            arrayList.add(new WCString(this.shortestString));
            for (n2 = 0; n2 <= this.shortestLen; ++n2) {
                this.expByLen.add(arrayList);
            }
        } else {
            arrayList.add(new WCString(this.shortestString));
            this.expByLen.add(arrayList);
        }
    }

    private String getShortestString() {
        String string = this.pattern;
        int n2 = string.length();
        block5: for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = string.charAt(i2);
            switch (c2) {
                case '*': {
                    String string2 = string.substring(0, i2);
                    String string3 = string.substring(i2 + 1);
                    string = string2 + string3;
                    --n2;
                    --i2;
                    continue block5;
                }
                case '?': {
                    string = string.substring(0, i2) + '\u0000' + string.substring(i2 + 1);
                    continue block5;
                }
                case '\\': {
                    string = string.substring(0, i2) + string.substring(i2 + 1);
                    ++i2;
                    continue block5;
                }
            }
        }
        return string;
    }

    private void buildStrings(ArrayList arrayList, String string, int n2, int n3) {
        block5: for (int i2 = n2; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            switch (c2) {
                case '*': {
                    String string2 = string.substring(0, i2);
                    String string3 = string.substring(i2 + 1);
                    for (int i3 = 0; i3 <= n3 - i2; ++i3) {
                        this.buildStrings(arrayList, string2 + string3, i2, n3);
                        string2 = string2 + '\u0000';
                    }
                    return;
                }
                case '?': {
                    string = string.substring(0, i2) + '\u0000' + string.substring(i2 + 1);
                    continue block5;
                }
                case '\\': {
                    string = string.substring(0, i2) + string.substring(i2 + 1);
                    ++i2;
                    continue block5;
                }
            }
        }
        if (n3 == string.length()) {
            arrayList.add(new WCString(string));
        }
    }

    public ArrayList getExpansion(int n2) {
        ArrayList arrayList;
        if (n2 <= this.shortestLen || !this.hasWCString) {
            arrayList = (ArrayList)this.expByLen.get(0);
        } else {
            for (int i2 = this.expByLen.size(); i2 <= n2; ++i2) {
                this.expByLen.add(null);
            }
            arrayList = (ArrayList)this.expByLen.get(n2);
            if (arrayList == null) {
                arrayList = new ArrayList();
                this.expByLen.set(n2, arrayList);
                this.buildStrings(arrayList, this.pattern, 0, n2);
            }
        }
        return arrayList;
    }

    private int distance(String string, String string2, int n2, int n3, int n4) {
        int n5;
        int n6 = string.length() + 1;
        int n7 = n3 + 1;
        int[] nArray = new int[n6];
        int[] nArray2 = new int[n6];
        for (n5 = 0; n5 < n6; ++n5) {
            nArray[n5] = n5;
        }
        int n8 = n2 + n7;
        for (int i2 = n2 + 1; i2 < n8; ++i2) {
            nArray2[0] = i2;
            n5 = n4;
            ++n5;
            for (int i3 = 1; i3 < n6; ++i3) {
                char c2 = string.charAt(i3 - 1);
                int n9 = c2 == '\u0000' || c2 == string2.charAt(i2 - 1) ? 0 : 1;
                int n10 = nArray[i3 - 1] + n9;
                int n11 = nArray[i3] + 1;
                int n12 = nArray2[i3 - 1] + 1;
                nArray2[i3] = Math.min(Math.min(n11, n12), n10);
                if (nArray2[i3] >= n5) continue;
                n5 = nArray2[i3];
            }
            if (n5 > n4) {
                return n5;
            }
            int[] nArray3 = nArray;
            nArray = nArray2;
            nArray2 = nArray3;
        }
        return nArray[n6 - 1];
    }

    public boolean isInDistance(int n2, String string) {
        if (this.caseInsensitive) {
            string = string.toUpperCase();
        }
        if (this.hasWCString) {
            ArrayList arrayList = this.getExpansion(string.length());
            int n3 = arrayList.size();
            for (int i2 = 0; i2 < n3; ++i2) {
                WCString wCString = (WCString)arrayList.get(i2);
                int n4 = wCString.subString != null ? this.distance(wCString.subString, string, wCString.subStart, wCString.subLen, n2) : this.distance(wCString.theString, string, 0, string.length(), n2);
                if (n4 > n2) continue;
                return true;
            }
        } else {
            int n5 = this.distance(this.shortestString, string, 0, string.length(), n2);
            if (n5 <= n2) {
                return true;
            }
        }
        return false;
    }

    static class WCString {
        final String theString;
        final String subString;
        final int subStart;
        final int subLen;

        WCString(String string) {
            this.theString = string;
            if (this.theString.length() > 0) {
                int n2;
                int n3 = this.theString.length();
                if (string.charAt(0) == '\u0000') {
                    for (n2 = 1; n2 < n3 && string.charAt(n2) == '\u0000'; ++n2) {
                    }
                    this.subStart = n2;
                } else {
                    this.subStart = 0;
                }
                if (string.charAt(n3 - 1) == '\u0000') {
                    for (n2 = n3 - 2; n2 > this.subStart && string.charAt(n2) == '\u0000'; --n2) {
                    }
                    this.subLen = n2 - this.subStart + 1;
                } else {
                    this.subLen = n3 - this.subStart;
                }
                this.subString = this.subLen > 0 && this.subLen < n3 ? this.theString.substring(this.subStart, this.subStart + this.subLen) : null;
            } else {
                this.subString = null;
                this.subStart = 0;
                this.subLen = 0;
            }
        }
    }
}

