/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.rts;

import com.iscobol.rts.Base64;
import com.iscobol.rts.Config;
import com.iscobol.rts.Factory;
import com.iscobol.rts.File;
import com.iscobol.rts.HTTPData;
import com.iscobol.rts.ICobolVar;
import com.iscobol.rts.IscobolRuntimeException;
import com.iscobol.rts.JSONStream;
import com.iscobol.rts.RtsUtil;
import com.iscobol.rts.XMLStream;
import com.iscobol.types.PicX;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class HTTPClient {
    private static IHTTPClientHelper httpClientHelper;
    private static int javaVersion;
    private static final String eol;
    private final String K_POST = "POST";
    private final String K_PUT = "PUT";
    private final String K_PATCH = "PATCH";
    private final String K_DELETE = "DELETE";
    private final String K_HEAD = "HEAD";
    private HttpURLConnection httpConn;
    private Proxy proxy = null;
    private HTTPData.Params parameters;
    private ArrayList headerProperties;
    private String user;
    private String password;
    private int responseCode;
    private byte[] response;
    private String responseContentType;
    private LinkedHashMap<String, Attachment> responseAttachments;
    private String encoding;
    private String lastRequest;
    private Double connectTimeout = -1.0;
    private Double readTimeout = -1.0;
    private int debugFlg = Config.a("iscobol.tracelevel", -1);
    private byte[] contentToLog = null;

    private void setConnection(String string) throws MalformedURLException, IOException {
        String string2 = string.toLowerCase();
        this.logString(null, "===============================");
        this.logString(null, "Connection requested at " + new SimpleDateFormat("yyyy-MM-dd - HH:mm:ss.ms").format(new Date()));
        this.logString(null, "Connecting to: " + string2);
        if (string2.startsWith("https://")) {
            String string3 = Config.a(".net.ssl.trust_store", null);
            if (string3 != null && string3.length() > 0 && !"*".equals(string3)) {
                System.setProperty("javax.net.ssl.trustStore", string3);
                string3 = Config.a(".net.ssl.trust_store_password", null);
                if (string3 != null) {
                    System.setProperty("javax.net.ssl.trustStorePassword", string3);
                }
            }
        } else if (!string.toLowerCase().startsWith("http://")) {
            string = "http://" + string;
        }
        URL uRL = new URL(string);
        if (this.httpConn != null) {
            this.httpConn.disconnect();
            this.httpConn = null;
        }
        try {
            this.httpConn = this.proxy == null ? (HttpURLConnection)uRL.openConnection() : (HttpURLConnection)uRL.openConnection(this.proxy);
        }
        catch (Exception exception) {
            this.logString(null, "An exception occurred opening connection:");
            this.logString(null, exception.getMessage());
            throw exception;
        }
        int n2 = this.connectTimeout.intValue();
        int n3 = this.readTimeout.intValue();
        this.httpConn.setConnectTimeout(n2 >= 0 ? n2 * 1000 : 0);
        this.httpConn.setReadTimeout(n3 >= 0 ? n3 * 1000 : 0);
        if (this.user != null) {
            String string4 = this.password != null ? "Basic " + new String(Base64.encode((this.user + ":" + this.password).getBytes())) : "Bearer " + this.user;
            this.httpConn.setRequestProperty("Authorization", string4);
        }
        if (this.headerProperties != null) {
            int n4 = this.headerProperties.size();
            for (int i2 = 0; i2 < n4; ++i2) {
                HTTPData.Pair pair = (HTTPData.Pair)this.headerProperties.get(i2);
                this.httpConn.setRequestProperty(pair.key, pair.value);
            }
        }
    }

    private void sendPostPut(HTTPData.ByteBuilder byteBuilder) {
        OutputStream outputStream = this.getOutputStream();
        try {
            outputStream.write(byteBuilder.getBytes(), 0, byteBuilder.length());
            outputStream.flush();
            if (this.isLoggingEnabled()) {
                this.contentToLog = (byte[])byteBuilder.getBytes().clone();
            }
        }
        catch (Exception exception) {
            this.logError(this.httpConn, exception);
            throw new IscobolRuntimeException(exception);
        }
    }

    private void sendPostPut(String string) {
        OutputStream outputStream = this.getOutputStream();
        try {
            byte[] byArray = string.getBytes("UTF-8");
            outputStream.write(byArray, 0, byArray.length);
            outputStream.flush();
            if (this.isLoggingEnabled()) {
                this.contentToLog = (byte[])byArray.clone();
            }
        }
        catch (Exception exception) {
            this.logError(this.httpConn, exception);
            throw new IscobolRuntimeException(exception);
        }
    }

    private OutputStream getOutputStream() {
        OutputStream outputStream;
        try {
            outputStream = this.httpConn.getOutputStream();
        }
        catch (SSLHandshakeException sSLHandshakeException) {
            if (this.httpConn instanceof HttpsURLConnection && Config.b("iscobol.http.ignore_certificates", false)) {
                HttpsURLConnection httpsURLConnection = (HttpsURLConnection)this.httpConn;
                TrustManager[] trustManagerArray = new TrustManager[]{new X509TrustManager(){

                    @Override
                    public X509Certificate[] getAcceptedIssuers() {
                        return null;
                    }

                    @Override
                    public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) {
                    }

                    @Override
                    public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) {
                    }
                }};
                try {
                    SSLContext sSLContext = SSLContext.getInstance("SSL");
                    sSLContext.init(null, trustManagerArray, null);
                    httpsURLConnection.setSSLSocketFactory(sSLContext.getSocketFactory());
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                try {
                    outputStream = this.httpConn.getOutputStream();
                }
                catch (Exception exception) {
                    this.logError(this.httpConn, exception);
                    throw new IscobolRuntimeException(exception);
                }
            }
            this.logError(this.httpConn, sSLHandshakeException);
            throw new IscobolRuntimeException(sSLHandshakeException);
        }
        catch (Exception exception) {
            this.logError(this.httpConn, exception);
            throw new IscobolRuntimeException(exception);
        }
        return outputStream;
    }

    private void connectPost(String string) {
        try {
            this.setConnection(string);
        }
        catch (Exception exception) {
            this.logError(this.httpConn, exception);
            throw new IscobolRuntimeException(exception);
        }
        try {
            this.httpConn.setRequestMethod("POST");
        }
        catch (Exception exception) {
            this.logError(this.httpConn, exception);
            throw new IscobolRuntimeException(exception);
        }
        this.httpConn.setDoOutput(true);
        this.httpConn.setDoInput(true);
    }

    private void connectWithMethod(String string, String string2) {
        try {
            this.setConnection(string);
        }
        catch (Exception exception) {
            this.logError(this.httpConn, exception);
            throw new IscobolRuntimeException(exception);
        }
        try {
            this.httpConn.setRequestMethod(string2);
        }
        catch (Exception exception) {
            this.logError(this.httpConn, exception);
            throw new IscobolRuntimeException(exception);
        }
        this.httpConn.setDoOutput(true);
        this.httpConn.setDoInput(true);
    }

    private void doRequest() {
        char c2;
        String string;
        try {
            this.responseCode = this.httpConn.getResponseCode();
        }
        catch (Exception exception) {
            this.logError(this.httpConn, exception);
            throw new IscobolRuntimeException(exception);
        }
        this.logRequestContent();
        this.logString(this.httpConn, "");
        this.logString(this.httpConn, "Response code: " + this.responseCode);
        this.logString(this.httpConn, "Response Headers:");
        this.encoding = "UTF-8";
        int n2 = 0;
        while ((string = this.httpConn.getHeaderField(n2)) != null) {
            int n3;
            String string2 = this.httpConn.getHeaderFieldKey(n2);
            this.logString(this.httpConn, (string2 != null ? string2 + ":" : "") + string);
            if ("Content-Type".equalsIgnoreCase(string2) && (n3 = string.indexOf("charset=")) >= 0) {
                this.encoding = "";
                for (int i2 = n3 + 8; i2 < string.length(); ++i2) {
                    char c3 = string.charAt(i2);
                    c2 = c3;
                    if (c3 == ' ' || c2 == ';') break;
                    this.encoding = this.encoding + c2;
                }
            }
            ++n2;
        }
        try {
            this.response = null;
            this.responseAttachments = null;
            InputStream inputStream = this.responseCode >= 400 ? this.httpConn.getErrorStream() : this.httpConn.getInputStream();
            byte[] byArray = new byte[8192];
            if (inputStream != null) {
                while ((c2 = inputStream.read(byArray, 0, byArray.length)) >= '\u0000') {
                    if (this.response == null) {
                        if (c2 == byArray.length) {
                            this.response = byArray;
                            byArray = new byte[byArray.length];
                            continue;
                        }
                        this.response = new byte[c2];
                        System.arraycopy(byArray, 0, this.response, 0, c2);
                        continue;
                    }
                    byte[] byArray2 = new byte[this.response.length + c2];
                    System.arraycopy(this.response, 0, byArray2, 0, this.response.length);
                    System.arraycopy(byArray, 0, byArray2, this.response.length, c2);
                    this.response = byArray2;
                }
            } else {
                this.response = new byte[0];
            }
            this.logResponseContent(this.response);
        }
        catch (Exception exception) {
            this.logError(this.httpConn, exception);
            throw new IscobolRuntimeException(exception);
        }
    }

    public void setAuth(ICobolVar iCobolVar, ICobolVar iCobolVar2) {
        this.user = iCobolVar.toStringNoGui();
        this.password = iCobolVar2.toStringNoGui();
        if (httpClientHelper != null) {
            httpClientHelper.setAuth(iCobolVar, iCobolVar2);
        }
    }

    public void setAuth(ICobolVar iCobolVar) {
        this.user = iCobolVar.toStringNoGui();
        this.password = null;
        if (httpClientHelper != null) {
            httpClientHelper.setAuth(iCobolVar, null);
        }
    }

    private void setHeaderProperty(String string, String string2) {
        if (this.headerProperties == null) {
            this.headerProperties = new ArrayList();
        }
        this.headerProperties.add(new HTTPData.Pair(string, string2));
    }

    public void setHeaderProperty(ICobolVar iCobolVar, ICobolVar iCobolVar2) {
        this.setHeaderProperty(iCobolVar.toStringNoGui().trim(), iCobolVar2.toStringNoGui().trim());
    }

    public void getHeaderProperty(ICobolVar iCobolVar, ICobolVar iCobolVar2) {
        if (this.httpConn != null) {
            String string = this.httpConn.getHeaderField(iCobolVar.toStringNoGui().trim());
            if (string != null) {
                iCobolVar2.set(this.httpConn.getHeaderField(iCobolVar.toStringNoGui().trim()));
            } else {
                iCobolVar2.set("");
            }
        }
    }

    public void setParameter(ICobolVar iCobolVar, ICobolVar iCobolVar2) {
        if (this.parameters == null) {
            this.parameters = new HTTPData.Params();
        }
        this.parameters.add(iCobolVar, iCobolVar2);
    }

    public void doPostEx(ICobolVar iCobolVar, ICobolVar iCobolVar2) {
        PicX picX = Config.a(".rest.default_stream", "json").equalsIgnoreCase("xml") ? Factory.getStrLiteral("application/xml") : Factory.getStrLiteral("application/json");
        this.doPostEx(iCobolVar, picX, iCobolVar2);
    }

    public void doPostEx(ICobolVar iCobolVar, ICobolVar iCobolVar2, ICobolVar iCobolVar3) {
        String string = iCobolVar2.toStringNoGui().trim();
        String string2 = this.getUrlString(iCobolVar);
        if (iCobolVar3.getIXMLAttributes() == null) {
            this.setHeaderProperty("Content-Type", string);
            this.connectWithMethod(string2, "POST");
            this.sendPostPut(iCobolVar3.toStringNoGui().trim());
            this.lastRequest = this.buildRequestLog(iCobolVar3.toStringNoGui().trim());
        } else {
            XMLStream xMLStream = string.contains("/json") ? new JSONStream(iCobolVar3) : new XMLStream(iCobolVar3);
            StringBuffer stringBuffer = new StringBuffer();
            xMLStream.writeToStringBuffer(stringBuffer);
            Map<String, ICobolVar> map = xMLStream.getMtomItems();
            if (!(xMLStream instanceof JSONStream) && !map.isEmpty()) {
                HTTPData.Params params = new HTTPData.Params();
                params.list.add(new HTTPData.Pair("myenvelope", stringBuffer.toString(), "<rootpart@veryant.com>", 0));
                for (String string3 : map.keySet()) {
                    HTTPData.MPFile mPFile = new HTTPData.MPFile(string3, string3, null, "<" + string3 + ">", 2);
                    mPFile.contents = map.get(string3).getBytes();
                    params.list.add(mPFile);
                    this.doPostMTOM(iCobolVar.toStringNoGui(), params);
                }
                return;
            }
            this.setHeaderProperty("Content-Type", string);
            this.connectWithMethod(string2, "POST");
            this.sendPostPut(stringBuffer.toString());
            this.lastRequest = this.buildRequestLog(stringBuffer.toString());
        }
        this.doRequest();
    }

    private String getUrlString(String string) {
        String string2 = string.toString().trim();
        if (this.parameters != null) {
            StringBuffer stringBuffer = new StringBuffer(string2);
            stringBuffer.append(string2.indexOf(63) >= 0 ? "&" : "?");
            this.parameters.getUrlencodedParameters(stringBuffer);
            string2 = stringBuffer.toString();
            this.parameters = null;
        }
        return string2;
    }

    private String getUrlString(ICobolVar iCobolVar) {
        String string = iCobolVar.toStringNoGui().trim();
        if (this.parameters != null) {
            StringBuffer stringBuffer = new StringBuffer(string);
            stringBuffer.append(string.indexOf(63) >= 0 ? "&" : "?");
            this.parameters.getUrlencodedParameters(stringBuffer);
            string = stringBuffer.toString();
            this.parameters = null;
        }
        return string;
    }

    public void doPostEx(ICobolVar iCobolVar, ICobolVar iCobolVar2, ICobolVar iCobolVar3, ICobolVar iCobolVar4) {
        String string = iCobolVar2.toStringNoGui().trim();
        String string2 = this.getUrlString(iCobolVar);
        if (iCobolVar3.getIXMLAttributes() == null) {
            this.setHeaderProperty("Content-Type", string);
            this.connectWithMethod(string2, "POST");
            this.sendPostPut(iCobolVar3.toStringNoGui().trim());
        } else {
            XMLStream xMLStream = string.contains("/json") ? new JSONStream(iCobolVar3, iCobolVar4) : new XMLStream(iCobolVar3);
            StringBuffer stringBuffer = new StringBuffer();
            xMLStream.writeToStringBuffer(stringBuffer);
            Map<String, ICobolVar> map = xMLStream.getMtomItems();
            if (!(xMLStream instanceof JSONStream) && !map.isEmpty()) {
                HTTPData.Params params = new HTTPData.Params();
                params.list.add(new HTTPData.Pair("myenvelope", stringBuffer.toString(), "<rootpart@veryant.com>", 0));
                for (String string3 : map.keySet()) {
                    HTTPData.MPFile mPFile = new HTTPData.MPFile(string3, string3, null, "<" + string3 + ">", 2);
                    mPFile.contents = map.get(string3).getBytes();
                    params.list.add(mPFile);
                    this.doPostMTOM(iCobolVar.toStringNoGui(), params);
                }
                return;
            }
            this.setHeaderProperty("Content-Type", string);
            this.connectWithMethod(string2, "POST");
            this.sendPostPut(stringBuffer.toString());
            this.lastRequest = this.buildRequestLog(stringBuffer.toString());
        }
        this.doRequest();
    }

    public void doPost(ICobolVar iCobolVar, HTTPData.Params params) {
        this.parameters = params;
        this.doPost(iCobolVar);
    }

    public void doPostMultipart(ICobolVar iCobolVar) {
        String string = "--------isCOBOL-FormBoundary-" + System.currentTimeMillis();
        this.setHeaderProperty("Content-Type", "multipart/form-data; boundary=" + string);
        this.doPostMultipart0(iCobolVar.toStringNoGui(), string);
    }

    public void doPutMultipart(ICobolVar iCobolVar) {
        String string = "--------isCOBOL-FormBoundary-" + System.currentTimeMillis();
        this.setHeaderProperty("Content-Type", "multipart/form-data; boundary=" + string);
        this.doPutMultipart0(iCobolVar.toStringNoGui(), string);
    }

    private void doPutMultipart0(String string, String string2) {
        this.connectWithMethod(string.toString(), "PUT");
        if (this.parameters != null) {
            this.sendPostPut(this.parameters.getMultipartParameters(string2));
            this.parameters = null;
        }
        this.doRequest();
    }

    private void doPostMTOM(String string, HTTPData.Params params) {
        String string2 = "--------isCOBOL-FormBoundary-" + System.currentTimeMillis();
        this.parameters = params;
        this.setHeaderProperty("SOAPAction", "soap");
        this.setHeaderProperty("Content-Type", "multipart/related; type=\"application/xop+xml\"; start=\"<rootpart@veryant.com>\"; start-info=\"text/xml\"; boundary=" + string2);
        this.doPostMultipart0(string, string2);
    }

    private void doPostMultipart0(String string, String string2) {
        this.connectPost(string.toString());
        if (this.parameters != null) {
            this.sendPostPut(this.parameters.getMultipartParameters(string2));
            this.parameters = null;
        }
        this.doRequest();
    }

    public void doPostMultipart(ICobolVar iCobolVar, HTTPData.Params params) {
        this.parameters = params;
        this.doPostMultipart(iCobolVar);
    }

    public void doPost(ICobolVar iCobolVar) {
        this.connectWithMethod(iCobolVar.toStringNoGui(), "POST");
        if (this.parameters != null) {
            StringBuffer stringBuffer = new StringBuffer();
            this.parameters.getUrlencodedParameters(stringBuffer);
            this.sendPostPut(stringBuffer.toString());
            this.parameters = null;
        }
        this.doRequest();
        this.lastRequest = this.buildRequestLog();
        this.logString(null, this.lastRequest);
    }

    public void doGet(String string, HTTPData.Params params) {
        this.parameters = params;
        this.doGet(string);
    }

    public void doGet(String string) {
        try {
            String string2 = this.getUrlString(string);
            this.setConnection(string2);
            this.lastRequest = this.buildRequestLog();
            this.logString(null, this.lastRequest);
        }
        catch (Exception exception) {
            throw new IscobolRuntimeException(exception);
        }
        this.doRequest();
    }

    public void doHead(String string, HTTPData.Params params) {
        this.parameters = params;
        this.doHead(string);
    }

    public void doHead(String string) {
        if (this.parameters != null) {
            StringBuffer stringBuffer = new StringBuffer(string);
            stringBuffer.append(string.indexOf(63) >= 0 ? "&" : "?");
            this.parameters.getUrlencodedParameters(stringBuffer);
            string = stringBuffer.toString();
            this.parameters = null;
        }
        try {
            this.connectWithMethod(string, "HEAD");
        }
        catch (Exception exception) {
            throw new IscobolRuntimeException(exception);
        }
        this.doRequest();
    }

    public void doDeleteEx(ICobolVar iCobolVar, ICobolVar iCobolVar2) {
        PicX picX = Config.a(".rest.default_stream", "json").equalsIgnoreCase("xml") ? Factory.getStrLiteral("application/xml") : Factory.getStrLiteral("application/json");
        this.doActionEx("DELETE", iCobolVar, picX, iCobolVar2, null);
    }

    public void doDeleteEx(ICobolVar iCobolVar, ICobolVar iCobolVar2, ICobolVar iCobolVar3) {
        this.doActionEx("DELETE", iCobolVar, iCobolVar2, iCobolVar3, null);
    }

    public void doDeleteEx(ICobolVar iCobolVar, ICobolVar iCobolVar2, ICobolVar iCobolVar3, ICobolVar iCobolVar4) {
        this.doActionEx("DELETE", iCobolVar, iCobolVar2, iCobolVar3, iCobolVar4);
    }

    public void doDelete(ICobolVar iCobolVar, HTTPData.Params params) {
        this.parameters = params;
        this.doDelete(iCobolVar);
    }

    public void doDelete(ICobolVar iCobolVar) {
        this.connectWithMethod(iCobolVar.toStringNoGui(), "DELETE");
        if (this.parameters != null) {
            StringBuffer stringBuffer = new StringBuffer();
            this.parameters.getUrlencodedParameters(stringBuffer);
            this.sendPostPut(stringBuffer.toString());
            this.parameters = null;
        }
        this.doRequest();
        this.lastRequest = this.buildRequestLog();
        this.logString(null, this.lastRequest);
    }

    public void doPutEx(ICobolVar iCobolVar, ICobolVar iCobolVar2) {
        PicX picX = Config.a(".rest.default_stream", "json").equalsIgnoreCase("xml") ? Factory.getStrLiteral("application/xml") : Factory.getStrLiteral("application/json");
        this.doPutEx(iCobolVar, picX, iCobolVar2);
    }

    public void doPutEx(ICobolVar iCobolVar, ICobolVar iCobolVar2, ICobolVar iCobolVar3) {
        String string = iCobolVar2.toStringNoGui().trim();
        String string2 = this.getUrlString(iCobolVar);
        if (iCobolVar3.getIXMLAttributes() == null) {
            this.setHeaderProperty("Content-Type", string);
            this.connectWithMethod(string2, "PUT");
            this.sendPostPut(iCobolVar3.toStringNoGui().trim());
        } else {
            XMLStream xMLStream = string.contains("/json") ? new JSONStream(iCobolVar3) : new XMLStream(iCobolVar3);
            StringBuffer stringBuffer = new StringBuffer();
            xMLStream.writeToStringBuffer(stringBuffer);
            Map<String, ICobolVar> map = xMLStream.getMtomItems();
            if (!(xMLStream instanceof JSONStream) && !map.isEmpty()) {
                HTTPData.Params params = new HTTPData.Params();
                params.list.add(new HTTPData.Pair("myenvelope", stringBuffer.toString(), "<rootpart@veryant.com>", 0));
                for (String string3 : map.keySet()) {
                    HTTPData.MPFile mPFile = new HTTPData.MPFile(string3, string3, null, "<" + string3 + ">", 2);
                    mPFile.contents = map.get(string3).getBytes();
                    params.list.add(mPFile);
                    this.doPostMTOM(iCobolVar.toStringNoGui(), params);
                }
                return;
            }
            this.setHeaderProperty("Content-Type", string);
            this.connectWithMethod(string2, "PUT");
            this.sendPostPut(stringBuffer.toString());
            this.lastRequest = this.buildRequestLog(stringBuffer.toString());
        }
        this.doRequest();
    }

    public void doPutEx(ICobolVar iCobolVar, ICobolVar iCobolVar2, ICobolVar iCobolVar3, ICobolVar iCobolVar4) {
        String string = iCobolVar2.toStringNoGui().trim();
        String string2 = this.getUrlString(iCobolVar);
        if (iCobolVar3.getIXMLAttributes() == null) {
            this.setHeaderProperty("Content-Type", string);
            this.connectWithMethod(string2, "PUT");
            this.sendPostPut(iCobolVar3.toStringNoGui().trim());
            this.lastRequest = this.buildRequestLog(iCobolVar3.toStringNoGui().trim());
        } else {
            XMLStream xMLStream = string.contains("/json") ? new JSONStream(iCobolVar3, iCobolVar4) : new XMLStream(iCobolVar3);
            StringBuffer stringBuffer = new StringBuffer();
            xMLStream.writeToStringBuffer(stringBuffer);
            Map<String, ICobolVar> map = xMLStream.getMtomItems();
            if (!(xMLStream instanceof JSONStream) && !map.isEmpty()) {
                HTTPData.Params params = new HTTPData.Params();
                params.list.add(new HTTPData.Pair("myenvelope", stringBuffer.toString(), "<rootpart@veryant.com>", 0));
                for (String string3 : map.keySet()) {
                    HTTPData.MPFile mPFile = new HTTPData.MPFile(string3, string3, null, "<" + string3 + ">", 2);
                    mPFile.contents = map.get(string3).getBytes();
                    params.list.add(mPFile);
                    this.doPostMTOM(iCobolVar.toStringNoGui(), params);
                }
                return;
            }
            this.setHeaderProperty("Content-Type", string);
            this.connectWithMethod(string2, "PUT");
            this.sendPostPut(stringBuffer.toString());
            this.lastRequest = this.buildRequestLog(stringBuffer.toString());
        }
        this.doRequest();
    }

    public void doPut(ICobolVar iCobolVar, HTTPData.Params params) {
        this.parameters = params;
        this.doPut(iCobolVar);
    }

    public void doPut(ICobolVar iCobolVar) {
        this.connectWithMethod(iCobolVar.toStringNoGui(), "PUT");
        if (this.parameters != null) {
            StringBuffer stringBuffer = new StringBuffer();
            this.parameters.getUrlencodedParameters(stringBuffer);
            this.sendPostPut(stringBuffer.toString());
            this.parameters = null;
        }
        this.doRequest();
    }

    public void doPatchEx(ICobolVar iCobolVar, ICobolVar iCobolVar2) {
        PicX picX = Config.a(".rest.default_stream", "json").equalsIgnoreCase("xml") ? Factory.getStrLiteral("application/xml") : Factory.getStrLiteral("application/json");
        this.doPatchEx(iCobolVar, picX, iCobolVar2, null);
    }

    public void doPatchEx(ICobolVar iCobolVar, ICobolVar iCobolVar2, ICobolVar iCobolVar3) {
        this.doPatchEx(iCobolVar, iCobolVar2, iCobolVar3, null);
    }

    public void doPatchEx(ICobolVar iCobolVar, ICobolVar iCobolVar2, ICobolVar iCobolVar3, ICobolVar iCobolVar4) {
        String string = this.getUrlString(iCobolVar);
        String string2 = iCobolVar2.toStringNoGui().trim();
        if (javaVersion > 8 && httpClientHelper != null) {
            try {
                if (this.parameters != null) {
                    httpClientHelper.setParameters(this.parameters);
                }
                if (this.headerProperties != null) {
                    httpClientHelper.setHeaderProperties(this.headerProperties);
                }
                httpClientHelper.setConnectionTimeout(this.connectTimeout.intValue());
                httpClientHelper.doPatchEx(string, iCobolVar2, iCobolVar3, null);
                this.responseCode = httpClientHelper.getResponseCode();
                this.response = httpClientHelper.getResponse();
                this.responseContentType = httpClientHelper.getContentType();
            }
            catch (Exception exception) {
                System.out.println(exception.getMessage());
            }
        } else {
            if (iCobolVar3.getIXMLAttributes() == null) {
                this.setHeaderProperty("Content-Type", string2);
                HTTPClient.allowMethods("PATCH");
                this.connectWithMethod(string, "PATCH");
                this.sendPostPut(iCobolVar3.toStringNoGui().trim());
            } else {
                XMLStream xMLStream = string2.contains("/json") ? new JSONStream(iCobolVar3, iCobolVar4) : new XMLStream(iCobolVar3);
                StringBuffer stringBuffer = new StringBuffer();
                xMLStream.writeToStringBuffer(stringBuffer);
                Map<String, ICobolVar> map = xMLStream.getMtomItems();
                if (!(xMLStream instanceof JSONStream) && !map.isEmpty()) {
                    HTTPData.Params params = new HTTPData.Params();
                    params.list.add(new HTTPData.Pair("myenvelope", stringBuffer.toString(), "<rootpart@veryant.com>", 0));
                    for (String string3 : map.keySet()) {
                        HTTPData.MPFile mPFile = new HTTPData.MPFile(string3, string3, null, "<" + string3 + ">", 2);
                        mPFile.contents = map.get(string3).getBytes();
                        params.list.add(mPFile);
                        this.doPostMTOM(iCobolVar.toStringNoGui(), params);
                    }
                    return;
                }
                this.setHeaderProperty("Content-Type", string2);
                HTTPClient.allowMethods("PATCH");
                this.connectWithMethod(string, "PATCH");
                this.sendPostPut(stringBuffer.toString());
                this.lastRequest = this.buildRequestLog(stringBuffer.toString());
            }
            this.doRequest();
        }
    }

    public void doPatch(ICobolVar iCobolVar, HTTPData.Params params) {
        this.parameters = params;
        this.doPatch(iCobolVar);
    }

    public void doPatch(ICobolVar iCobolVar) {
        if (javaVersion > 8 && httpClientHelper != null) {
            try {
                String string = this.getUrlString(iCobolVar);
                Class<?> clazz = Class.forName("com.iscobol.rts.HTTPClientHelper");
                Constructor<?> constructor = clazz.getConstructor(new Class[0]);
                IHTTPClientHelper iHTTPClientHelper = (IHTTPClientHelper)constructor.newInstance(new Object[0]);
                if (this.parameters != null) {
                    iHTTPClientHelper.setParameters(this.parameters);
                }
                if (this.headerProperties != null) {
                    iHTTPClientHelper.setHeaderProperties(this.headerProperties);
                }
                iHTTPClientHelper.setConnectionTimeout(this.connectTimeout.intValue());
                iHTTPClientHelper.doPatchEx(string, null, null, null);
                this.responseCode = iHTTPClientHelper.getResponseCode();
                this.response = iHTTPClientHelper.getResponse();
                this.responseContentType = iHTTPClientHelper.getContentType();
            }
            catch (Exception exception) {
                System.out.println(exception.getMessage());
            }
        } else {
            HTTPClient.allowMethods("PATCH");
            this.connectWithMethod(iCobolVar.toStringNoGui(), "PATCH");
            if (this.parameters != null) {
                StringBuffer stringBuffer = new StringBuffer();
                this.parameters.getUrlencodedParameters(stringBuffer);
                this.sendPostPut(stringBuffer.toString());
                this.parameters = null;
            }
            this.doRequest();
        }
    }

    public void getResponseCode(ICobolVar iCobolVar) {
        iCobolVar.set(this.responseCode);
    }

    public void getResponseMessage(ICobolVar iCobolVar) {
        if (javaVersion < 11) {
            if (this.httpConn != null) {
                try {
                    iCobolVar.set(this.httpConn.getResponseMessage());
                    this.logString(this.httpConn, "Response from server:");
                    this.logString(this.httpConn, this.httpConn.getResponseMessage());
                }
                catch (Exception exception) {
                    throw new IscobolRuntimeException(exception);
                }
            } else {
                iCobolVar.set(new byte[]{32});
            }
        } else {
            iCobolVar.set(this.response);
        }
    }

    private String getResponseString() {
        return this.getResponseString(this.response);
    }

    private String getResponseString(byte[] byArray) {
        if (byArray != null) {
            if (this.encoding != null) {
                try {
                    return new String(byArray, 0, byArray.length, this.encoding);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    throw new IscobolRuntimeException(unsupportedEncodingException);
                }
            }
            return new String(byArray, 0, byArray.length);
        }
        return "";
    }

    public void getResponsePlain(ICobolVar iCobolVar) {
        if (this.response != null) {
            iCobolVar.set(this.getResponseString());
        } else {
            iCobolVar.set(new byte[]{32});
        }
    }

    public void getRequestPlain(ICobolVar iCobolVar) {
        if (this.lastRequest != null) {
            iCobolVar.set(this.lastRequest);
        } else {
            iCobolVar.set(new byte[]{32});
        }
    }

    public void getResponseEx(ICobolVar iCobolVar) {
        this.getResponseEx(iCobolVar, null);
    }

    public void getResponseAttachmentIDs(ICobolVar iCobolVar) {
        if (this.responseAttachments != null) {
            String string = "";
            for (String string2 : this.responseAttachments.keySet()) {
                if (string.length() > 0) {
                    string = string + ",";
                }
                string = string + string2;
            }
            iCobolVar.set(string);
        }
    }

    public void getResponseAttachmentBody(ICobolVar iCobolVar, ICobolVar iCobolVar2) {
        Attachment attachment;
        if (this.responseAttachments != null && (attachment = this.responseAttachments.get(iCobolVar.toStringNoGui())) != null && attachment.body != null) {
            iCobolVar2.set(attachment.body);
        } else {
            iCobolVar2.set("");
        }
    }

    public void getResponseAttachmentAttrNames(ICobolVar iCobolVar, ICobolVar iCobolVar2) {
        Attachment attachment;
        if (this.responseAttachments != null && (attachment = this.responseAttachments.get(iCobolVar.toStringNoGui())) != null) {
            String string = "";
            for (String string2 : attachment.attrs.keySet()) {
                if (string.length() > 0) {
                    string = string + ",";
                }
                string = string + string2;
            }
            iCobolVar2.set(string);
        } else {
            iCobolVar2.set("");
        }
    }

    public void getResponseAttachmentAttr(ICobolVar iCobolVar, ICobolVar iCobolVar2, ICobolVar iCobolVar3) {
        String string;
        Attachment attachment;
        if (this.responseAttachments != null && (attachment = this.responseAttachments.get(iCobolVar.toStringNoGui())) != null && (string = attachment.attrs.get(iCobolVar2.toStringNoGui())) != null) {
            iCobolVar3.set(string);
        } else {
            iCobolVar3.set("");
        }
    }

    public void getResponseEx(ICobolVar iCobolVar, String string) {
        if (this.response != null) {
            this.responseAttachments = new LinkedHashMap();
            HashMap<String, PicX> hashMap = null;
            boolean bl = Config.b("iscobol.http.mtom_enabled", false);
            String string2 = this.getResponseContentType();
            byte[] byArray = this.response;
            if (string2.startsWith("multipart")) {
                Object object;
                int n2;
                String[] stringArray = RtsUtil.parseArguments(string2, ";");
                String string3 = null;
                byte[] byArray2 = null;
                byte[] byArray3 = null;
                byte[] byArray4 = new byte[]{13, 10};
                String[] stringArray2 = stringArray;
                int n3 = stringArray2.length;
                for (n2 = 0; n2 < n3; ++n2) {
                    object = stringArray2[n2];
                    String string4 = ((String)(object = ((String)object).trim())).toLowerCase();
                    if (string4.startsWith("start=")) {
                        string3 = ((String)object).substring(6);
                        continue;
                    }
                    if (!string4.startsWith("boundary=")) continue;
                    byArray2 = ("--" + ((String)object).substring(9) + "\r\n").getBytes();
                    byArray3 = ("--" + ((String)object).substring(9) + "--").getBytes();
                }
                if (byArray2 != null) {
                    int n4 = 0;
                    while ((n3 = RtsUtil.indexOf(this.response, byArray2, n4)) >= 0 && ((n2 = RtsUtil.indexOf(this.response, byArray2, n3 + byArray2.length)) >= 0 || (n2 = RtsUtil.indexOf(this.response, byArray3, n3 + byArray2.length)) >= 0)) {
                        int n5;
                        n4 = n2;
                        object = new byte[n2 - n3 - byArray2.length];
                        System.arraycopy(this.response, n3 + byArray2.length, object, 0, ((Object)object).length);
                        byte[] byArray5 = null;
                        int n6 = 0;
                        Attachment attachment = null;
                        while ((n5 = RtsUtil.indexOf((byte[])object, byArray4, n6)) >= 0) {
                            String string5;
                            if (n5 == n6) {
                                String string6;
                                byArray5 = new byte[((Object)object).length - n6 - byArray4.length];
                                System.arraycopy(object, n6 + byArray4.length, byArray5, 0, byArray5.length);
                                string5 = attachment != null ? attachment.attrs.get("content-id") : null;
                                String string7 = string6 = attachment != null ? attachment.attrs.get("content-type") : null;
                                if (byArray == this.response && byArray5 != null && string5 != null && string3 != null && string5.equals(string3)) {
                                    byArray = byArray5;
                                    if (string6 != null) {
                                        string2 = string6;
                                    }
                                } else if (attachment != null) {
                                    attachment.body = byArray5;
                                    this.responseAttachments.put(attachment.attrs.get("content-id"), attachment);
                                    if (bl && string5 != null && string5.length() > 2) {
                                        if (hashMap == null) {
                                            hashMap = new HashMap<String, PicX>();
                                        }
                                        hashMap.put(string5.substring(1, string5.length() - 1), new PicX(attachment.body));
                                    }
                                }
                                attachment = null;
                            } else {
                                string5 = new String((byte[])object, n6, n5 - n6);
                                int n7 = string5.indexOf(58);
                                if (n7 > 0 && n7 < string5.length() - 1) {
                                    if (attachment == null) {
                                        attachment = new Attachment();
                                    }
                                    attachment.attrs.put(string5.substring(0, n7).trim(), string5.substring(n7 + 1).trim());
                                }
                            }
                            n6 = n5 + byArray4.length;
                        }
                    }
                }
            }
            if (string2.contains("xml") || Config.a(".rest.default_stream", "json").equalsIgnoreCase("xml")) {
                this.getResponseXML(byArray, iCobolVar, string, hashMap);
            } else {
                this.getResponseJSON(byArray, iCobolVar, string, null);
            }
        } else {
            iCobolVar.set(new byte[]{32});
        }
    }

    public void getResponseXML(ICobolVar iCobolVar) {
        this.getResponseXML(this.response, iCobolVar, null, null);
    }

    public void getResponseXML(ICobolVar iCobolVar, String string) {
        this.getResponseXML(this.response, iCobolVar, string, null);
    }

    private void getResponseXML(byte[] byArray, ICobolVar iCobolVar, String string, Map<String, ICobolVar> map) {
        if (byArray != null) {
            XMLStream xMLStream = new XMLStream(iCobolVar);
            xMLStream.setMtomItems(map);
            if (string == null) {
                string = this.encoding;
            }
            xMLStream.readFromStream(new ByteArrayInputStream(byArray), string);
        } else {
            iCobolVar.set(new byte[]{32});
        }
    }

    public void getResponseJSON(ICobolVar iCobolVar) {
        this.getResponseJSON(this.response, iCobolVar, null, null);
    }

    public void getResponseJSON(ICobolVar iCobolVar, String string) {
        this.getResponseJSON(this.response, iCobolVar, string, null);
    }

    public void getResponseJSON(ICobolVar iCobolVar, String string, ICobolVar iCobolVar2) {
        this.getResponseJSON(this.response, iCobolVar, string, iCobolVar2);
    }

    private void getResponseJSON(byte[] byArray, ICobolVar iCobolVar, String string, ICobolVar iCobolVar2) {
        if (byArray != null) {
            JSONStream jSONStream = new JSONStream(iCobolVar, iCobolVar2);
            if (string == null) {
                string = this.encoding;
            }
            jSONStream.readFromStream(new ByteArrayInputStream(byArray), string);
        } else {
            iCobolVar.set(new byte[]{32});
        }
    }

    public void saveResponseRaw(ICobolVar iCobolVar) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(File.get(iCobolVar.toStringNoGui().trim()));
            fileOutputStream.write(this.response, 0, this.response.length);
            fileOutputStream.close();
        }
        catch (IOException iOException) {
            throw new IscobolRuntimeException(iOException);
        }
    }

    public String getMethod() {
        return this.httpConn.getRequestMethod();
    }

    public void doActionEx(String string, ICobolVar iCobolVar, ICobolVar iCobolVar2, ICobolVar iCobolVar3) {
        String string2 = iCobolVar2.toStringNoGui().trim();
        if (iCobolVar3.getIXMLAttributes() == null) {
            this.setHeaderProperty("Content-Type", string2);
            this.connectWithMethod(iCobolVar.toStringNoGui().trim(), string);
            this.sendPostPut(iCobolVar3.toStringNoGui().trim());
        } else {
            XMLStream xMLStream = string2.contains("/json") ? new JSONStream(iCobolVar3) : new XMLStream(iCobolVar3);
            StringBuffer stringBuffer = new StringBuffer();
            xMLStream.writeToStringBuffer(stringBuffer);
            Map<String, ICobolVar> map = xMLStream.getMtomItems();
            if (!(xMLStream instanceof JSONStream) && !map.isEmpty()) {
                HTTPData.Params params = new HTTPData.Params();
                params.list.add(new HTTPData.Pair("myenvelope", stringBuffer.toString(), "<rootpart@veryant.com>", 0));
                for (String string3 : map.keySet()) {
                    HTTPData.MPFile mPFile = new HTTPData.MPFile(string3, string3, null, "<" + string3 + ">", 2);
                    mPFile.contents = map.get(string3).getBytes();
                    params.list.add(mPFile);
                    this.doPostMTOM(iCobolVar.toStringNoGui(), params);
                }
                return;
            }
            this.setHeaderProperty("Content-Type", string2);
            this.connectWithMethod(iCobolVar.toStringNoGui().trim(), string);
            this.sendPostPut(stringBuffer.toString());
            this.lastRequest = this.buildRequestLog(stringBuffer.toString());
        }
        this.doRequest();
    }

    public void doActionEx(String string, ICobolVar iCobolVar, ICobolVar iCobolVar2, ICobolVar iCobolVar3, ICobolVar iCobolVar4) {
        String string2 = iCobolVar2.toStringNoGui().trim();
        if (iCobolVar3.getIXMLAttributes() == null) {
            this.setHeaderProperty("Content-Type", string2);
            this.connectWithMethod(iCobolVar.toStringNoGui().trim(), string);
            this.sendPostPut(iCobolVar3.toStringNoGui().trim());
        } else {
            XMLStream xMLStream = string2.contains("/json") ? new JSONStream(iCobolVar3, iCobolVar4) : new XMLStream(iCobolVar3);
            StringBuffer stringBuffer = new StringBuffer();
            xMLStream.writeToStringBuffer(stringBuffer);
            Map<String, ICobolVar> map = xMLStream.getMtomItems();
            if (!(xMLStream instanceof JSONStream) && !map.isEmpty()) {
                HTTPData.Params params = new HTTPData.Params();
                params.list.add(new HTTPData.Pair("myenvelope", stringBuffer.toString(), "<rootpart@veryant.com>", 0));
                for (String string3 : map.keySet()) {
                    HTTPData.MPFile mPFile = new HTTPData.MPFile(string3, string3, null, "<" + string3 + ">", 2);
                    mPFile.contents = map.get(string3).getBytes();
                    params.list.add(mPFile);
                    this.doPostMTOM(iCobolVar.toStringNoGui(), params);
                }
                return;
            }
            this.setHeaderProperty("Content-Type", string2);
            this.connectWithMethod(iCobolVar.toStringNoGui().trim(), string);
            this.sendPostPut(stringBuffer.toString());
            this.lastRequest = this.buildRequestLog(stringBuffer.toString());
        }
        this.doRequest();
    }

    private static void allowMethods(String ... stringArray) {
        try {
            Field field = HttpURLConnection.class.getDeclaredField("methods");
            Field field2 = Field.class.getDeclaredField("modifiers");
            field2.setAccessible(true);
            field2.setInt(field, field.getModifiers() & 0xFFFFFFEF);
            field.setAccessible(true);
            String[] stringArray2 = (String[])field.get(null);
            LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>(Arrays.asList(stringArray2));
            linkedHashSet.addAll(Arrays.asList(stringArray));
            String[] stringArray3 = linkedHashSet.toArray(new String[0]);
            field.set(null, stringArray3);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setConnectTimeout(Double d2) {
        this.connectTimeout = d2;
    }

    public void setReadTimeout(Double d2) {
        this.readTimeout = d2;
    }

    public Double getConnectTimeout() {
        return this.connectTimeout;
    }

    public Double getReadTimeout() {
        return this.readTimeout;
    }

    public void setProxy(String string, int n2) {
        if (javaVersion < 11 || httpClientHelper == null) {
            this.proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(string, n2));
        } else {
            httpClientHelper.setProxy(string, n2);
        }
    }

    private String buildRequestLog() {
        return this.buildRequestLog(null);
    }

    private String buildRequestLog(String string) {
        String string2 = null;
        try {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(eol);
            stringBuilder.append("URL: " + this.httpConn.getURL());
            stringBuilder.append(eol);
            stringBuilder.append(eol);
            stringBuilder.append("Method: " + this.httpConn.getRequestMethod());
            stringBuilder.append(eol);
            this.appendParameters(stringBuilder);
            this.appendHeaderFields(stringBuilder);
            string2 = this.safeGetResponseCode(this.httpConn);
            if (string2 != null) {
                stringBuilder.append(string2);
            }
            string2 = stringBuilder.toString() + eol + eol + (string != null ? "Content:" + eol + string : "");
            this.logString(this.httpConn, string2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string2;
    }

    private void appendHeaderFields(StringBuilder stringBuilder) {
        try {
            Map<String, List<String>> map = this.httpConn.getHeaderFields();
            if (map.size() > 0) {
                stringBuilder.append("Request Headers:");
            }
            this.generateHeaderEntry(stringBuilder, map);
            map = this.httpConn.getRequestProperties();
            if (map.size() > 0) {
                stringBuilder.append("Request Properties:");
            }
            this.generateHeaderEntry(stringBuilder, map);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void appendParameters(StringBuilder stringBuilder) {
        try {
            if (this.httpConn.getHeaderFields().size() > 0) {
                stringBuilder.append("Header fields:");
                stringBuilder.append(eol);
                Map<String, List<String>> map = this.httpConn.getHeaderFields();
                this.generateHeaderEntry(stringBuilder, map);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void generateHeaderEntry(StringBuilder stringBuilder, Map<String, List<String>> map) {
        try {
            for (String string : map.keySet()) {
                stringBuilder.append(String.format("%s%s", string != null ? string + " = " : "", map.get(string)));
                stringBuilder.append(eol);
            }
            if (map.size() > 0) {
                stringBuilder.append(eol);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void logString(HttpURLConnection httpURLConnection, String string) {
        block5: {
            if (Config.b("iscobol.httpclient.logging", false) && Config.a("iscobol.httpclient.logfile", null) != null) {
                String string2 = Config.a("iscobol.httpclient.logfile", (String)null);
                try {
                    Object object;
                    java.io.File file = new java.io.File(string2);
                    if (!file.exists()) {
                        object = file.getParentFile();
                        if (object != null && !((java.io.File)object).exists() && !((java.io.File)object).mkdirs()) {
                            ((java.io.File)object).mkdirs();
                        }
                        file.createNewFile();
                    }
                    object = new FileWriter(file, true);
                    BufferedWriter bufferedWriter = new BufferedWriter((Writer)object);
                    bufferedWriter.write(string);
                    bufferedWriter.newLine();
                    bufferedWriter.close();
                }
                catch (IOException iOException) {
                    if (this.debugFlg <= 10) break block5;
                    System.out.print(String.format("An error occurred creating HTTPClient logfile '%s'%sMessage: %s%s", string2, eol, iOException.getMessage(), eol));
                }
            }
        }
    }

    private void logError(HttpURLConnection httpURLConnection, Exception exception) {
        this.logString(httpURLConnection, "================>");
        this.logString(httpURLConnection, "An error occurred");
        this.logString(httpURLConnection, String.format("URL: %s", httpURLConnection.getURL().toString()));
        this.logString(httpURLConnection, String.format("Method: %s", httpURLConnection.getRequestMethod()));
        String string = this.safeGetResponseCode(httpURLConnection);
        if (string != null) {
            this.logString(httpURLConnection, string);
        }
        this.logString(httpURLConnection, "Exception class: " + exception.getClass().getName());
        this.logString(httpURLConnection, "Exception message: " + exception.getLocalizedMessage());
        this.logString(httpURLConnection, "<================");
    }

    private String getResponseContentType() {
        if (javaVersion < 11 || this.responseContentType == null) {
            this.responseContentType = this.httpConn.getHeaderField("Content-Type");
        }
        return this.responseContentType;
    }

    private String safeGetResponseCode(HttpURLConnection httpURLConnection) {
        try {
            return String.format("Response code: %d - %s", httpURLConnection.getResponseCode(), httpURLConnection.getResponseMessage());
        }
        catch (Exception exception) {
            return null;
        }
    }

    private boolean isLoggingEnabled() {
        return Config.b("iscobol.httpclient.logging", false);
    }

    private void logRequestContent() {
        if (this.isLoggingEnabled() && this.contentToLog != null) {
            this.logString(this.httpConn, "Request content:");
            this.logString(this.httpConn, new String(this.contentToLog));
        }
    }

    private void logResponseContent(byte[] byArray) {
        if (this.isLoggingEnabled()) {
            try {
                this.logString(this.httpConn, "Response content:");
                this.logString(this.httpConn, new String(byArray));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    static {
        javaVersion = 8;
        String[] stringArray = System.getProperty("java.version").split("\\.");
        javaVersion = Integer.parseInt(stringArray[0]);
        if (javaVersion < 11) {
            httpClientHelper = null;
        } else {
            try {
                Class<?> clazz = Class.forName("com.iscobol.rts.HTTPClientHelper");
                Class<?> clazz2 = Class.forName("com.iscobol.rts.HTTPClientHelper");
                Constructor<?> constructor = clazz2.getConstructor(new Class[0]);
                httpClientHelper = (IHTTPClientHelper)constructor.newInstance(new Object[0]);
            }
            catch (Exception exception) {
                System.out.println(exception.getMessage());
                httpClientHelper = null;
            }
        }
        eol = System.getProperty("line.separator", "\n");
    }

    static interface IHTTPClientHelper {
        public void setConnectionTimeout(int var1);

        public void setAuth(ICobolVar var1, ICobolVar var2);

        public void setParameters(HTTPData.Params var1);

        public void setHeaderProperties(ArrayList var1);

        public void setProxy(String var1, int var2);

        public void doPatchEx(String var1, ICobolVar var2, ICobolVar var3, ICobolVar var4) throws IOException, InterruptedException;

        public int getResponseCode();

        public byte[] getResponse();

        public String getContentType();

        public void test();
    }

    private static class Attachment
    implements Comparator<String> {
        byte[] body;
        Map<String, String> attrs = new TreeMap<String, String>(this);

        private Attachment() {
        }

        @Override
        public int compare(String string, String string2) {
            return string.compareToIgnoreCase(string2);
        }
    }
}

