/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.rts;

import com.iscobol.rts.Config;
import com.iscobol.rts.HTTPClient;
import com.iscobol.rts.HTTPData;
import com.iscobol.rts.ICobolVar;
import com.sun.net.httpserver.Headers;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.net.Authenticator;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.PasswordAuthentication;
import java.net.ProxySelector;
import java.net.URI;
import java.net.URL;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Date;

public class HTTPClientHelper
implements HTTPClient.IHTTPClientHelper {
    private int connectTimeout = Integer.MAX_VALUE;
    private String user;
    private String password;
    private String proxyHost;
    private int proxyPort;
    private HTTPData.Params parameters;
    private int debugFlg = Config.a("iscobol.tracelevel", -1);
    private static final String eol = System.getProperty("line.separator", "\n");
    private ArrayList headerProperties;
    private int responseCode;
    private HttpClient httpConn;
    private HttpRequest request;
    private HttpResponse<String> response;

    @Override
    public void test() {
        System.out.println("HTTPClientHelper.test");
    }

    @Override
    public void setConnectionTimeout(int n2) {
        this.connectTimeout = n2;
    }

    @Override
    public void setAuth(ICobolVar iCobolVar, ICobolVar iCobolVar2) {
        this.user = iCobolVar.toString();
        this.password = iCobolVar2 == null ? null : iCobolVar2.toString();
    }

    @Override
    public void setProxy(String string, int n2) {
        this.proxyHost = string;
        this.proxyPort = n2;
    }

    @Override
    public void setParameters(HTTPData.Params params) {
        this.parameters = params;
    }

    @Override
    public void setHeaderProperties(ArrayList arrayList) {
        this.headerProperties = arrayList;
    }

    private synchronized void setConnection(String object, String string, String string2) throws MalformedURLException, IOException {
        try {
            Object object2;
            Object object3;
            String string3 = ((String)object).toLowerCase();
            this.logString(null, "===============================");
            this.logString(null, "Connection requested at " + new SimpleDateFormat("yyyy-MM-dd - HH:mm:ss.ms").format(new Date()));
            this.logString(null, "Connecting to: " + string3);
            if (string3.startsWith("https://")) {
                object3 = Config.a(".net.ssl.trust_store", null);
                if (object3 != null && ((String)object3).length() > 0 && !"*".equals(object3)) {
                    System.setProperty("javax.net.ssl.trustStore", (String)object3);
                    object3 = Config.a(".net.ssl.trust_store_password", null);
                    if (object3 != null) {
                        System.setProperty("javax.net.ssl.trustStorePassword", (String)object3);
                    }
                }
            } else if (!((String)object).toLowerCase().startsWith("http://")) {
                object = "http://" + (String)object;
            }
            URL uRL = new URL((String)object);
            object3 = this.proxyHost != null ? ProxySelector.of(new InetSocketAddress(this.proxyHost, this.proxyPort)) : ProxySelector.getDefault();
            Headers headers = new Headers();
            if (string != null) {
                headers.add("Content-Type", string);
            }
            if (this.headerProperties != null) {
                int n2 = this.headerProperties.size();
                for (int i2 = 0; i2 < n2; ++i2) {
                    object2 = (HTTPData.Pair)this.headerProperties.get(i2);
                    headers.add(((HTTPData.Pair)object2).key, ((HTTPData.Pair)object2).value);
                }
            }
            HttpRequest.BodyPublisher bodyPublisher = string2 != null ? HttpRequest.BodyPublishers.ofString(string2) : HttpRequest.BodyPublishers.noBody();
            object2 = this.user != null ? new UsernamePasswordAuthenticator(this.user, this.password) : Authenticator.getDefault();
            Duration duration = this.connectTimeout > 0 ? Duration.ofSeconds(this.connectTimeout) : Duration.ofSeconds(60L);
            this.httpConn = HttpClient.newBuilder().version(HttpClient.Version.HTTP_2).followRedirects(HttpClient.Redirect.NORMAL).build();
            try {
                this.request = HttpRequest.newBuilder().uri(URI.create(((String)object).trim())).timeout(duration).header("Content-Type", "application/json").method("PATCH", bodyPublisher).build();
            }
            catch (Exception exception) {
                throw new MalformedURLException(exception.getMessage());
            }
        }
        catch (Exception exception) {
            this.logString(null, "An exception occurred opening connection:");
            this.logString(null, exception.getMessage());
            throw exception;
        }
    }

    @Override
    public void doPatchEx(String string, ICobolVar iCobolVar, ICobolVar iCobolVar2, ICobolVar iCobolVar3) throws IOException, InterruptedException {
        this.setConnection(string, iCobolVar != null ? iCobolVar.toString() : null, iCobolVar2 != null ? iCobolVar2.toString() : null);
        this.response = this.httpConn.send(this.request, HttpResponse.BodyHandlers.ofString());
    }

    @Override
    public int getResponseCode() {
        return this.response.statusCode();
    }

    @Override
    public byte[] getResponse() {
        return this.response.body().getBytes();
    }

    @Override
    public String getContentType() {
        return this.response.headers().firstValue("Content-Type").get();
    }

    private void logString(HttpClient httpClient, String string) {
        block7: {
            if (Config.b("iscobol.httpclient.logging", false) && Config.a("iscobol.httpclient.logfile", null) != null) {
                String string2 = Config.a("iscobol.httpclient.logfile", (String)null);
                try {
                    Object object;
                    File file = new File(string2);
                    if (!file.exists()) {
                        object = file.getParentFile();
                        if (object != null && !((File)object).exists() && !((File)object).mkdirs()) {
                            ((File)object).mkdirs();
                        }
                        try {
                            file.createNewFile();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    object = new FileWriter(file, true);
                    BufferedWriter bufferedWriter = new BufferedWriter((Writer)object);
                    bufferedWriter.write(string);
                    bufferedWriter.newLine();
                    bufferedWriter.close();
                }
                catch (IOException iOException) {
                    if (this.debugFlg <= 10) break block7;
                    System.out.print(String.format("An error occurred creating HTTPClient logfile '%s'%sMessage: %s%s", string2, eol, iOException.getMessage(), eol));
                }
            }
        }
    }

    public static class UsernamePasswordAuthenticator
    extends Authenticator {
        private String username;
        private String password;

        public UsernamePasswordAuthenticator(String string, String string2) {
            this.username = string;
            this.password = string2;
        }

        @Override
        protected PasswordAuthentication getPasswordAuthentication() {
            String string = this.getRequestingPrompt();
            String string2 = this.getRequestingHost();
            InetAddress inetAddress = this.getRequestingSite();
            int n2 = this.getRequestingPort();
            return new PasswordAuthentication(this.username, this.password.toCharArray());
        }
    }
}

