/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.rts;

import com.iscobol.io.PathTokenizer;
import com.iscobol.rts.Base64;
import com.iscobol.rts.Config;
import com.iscobol.rts.File;
import com.iscobol.rts.HTTPData;
import com.iscobol.rts.ICobolVar;
import com.iscobol.rts.INumericVar;
import com.iscobol.rts.IPicNumEdit;
import com.iscobol.rts.IXMLAttributes;
import com.iscobol.rts.IscobolRuntimeException;
import com.iscobol.rts.JSONStream;
import com.iscobol.rts.RtsUtil;
import com.iscobol.rts.XMLStream;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.nio.charset.Charset;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;

public class HTTPHandler {
    public static final int RESPONSE_TYPE_NORMAL = 0;
    public static final int RESPONSE_TYPE_ERROR = 1;
    public static final int RESPONSE_TYPE_REDIRECT = 2;
    private static HashMap outData = new HashMap();
    private final Map _inputData;
    private final Map headerInData;
    private Map headerOutData;
    private StringBuffer outMessage;
    private InputStream outBinaryFile;
    private Reader outTextFile;
    private String outMimeType = "text/plain";
    private int responseType = 0;
    private int error = 0;
    private boolean isSessionInvalid;
    private InputStream inputStream;
    private final Charset charSet;
    private String requestMethod;
    private String contentType;
    private String htmlPrefix;
    private java.io.File[] htmlPrefixArray;
    private Object request;
    private Object response;
    private Object session;

    public static HTTPHandler get() {
        HTTPHandler hTTPHandler = (HTTPHandler)outData.get(Thread.currentThread());
        if (hTTPHandler == null) {
            throw new IscobolRuntimeException(35, "No HTTP connection found");
        }
        return hTTPHandler;
    }

    public static HTTPHandler remove() {
        return (HTTPHandler)outData.remove(Thread.currentThread());
    }

    public HTTPHandler(Map map, InputStream inputStream, Map map2, Charset charset) {
        this._inputData = map;
        this.inputStream = inputStream;
        this.headerInData = map2;
        this.charSet = charset;
        outData.put(Thread.currentThread(), this);
        this.request = null;
        this.response = null;
        this.session = null;
    }

    public HTTPHandler(Map map) {
        this(map, null, null, null);
    }

    private Object inputDataGet(String string) {
        Object v2 = this._inputData.get(string);
        if (v2 == null) {
            for (Map.Entry entry : this._inputData.entrySet()) {
                if (!string.equalsIgnoreCase(entry.getKey().toString())) continue;
                v2 = entry.getValue();
                break;
            }
        }
        return v2;
    }

    public Object getInputParameter(String string) {
        Object object = this.inputDataGet(string);
        if (object instanceof byte[]) {
            return object;
        }
        if (object instanceof String[] && ((String[])object).length > 0) {
            return ((String[])object)[0];
        }
        if (object instanceof String) {
            return (String)object;
        }
        return null;
    }

    public void accept(ICobolVar iCobolVar) {
        this.accept(iCobolVar, null);
    }

    private int set(ICobolVar iCobolVar, String string) {
        if (string == null) {
            iCobolVar.initialize(null, null, false);
            return 0;
        }
        if (iCobolVar instanceof IPicNumEdit) {
            iCobolVar.set(string.getBytes());
        } else {
            iCobolVar.set(string);
        }
        return string.length();
    }

    private void accept(ICobolVar iCobolVar, IXMLAttributes iXMLAttributes) {
        String string = iXMLAttributes != null ? iXMLAttributes.getIdentifier() : null;
        Enumeration enumeration = iCobolVar.getChildren();
        IXMLAttributes iXMLAttributes2 = iCobolVar.getIXMLAttributes();
        boolean bl = Config.b(".http.cgi_clear_missing_values", true);
        if (iXMLAttributes2 != null && !iXMLAttributes2.isCDATA() && iXMLAttributes2.getIdentifier() != null) {
            string = iXMLAttributes2.getIdentifier();
        }
        if (enumeration != null && enumeration.hasMoreElements()) {
            while (enumeration.hasMoreElements()) {
                this.accept((ICobolVar)enumeration.nextElement(), iXMLAttributes2);
            }
        } else {
            String string2 = string != null ? string : iCobolVar.getName().toLowerCase().replace('-', '_');
            Object object = this.inputDataGet(string2);
            if (object != null) {
                if (object instanceof byte[]) {
                    iCobolVar.set((byte[])object);
                } else if (object instanceof String) {
                    this.set(iCobolVar, iXMLAttributes, (String)object);
                } else if (object instanceof String[]) {
                    String[] stringArray = (String[])object;
                    int[] nArray = iCobolVar.getDimensions();
                    if (nArray != null && nArray.length == 1) {
                        int n2;
                        int n3 = Math.min(nArray[0], stringArray.length);
                        for (n2 = 0; n2 < n3; ++n2) {
                            this.set(iCobolVar.intIAt(n2 + 1), iXMLAttributes, stringArray[n2]);
                        }
                        if (bl) {
                            while (n2 < nArray[0]) {
                                this.set(iCobolVar.intIAt(n2 + 1), null);
                                ++n2;
                            }
                        }
                    } else {
                        this.set(iCobolVar, iXMLAttributes, stringArray[0]);
                    }
                }
            } else if (bl) {
                this.set(iCobolVar, null);
            }
        }
    }

    private void set(ICobolVar iCobolVar, IXMLAttributes iXMLAttributes, String string) {
        if (iXMLAttributes != null) {
            if (iXMLAttributes.isBase64Binary()) {
                byte[] byArray = Base64.decode(string.getBytes());
                if (byArray != null) {
                    iCobolVar.set(byArray);
                } else {
                    this.set(iCobolVar, string);
                }
            } else if (iXMLAttributes.isHexBinary()) {
                iCobolVar.set(RtsUtil.hexToBytes(string));
            } else if (iXMLAttributes.isBoolean()) {
                boolean bl = Boolean.parseBoolean(string);
                if (iCobolVar instanceof INumericVar) {
                    iCobolVar.set(bl ? 1 : 0);
                } else {
                    iCobolVar.set(Boolean.toString(bl));
                }
            } else {
                this.set(iCobolVar, string);
            }
        } else {
            this.set(iCobolVar, string);
        }
    }

    public void acceptAllParameters(ICobolVar iCobolVar) {
        String string = System.getProperty("line.separator", "\n");
        StringBuffer stringBuffer = new StringBuffer();
        for (Map.Entry entry : this._inputData.entrySet()) {
            stringBuffer.append(entry.getKey());
            stringBuffer.append('=');
            stringBuffer.append(((String[])entry.getValue())[0]);
            stringBuffer.append(string);
        }
        iCobolVar.set(stringBuffer.toString());
    }

    public String getHeader(String string) {
        String string2;
        if (this.headerInData != null) {
            string2 = (String)this.headerInData.get(string);
            if (string2 == null) {
                string2 = "";
            }
        } else {
            string2 = "";
        }
        return string2;
    }

    public int getIntHeader(String string) {
        String string2 = this.getHeader(string);
        if (string2.length() > 0) {
            try {
                return Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                return -1;
            }
        }
        return -1;
    }

    public void acceptEx(ICobolVar iCobolVar) {
        if (this.contentType.contains("xml") || Config.a(".rest.default_stream", "json").equalsIgnoreCase("xml")) {
            this.acceptFromXML(iCobolVar);
        } else {
            this.acceptFromJSON(iCobolVar);
        }
    }

    public void acceptEx(ICobolVar iCobolVar, ICobolVar iCobolVar2) {
        if (this.contentType.contains("xml") || Config.a(".rest.default_stream", "json").equalsIgnoreCase("xml")) {
            this.acceptFromXML(iCobolVar);
        } else {
            this.acceptFromJSON(iCobolVar, iCobolVar2);
        }
    }

    public void acceptFromXML(ICobolVar iCobolVar) {
        XMLStream xMLStream = new XMLStream(iCobolVar);
        if (this.inputStream == null) {
            throw new IscobolRuntimeException(4, "stream=null");
        }
        xMLStream.readFromStream(this.inputStream);
    }

    public void acceptFromJSON(ICobolVar iCobolVar) {
        JSONStream jSONStream = new JSONStream(iCobolVar, null, this.charSet);
        if (this.inputStream == null) {
            throw new IscobolRuntimeException(4, "stream=null");
        }
        jSONStream.readFromStream(this.inputStream);
    }

    public void acceptFromJSON(ICobolVar iCobolVar, ICobolVar iCobolVar2) {
        JSONStream jSONStream = new JSONStream(iCobolVar, iCobolVar2, this.charSet);
        if (this.inputStream == null) {
            throw new IscobolRuntimeException(4, "stream=null");
        }
        jSONStream.readFromStream(this.inputStream);
    }

    public String getOutputMimeType() {
        return this.outMimeType;
    }

    public String getOutputMessage() {
        String string;
        if (this.outMessage != null) {
            string = this.outMessage.toString();
        } else if (this.outTextFile != null) {
            this.outMessage = new StringBuffer();
            char[] cArray = new char[512];
            try {
                int n2;
                while ((n2 = this.outTextFile.read(cArray)) > 0) {
                    this.outMessage.append(cArray, 0, n2);
                }
                this.outTextFile.close();
                this.outTextFile = null;
            }
            catch (IOException iOException) {
                this.outMessage.append(iOException.toString());
            }
            string = this.outMessage.toString();
        } else {
            string = null;
        }
        this.outMessage = null;
        return string;
    }

    public InputStream getOutputBinaryFile() {
        return this.outBinaryFile;
    }

    public Reader getOutputTextFile() {
        return this.outTextFile;
    }

    public int getResponseType() {
        return this.responseType;
    }

    public int getError() {
        return this.error;
    }

    public void addOutHeader(ICobolVar iCobolVar, ICobolVar iCobolVar2) {
        this.addOutHeader(iCobolVar.toStringNoGui().trim(), iCobolVar2 == null ? null : iCobolVar2.toStringNoGui().trim());
    }

    private void addOutHeader(String string, String string2) {
        if (this.headerOutData == null) {
            this.headerOutData = new HashMap();
        }
        if (string2 == null || string2.length() == 0) {
            this.headerOutData.remove(string);
        } else {
            this.headerOutData.put(string, string2);
        }
    }

    public Map getOutHeader() {
        return this.headerOutData;
    }

    public void displayEx(ICobolVar iCobolVar) {
        this.displayEx(iCobolVar, null, null);
    }

    public void displayEx(ICobolVar iCobolVar, ICobolVar iCobolVar2) {
        this.displayEx(iCobolVar, iCobolVar2, null);
    }

    public void displayEx(ICobolVar iCobolVar, ICobolVar iCobolVar2, ICobolVar iCobolVar3) {
        if (this.contentType.contains("xml") || Config.a(".rest.default_stream", "json").equalsIgnoreCase("xml")) {
            this.displayXML(iCobolVar);
        } else {
            this.displayJSON(iCobolVar, iCobolVar2, iCobolVar3);
        }
    }

    public void displayXML(ICobolVar iCobolVar) {
        this.outMessage = new StringBuffer();
        this.outMimeType = "text/xml";
        this.responseType = 0;
        this.error = 0;
        XMLStream xMLStream = new XMLStream(iCobolVar);
        xMLStream.writeToStringBuffer(this.outMessage);
    }

    public void displayJSON(ICobolVar iCobolVar) {
        this.outMessage = new StringBuffer();
        this.outMimeType = "application/json";
        this.responseType = 0;
        this.error = 0;
        JSONStream jSONStream = new JSONStream(iCobolVar);
        jSONStream.writeToStringBuffer(this.outMessage);
    }

    public void displayJSON(ICobolVar iCobolVar, ICobolVar iCobolVar2) {
        this.outMessage = new StringBuffer();
        this.outMimeType = "application/json";
        this.responseType = 0;
        this.error = 0;
        JSONStream jSONStream = new JSONStream(iCobolVar, iCobolVar2);
        jSONStream.writeToStringBuffer(this.outMessage);
    }

    public void displayJSON(ICobolVar iCobolVar, ICobolVar iCobolVar2, ICobolVar iCobolVar3) {
        this.outMessage = new StringBuffer();
        this.outMimeType = "application/json";
        this.responseType = 0;
        this.error = 0;
        JSONStream jSONStream = new JSONStream(iCobolVar, iCobolVar2, iCobolVar3);
        jSONStream.writeToStringBuffer(this.outMessage);
    }

    public void displayHTML(ICobolVar iCobolVar, ICobolVar iCobolVar2) {
        String string = iCobolVar2 == null ? "" : iCobolVar2.toStringNoGui().trim();
        this.outMessage = new StringBuffer();
        this.outMimeType = "text/html";
        this.responseType = 0;
        this.error = 0;
        XMLStream xMLStream = new XMLStream(iCobolVar);
        xMLStream.writeToStringBuffer(this.outMessage);
        if (string.length() > 0) {
            this.outMessage.insert(0, string);
        }
    }

    private void display(String string) {
        this.responseType = 0;
        this.error = 0;
        if (this.outMessage == null) {
            this.outMessage = new StringBuffer(string);
        } else {
            this.outMessage.append(string);
        }
    }

    public void displayText(ICobolVar iCobolVar) {
        this.outMimeType = "text/plain";
        this.display(iCobolVar.toStringNoGui().trim());
    }

    public void displayText(ICobolVar iCobolVar, ICobolVar iCobolVar2) {
        this.outMimeType = iCobolVar2.toStringNoGui();
        this.display(iCobolVar.toStringNoGui().trim());
    }

    public void displayBinaryFile(ICobolVar iCobolVar, ICobolVar iCobolVar2) {
        this.outMimeType = iCobolVar2.toStringNoGui();
        this.outMessage = null;
        try {
            this.outBinaryFile = new FileInputStream(iCobolVar.toStringNoGui().trim());
            this.responseType = 0;
            this.error = 0;
        }
        catch (IOException iOException) {
            StringWriter stringWriter = new StringWriter();
            iOException.printStackTrace(new PrintWriter(stringWriter));
            this.responseType = 1;
            this.error = 404;
            this.outMessage = stringWriter.getBuffer();
            this.outBinaryFile = null;
        }
    }

    private void _displayTextFile(String string, String string2) {
        this.outMimeType = string2;
        this.outMessage = null;
        try {
            this.outTextFile = new FileReader(string.trim());
            this.responseType = 0;
            this.error = 0;
        }
        catch (IOException iOException) {
            StringWriter stringWriter = new StringWriter();
            iOException.printStackTrace(new PrintWriter(stringWriter));
            this.responseType = 1;
            this.error = 404;
            this.outMessage = stringWriter.getBuffer();
            this.outBinaryFile = null;
        }
    }

    public void displayTextFile(ICobolVar iCobolVar, ICobolVar iCobolVar2) {
        this._displayTextFile(iCobolVar.toStringNoGui().trim(), iCobolVar2.toStringNoGui().trim());
    }

    public void displayTextFile(ICobolVar iCobolVar) {
        this._displayTextFile(iCobolVar.toStringNoGui().trim(), "text/plain");
    }

    public void displayError(int n2, ICobolVar iCobolVar) {
        this.displayError(n2, iCobolVar.toStringNoGui().trim());
    }

    public void displayError(int n2, String string) {
        this.responseType = 1;
        this.error = n2;
        this.outMessage = string != null ? new StringBuffer(string) : new StringBuffer("(null)");
    }

    public void redirect(ICobolVar iCobolVar) {
        this.redirect(iCobolVar, null);
    }

    public void redirect(ICobolVar iCobolVar, HTTPData.Params params) {
        this.responseType = 2;
        this.error = 0;
        String string = iCobolVar.toStringNoGui().trim();
        this.outMessage = new StringBuffer(string);
        if (params != null) {
            this.outMessage.append(string.indexOf(63) >= 0 ? "&" : "?");
            params.getUrlencodedParameters(this.outMessage);
        }
    }

    public boolean isRedirect() {
        return this.responseType == 2;
    }

    public void invalidateSession() {
        this.isSessionInvalid = true;
    }

    public boolean isSessionInvalidated() {
        return this.isSessionInvalid;
    }

    private void getVarValue(ICobolVar iCobolVar, StringBuffer stringBuffer) {
        StringBuffer stringBuffer2 = new StringBuffer();
        this.getVarValueRec(iCobolVar, stringBuffer2);
        stringBuffer.append(stringBuffer2.toString().trim());
    }

    private void getVarValueRec(ICobolVar iCobolVar, StringBuffer stringBuffer) {
        Enumeration enumeration = iCobolVar.getChildren();
        if (enumeration != null && enumeration.hasMoreElements()) {
            while (enumeration.hasMoreElements()) {
                this.getVarValueRec((ICobolVar)enumeration.nextElement(), stringBuffer);
            }
        } else {
            stringBuffer.append(iCobolVar.toStringNoGui());
        }
    }

    private void doHtmlProcess(Reader reader, Map map) throws IOException {
        if (Config.b(".http.value_prefix_colon", false)) {
            this.doHtmlProcessColon(reader, map);
        } else {
            this.doHtmlProcessPercent(reader, map);
        }
    }

    private void doHtmlProcessPercent(Reader reader, Map map) throws IOException {
        int n2;
        while ((n2 = reader.read()) >= 0) {
            if (n2 == 37) {
                n2 = reader.read();
                if (n2 == 37) {
                    StringBuffer stringBuffer = new StringBuffer();
                    while ((n2 = reader.read()) >= 0 && n2 != 37) {
                        stringBuffer.append((char)n2);
                    }
                    if (n2 == 37) {
                        n2 = reader.read();
                        if (n2 == 37) {
                            ICobolVar iCobolVar = (ICobolVar)map.get(stringBuffer.toString().toUpperCase());
                            if (iCobolVar == null) continue;
                            this.getVarValue(iCobolVar, this.outMessage);
                            continue;
                        }
                        this.outMessage.append('%');
                        this.outMessage.append('%');
                        this.outMessage.append(stringBuffer);
                        this.outMessage.append('%');
                        this.outMessage.append((char)n2);
                        continue;
                    }
                    this.outMessage.append('%');
                    this.outMessage.append('%');
                    this.outMessage.append(stringBuffer);
                    continue;
                }
                this.outMessage.append('%');
                this.outMessage.append((char)n2);
                continue;
            }
            this.outMessage.append((char)n2);
        }
    }

    private static boolean isCobolIdentifier(int n2) {
        return Character.isJavaIdentifierPart((char)n2) || n2 == 45;
    }

    private void doHtmlProcessColon(Reader reader, Map map) throws IOException {
        int n2;
        while ((n2 = reader.read()) >= 0) {
            if (n2 == 58) {
                n2 = reader.read();
                if (HTTPHandler.isCobolIdentifier(n2)) {
                    StringBuffer stringBuffer = new StringBuffer();
                    stringBuffer.append((char)n2);
                    while (HTTPHandler.isCobolIdentifier(n2 = reader.read())) {
                        stringBuffer.append((char)n2);
                    }
                    ICobolVar iCobolVar = (ICobolVar)map.get(stringBuffer.toString().toUpperCase());
                    if (iCobolVar != null) {
                        this.getVarValue(iCobolVar, this.outMessage);
                    } else {
                        this.outMessage.append(':');
                        this.outMessage.append(stringBuffer);
                    }
                } else {
                    this.outMessage.append(':');
                }
                if (n2 < 0) continue;
                this.outMessage.append((char)n2);
                continue;
            }
            this.outMessage.append((char)n2);
        }
    }

    private void addVar(ICobolVar iCobolVar, Map map) {
        Enumeration enumeration;
        IXMLAttributes iXMLAttributes = iCobolVar.getIXMLAttributes();
        if (iXMLAttributes != null) {
            String string;
            if (!iXMLAttributes.isCDATA() && (string = iXMLAttributes.getIdentifier()) != null) {
                map.put(string.toUpperCase(), iCobolVar);
            }
        } else {
            map.put(iCobolVar.getName().toUpperCase(), iCobolVar);
        }
        if ((enumeration = iCobolVar.getChildren()) != null) {
            while (enumeration.hasMoreElements()) {
                this.addVar((ICobolVar)enumeration.nextElement(), map);
            }
        }
    }

    private java.io.File getTemplate(String string) {
        int n2;
        Object object;
        String string2 = Config.a(".http.html_template_prefix", "");
        if (!string2.equals(this.htmlPrefix)) {
            this.htmlPrefix = string2;
            if (this.htmlPrefix.length() > 0) {
                object = new PathTokenizer(this.htmlPrefix);
                n2 = ((PathTokenizer)object).countTokens();
                if (n2 > 0) {
                    this.htmlPrefixArray = new java.io.File[n2];
                    for (int i2 = 0; i2 < n2; ++i2) {
                        this.htmlPrefixArray[i2] = File.get(((PathTokenizer)object).nextToken());
                    }
                } else {
                    this.htmlPrefixArray = new java.io.File[]{File.get("")};
                }
            } else {
                this.htmlPrefixArray = new java.io.File[]{File.get("")};
            }
        }
        for (n2 = 0; n2 < this.htmlPrefixArray.length; ++n2) {
            if (!string.endsWith(".htm") && !string.endsWith(".html")) {
                object = new java.io.File(this.htmlPrefixArray[n2], string + ".html");
                if (((java.io.File)object).exists()) {
                    return object;
                }
                object = new java.io.File(this.htmlPrefixArray[n2], string + ".htm");
                if (((java.io.File)object).exists()) {
                    return object;
                }
            }
            if (!((java.io.File)(object = new java.io.File(this.htmlPrefixArray[n2], string))).exists()) continue;
            return object;
        }
        return null;
    }

    public boolean processHtmlString(ICobolVar iCobolVar, ICobolVar iCobolVar2) {
        Enumeration enumeration;
        StringReader stringReader = new StringReader(iCobolVar.toStringNoGui());
        if (Config.b(".http.cgi_no_cache", true)) {
            this.addOutHeader("Pragma", "no-cache");
        }
        this.outMimeType = Config.a(".http.cgi_content_type", "text/html");
        IXMLAttributes iXMLAttributes = iCobolVar2 != null ? iCobolVar2.getIXMLAttributes() : null;
        if (this.outMessage == null) {
            this.outMessage = new StringBuffer();
        }
        HashMap hashMap = new HashMap();
        if (iXMLAttributes != null && !iXMLAttributes.isCDATA() && (enumeration = iCobolVar2.getChildren()) != null && enumeration.hasMoreElements()) {
            while (enumeration.hasMoreElements()) {
                this.addVar((ICobolVar)enumeration.nextElement(), hashMap);
            }
        }
        try {
            this.doHtmlProcess(stringReader, hashMap);
            ((Reader)stringReader).close();
            return true;
        }
        catch (IOException iOException) {
            this.handleIOException(iOException);
            return false;
        }
    }

    public boolean processHtmlFile(ICobolVar iCobolVar) {
        String string;
        IXMLAttributes iXMLAttributes = iCobolVar.getIXMLAttributes();
        if (Config.b(".http.cgi_no_cache", true)) {
            this.addOutHeader("Pragma", "no-cache");
        }
        this.outMimeType = Config.a(".http.cgi_content_type", "text/html");
        if (this.outMessage == null) {
            this.outMessage = new StringBuffer();
        }
        if (iXMLAttributes != null && !iXMLAttributes.isCDATA() && (string = iXMLAttributes.getIdentifier()) != null) {
            Reader reader = this.getPage(string);
            if (reader != null) {
                HashMap hashMap = new HashMap();
                Enumeration enumeration = iCobolVar.getChildren();
                if (enumeration != null && enumeration.hasMoreElements()) {
                    while (enumeration.hasMoreElements()) {
                        this.addVar((ICobolVar)enumeration.nextElement(), hashMap);
                    }
                }
                try {
                    this.doHtmlProcess(reader, hashMap);
                    reader.close();
                    return true;
                }
                catch (IOException iOException) {
                    this.handleIOException(iOException);
                }
            }
        } else {
            string = iCobolVar.toStringNoGui().trim();
            Reader reader = this.getPage(string);
            if (reader != null) {
                char[] cArray = new char[8192];
                try {
                    int n2;
                    while ((n2 = reader.read(cArray)) > 0) {
                        this.outMessage.append(cArray, 0, n2);
                    }
                    reader.close();
                    return true;
                }
                catch (IOException iOException) {
                    this.handleIOException(iOException);
                }
            }
        }
        return false;
    }

    private Reader getPage(String string) {
        java.io.File file = this.getTemplate(string);
        if (file != null) {
            try {
                return new FileReader(file);
            }
            catch (IOException iOException) {
                this.handleIOException(iOException);
                return null;
            }
        }
        this.outMessage.append("File ");
        this.outMessage.append(string);
        this.outMessage.append(" doesn't exist.");
        this.outMessage.append("\nhttp.html_template_prefix=" + this.htmlPrefix);
        this.outMessage.append("\n");
        return null;
    }

    private void handleIOException(IOException iOException) {
        this.outMessage.append(iOException.toString());
        this.outMessage.append("\nhttp.html_template_prefix=" + this.htmlPrefix);
        this.outMessage.append("\n");
    }

    public String getMethod() {
        return this.requestMethod;
    }

    public void setMethod(String string) {
        this.requestMethod = string;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String string) {
        this.contentType = string != null ? string.toLowerCase() : "";
    }

    public static int cgiGet(ICobolVar iCobolVar, ICobolVar iCobolVar2, ICobolVar iCobolVar3) {
        int n2;
        int n3;
        HTTPHandler hTTPHandler = HTTPHandler.get();
        Object object = hTTPHandler.inputDataGet(iCobolVar.toStringNoGui().trim());
        int n4 = n3 = iCobolVar3 == null ? 0 : iCobolVar3.toint();
        if (object instanceof byte[]) {
            if (n3 <= 1) {
                iCobolVar2.set((byte[])object);
                n2 = ((byte[])object).length;
            } else {
                n2 = hTTPHandler.set(iCobolVar2, "");
            }
        } else if (object instanceof String[]) {
            String[] stringArray = (String[])object;
            n2 = n3 <= 1 ? hTTPHandler.set(iCobolVar2, stringArray[0]) : (--n3 < stringArray.length ? hTTPHandler.set(iCobolVar2, stringArray[n3]) : hTTPHandler.set(iCobolVar2, ""));
        } else {
            n2 = object != null ? (n3 <= 1 ? hTTPHandler.set(iCobolVar2, object.toString()) : hTTPHandler.set(iCobolVar2, "")) : -1;
        }
        return n2;
    }

    public static void cgiAccept(ICobolVar iCobolVar) {
        HTTPHandler hTTPHandler = HTTPHandler.get();
        hTTPHandler.accept(iCobolVar);
    }

    public static void cgiDisplay(ICobolVar iCobolVar) {
        HTTPHandler hTTPHandler = HTTPHandler.get();
        IXMLAttributes iXMLAttributes = iCobolVar.getIXMLAttributes();
        if (iXMLAttributes != null && !iXMLAttributes.isCDATA() && iXMLAttributes.getIdentifier() != null) {
            hTTPHandler.processHtmlFile(iCobolVar);
        } else {
            hTTPHandler.processHtmlString(iCobolVar, null);
        }
    }

    public static void cgiDisplay(String string) {
        HTTPHandler hTTPHandler = HTTPHandler.get();
        if (Config.b(".http.cgi_no_cache", true)) {
            hTTPHandler.addOutHeader("Pragma", "no-cache");
        }
        hTTPHandler.outMimeType = Config.a(".http.cgi_content_type", "text/html");
        hTTPHandler.display(string);
    }

    public void setRequest(Object object) {
        this.request = object;
    }

    public Object getRequest() {
        return this.request;
    }

    public void setResponse(Object object) {
        this.response = object;
    }

    public Object getResponse() {
        return this.response;
    }

    public void setSession(Object object) {
        this.session = object;
    }

    public Object getSession() {
        return this.session;
    }
}

