/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.rts;

import com.iscobol.rts.Factory;
import com.iscobol.rts.ICobolVar;
import com.iscobol.rts.INumericVar;
import com.iscobol.rts.IPicNumEdit;
import com.iscobol.rts.IXMLAttributes;
import com.iscobol.rts.IscobolRuntimeException;
import com.iscobol.rts.JSONException;
import com.iscobol.rts.SAJParser;
import com.iscobol.types.CobolNum;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Enumeration;
import java.util.IdentityHashMap;
import java.util.Stack;
import java.util.Vector;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class JSONParseGenerate
extends DefaultHandler {
    private Stack<Node> varStack;
    private Node last;
    private IdentityHashMap<ICobolVar, String> names = new IdentityHashMap();
    private IdentityHashMap<ICobolVar, ICobolVar> suppressedVars = new IdentityHashMap();
    private int suppressed;
    private PrintWriter out;

    public JSONParseGenerate name(ICobolVar iCobolVar, ICobolVar iCobolVar2) {
        this.names.put(iCobolVar, iCobolVar2.toStringNoGui());
        return this;
    }

    public JSONParseGenerate suppress(ICobolVar iCobolVar) {
        this.suppressedVars.put(iCobolVar, iCobolVar);
        return this;
    }

    public void generate(ICobolVar iCobolVar, ICobolVar iCobolVar2) throws JSONException {
        this.generate(iCobolVar, iCobolVar2, null);
    }

    public void generate(ICobolVar iCobolVar, ICobolVar iCobolVar2, ICobolVar iCobolVar3) throws JSONException {
        try {
            this._generate(iCobolVar, iCobolVar2, iCobolVar3);
        }
        catch (Exception exception) {
            throw new JSONException(exception);
        }
    }

    private void _generate(ICobolVar iCobolVar, ICobolVar iCobolVar2, ICobolVar iCobolVar3) {
        StringWriter stringWriter = new StringWriter();
        this.out = new PrintWriter(stringWriter);
        this.out.print('{');
        this.writeObject(iCobolVar2, null);
        this.out.print('}');
        if (this.out != null) {
            this.out.close();
        }
        this.out = null;
        String string = stringWriter.toString();
        iCobolVar.set(string);
        if (iCobolVar3 != null) {
            iCobolVar3.set(string.length());
        }
    }

    private void writeObject(ICobolVar iCobolVar, int[] nArray) {
        if (this.suppressedVars.containsKey(iCobolVar)) {
            return;
        }
        String string = this.getAlias(iCobolVar);
        this.out.print('\"');
        this.out.print(string);
        this.out.print('\"');
        this.out.print(':');
        this.possibleArray(iCobolVar, nArray);
    }

    private void possibleArray(ICobolVar iCobolVar, int[] nArray) {
        int[] nArray2 = iCobolVar.getDimensions();
        if (nArray == null) {
            if (nArray2 == null) {
                if (JSONParseGenerate.hasChildren(iCobolVar)) {
                    this.out.print('{');
                    this.writeChildren(iCobolVar, nArray);
                    this.out.print('}');
                } else {
                    this.writeValue(iCobolVar);
                }
            } else {
                nArray = new int[1];
                this.writeArray(iCobolVar, 0, nArray2[0], nArray);
            }
        } else if (nArray.length == nArray2.length) {
            if (JSONParseGenerate.hasChildren(iCobolVar)) {
                this.out.print('{');
                this.writeChildren(iCobolVar, nArray);
                this.out.print('}');
            } else {
                this.writeValue(this.getVar(iCobolVar, nArray));
            }
        } else {
            int n2;
            int[] nArray3 = new int[nArray2.length];
            for (n2 = 0; n2 < nArray.length; ++n2) {
                nArray3[n2] = nArray[n2];
            }
            nArray = nArray3;
            n2 = nArray2[nArray2.length - 1];
            this.writeArray(iCobolVar, nArray2.length - 1, n2, nArray);
        }
    }

    private ICobolVar getNextElement(Enumeration enumeration, int[] nArray) {
        while (enumeration.hasMoreElements()) {
            ICobolVar iCobolVar = (ICobolVar)enumeration.nextElement();
            if (this.suppressedVars.containsKey(iCobolVar)) continue;
            return iCobolVar;
        }
        return null;
    }

    private void writeArray(ICobolVar iCobolVar, int n2, int n3, int[] nArray) {
        this.out.print('[');
        if (n3 > 0) {
            boolean bl = JSONParseGenerate.hasChildren(iCobolVar);
            boolean bl2 = false;
            int n4 = 1;
            while (true) {
                nArray[n2] = ++n4;
                if (bl) {
                    if (bl2) {
                        this.out.print(',');
                    } else {
                        bl2 = true;
                    }
                    this.out.print('{');
                    this.writeChildren(iCobolVar, nArray);
                    this.out.print('}');
                } else {
                    if (bl2) {
                        this.out.print(',');
                    } else {
                        bl2 = true;
                    }
                    this.writeValue(this.getVar(iCobolVar, nArray));
                }
                if (n4 == n3) break;
            }
            nArray[n2] = n4;
        }
        this.out.print(']');
    }

    private void writeChildren(ICobolVar iCobolVar, int[] nArray) {
        ICobolVar iCobolVar2;
        Enumeration enumeration = iCobolVar.getChildren();
        if (enumeration != null && (iCobolVar2 = this.getNextElement(enumeration, nArray)) != null) {
            while (true) {
                this.writeIdentified(iCobolVar2, nArray);
                iCobolVar2 = this.getNextElement(enumeration, nArray);
                if (iCobolVar2 == null) break;
                this.out.print(',');
            }
        }
    }

    private void writeValue(ICobolVar iCobolVar) {
        String string = iCobolVar.toStringNoGui();
        if (iCobolVar instanceof INumericVar) {
            this.out.print(string);
        } else {
            string = Factory.rightTrim(string);
            string = JSONParseGenerate.JSEscape(string);
            this.out.print("\"" + string + "\"");
        }
    }

    private static String JSEscape(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = string.length();
        block10: for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = string.charAt(i2);
            switch (c2) {
                case '\u0000': {
                    stringBuffer.append("\\O");
                    continue block10;
                }
                case '\b': {
                    stringBuffer.append("\\b");
                    continue block10;
                }
                case '\f': {
                    stringBuffer.append("\\f");
                    continue block10;
                }
                case '\n': {
                    stringBuffer.append("\\n");
                    continue block10;
                }
                case '\r': {
                    stringBuffer.append("\\r");
                    continue block10;
                }
                case '\t': {
                    stringBuffer.append("\\t");
                    continue block10;
                }
                case '\"': {
                    stringBuffer.append("\\\"");
                    continue block10;
                }
                case '\\': {
                    stringBuffer.append("\\\\");
                    continue block10;
                }
                default: {
                    stringBuffer.append(c2);
                }
            }
        }
        return stringBuffer.toString();
    }

    private void writeIdentified(ICobolVar iCobolVar, int[] nArray) {
        if (JSONParseGenerate.hasChildren(iCobolVar)) {
            this.writeObject(iCobolVar, nArray);
        } else {
            if (this.suppressedVars.containsKey(iCobolVar)) {
                return;
            }
            String string = this.getAlias(iCobolVar);
            this.out.print('\"');
            this.out.print(string);
            this.out.print('\"');
            this.out.print(':');
            this.possibleArray(iCobolVar, nArray);
        }
    }

    private static boolean hasChildren(ICobolVar iCobolVar) {
        Enumeration enumeration = iCobolVar.getChildren();
        return enumeration.hasMoreElements();
    }

    public void parse(ICobolVar iCobolVar, ICobolVar iCobolVar2) throws JSONException {
        try {
            this._parse(iCobolVar, iCobolVar2);
        }
        catch (Exception exception) {
            throw new JSONException(exception);
        }
    }

    private void _parse(ICobolVar iCobolVar, ICobolVar iCobolVar2) {
        this.varStack = new Stack();
        this.pushNode(iCobolVar2, null);
        try {
            SAJParser sAJParser = new SAJParser(false);
            sAJParser.parse(new StringReader(iCobolVar.toStringNoGui()), this, null);
        }
        catch (IOException iOException) {
            throw new IscobolRuntimeException(iOException);
        }
        catch (SAXException sAXException) {
            if (sAXException.getException() != null) {
                throw new IscobolRuntimeException(sAXException.getException());
            }
            throw new IscobolRuntimeException(sAXException);
        }
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        block7: {
            Node node;
            block6: {
                if (this.suppressed > 0) {
                    ++this.suppressed;
                    return;
                }
                if (this.varStack.isEmpty()) {
                    throw new SAXException("Empty stack on start element " + string3);
                }
                node = this.varStack.peek();
                if (this.suppressedVars.containsKey(node.var)) {
                    ++this.suppressed;
                    return;
                }
                if (this.last == null || !this.tagcmp(string2, this.last)) break block6;
                this.varStack.push(this.last);
                ICobolVar iCobolVar = this.last.var.getIParent();
                if (iCobolVar == null || this.last.var.getDimensions() == iCobolVar.getDimensions()) break block7;
                this.last.clearData();
                int n2 = this.last.dim.length - 1;
                this.last.dim[n2] = this.last.dim[n2] + 1;
                this.last.sted = false;
                this.last = null;
                this.startElement(string, string2, string3, attributes);
                break block7;
            }
            if (!node.sted && this.tagcmp(string2, node)) {
                node.sted = true;
            } else {
                for (int i2 = node.next.size() - 1; i2 >= 0; --i2) {
                    ICobolVar iCobolVar = node.next.elementAt(i2);
                    if (!this.tagcmp(string2, iCobolVar)) continue;
                    this.pushChildNode(string2, node, iCobolVar);
                    break;
                }
            }
        }
        this.last = null;
    }

    protected void pushNode(ICobolVar iCobolVar, int[] nArray) {
        Enumeration enumeration = iCobolVar.getChildren();
        int[] nArray2 = iCobolVar.getDimensions();
        if (nArray2 != null) {
            if (nArray == null) {
                nArray = new int[]{1};
            } else if (nArray.length != nArray2.length) {
                for (int i2 = 0; i2 < nArray.length; ++i2) {
                    nArray2[i2] = nArray[i2];
                }
                nArray2[nArray.length] = 1;
                nArray = nArray2;
            }
        }
        Node node = new Node(iCobolVar, nArray);
        if (enumeration.hasMoreElements()) {
            enumeration = iCobolVar.getChildren();
            while (enumeration.hasMoreElements()) {
                ICobolVar iCobolVar2 = (ICobolVar)enumeration.nextElement();
                node.next.addElement(iCobolVar2);
            }
        } else if (node.data == null) {
            node.data = iCobolVar;
        }
        this.varStack.push(node);
    }

    private void pushChildNode(String string, Node node, ICobolVar iCobolVar) throws SAXException {
        this.pushNode(iCobolVar, node.dim);
        this.startElement(null, string, string, null);
    }

    @Override
    public void characters(char[] cArray, int n2, int n3) throws SAXException {
        if (this.suppressed > 0) {
            return;
        }
        if (this.varStack.isEmpty()) {
            throw new SAXException("Empty stack on characters, last=" + this.last);
        }
        Node node = this.varStack.peek();
        node.cdata.append(cArray, n2, n3);
    }

    private boolean isOccurs(ICobolVar iCobolVar) {
        int[] nArray = iCobolVar.getDimensions();
        if (nArray != null) {
            ICobolVar iCobolVar2 = iCobolVar.getIParent();
            int[] nArray2 = iCobolVar2 != null ? iCobolVar2.getDimensions() : null;
            if (nArray2 != null) {
                return nArray2.length < nArray.length;
            }
            return true;
        }
        return false;
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
        if (this.suppressed > 0) {
            --this.suppressed;
            return;
        }
        if (this.varStack.isEmpty()) {
            throw new SAXException("Empty stack on end element " + string3);
        }
        Node node = this.varStack.pop();
        if (this.isOccurs(node.var)) {
            this.last = node;
        }
        if (node.data != null) {
            this.set(node.data, node.dim, node.cdata.toString());
        }
    }

    private boolean tagcmp(String string, Node node) {
        return this.tagcmp(string, node.var);
    }

    private boolean tagcmp(String string, ICobolVar iCobolVar) {
        return string.equalsIgnoreCase(this.getAlias(iCobolVar));
    }

    private String getAlias(ICobolVar iCobolVar) {
        String string = this.names.get(iCobolVar);
        if (string != null) {
            return string;
        }
        IXMLAttributes iXMLAttributes = iCobolVar.getIXMLAttributes();
        if (iXMLAttributes != null && iXMLAttributes.getIdentifier() != null) {
            return iXMLAttributes.getIdentifier();
        }
        return iCobolVar.getName();
    }

    private void set(ICobolVar iCobolVar, int[] nArray, String string) {
        ICobolVar iCobolVar2 = this.getVar(iCobolVar, nArray);
        if (iCobolVar2 == null) {
            return;
        }
        if (iCobolVar2 instanceof IPicNumEdit) {
            boolean[] blArray = new boolean[1];
            iCobolVar2.set(CobolNum.valueOf(string, iCobolVar2.isDecimalPointComma(), blArray));
            if (blArray[0]) {
                iCobolVar2.set(string);
            }
        } else {
            iCobolVar2.set(string);
        }
    }

    private ICobolVar getVar(ICobolVar iCobolVar, int[] nArray) {
        ICobolVar iCobolVar2;
        block4: {
            iCobolVar2 = null;
            if (nArray == null) {
                iCobolVar2 = iCobolVar;
            } else {
                try {
                    iCobolVar2 = iCobolVar.intIAt(nArray);
                }
                catch (IscobolRuntimeException iscobolRuntimeException) {
                    if (iscobolRuntimeException.getErrNum() == 1) break block4;
                    throw iscobolRuntimeException;
                }
            }
        }
        return iCobolVar2;
    }

    private static class Node {
        StringBuffer cdata = new StringBuffer();
        final ICobolVar var;
        final int[] dim;
        final Vector<ICobolVar> next = new Vector();
        ICobolVar data;
        boolean sted;

        Node(ICobolVar iCobolVar, int[] nArray) {
            this.var = iCobolVar;
            this.dim = nArray;
        }

        void clearData() {
            this.cdata = new StringBuffer();
        }
    }
}

