/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.rts;

import com.iscobol.rts.Base64;
import com.iscobol.rts.Config;
import com.iscobol.rts.Factory;
import com.iscobol.rts.ICobolVar;
import com.iscobol.rts.INumericVar;
import com.iscobol.rts.IXMLAttributes;
import com.iscobol.rts.IscobolRuntimeException;
import com.iscobol.rts.RtsUtil;
import com.iscobol.rts.SAJParser;
import com.iscobol.rts.XMLStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.Enumeration;
import java.util.Stack;
import org.xml.sax.SAXException;

public class JSONStream
extends XMLStream {
    private static final int PLAIN = 0;
    private static final int BOOLEAN = 1;
    private static final int BASE64 = 2;
    private static final int HEX = 3;
    private static final int RAW = 4;
    private static final int NULLABLE = 16;
    private final String rootName;
    private int indentNumber = -1;
    private final Charset charSet;
    private boolean escapeAnyCharacter;

    public JSONStream(ICobolVar iCobolVar, ICobolVar iCobolVar2, Charset charset) {
        super(iCobolVar);
        String string = iCobolVar2 != null ? iCobolVar2.toStringNoGui() : "";
        this.charSet = charset;
        if (Config.c(string)) {
            IXMLAttributes iXMLAttributes = iCobolVar.getIXMLAttributes();
            this.rootName = iXMLAttributes.getIdentifier();
        } else {
            this.rootName = null;
        }
    }

    public JSONStream(ICobolVar iCobolVar, ICobolVar iCobolVar2, ICobolVar iCobolVar3) {
        this(iCobolVar, iCobolVar2, iCobolVar3 != null ? Charset.forName(iCobolVar3.toStringNoGui().trim()) : null);
    }

    public JSONStream(ICobolVar iCobolVar, ICobolVar iCobolVar2) {
        this(iCobolVar, iCobolVar2, (Charset)null);
    }

    public JSONStream(ICobolVar iCobolVar) {
        this(iCobolVar, null);
    }

    private void eol(PrintWriter printWriter) {
        if (this.indentNumber >= 0) {
            printWriter.println("");
        }
    }

    private void spaces(PrintWriter printWriter, int n2) {
        if (this.indentNumber > 0) {
            for (int i2 = 0; i2 < n2; ++i2) {
                printWriter.print(' ');
            }
        }
    }

    private boolean dummyRoot() {
        return this.rootName != null;
    }

    @Override
    protected int read(InputStream inputStream) {
        return this.read(new InputStreamReader(inputStream));
    }

    @Override
    protected int read(Reader reader) {
        ICobolVar iCobolVar;
        this.readConfiguration();
        this.varStack = new Stack();
        if (this.initializeOnRead) {
            this.xmlVar.initialize(null, null, true);
        }
        if ((iCobolVar = this.arrayOnly()) != null) {
            this.pushNode(iCobolVar.getIParent(), null, null);
            this.pushNode(iCobolVar, null, null);
        } else {
            this.pushNode(this.xmlVar, null, null);
        }
        try {
            SAJParser sAJParser = new SAJParser(this.escapeAnyCharacter);
            sAJParser.parse(reader, this, this.rootName);
        }
        catch (IOException iOException) {
            throw new IscobolRuntimeException(iOException);
        }
        catch (SAXException sAXException) {
            if (sAXException.getException() != null) {
                throw new IscobolRuntimeException(sAXException.getException());
            }
            throw new IscobolRuntimeException(sAXException);
        }
        return 1;
    }

    protected void createTransformerHandler() {
    }

    @Override
    public void setPrintWriter(PrintWriter printWriter) {
        this.out = printWriter;
    }

    @Override
    public void setFileName(String string, String string2) {
        if (string != null) {
            try {
                Charset charset = string2 != null ? Charset.forName(string2) : this.charSet;
                if (charset != null) {
                    this.out = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(string.trim()), charset));
                }
                this.out = new PrintWriter(new FileWriter(string.trim()));
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new IscobolRuntimeException(130, fileNotFoundException.getMessage());
            }
            catch (IOException iOException) {
                throw new IscobolRuntimeException(133, iOException.getMessage());
            }
        } else {
            this.out = new PrintWriter(System.out);
        }
        this.createTransformerHandler();
    }

    private String JSEscape(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = string.length();
        block10: for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = string.charAt(i2);
            switch (c2) {
                case '\u0000': {
                    stringBuffer.append("\\O");
                    continue block10;
                }
                case '\b': {
                    stringBuffer.append("\\b");
                    continue block10;
                }
                case '\f': {
                    stringBuffer.append("\\f");
                    continue block10;
                }
                case '\n': {
                    stringBuffer.append("\\n");
                    continue block10;
                }
                case '\r': {
                    stringBuffer.append("\\r");
                    continue block10;
                }
                case '\t': {
                    stringBuffer.append("\\t");
                    continue block10;
                }
                case '\"': {
                    stringBuffer.append("\\\"");
                    continue block10;
                }
                case '\\': {
                    stringBuffer.append("\\\\");
                    continue block10;
                }
                default: {
                    stringBuffer.append(c2);
                }
            }
        }
        return stringBuffer.toString();
    }

    private ICobolVar arrayOnly() {
        ICobolVar iCobolVar = null;
        IXMLAttributes iXMLAttributes = this.xmlVar.getIXMLAttributes();
        if (iXMLAttributes == null || iXMLAttributes.getIdentifier().length() == 0) {
            Enumeration enumeration = this.xmlVar.getChildren();
            int n2 = 0;
            while (enumeration.hasMoreElements()) {
                iCobolVar = (ICobolVar)enumeration.nextElement();
                ++n2;
            }
            if (n2 == 1 && ((iXMLAttributes = iCobolVar.getIXMLAttributes()) == null || iXMLAttributes.getIdentifier().length() == 0) && iCobolVar.getDimensions() != null) {
                return iCobolVar;
            }
        }
        return null;
    }

    @Override
    protected int internalWrite(boolean bl) {
        ICobolVar iCobolVar;
        this.readConfiguration();
        if (this.out == null) {
            this.setOutputStream(System.out);
        }
        if ((iCobolVar = this.arrayOnly()) != null) {
            this.possibleArray(iCobolVar, null, this.indentNumber, 0);
        } else if (this.dummyRoot()) {
            this.writeObject(this.xmlVar, null, 0);
        } else {
            this.out.print('{');
            this.eol(this.out);
            this.writeObject(this.xmlVar, null, this.indentNumber);
            this.eol(this.out);
            this.out.print('}');
        }
        if (this.out != null) {
            this.out.close();
        }
        this.out = null;
        return 1;
    }

    private int getType(IXMLAttributes iXMLAttributes) {
        int n2;
        int n3 = n2 = iXMLAttributes.isNullable() ? 16 : 0;
        if (iXMLAttributes.isBoolean()) {
            return n2 + 1;
        }
        if (iXMLAttributes.isBase64Binary()) {
            return n2 + 2;
        }
        if (iXMLAttributes.isHexBinary()) {
            return n2 + 3;
        }
        if (iXMLAttributes.isRaw()) {
            return n2 + 4;
        }
        return n2 + 0;
    }

    @Override
    protected boolean isEmpty(ICobolVar iCobolVar, int[] nArray) {
        IXMLAttributes iXMLAttributes = iCobolVar.getIXMLAttributes();
        if (iXMLAttributes != null && iXMLAttributes.isNullable()) {
            return false;
        }
        return super.isEmpty(iCobolVar, nArray);
    }

    protected boolean isNull(String string, boolean bl) {
        if (bl) {
            try {
                return Integer.parseInt(string) == 0;
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
        }
        return string.trim().length() == 0;
    }

    private void writeObject(ICobolVar iCobolVar, int[] nArray, int n2) {
        boolean bl;
        IXMLAttributes iXMLAttributes = iCobolVar.getIXMLAttributes();
        if (iXMLAttributes == null) {
            throw new IllegalArgumentException(iCobolVar.getName());
        }
        int n3 = this.getType(iXMLAttributes);
        boolean bl2 = bl = (n3 & 0x10) == 16;
        if (this.dummyRoot() && iCobolVar == this.xmlVar) {
            this.possibleArray(iCobolVar, nArray, n2 + this.indentNumber, this.getType(iXMLAttributes));
        } else {
            String string = iXMLAttributes.getIdentifier();
            this.spaces(this.out, n2);
            this.out.print('\"');
            this.out.print(string);
            this.out.print('\"');
            this.out.print(':');
            if (!bl && this.omitEmptyElements && this.isEmpty(iCobolVar, nArray)) {
                boolean bl3 = false;
                Enumeration enumeration = iCobolVar.getChildren();
                while (enumeration.hasMoreElements()) {
                    ICobolVar iCobolVar2 = (ICobolVar)enumeration.nextElement();
                    IXMLAttributes iXMLAttributes2 = iCobolVar2.getIXMLAttributes();
                    if (iXMLAttributes2 == null || iXMLAttributes2.isAttribute()) continue;
                    bl3 = true;
                    break;
                }
                if (bl3) {
                    this.out.print("{}");
                } else {
                    this.out.print("\"\"");
                }
            } else {
                this.possibleArray(iCobolVar, nArray, n2 + this.indentNumber, this.getType(iXMLAttributes));
            }
        }
    }

    private void writeArray(ICobolVar iCobolVar, int n2, int n3, int[] nArray, int n4, int n5) {
        boolean bl = (n5 & 0x10) == 16;
        this.out.print('[');
        if (n3 > 0) {
            boolean bl2 = JSONStream.isObject(iCobolVar);
            boolean bl3 = false;
            int n6 = 1;
            while (true) {
                nArray[n2] = ++n6;
                if (bl2) {
                    if (bl || !this.omitEmptyElements || !this.isEmpty(iCobolVar, nArray)) {
                        if (bl3) {
                            this.out.print(',');
                        } else {
                            bl3 = true;
                        }
                        this.eol(this.out);
                        this.spaces(this.out, n4);
                        this.out.print('{');
                        this.eol(this.out);
                        this.writeChildren(iCobolVar, nArray, n4 + this.indentNumber, n5);
                        this.eol(this.out);
                        this.spaces(this.out, n4);
                        this.out.print('}');
                    }
                } else if (!this.omitEmptyElements || !this.isEmpty(iCobolVar, nArray)) {
                    if (bl3) {
                        this.out.print(',');
                    } else {
                        bl3 = true;
                    }
                    this.eol(this.out);
                    this.spaces(this.out, n4 + this.indentNumber);
                    this.writeChildren(iCobolVar, nArray, n4 + this.indentNumber, n5);
                }
                if (n6 == n3) break;
            }
            nArray[n2] = n6;
            this.eol(this.out);
            this.spaces(this.out, bl2 ? n4 - this.indentNumber : n4);
        }
        this.out.print(']');
    }

    private void possibleArray(ICobolVar iCobolVar, int[] nArray, int n2, int n3) {
        int[] nArray2 = iCobolVar.getDimensions();
        if (nArray == null) {
            if (nArray2 == null) {
                if (JSONStream.isObject(iCobolVar)) {
                    this.out.print('{');
                    this.eol(this.out);
                    this.writeChildren(iCobolVar, nArray, n2, n3);
                    this.eol(this.out);
                    this.spaces(this.out, n2 - this.indentNumber);
                    this.out.print('}');
                } else {
                    this.writeChildren(iCobolVar, nArray, n2, n3);
                }
            } else {
                nArray = new int[1];
                this.writeArray(iCobolVar, 0, nArray2[0], nArray, n2, n3);
            }
        } else if (nArray.length == nArray2.length) {
            if (JSONStream.isObject(iCobolVar)) {
                this.out.print('{');
                this.eol(this.out);
                this.writeChildren(iCobolVar, nArray, n2, n3);
                this.eol(this.out);
                this.spaces(this.out, n2);
                this.out.print('}');
            } else {
                this.writeChildren(iCobolVar, nArray, n2, n3);
            }
        } else {
            int n4;
            int[] nArray3 = new int[nArray2.length];
            for (n4 = 0; n4 < nArray.length; ++n4) {
                nArray3[n4] = nArray[n4];
            }
            nArray = nArray3;
            n4 = this.getDimension(iCobolVar, nArray, nArray2[nArray2.length - 1]);
            this.writeArray(iCobolVar, nArray2.length - 1, n4, nArray, n2, n3);
        }
    }

    private int getRTrimLen(byte[] byArray) {
        int n2 = byArray.length;
        if (this.rtrim) {
            for (int i2 = byArray.length - 1; i2 >= 0 && byArray[i2] == 32; --i2) {
                --n2;
            }
        }
        return n2;
    }

    private void writeValue(ICobolVar iCobolVar, int n2) {
        boolean bl = (n2 & 0x10) == 16;
        boolean bl2 = iCobolVar instanceof INumericVar;
        if (bl && this.isNull(iCobolVar.toStringNoGui(), bl2)) {
            this.out.print("null");
        } else if (bl2) {
            switch (n2) {
                case 1: {
                    this.out.print(iCobolVar.toint() != 0);
                    break;
                }
                case 2: {
                    byte[] byArray = iCobolVar.getBytes();
                    String string = new String(Base64.encode(byArray, 0, byArray.length));
                    this.out.print("\"" + string + "\"");
                    break;
                }
                case 3: {
                    byte[] byArray = iCobolVar.getBytes();
                    String string = RtsUtil.bytesToHex(byArray, 0, byArray.length);
                    this.out.print("\"" + string + "\"");
                    break;
                }
                default: {
                    String string = iCobolVar.toStringNoGui();
                    if (n2 != 4) {
                        string = string.replace(',', '.');
                    }
                    this.out.print(string);
                    break;
                }
            }
        } else {
            switch (n2) {
                case 1: {
                    this.out.print(Boolean.parseBoolean(iCobolVar.toStringNoGui().trim()));
                    break;
                }
                case 2: {
                    byte[] byArray = iCobolVar.getBytes();
                    int n3 = this.getRTrimLen(byArray);
                    String string = new String(Base64.encode(byArray, 0, n3));
                    this.out.print("\"" + string + "\"");
                    break;
                }
                case 3: {
                    byte[] byArray = iCobolVar.getBytes();
                    int n4 = this.getRTrimLen(byArray);
                    String string = RtsUtil.bytesToHex(byArray, 0, n4);
                    this.out.print("\"" + string + "\"");
                    break;
                }
                case 4: {
                    String string = iCobolVar.toStringNoGui();
                    if (this.rtrim) {
                        string = Factory.rightTrim(string);
                    }
                    this.out.print(string);
                    break;
                }
                default: {
                    String string = iCobolVar.toStringNoGui();
                    if (this.rtrim) {
                        string = Factory.rightTrim(string);
                    }
                    string = this.JSEscape(string);
                    this.out.print("\"" + string + "\"");
                }
            }
        }
    }

    private ICobolVar getNextElement(Enumeration enumeration, int[] nArray, boolean bl) {
        while (enumeration.hasMoreElements()) {
            ICobolVar iCobolVar = (ICobolVar)enumeration.nextElement();
            if (!bl && this.omitEmptyElements && this.isEmpty(iCobolVar, nArray)) continue;
            return iCobolVar;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void writeChildren(ICobolVar iCobolVar, int[] nArray, int n2, int n3) {
        ICobolVar iCobolVar2;
        boolean bl;
        Enumeration enumeration = iCobolVar.getChildren();
        boolean bl2 = bl = (n3 & 0x10) == 16;
        if (enumeration == null || (iCobolVar2 = this.getNextElement(enumeration, nArray, bl)) == null) return;
        while (true) {
            IXMLAttributes iXMLAttributes;
            if ((iXMLAttributes = iCobolVar2.getIXMLAttributes()) != null) {
                if (!iXMLAttributes.isAttribute()) {
                    String string = iXMLAttributes.getIdentifier();
                    if (string == null) throw new IscobolRuntimeException(3, "Invalid json struct:" + iCobolVar2.getName());
                    this.writeIdentified(string, iCobolVar2, nArray, n2, this.getType(iXMLAttributes));
                }
            } else {
                Enumeration enumeration2 = iCobolVar2.getChildren();
                if (enumeration2 != null && enumeration2.hasMoreElements()) {
                    this.possibleArray(iCobolVar2, nArray, n2, n3);
                } else {
                    if (nArray != null) {
                        iCobolVar2 = iCobolVar2.intIAt(nArray);
                    }
                    this.writeValue(iCobolVar2, n3);
                }
            }
            if ((iCobolVar2 = this.getNextElement(enumeration, nArray, bl)) == null) return;
            this.out.print(',');
            this.eol(this.out);
        }
    }

    private static boolean isObject(ICobolVar iCobolVar) {
        Enumeration enumeration = iCobolVar.getChildren();
        while (enumeration.hasMoreElements()) {
            ICobolVar iCobolVar2 = (ICobolVar)enumeration.nextElement();
            IXMLAttributes iXMLAttributes = iCobolVar2.getIXMLAttributes();
            if (iXMLAttributes == null) continue;
            return true;
        }
        return false;
    }

    private void writeIdentified(String string, ICobolVar iCobolVar, int[] nArray, int n2, int n3) {
        if (JSONStream.isObject(iCobolVar)) {
            this.writeObject(iCobolVar, nArray, n2);
        } else {
            this.spaces(this.out, n2);
            this.out.print('\"');
            this.out.print(string);
            this.out.print('\"');
            this.out.print(':');
            this.possibleArray(iCobolVar, nArray, n2, n3);
        }
    }

    @Override
    protected void readConfiguration() {
        this.indentNumber = Config.a(".jsonstream.indent_number", -1);
        this.omitEmptyElements = Config.b(".jsonstream.omit_empty_elements", true);
        this.rtrim = Config.b(".jsonstream.rtrim", false);
        this.escapeAnyCharacter = Config.b(".jsonstream.allow_backslash_escaping_any_character", false);
        this.initializeOnRead = Config.b(".jsonstream.initialize_on_read", false);
    }
}

