/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.rts;

import com.iscobol.rts.IOUtil;
import java.io.Serializable;

public class KeyDescription
implements Serializable {
    public static final int LEN_DUP = 1;
    public static final int LEN_SEG_NUM = 2;
    public static final int LEN_SEG_SIZE = 3;
    public static final int LEN_SEG_OFFS = 10;
    private byte[] stringDescr;
    public boolean duplicates;
    public Segs[] segment;

    public KeyDescription(byte[] byArray) {
        int[] nArray = IOUtil.csv2Int(byArray);
        int[] nArray2 = new int[nArray.length];
        nArray2[0] = 2;
        nArray2[1] = 1;
        int n2 = 2;
        while (n2 < nArray2.length - 1) {
            nArray2[n2++] = 3;
            nArray2[n2++] = 10;
        }
        this.stringDescr = IOUtil.int2Csv(nArray, nArray2);
    }

    public KeyDescription(int n2, boolean bl) {
        this.duplicates = bl;
        this.segment = new Segs[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            this.segment[i2] = new Segs();
        }
    }

    public boolean isDup() {
        int n2 = this.getNumSegments();
        return this.duplicates;
    }

    public void setSegment(int n2, int n3, int n4) {
        int n5 = this.getNumSegments();
        if (n2 < n5) {
            this.segment[n2].size = n3;
            this.segment[n2].offset = n4;
        }
    }

    public Segs getSegment(int n2) {
        int n3 = this.getNumSegments();
        Segs segs = n2 < n3 ? this.segment[n2] : null;
        return segs;
    }

    public int getNumSegments() {
        int n2;
        if (this.segment == null) {
            if (this.stringDescr != null) {
                int[] nArray = IOUtil.csv2Int(this.stringDescr);
                if (nArray.length >= 4) {
                    this.duplicates = nArray[1] == 1;
                    this.segment = new Segs[(nArray.length - 2) / 2];
                    int n3 = 2;
                    for (int i2 = 0; i2 < this.segment.length; ++i2) {
                        this.segment[i2] = new Segs();
                        this.segment[i2].size = nArray[n3++];
                        this.segment[i2].offset = nArray[n3++];
                    }
                    n2 = this.segment.length;
                } else {
                    n2 = 0;
                }
            } else {
                n2 = 0;
            }
        } else {
            n2 = this.segment.length;
        }
        return n2;
    }

    public byte[] toByteArray() {
        if (this.stringDescr == null) {
            int[] nArray = new int[this.segment.length * 2 + 2];
            int[] nArray2 = new int[nArray.length];
            nArray[0] = this.segment.length;
            nArray2[0] = 2;
            nArray[1] = this.duplicates ? 1 : 0;
            nArray2[1] = 1;
            int n2 = 2;
            for (int i2 = 0; i2 < this.segment.length; ++i2) {
                nArray[n2] = this.segment[i2].size;
                nArray2[n2++] = 3;
                nArray[n2] = this.segment[i2].offset;
                nArray2[n2++] = 10;
            }
            this.stringDescr = IOUtil.int2Csv(nArray, nArray2);
        }
        return this.stringDescr;
    }

    public String toString() {
        return new String(this.toByteArray());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public int length() {
        int n2 = 0;
        for (int i2 = this.getNumSegments() - 1; i2 >= 0; --i2) {
            n2 += this.segment[i2].size;
        }
        return n2;
    }

    public boolean equals(KeyDescription keyDescription) {
        int n2 = this.getNumSegments();
        if (n2 == keyDescription.getNumSegments()) {
            for (int i2 = 0; i2 < n2; ++i2) {
                if (this.segment[i2].equals(keyDescription.segment[i2])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static void main(String[] stringArray) {
        KeyDescription keyDescription = new KeyDescription(stringArray[0].getBytes());
        int n2 = keyDescription.getNumSegments();
        boolean bl = keyDescription.isDup();
        System.out.println("nseg=" + n2 + ", isDup=" + bl);
        Segs[] segsArray = new Segs[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            segsArray[i2] = keyDescription.getSegment(i2);
            System.out.println("seg=" + i2 + ", =[" + segsArray[i2].toString() + "]");
        }
        KeyDescription keyDescription2 = new KeyDescription(n2, bl);
        for (int i3 = 0; i3 < n2; ++i3) {
            keyDescription2.setSegment(i3, segsArray[i3].size, segsArray[i3].offset);
        }
        System.out.println("[" + keyDescription2.toString() + "]");
        System.out.println("->" + keyDescription2.equals(keyDescription) + "<-");
    }

    public class Segs
    implements Serializable {
        public int size;
        public int offset;

        public boolean equals(Segs segs) {
            return this.size == segs.size && this.offset == segs.offset;
        }

        public byte[] toByteArray() {
            return IOUtil.int2Csv(new int[]{this.size, this.offset}, new int[]{3, 10});
        }

        public String toString() {
            return new String(this.toByteArray());
        }
    }
}

