/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.rts;

import com.iscobol.rts.CallLoader;
import com.iscobol.rts.Config;
import com.iscobol.rts.Factory;
import com.iscobol.rts.ICoverageClassLoader;
import com.iscobol.rts.IDumpCreator;
import com.iscobol.rts.IscobolCall;
import com.iscobol.rts.IscobolModule;
import com.iscobol.rts.IscobolStackTraceElement;
import com.iscobol.rts.SMAPReader;
import com.iscobol.rts.Unloaded;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Vector;

public class LayoutExceptionCobol {
    public static final String eol = System.getProperty("line.separator", "\n");
    private Throwable exc;
    private String javaName;
    private IscobolStackTraceElement[] stackTrace;
    private StackTraceElement[] javaTopTrace;
    private String msg;
    private final IDumpCreator dumpCreator;
    private boolean SMAPInfo;

    static boolean isNumber(String string) {
        try {
            Double.parseDouble(string);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public LayoutExceptionCobol(Throwable throwable) {
        this(throwable, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LayoutExceptionCobol(Throwable throwable, IDumpCreator iDumpCreator) {
        this.dumpCreator = iDumpCreator;
        this.exc = throwable;
        this.msg = throwable.getLocalizedMessage();
        if (this.msg == null || this.msg.length() == 0 || LayoutExceptionCobol.isNumber(this.msg)) {
            this.msg = throwable.getClass().getName() + " caught! (" + this.msg + ")";
        }
        if (!Config.b(".exception.java", false)) {
            HashMap<String, ClassAndSmap> hashMap = new HashMap<String, ClassAndSmap>();
            try {
                int n2;
                StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
                Vector<IscobolStackTraceElement> vector = new Vector<IscobolStackTraceElement>();
                Vector<StackTraceElement> vector2 = new Vector<StackTraceElement>();
                boolean bl = false;
                CallLoader callLoader = Factory.getLoader();
                for (n2 = 0; n2 < stackTraceElementArray.length; ++n2) {
                    String string;
                    char c2;
                    String string2 = stackTraceElementArray[n2].getClassName();
                    ClassAndSmap classAndSmap = (ClassAndSmap)hashMap.get(string2);
                    if (classAndSmap == null) {
                        InputStream inputStream;
                        Object object;
                        block41: {
                            classAndSmap = new ClassAndSmap();
                            try {
                                if (callLoader != null) {
                                    int n3 = Config.a(".tracelevel", 0);
                                    try {
                                        Config.b(".tracelevel", "0");
                                        classAndSmap.clazz = callLoader.loadClass(string2);
                                        break block41;
                                    }
                                    catch (ClassNotFoundException classNotFoundException) {
                                        classAndSmap.clazz = Class.forName(string2);
                                        break block41;
                                    }
                                    finally {
                                        Config.b(".tracelevel", Integer.toString(n3));
                                    }
                                }
                                classAndSmap.clazz = Factory.classForName(string2);
                            }
                            catch (NoClassDefFoundError noClassDefFoundError) {
                                classAndSmap.clazz = Unloaded.class;
                            }
                        }
                        if (classAndSmap.clazz.getClassLoader() instanceof ICoverageClassLoader) {
                            object = ((ICoverageClassLoader)((Object)classAndSmap.clazz.getClassLoader())).getOriginalBytes(classAndSmap.clazz.getName());
                            inputStream = object != null ? new ByteArrayInputStream((byte[])object) : null;
                        } else {
                            object = classAndSmap.clazz.getName();
                            int n4 = ((String)object).lastIndexOf(46);
                            if (n4 >= 0) {
                                object = ((String)object).substring(n4 + 1, ((String)object).length());
                            }
                            if (IscobolModule.class.isAssignableFrom(classAndSmap.clazz) && (n4 = ((String)object).indexOf(36)) > 0) {
                                object = ((String)object).substring(0, n4);
                            }
                            object = (String)object + ".class";
                            inputStream = classAndSmap.clazz.getResourceAsStream((String)object);
                        }
                        if (inputStream != null) {
                            try {
                                classAndSmap.smap = new SMAPReader(inputStream);
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                        hashMap.put(string2, classAndSmap);
                    }
                    if (classAndSmap.smap != null && classAndSmap.smap.isOk()) {
                        SMAPReader.CobolInfo cobolInfo = classAndSmap.smap.getLineInfo(stackTraceElementArray[n2].getLineNumber());
                        this.SMAPInfo = true;
                        bl = true;
                        if (!IscobolCall.class.isAssignableFrom(classAndSmap.clazz) && !IscobolModule.class.isAssignableFrom(classAndSmap.clazz) || (c2 = (string = stackTraceElementArray[n2].getMethodName()).charAt(0)) != '_' && !Character.isUpperCase(c2)) continue;
                        vector.addElement(new IscobolStackTraceElement(stackTraceElementArray[n2].getClassName(), stackTraceElementArray[n2].getMethodName(), cobolInfo.fileName, cobolInfo.line, classAndSmap.clazz));
                        continue;
                    }
                    if (Unloaded.class == classAndSmap.clazz) {
                        bl = true;
                        string = stackTraceElementArray[n2].getMethodName();
                        vector.addElement(new IscobolStackTraceElement(stackTraceElementArray[n2].getClassName(), string, null, 0, classAndSmap.clazz, string2));
                        continue;
                    }
                    if (IscobolCall.class.isAssignableFrom(classAndSmap.clazz) || IscobolModule.class.isAssignableFrom(classAndSmap.clazz)) {
                        bl = true;
                        string = stackTraceElementArray[n2].getMethodName();
                        c2 = string.charAt(0);
                        if (c2 != '_' && !Character.isUpperCase(c2)) continue;
                        vector.addElement(new IscobolStackTraceElement(stackTraceElementArray[n2].getClassName(), string, null, 0, classAndSmap.clazz));
                        continue;
                    }
                    if (bl) continue;
                    vector2.addElement(stackTraceElementArray[n2]);
                }
                this.stackTrace = new IscobolStackTraceElement[vector.size()];
                for (n2 = 0; n2 < this.stackTrace.length; ++n2) {
                    this.stackTrace[n2] = (IscobolStackTraceElement)vector.elementAt(n2);
                }
                this.javaTopTrace = new StackTraceElement[vector2.size()];
                for (n2 = 0; n2 < this.javaTopTrace.length; ++n2) {
                    this.javaTopTrace[n2] = (StackTraceElement)vector2.elementAt(n2);
                }
                if (this.dumpCreator != null) {
                    this.dumpCreator.dump(this.stackTrace);
                }
            }
            catch (Throwable throwable2) {
                System.out.println(throwable2);
            }
        } else if (Config.a(".exception.message", 0) == 3 || Config.a(".exception_message", ".display_message", 0) == 3) {
            HashMap<String, Class> hashMap = new HashMap<String, Class>();
            try {
                StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
                CallLoader callLoader = Factory.getLoader();
                for (int i2 = 0; i2 < stackTraceElementArray.length; ++i2) {
                    String string;
                    char c3;
                    String string3 = stackTraceElementArray[i2].getClassName();
                    Class clazz = (Class)hashMap.get(string3);
                    if (clazz == null) {
                        block43: {
                            try {
                                if (callLoader != null) {
                                    int n5 = Config.a(".tracelevel", 0);
                                    try {
                                        Config.b(".tracelevel", "0");
                                        clazz = callLoader.loadClass(string3);
                                        break block43;
                                    }
                                    catch (ClassNotFoundException classNotFoundException) {
                                        clazz = Class.forName(string3);
                                        break block43;
                                    }
                                    finally {
                                        Config.b(".tracelevel", Integer.toString(n5));
                                    }
                                }
                                clazz = Factory.classForName(string3);
                            }
                            catch (NoClassDefFoundError noClassDefFoundError) {
                                clazz = Unloaded.class;
                            }
                        }
                        hashMap.put(string3, clazz);
                    }
                    if (!IscobolCall.class.isAssignableFrom(clazz) && !IscobolModule.class.isAssignableFrom(clazz) || (c3 = (string = stackTraceElementArray[i2].getMethodName()).charAt(0)) != '_' && !Character.isUpperCase(c3)) continue;
                    this.javaName = clazz.getName();
                    break;
                }
            }
            catch (Throwable throwable3) {
                System.out.println(throwable3);
            }
        }
    }

    public String getName() {
        if (this.stackTrace != null && this.stackTrace.length > 0) {
            return this.stackTrace[0].name;
        }
        if (this.javaName != null) {
            return this.javaName;
        }
        return "ads-dump";
    }

    public String getLocalizedMessage() {
        return this.msg;
    }

    public String toString(PrintWriter printWriter) {
        if (this.stackTrace == null) {
            return this.exc.toString();
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.msg);
        if (this.stackTrace.length > 0) {
            stringBuffer.append("  in ");
            stringBuffer.append(this.stackTrace[0].toString());
        }
        return stringBuffer.toString();
    }

    public void printStackTrace(PrintWriter printWriter) {
        if (this.stackTrace == null) {
            if (printWriter != null) {
                this.exc.printStackTrace(printWriter);
            } else {
                this.exc.printStackTrace();
            }
        } else {
            String string;
            int n2;
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.msg);
            stringBuffer.append(eol);
            if (this.stackTrace.length > 0) {
                stringBuffer.append("  in ");
                stringBuffer.append(this.stackTrace[0].toString());
                stringBuffer.append(eol);
                for (n2 = 1; n2 < this.stackTrace.length; ++n2) {
                    stringBuffer.append("     ");
                    stringBuffer.append(this.stackTrace[n2].toString());
                    stringBuffer.append(eol);
                }
            }
            if (this.javaTopTrace != null && this.javaTopTrace.length > 0) {
                stringBuffer.append("(Top of stack)");
                stringBuffer.append(eol);
                for (n2 = 0; n2 < this.javaTopTrace.length; ++n2) {
                    stringBuffer.append("   (");
                    stringBuffer.append(this.javaTopTrace[n2].toString());
                    stringBuffer.append(")");
                    stringBuffer.append(eol);
                }
            }
            if (this.dumpCreator != null && (string = this.dumpCreator.getDumpInfo()) != null) {
                stringBuffer.append(string);
            }
            if (printWriter != null) {
                printWriter.print(stringBuffer.toString());
            } else {
                System.err.print(stringBuffer.toString());
            }
        }
    }

    public boolean hasSMAPInfo() {
        return this.SMAPInfo;
    }

    private static class ClassAndSmap {
        Class clazz;
        SMAPReader smap;

        private ClassAndSmap() {
        }
    }
}

