/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.rts;

import com.iscobol.rts.FactoryData;
import com.iscobol.rts.IsInitial;
import com.iscobol.rts.IsResident;
import com.iscobol.rts.IscobolCall;
import com.iscobol.rts.IscobolRuntimeException;
import com.iscobol.rts.IscobolSystem;
import com.iscobol.rts.LocalStorageProvider;
import com.iscobol.rts.RuntimeErrorsNumbers;
import com.iscobol.rts.ThreadLocalStorageProvider;
import com.iscobol.rts.WithEntryPoints;
import com.iscobol.rts.WithName;
import java.util.ArrayList;

public class LeveledRecursiveCall
implements IscobolCall,
LocalStorageProvider,
RuntimeErrorsNumbers,
ThreadLocalStorageProvider,
WithName {
    private final Class callClass;
    private final ArrayList array = new ArrayList();
    private int level;
    private IscobolCall mostRecentCall;
    int mostRecentLevel;

    public static IscobolCall get(Object object, FactoryData factoryData) {
        if (object instanceof IsInitial || object instanceof LeveledRecursiveCall) {
            return (IscobolCall)object;
        }
        if (object instanceof WithEntryPoints) {
            if (object instanceof IsResident) {
                return new WEPointsResident((WithEntryPoints)object);
            }
            return new WEPoints((WithEntryPoints)object);
        }
        if (object instanceof IsResident) {
            return new Resident((IscobolCall)object);
        }
        IscobolCall iscobolCall = (IscobolCall)factoryData.recurCallList.get(object);
        if (iscobolCall == null) {
            iscobolCall = new LeveledRecursiveCall((IscobolCall)object);
            factoryData.recurCallList.put(object, iscobolCall);
        }
        return iscobolCall;
    }

    private LeveledRecursiveCall(IscobolCall iscobolCall) {
        this.mostRecentCall = iscobolCall;
        this.callClass = iscobolCall.getClass();
        this.array.add(iscobolCall);
    }

    private IscobolCall get() {
        IscobolCall iscobolCall;
        if (this.level >= this.array.size()) {
            try {
                iscobolCall = (IscobolCall)this.callClass.newInstance();
                this.array.add(iscobolCall);
            }
            catch (Exception exception) {
                throw new IscobolRuntimeException(7, this.callClass.getName() + " (" + exception + ")");
            }
        } else {
            iscobolCall = (IscobolCall)this.array.get(this.level);
        }
        return iscobolCall;
    }

    @Override
    public Object call(Object[] objectArray) {
        Object object;
        if (this.level != this.mostRecentLevel) {
            this.mostRecentCall = this.get();
            this.mostRecentLevel = this.level;
        }
        ++this.level;
        try {
            object = this.mostRecentCall.call(objectArray);
        }
        finally {
            --this.level;
        }
        return object;
    }

    @Override
    public void perform(int n2, int n3) {
        if (this.level != this.mostRecentLevel) {
            this.mostRecentCall = this.get();
            this.mostRecentLevel = this.level;
        }
        ++this.level;
        try {
            this.mostRecentCall.perform(n2, n3);
        }
        finally {
            --this.level;
        }
    }

    public void closeFiles() {
        if (this.level != this.mostRecentLevel) {
            this.mostRecentCall = this.get();
            this.mostRecentLevel = this.level;
        }
        ++this.level;
        try {
            this.mostRecentCall.finalize();
        }
        finally {
            --this.level;
        }
    }

    public void forceAllFinalize() {
        this.level = 0;
        this.finalize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void finalize() {
        if (this.level < 0) {
            return;
        }
        for (int i2 = this.array.size() - 1; i2 >= this.level; --i2) {
            FactoryData factoryData;
            IscobolCall iscobolCall = (IscobolCall)this.array.get(i2);
            this.array.remove(i2);
            try {
                iscobolCall.finalize();
            }
            catch (Throwable throwable) {
                factoryData = (FactoryData)IscobolSystem.get(FactoryData.class);
                if (factoryData != null) {
                    factoryData.recurCallList.remove(iscobolCall);
                }
                if (iscobolCall != this.mostRecentCall) continue;
                if (i2 > 0) {
                    this.mostRecentCall = (IscobolCall)this.array.get(i2 - 1);
                    --this.mostRecentLevel;
                    continue;
                }
                this.mostRecentCall = null;
                this.mostRecentLevel = -1;
                continue;
            }
            catch (Throwable throwable) {
                FactoryData factoryData2 = (FactoryData)IscobolSystem.get(FactoryData.class);
                if (factoryData2 != null) {
                    factoryData2.recurCallList.remove(iscobolCall);
                }
                if (iscobolCall == this.mostRecentCall) {
                    if (i2 > 0) {
                        this.mostRecentCall = (IscobolCall)this.array.get(i2 - 1);
                        --this.mostRecentLevel;
                    } else {
                        this.mostRecentCall = null;
                        this.mostRecentLevel = -1;
                    }
                }
                throw throwable;
            }
            factoryData = (FactoryData)IscobolSystem.get(FactoryData.class);
            if (factoryData != null) {
                factoryData.recurCallList.remove(iscobolCall);
            }
            if (iscobolCall != this.mostRecentCall) continue;
            if (i2 > 0) {
                this.mostRecentCall = (IscobolCall)this.array.get(i2 - 1);
                --this.mostRecentLevel;
                continue;
            }
            this.mostRecentCall = null;
            this.mostRecentLevel = -1;
            continue;
        }
    }

    public String[] getEntryPoints() {
        if (this.mostRecentCall instanceof WithEntryPoints) {
            return ((WithEntryPoints)this.mostRecentCall).getEntryPoints();
        }
        return new String[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object call(int n2, Object[] objectArray) {
        Object object;
        if (this.level != this.mostRecentLevel) {
            this.mostRecentCall = this.get();
            this.mostRecentLevel = this.level;
        }
        ++this.level;
        try {
            object = ((WithEntryPoints)this.mostRecentCall).call(n2, objectArray);
        }
        finally {
            --this.level;
        }
        return object;
    }

    public IscobolCall getMostRecent() {
        return this.mostRecentCall;
    }

    @Override
    public String getName() {
        return this.callClass.getName();
    }

    public boolean isEmpty() {
        return this.array.size() == 0;
    }

    @Override
    public Object newLocalStorage() {
        if (LocalStorageProvider.class.isAssignableFrom(this.callClass)) {
            return ((LocalStorageProvider)((Object)this.get())).newLocalStorage();
        }
        return null;
    }

    @Override
    public Object newThreadLocalStorage() {
        if (ThreadLocalStorageProvider.class.isAssignableFrom(this.callClass)) {
            return ((ThreadLocalStorageProvider)((Object)this.get())).newThreadLocalStorage();
        }
        return null;
    }

    @Override
    public String threadLocalStorageName() {
        if (ThreadLocalStorageProvider.class.isAssignableFrom(this.callClass)) {
            return ((ThreadLocalStorageProvider)((Object)this.get())).threadLocalStorageName();
        }
        return this.getClass().getName();
    }

    private static class Resident
    extends LeveledRecursiveCall
    implements IsResident {
        private Resident(IscobolCall iscobolCall) {
            super(iscobolCall);
        }
    }

    private static class WEPointsResident
    extends LeveledRecursiveCall
    implements IsResident,
    WithEntryPoints {
        private WEPointsResident(WithEntryPoints withEntryPoints) {
            super(withEntryPoints);
        }
    }

    private static class WEPoints
    extends LeveledRecursiveCall
    implements WithEntryPoints {
        private WEPoints(WithEntryPoints withEntryPoints) {
            super(withEntryPoints);
        }
    }
}

