/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.rts;

import com.iscobol.gui.server.CobolAcceptStack;
import com.iscobol.gui.server.CobolRecordAccept;
import com.iscobol.gui.server.DisplayWindow;
import com.iscobol.rts.ErrorBox;
import com.iscobol.rts.Factory;
import com.iscobol.rts.Handle;
import com.iscobol.rts.ICobolVar;
import com.iscobol.rts.INumericVar;
import com.iscobol.rts.IsThread;
import com.iscobol.rts.IscobolSystem;
import com.iscobol.rts.MonitorFinalize;
import com.iscobol.rts.StopRunException;
import com.iscobol.rts.StoppedThreadException;
import com.iscobol.rts.ThreadException;
import com.iscobol.rts.ThreadName;
import com.iscobol.rts.UserHandles;
import com.iscobol.types.CobolVar;
import com.iscobol.types.NumericVar;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Vector;

public abstract class Monitor
implements Handle,
Runnable {
    private Thread thread;
    private boolean[] ended = new boolean[1];
    private int id;
    private CobolAcceptStack cas;
    private CobolAcceptStack casdestroy;
    private Monitor parent;
    private Monitor lastMonitor;
    private boolean stopped;
    public Object CGEObject;
    private Vector objToFinalize;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Message getMessage(int n2, Monitor monitor) {
        LinkedList linkedList;
        LinkedList linkedList2 = linkedList = PseudoStaticData.get().messageList;
        synchronized (linkedList2) {
            Message message2;
            for (Message message2 : linkedList) {
                if (!message2.is(n2, monitor)) continue;
                return message2;
            }
            message2 = new Message(n2, monitor);
            linkedList.addLast(message2);
            return message2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int getAnyMessage(Monitor monitor, ICobolVar iCobolVar, int[] nArray) {
        LinkedList linkedList;
        int n2 = -1;
        LinkedList linkedList2 = linkedList = PseudoStaticData.get().messageList;
        synchronized (linkedList2) {
            for (Message message : linkedList) {
                if (message.to != monitor || message.mesg.size() <= 0) continue;
                ICobolVar iCobolVar2 = (ICobolVar)message.mesg.removeFirst();
                iCobolVar2.moveTo(iCobolVar);
                nArray[0] = message.from;
                n2 = iCobolVar2.length();
            }
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void notifyEnd(Monitor monitor) {
        LinkedList linkedList;
        LinkedList linkedList2 = linkedList = PseudoStaticData.get().messageList;
        synchronized (linkedList2) {
            Iterator iterator = linkedList.iterator();
            while (iterator.hasNext()) {
                Message message = (Message)iterator.next();
                if (message.from == monitor.id) {
                    Message message2 = message;
                    synchronized (message2) {
                        message.notify();
                        continue;
                    }
                }
                if (message.to != monitor) continue;
                iterator.remove();
            }
        }
    }

    public Monitor(NumericVar numericVar, Monitor monitor) {
        this((INumericVar)numericVar, monitor);
    }

    public Monitor(INumericVar iNumericVar, Monitor monitor) {
        Thread thread = Thread.currentThread();
        int n2 = thread instanceof IsThread ? ((IsThread)thread).id : 0;
        this.id = UserHandles.ssetId(this);
        if (iNumericVar != null) {
            iNumericVar.set(this.id);
        }
        this.thread = new IsThread((Runnable)this, n2);
        ThreadName.setName(this.thread, this);
        Factory.addMonitor(this, this.thread);
        IscobolSystem.duplicateEnv(this.thread);
        this.parent = monitor;
        this.parent.lastMonitor = this;
        this.lastMonitor = this.parent;
    }

    public Monitor() {
        this.id = UserHandles.ssetId(this);
        this.thread = Thread.currentThread();
    }

    public abstract void launch();

    public void start() {
        this.thread.start();
    }

    @Override
    public void run() {
        try {
            this.launch();
        }
        catch (StopRunException stopRunException) {
        }
        catch (ThreadDeath threadDeath) {
        }
        catch (Throwable throwable) {
            this.handleError(throwable);
        }
        finally {
            this.setEnded();
            Factory.removeMonitor(this, this.thread);
            UserHandles.free(this.id);
            Monitor.notifyEnd(this);
            IscobolSystem.destroyEnv(this.thread);
            this.finalize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setEnded() {
        boolean[] blArray = this.ended;
        synchronized (this.ended) {
            this.ended[0] = true;
            this.ended.notifyAll();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitFor() {
        boolean[] blArray = this.ended;
        synchronized (this.ended) {
            if (!this.ended[0]) {
                try {
                    this.ended.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    protected void handleError(Throwable throwable) {
        ErrorBox.show(throwable);
    }

    public void stopThread() {
        this.stopped = true;
        if (this.casdestroy != null) {
            this.casdestroy.push(new CobolRecordAccept(25, 91, 0, (DisplayWindow)null, 0, this.id, true, true));
        }
    }

    public void yield() {
        if (this.thread != null) {
            Thread.yield();
        }
        if (this.stopped || this.thread != null && this.thread.isInterrupted()) {
            throw new StoppedThreadException();
        }
    }

    public synchronized void finalize() {
        if (this.objToFinalize != null) {
            for (int i2 = this.objToFinalize.size() - 1; i2 >= 0; --i2) {
                try {
                    ((MonitorFinalize)this.objToFinalize.elementAt(i2)).monitorFinalize();
                    continue;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        this.objToFinalize = null;
        if (this.casdestroy != null) {
            this.casdestroy.push(new CobolRecordAccept(25, 91, 0, (DisplayWindow)null, 0, this.id, true, true));
        }
        this.casdestroy = null;
        if (this.parent != null && this.parent.lastMonitor == this) {
            this.parent.lastMonitor = null;
        }
        this.lastMonitor = null;
    }

    public Thread getThread() {
        return this.thread;
    }

    public Monitor getMainMonitor() {
        if (this.parent == null) {
            return this;
        }
        return this.parent.getMainMonitor();
    }

    public Monitor getLastMonitor() {
        return this.lastMonitor;
    }

    public int getId() {
        return this.id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCas(CobolAcceptStack cobolAcceptStack, Monitor monitor) {
        this.cas = cobolAcceptStack;
        if (this.cas != null) {
            LinkedList linkedList;
            Message message = null;
            int n2 = 0;
            LinkedList linkedList2 = linkedList = PseudoStaticData.get().messageList;
            synchronized (linkedList2) {
                Iterator iterator = linkedList.iterator();
                while (iterator.hasNext()) {
                    Message message2 = message = (Message)iterator.next();
                    synchronized (message2) {
                        if (message.mesg.size() > 0 && message.isTo(monitor) && message.isFrom(this.id) && (n2 = message.getSendAfter()) > 0) {
                            while (n2 > 0) {
                                this.cas.push(new CobolRecordAccept(4, 95, 0, (DisplayWindow)null, 0, message.getTo().getId(), true, true));
                                --n2;
                            }
                            message.resetsendafter();
                        }
                    }
                }
            }
        }
    }

    public void setCasdestroy(CobolAcceptStack cobolAcceptStack) {
        this.casdestroy = cobolAcceptStack;
    }

    public CobolAcceptStack getCasdestroy() {
        return this.casdestroy;
    }

    public boolean isThread(Thread thread) {
        return thread.equals(this.thread);
    }

    public String toString() {
        return "id=" + this.id + ",[" + this.thread.toString() + "]";
    }

    public void send(Monitor monitor, CobolVar cobolVar) {
        this.send(monitor, (ICobolVar)cobolVar);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(Monitor monitor, ICobolVar iCobolVar) {
        Message message;
        this.lastMonitor = monitor;
        Message message2 = message = Monitor.getMessage(this.id, monitor);
        synchronized (message2) {
            message.mesg.addLast(iCobolVar.intICopy());
            if (this.cas != null) {
                this.cas.push(new CobolRecordAccept(4, 95, 0, (DisplayWindow)null, 0, monitor.id, true, true));
            } else {
                message.incrsendafter();
            }
            message.notify();
        }
    }

    public int receiveAll(CobolVar cobolVar, NumericVar numericVar) {
        return this.receiveAll((ICobolVar)cobolVar, (INumericVar)numericVar);
    }

    public int receiveAll(ICobolVar iCobolVar, INumericVar iNumericVar) {
        int[] nArray = new int[1];
        int n2 = Monitor.getAnyMessage(this, iCobolVar, nArray);
        if (n2 < 0) {
            throw new ThreadException(99);
        }
        if (iNumericVar != null) {
            iNumericVar.set(nArray[0]);
        }
        return n2;
    }

    public int receive(int n2, CobolVar cobolVar, long l2) throws ThreadException {
        return this.receive(n2, (ICobolVar)cobolVar, l2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int receive(int n2, ICobolVar iCobolVar, long l2) throws ThreadException {
        Message message;
        Monitor monitor;
        this.lastMonitor = monitor = Factory.getMonitorById(n2);
        int n3 = 0;
        Message message2 = message = Monitor.getMessage(n2, this);
        synchronized (message2) {
            if (message.mesg.size() == 0) {
                if (monitor == null || monitor.ended[0]) {
                    throw new ThreadException(10);
                }
                if (l2 == 0L) {
                    throw new ThreadException(99);
                }
                try {
                    if (l2 > 0L) {
                        message.wait(l2);
                    } else {
                        message.wait();
                    }
                }
                catch (InterruptedException interruptedException) {
                    throw new StoppedThreadException();
                }
            }
            if (message.mesg.size() == 0) {
                if (monitor == null || monitor.ended[0]) {
                    throw new ThreadException(-1);
                }
                throw new ThreadException(99);
            }
            ICobolVar iCobolVar2 = (ICobolVar)message.mesg.removeFirst();
            iCobolVar2.moveTo(iCobolVar);
            n3 = iCobolVar2.length();
        }
        return n3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int waitEnd(int n2, long l2) {
        Message message;
        Monitor monitor = Factory.getMonitorById(n2);
        int n3 = 0;
        Message message2 = message = Monitor.getMessage(n2, this);
        synchronized (message2) {
            if (message.mesg.size() == 0) {
                if (monitor == null || monitor.ended[0]) {
                    throw new ThreadException(10);
                }
                if (l2 == 0L) {
                    throw new ThreadException(99);
                }
                try {
                    if (l2 > 0L) {
                        message.wait(l2);
                        if (message.mesg.size() == 0 && !this.ended[0]) {
                            throw new ThreadException(99);
                        }
                    } else {
                        message.wait();
                    }
                }
                catch (InterruptedException interruptedException) {
                    throw new StoppedThreadException();
                }
            }
            if (message.mesg.size() > 0) {
                ICobolVar iCobolVar = (ICobolVar)message.mesg.getFirst();
                n3 = iCobolVar.length();
            }
        }
        return n3;
    }

    public void setPriority(int n2) {
        this.thread.setPriority(n2);
    }

    @Override
    public int type() {
        return 4;
    }

    public void addObjToFinalize(MonitorFinalize monitorFinalize) {
        if (this.objToFinalize == null) {
            this.objToFinalize = new Vector();
        }
        this.objToFinalize.addElement(monitorFinalize);
    }

    public void removeObjToFinalize(MonitorFinalize monitorFinalize) {
        if (this.objToFinalize != null) {
            this.objToFinalize.removeElement(monitorFinalize);
        }
    }

    private static class Message {
        private int from;
        private int sendafter;
        private Monitor to;
        private LinkedList mesg = new LinkedList();

        Message(int n2, Monitor monitor) {
            this.from = n2;
            this.to = monitor;
        }

        boolean is(int n2, Monitor monitor) {
            return n2 == this.from && monitor == this.to;
        }

        boolean isFrom(int n2) {
            return n2 == this.from;
        }

        int getSendAfter() {
            return this.sendafter;
        }

        void incrsendafter() {
            ++this.sendafter;
        }

        void resetsendafter() {
            this.sendafter = 0;
        }

        Monitor getTo() {
            return this.to;
        }

        int getFrom() {
            return this.from;
        }

        boolean isTo(Monitor monitor) {
            return monitor == this.to;
        }

        public String toString() {
            return "from=" + this.from + ",to=" + this.to + ",size=" + this.mesg.size() + ",hash=" + this.hashCode();
        }
    }

    private static class PseudoStaticData {
        private LinkedList messageList = new LinkedList();

        private PseudoStaticData() {
        }

        private static PseudoStaticData get() {
            PseudoStaticData pseudoStaticData = (PseudoStaticData)IscobolSystem.get(PseudoStaticData.class);
            if (pseudoStaticData == null) {
                pseudoStaticData = new PseudoStaticData();
                IscobolSystem.set(PseudoStaticData.class, pseudoStaticData);
            }
            return pseudoStaticData;
        }
    }
}

