/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.rts;

import com.iscobol.as.ServerCallHandler;
import com.iscobol.rts.Config;
import com.iscobol.rts.Finalizable;
import com.iscobol.rts.IsRemote;
import com.iscobol.rts.IsRemoteFactory;
import com.iscobol.rts.IsRemoteMethod;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class RemoteConnections
implements Finalizable {
    private Hashtable<String, Vector<ConnObj>> connectionsTable = new Hashtable();
    private String currentRemoteCodePrefix;
    private IsRemoteFactory factory;

    public RemoteConnections(IsRemoteFactory isRemoteFactory) {
        this.factory = isRemoteFactory;
        this.load();
    }

    public void load() {
        String string = Config.a(".remote.code_prefix", (String)null);
        if (string != null) {
            if (this.currentRemoteCodePrefix == null || !this.currentRemoteCodePrefix.equals(string)) {
                this.currentRemoteCodePrefix = string;
                Vector<ConnObj> vector = this.connectionsTable.get(this.currentRemoteCodePrefix);
                if (vector == null) {
                    vector = new Vector();
                    this.connectionsTable.put(this.currentRemoteCodePrefix, vector);
                    StringTokenizer stringTokenizer = new StringTokenizer(this.currentRemoteCodePrefix, "\n");
                    while (stringTokenizer.hasMoreTokens()) {
                        String string2 = stringTokenizer.nextToken();
                        if (string2.startsWith("isc:")) {
                            try {
                                vector.add(new ConnObj(string2, false));
                            }
                            catch (MalformedURLException malformedURLException) {}
                            continue;
                        }
                        if (!string2.startsWith("iscp:")) continue;
                        try {
                            vector.add(new ConnObj(string2, true));
                        }
                        catch (MalformedURLException malformedURLException) {}
                    }
                }
            }
        } else {
            this.currentRemoteCodePrefix = null;
        }
    }

    public boolean isEmpty() {
        Vector<ConnObj> vector = this.getCurrentConnections();
        if (vector != null) {
            return vector.isEmpty();
        }
        return true;
    }

    public int getConnectionCount() {
        Vector<ConnObj> vector = this.getCurrentConnections();
        if (vector != null) {
            return vector.size();
        }
        return 0;
    }

    public String getRemoteURL(int n2) {
        return this.getConnectionObject((int)n2).url;
    }

    private Vector<ConnObj> getCurrentConnections() {
        if (this.currentRemoteCodePrefix != null) {
            return this.connectionsTable.get(this.currentRemoteCodePrefix);
        }
        return null;
    }

    public IsRemote getIsRemote(int n2, String string) throws IOException, ArrayIndexOutOfBoundsException {
        ConnObj connObj = this.getConnectionObject(n2);
        ServerCallHandler serverCallHandler = this.getServerCallHandler(connObj);
        return this.factory.getIsRemote(serverCallHandler.getServerCall(), string, connObj.isCp);
    }

    public IsRemoteMethod getIsRemoteMethod(int n2, String string, String string2, String string3, Object[] objectArray) throws IOException, ArrayIndexOutOfBoundsException {
        ConnObj connObj = this.getConnectionObject(n2);
        ServerCallHandler serverCallHandler = this.getServerCallHandler(connObj);
        return this.factory.getIsRemoteMethod(serverCallHandler.getServerCall(), string, string2, string3, objectArray);
    }

    private ConnObj getConnectionObject(int n2) {
        Vector<ConnObj> vector = this.getCurrentConnections();
        if (vector == null || n2 < 0 || n2 >= vector.size()) {
            throw new ArrayIndexOutOfBoundsException(Integer.toString(n2));
        }
        return vector.get(n2);
    }

    private ServerCallHandler getServerCallHandler(ConnObj connObj) throws IOException, ArrayIndexOutOfBoundsException {
        String string = Config.a(".remote.conf", ".remote_conf", "");
        ServerCallHandler serverCallHandler = connObj.serverCallHandlers.get(string);
        if (serverCallHandler == null) {
            serverCallHandler = ServerCallHandler.init(connObj.host, Integer.toString(connObj.port), string);
            connObj.serverCallHandlers.put(string, serverCallHandler);
        }
        return serverCallHandler;
    }

    protected void finalize() throws Throwable {
        this.myFinalize();
    }

    @Override
    public void myFinalize() {
        this.disconnectAll();
        this.connectionsTable.clear();
    }

    public void disconnectAll() {
        for (Vector<ConnObj> vector : this.connectionsTable.values()) {
            for (ConnObj connObj : vector) {
                for (ServerCallHandler serverCallHandler : connObj.serverCallHandlers.values()) {
                    try {
                        serverCallHandler.shutdown();
                    }
                    catch (IOException iOException) {}
                }
                connObj.serverCallHandlers.clear();
            }
        }
    }

    private static class ConnObj {
        final Hashtable<String, ServerCallHandler> serverCallHandlers = new Hashtable();
        final String url;
        final String host;
        final int port;
        final boolean isCp;

        ConnObj(String string, boolean bl) throws MalformedURLException {
            this.url = string;
            URL uRL = new URL("file" + string.substring(string.indexOf(58)));
            this.host = uRL.getHost();
            this.port = uRL.getPort();
            this.isCp = bl;
        }
    }
}

