/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.rts;

import java.util.ResourceBundle;
import javax.swing.JOptionPane;

public class RuntimeProperties {
    private static final ResourceBundle rb = ResourceBundle.getBundle("com.iscobol.rts.runtime");

    public static String getProductCopyright() {
        String string = rb.getString("product.copyright");
        return string;
    }

    public static String getProductDisplayName() {
        String string = rb.getString("product.displayname");
        return string;
    }

    public static String getProductFolderName() {
        String string = rb.getString("product.foldername");
        return string;
    }

    public static int getVersionNumber() {
        String string = rb.getString("runtime.version.number");
        int n2 = Integer.parseInt(string);
        return n2;
    }

    public static int getReleaseNumber() {
        String string = rb.getString("runtime.release.number");
        int n2 = Integer.parseInt(string);
        return n2;
    }

    public static int getMaintenanceNumber() {
        int n2;
        String string = rb.getString("runtime.maintenance.number");
        try {
            n2 = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            n2 = 999999;
        }
        return n2;
    }

    public static String getBuildNumber() {
        String string = rb.getString("runtime.build.number");
        return string;
    }

    public static String getShortBuildNumber() {
        String string = rb.getString("runtime.build.number");
        int n2 = string.indexOf(45);
        return n2 >= 0 ? string.substring(0, n2) : "0";
    }

    public static int getBuildMainNumber() {
        String string = rb.getString("runtime.build.number");
        if (string.equals("@BUILD_NUMBER")) {
            return 1000000297;
        }
        int n2 = 0;
        n2 = string.indexOf(46);
        if (n2 <= 0 && (n2 = string.indexOf(45)) <= 0 && (n2 = string.indexOf(43)) <= 0) {
            return 1000000297;
        }
        return Integer.parseInt(string.substring(0, n2));
    }

    public static int getSpNumber() {
        String string = rb.getString("runtime.sp.number");
        int n2 = Integer.parseInt(string);
        return n2;
    }

    public static String getFullVersionNumber() {
        if (RuntimeProperties.getBuildNumber().equals("@BUILD_NUMBER@")) {
            return " build#internal";
        }
        return RuntimeProperties.getProductDisplayName() + " release " + RuntimeProperties.getVersionNumber() + " R" + RuntimeProperties.getReleaseNumber() + (RuntimeProperties.getSpNumber() == 0 ? "" : " U" + RuntimeProperties.getSpNumber()) + " build#" + RuntimeProperties.getBuildNumber();
    }

    public static String getFullVersionNumberForFile() {
        return RuntimeProperties.getProductDisplayName().replace('-', '_').replace('.', '_') + "_" + RuntimeProperties.getVersionNumber() + "_R" + RuntimeProperties.getReleaseNumber() + (RuntimeProperties.getSpNumber() == 0 ? "" : "_U" + RuntimeProperties.getSpNumber()) + "_" + RuntimeProperties.getBuildNumber().replace('-', '_').replace('.', '_');
    }

    public static void main(String[] stringArray) {
        String string;
        if (stringArray.length == 1) {
            string = stringArray[0].equals("-v") ? RuntimeProperties.getFullVersionNumber() : (stringArray[0].equals("-n") ? RuntimeProperties.getProductDisplayName() : (stringArray[0].equals("-f") ? RuntimeProperties.getProductFolderName() : (stringArray[0].equals("-vf") ? RuntimeProperties.getFullVersionNumberForFile() : (stringArray[0].equals("-c") ? RuntimeProperties.getProductCopyright() : (stringArray[0].equals("-major-version") ? Integer.toString(RuntimeProperties.getVersionNumber()) : (stringArray[0].equals("-minor-version") ? Integer.toString(RuntimeProperties.getReleaseNumber()) : RuntimeProperties.getFullVersionNumber()))))));
        } else {
            String[] stringArray2 = new String[]{RuntimeProperties.getFullVersionNumber(), RuntimeProperties.getProductCopyright()};
            JOptionPane.showMessageDialog(null, stringArray2, "isCOBOL Version", 1);
            System.exit(0);
            string = "";
        }
        System.out.println(string);
    }
}

