/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.rts;

import java.io.IOException;
import java.io.Reader;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.DefaultHandler;

public class SAJParser {
    private String rootName;
    private Attributes dummyAttr = new AttributesImpl();
    private int line = 1;
    private int col;
    private int _lookup = -1;
    private Reader input;
    private DefaultHandler handler;
    private final boolean escapeAnyCharacter;
    private final boolean copyGen;

    public SAJParser() {
        this(false, false);
    }

    public SAJParser(boolean bl) {
        this(bl, false);
    }

    public SAJParser(boolean bl, boolean bl2) {
        this.escapeAnyCharacter = bl;
        this.copyGen = bl2;
    }

    private void exceptionChar(int n2) throws SAXException {
        throw new SAXException("Unxpected character '" + (char)n2 + "' line=" + this.line + ", col=" + this.col);
    }

    private void ungetChar(char c2) {
        if (this._lookup >= 0) {
            throw new RuntimeException("Internal error: lookup > 1!");
        }
        this._lookup = c2;
    }

    private char getChar() throws IOException {
        return this.getChar(false);
    }

    private char getChar(boolean bl) throws IOException {
        int n2;
        if (this._lookup >= 0) {
            int n3 = this._lookup;
            this._lookup = -1;
            return (char)n3;
        }
        while ((n2 = this.input.read()) >= 0) {
            if (n2 == 10) {
                ++this.line;
                this.col = 1;
                continue;
            }
            ++this.col;
            if (n2 <= 32 && !bl) continue;
            return (char)n2;
        }
        this.input.close();
        throw new EndOfFileException();
    }

    private MyCharBuffer getNumber(char c2) throws IOException, SAXException {
        MyCharBuffer myCharBuffer = new MyCharBuffer();
        if (c2 == '-' || c2 >= '0' && c2 <= '9') {
            myCharBuffer.append(c2);
            while ((c2 = this.getChar()) >= '0' && c2 <= '9') {
                myCharBuffer.append(c2);
            }
            if (c2 == '.') {
                myCharBuffer.append(c2);
                while ((c2 = this.getChar()) >= '0' && c2 <= '9') {
                    myCharBuffer.append(c2);
                }
            }
            if (c2 == 'e' || c2 == 'E') {
                myCharBuffer.append(c2);
                c2 = this.getChar();
                if (c2 == '+' || c2 == '-') {
                    myCharBuffer.append(c2);
                    c2 = this.getChar();
                }
                while (c2 >= '0' && c2 <= '9') {
                    myCharBuffer.append(c2);
                    c2 = this.getChar();
                }
                this.ungetChar(c2);
            } else {
                this.ungetChar(c2);
            }
        } else {
            this.exceptionChar(c2);
        }
        return myCharBuffer;
    }

    private MyCharBuffer getString(char c2) throws IOException, SAXException {
        MyCharBuffer myCharBuffer = new MyCharBuffer();
        if (c2 == '\"') {
            try {
                block16: while ((c2 = this.getChar(true)) != '\"') {
                    if (c2 == '\\') {
                        c2 = this.getChar();
                        switch (c2) {
                            case '\"': 
                            case '/': 
                            case '\\': {
                                myCharBuffer.append(c2);
                                continue block16;
                            }
                            case 'b': {
                                myCharBuffer.append('\b');
                                continue block16;
                            }
                            case 'f': {
                                myCharBuffer.append('\f');
                                continue block16;
                            }
                            case 'n': {
                                myCharBuffer.append('\n');
                                continue block16;
                            }
                            case 'r': {
                                myCharBuffer.append('\r');
                                continue block16;
                            }
                            case 't': {
                                myCharBuffer.append('\t');
                                continue block16;
                            }
                            case 'u': {
                                char c3 = '\u0000';
                                block17: for (int i2 = 0; i2 < 4; ++i2) {
                                    c3 = (char)(c3 * 16);
                                    c2 = this.getChar();
                                    switch (c2) {
                                        case '0': 
                                        case '1': 
                                        case '2': 
                                        case '3': 
                                        case '4': 
                                        case '5': 
                                        case '6': 
                                        case '7': 
                                        case '8': 
                                        case '9': {
                                            c3 = (char)(c3 + (c2 - 48));
                                            continue block17;
                                        }
                                        case 'A': 
                                        case 'B': 
                                        case 'C': 
                                        case 'D': 
                                        case 'E': 
                                        case 'F': {
                                            c3 = (char)(c3 + (c2 - 65 + 10));
                                            continue block17;
                                        }
                                        case 'a': 
                                        case 'b': 
                                        case 'c': 
                                        case 'd': 
                                        case 'e': 
                                        case 'f': {
                                            c3 = (char)(c3 + (c2 - 97 + 10));
                                            continue block17;
                                        }
                                        default: {
                                            this.exceptionChar(c2);
                                        }
                                    }
                                }
                                myCharBuffer.append(c3);
                                continue block16;
                            }
                        }
                        if (this.escapeAnyCharacter) {
                            myCharBuffer.append(c2);
                            continue;
                        }
                        this.exceptionChar(c2);
                        continue;
                    }
                    myCharBuffer.append(c2);
                }
            }
            catch (EndOfFileException endOfFileException) {
                throw new SAXException("Unclosed string");
            }
        } else {
            this.exceptionChar(c2);
        }
        return myCharBuffer;
    }

    private void characters(char[] cArray, int n2, int n3, ElementType elementType) throws SAXException {
        if (this.handler instanceof Handler) {
            ((Handler)this.handler).characters(cArray, n2, n3, elementType);
        } else {
            this.handler.characters(cArray, n2, n3);
        }
    }

    private void getValue(char c2) throws IOException, SAXException {
        switch (c2) {
            case '-': 
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                MyCharBuffer myCharBuffer = this.getNumber(c2);
                this.characters(myCharBuffer.array(), 0, myCharBuffer.length(), ElementType.NUMERIC);
                break;
            }
            case '\"': {
                MyCharBuffer myCharBuffer = this.getString(c2);
                this.characters(myCharBuffer.array(), 0, myCharBuffer.length(), ElementType.STRING);
                break;
            }
            case '{': {
                this.getObject(c2);
                break;
            }
            case 't': {
                c2 = this.getChar();
                if (c2 == 'r' && (c2 = this.getChar()) == 'u' && (c2 = this.getChar()) == 'e') {
                    this.characters(new char[]{'t', 'r', 'u', 'e'}, 0, 4, ElementType.BOOLEAN);
                    break;
                }
                this.exceptionChar(c2);
                break;
            }
            case 'f': {
                c2 = this.getChar();
                if (c2 == 'a' && (c2 = this.getChar()) == 'l' && (c2 = this.getChar()) == 's' && (c2 = this.getChar()) == 'e') {
                    this.characters(new char[]{'f', 'a', 'l', 's', 'e'}, 0, 5, ElementType.BOOLEAN);
                    break;
                }
                this.exceptionChar(c2);
                break;
            }
            case 'n': {
                c2 = this.getChar();
                if (c2 == 'u' && (c2 = this.getChar()) == 'l' && (c2 = this.getChar()) == 'l') {
                    this.characters(new char[]{'n', 'u', 'l', 'l'}, 0, 4, ElementType.STRING);
                    break;
                }
                this.exceptionChar(c2);
                break;
            }
            default: {
                this.exceptionChar(c2);
            }
        }
    }

    private void getArray(String string) throws IOException, SAXException {
        char c2;
        do {
            if ((c2 = this.getChar()) == ']') {
                if (!this.copyGen) break;
                this.handler.startElement("array", string, string, this.dummyAttr);
                this.characters(new char[0], 0, 0, ElementType.STRING);
                this.handler.endElement("", string, string);
                break;
            }
            this.handler.startElement(this.copyGen ? "array" : "", string, string, this.dummyAttr);
            if (c2 == '[') {
                this.getArray(string);
            } else {
                this.getValue(c2);
            }
            this.handler.endElement("", string, string);
        } while ((c2 = this.getChar()) == ',');
        if (c2 != ']') {
            this.exceptionChar(c2);
        }
    }

    private void getObject(char c2) throws IOException, SAXException {
        int n2 = 0;
        do {
            if ((c2 = this.getChar()) != '}') {
                ++n2;
                String string = this.getString(c2).toString();
                c2 = this.getChar();
                if (c2 == ':') {
                    c2 = this.getChar();
                    if (c2 == '[') {
                        this.getArray(string);
                        continue;
                    }
                    this.handler.startElement("", string, string, this.dummyAttr);
                    this.getValue(c2);
                    this.handler.endElement("", string, string);
                    continue;
                }
                this.exceptionChar(c2);
                continue;
            }
            this.ungetChar(c2);
        } while ((c2 = this.getChar()) == ',');
        if (c2 != '}') {
            this.exceptionChar(c2);
        }
        if (n2 == 0) {
            this.characters(new char[0], 0, 0, ElementType.STRING);
        }
    }

    public void parse(Reader reader, DefaultHandler defaultHandler, String string) throws IOException, SAXException {
        this.input = reader;
        this.rootName = string;
        this.handler = defaultHandler;
        try {
            char c2 = this.getChar();
            this.handler.startDocument();
            if (this.rootName != null) {
                this.handler.startElement("", this.rootName, this.rootName, this.dummyAttr);
            }
            try {
                switch (c2) {
                    case '{': {
                        this.getObject(c2);
                        break;
                    }
                    case '[': {
                        this.getArray("");
                        break;
                    }
                    default: {
                        this.exceptionChar(c2);
                        break;
                    }
                }
            }
            catch (EndOfFileException endOfFileException) {
                // empty catch block
            }
            if (this.rootName != null) {
                this.handler.endElement("", this.rootName, this.rootName);
            }
            this.handler.endDocument();
        }
        catch (EndOfFileException endOfFileException) {
            throw new SAXException("Void JSON file!");
        }
    }

    static class MyCharBuffer {
        private char[] buffer = new char[8];
        private int len;

        MyCharBuffer() {
        }

        public void append(char c2) {
            if (this.len == this.buffer.length) {
                char[] cArray = new char[this.len << 1];
                System.arraycopy(this.buffer, 0, cArray, 0, this.len);
                this.buffer = cArray;
            }
            this.buffer[this.len++] = c2;
        }

        public int length() {
            return this.len;
        }

        public char[] array() {
            return this.buffer;
        }

        public String toString() {
            return new String(this.buffer, 0, this.len);
        }
    }

    static class EndOfFileException
    extends IOException {
        EndOfFileException() {
        }
    }

    public static abstract class Handler
    extends DefaultHandler {
        public abstract void characters(char[] var1, int var2, int var3, ElementType var4) throws SAXException;
    }

    public static enum ElementType {
        STRING,
        NUMERIC,
        BOOLEAN;

    }
}

