/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.rts;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.zip.InflaterInputStream;

public class SMAPReader {
    private static final Map<String, Integer> formats;
    private byte[] orig;
    private int origPos;
    private int smapIdx;
    private String smap;
    private int newFormatLength;
    protected int newFormat;
    private String javaFile;
    private String fileName;
    private Vector<String> files = new Vector();
    private Vector<LineInfo> lines = new Vector();
    private Vector<String[]> copyStmts = new Vector();
    private Map<String, byte[]> copyResources = new HashMap<String, byte[]>();
    protected long timestamp;

    public SMAPReader(InputStream inputStream) throws IOException {
        this(inputStream, true);
    }

    protected SMAPReader(InputStream inputStream, boolean bl) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byte[] byArray = new byte[8192];
        int n2 = inputStream.read(byArray);
        while (n2 >= 0) {
            byteArrayOutputStream.write(byArray, 0, n2);
            n2 = inputStream.read(byArray);
        }
        byteArrayOutputStream.close();
        inputStream.close();
        this.orig = byteArrayOutputStream.toByteArray();
        this.skip(8);
        n2 = this.read2();
        this.smapIdx = this.scanConstantPool(n2);
        this.skip(6);
        int n3 = this.read2();
        this.skip(n3 * 2);
        this.skipMembers();
        this.skipMembers();
        int n4 = this.read2();
        this.smap = this.skipAttrs(n4);
        if (this.smap != null) {
            this.buildOld();
        } else {
            switch (this.newFormat) {
                case 1: {
                    this.buildOld2(this.newFormatLength);
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    this.build(this.newFormatLength);
                    break;
                }
                default: {
                    if (!bl) break;
                    throw new IOException("unknown SMAP format");
                }
            }
        }
    }

    int scanConstantPool(int n2) throws IOException {
        int n3 = -1;
        block7: for (int i2 = 1; i2 < n2; ++i2) {
            int n4 = this.read1();
            switch (n4) {
                case 1: {
                    String string = this.readUTF8String(this.read2());
                    Integer n5 = formats.get(string);
                    if (n5 == null) continue block7;
                    this.newFormat = n5;
                    n3 = i2;
                    continue block7;
                }
                case 7: 
                case 8: 
                case 16: {
                    this.skip(2);
                    continue block7;
                }
                case 3: 
                case 4: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 18: {
                    this.skip(4);
                    continue block7;
                }
                case 15: {
                    this.skip(3);
                    continue block7;
                }
                case 5: 
                case 6: {
                    this.skip(8);
                    ++i2;
                    continue block7;
                }
                default: {
                    throw new IOException("unexpected tag: " + n4);
                }
            }
        }
        return n3;
    }

    void skipMembers() throws UnsupportedEncodingException {
        int n2 = this.read2();
        for (int i2 = 0; i2 < n2; ++i2) {
            this.skip(6);
            int n3 = this.read2();
            this.skipAttrs(n3);
        }
    }

    private String skipAttrs(int n2) throws UnsupportedEncodingException {
        String string = null;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (this.read2() == this.smapIdx) {
                int n3 = this.read4();
                if (this.newFormat > 0) {
                    this.newFormatLength = n3;
                    break;
                }
                string = this.readUTF8String(n3);
                break;
            }
            this.skip(this.read4());
        }
        return string;
    }

    private void skip(int n2) {
        this.origPos += n2;
    }

    int read1() {
        return this.orig[this.origPos++] & 0xFF;
    }

    int read2() {
        return (this.read1() << 8) + this.read1();
    }

    int read4() {
        return (this.read2() << 16) + this.read2();
    }

    String readUTF8String(int n2) throws UnsupportedEncodingException {
        String string = new String(this.orig, this.origPos, n2, "UTF-8");
        this.origPos += n2;
        return string;
    }

    private void buildOld2(int n2) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.orig, this.origPos, n2);
        DataInputStream dataInputStream = new DataInputStream(new InflaterInputStream(byteArrayInputStream));
        this.buildOld2(dataInputStream);
        dataInputStream.close();
    }

    private void build(int n2) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.orig, this.origPos, n2);
        DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
        int n3 = dataInputStream.readInt();
        byte[] byArray = new byte[n3];
        dataInputStream.read(byArray);
        DataInputStream dataInputStream2 = new DataInputStream(new InflaterInputStream(new ByteArrayInputStream(byArray)));
        this.intBuild(dataInputStream2);
        this.buildExt(dataInputStream, dataInputStream2);
        dataInputStream2.close();
        dataInputStream.close();
    }

    protected void buildExt(DataInputStream dataInputStream, DataInputStream dataInputStream2) throws IOException {
    }

    protected void buildOld2(DataInputStream dataInputStream) throws IOException {
        this.intBuild(dataInputStream);
    }

    private void intBuild(DataInputStream dataInputStream) throws IOException {
        int n2;
        int n3;
        int n4 = dataInputStream.readInt();
        for (n3 = 0; n3 < n4; ++n3) {
            this.lines.addElement(new LineInfo(dataInputStream.readInt(), dataInputStream.readShort(), dataInputStream.readShort(), dataInputStream.readInt()));
        }
        this.readCopyStmts(dataInputStream);
        n3 = dataInputStream.readInt();
        for (n2 = 0; n2 < n3; ++n2) {
            this.files.addElement(dataInputStream.readUTF());
        }
        if (this.newFormat >= 3) {
            n2 = dataInputStream.readInt();
            for (int i2 = 0; i2 < n2; ++i2) {
                String string = dataInputStream.readUTF();
                byte[] byArray = new byte[dataInputStream.readInt()];
                dataInputStream.readFully(byArray);
                this.copyResources.put(string, byArray);
            }
            if (this.newFormat >= 5) {
                this.timestamp = dataInputStream.readLong();
            }
        }
        if (this.files.size() > 0) {
            this.fileName = this.files.elementAt(0);
        }
    }

    protected void readCopyStmts(DataInputStream dataInputStream) throws IOException {
        int n2 = dataInputStream.readInt();
        for (int i2 = 0; i2 < n2; ++i2) {
            this.copyStmts.addElement(new String[]{dataInputStream.readUTF(), Integer.toString(dataInputStream.readInt()), dataInputStream.readUTF(), Short.toString(dataInputStream.readShort()), Short.toString(dataInputStream.readShort())});
        }
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    private void buildOld() {
        StringTokenizer stringTokenizer = new StringTokenizer(this.smap, "\r\n");
        try {
            int n2;
            if ("SMAP".equals(stringTokenizer.nextToken())) {
                this.javaFile = stringTokenizer.nextToken();
                stringTokenizer.nextToken();
            }
            while (!"*S isCOBOL".equals(stringTokenizer.nextToken())) {
            }
            String string = stringTokenizer.nextToken();
            if ("*F".equals(string)) {
                string = stringTokenizer.nextToken();
                while (!"*L".equals(string)) {
                    int n3;
                    StringTokenizer stringTokenizer2 = new StringTokenizer(string, " ");
                    n2 = Integer.parseInt(stringTokenizer2.nextToken());
                    if (n2 >= this.files.size()) {
                        this.files.setSize(n2 + 1);
                    }
                    String string2 = stringTokenizer2.nextToken();
                    if (this.fileName == null && (n3 = string2.lastIndexOf(44)) >= 0) {
                        try {
                            int n4 = Integer.parseInt(string2.substring(n3 + 1));
                            if (n4 == 0) {
                                this.fileName = string2.substring(0, n3);
                            }
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                    }
                    this.files.setElementAt(string2, n2);
                    string = stringTokenizer.nextToken();
                }
            }
            if ("*L".equals(string)) {
                n2 = 0;
                while (stringTokenizer.hasMoreTokens() && (string = stringTokenizer.nextToken()).charAt(0) != '*') {
                    LineInfo lineInfo = new LineInfo(string, n2);
                    this.lines.add(lineInfo);
                    n2 = lineInfo.fileNum;
                }
            }
            if ("*C".equals(string)) {
                while (stringTokenizer.hasMoreTokens() && (string = stringTokenizer.nextToken()).charAt(0) != '*') {
                    this.copyStmts.add(string.split("\\,"));
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    public boolean isOk() {
        return !this.lines.isEmpty();
    }

    public CobolInfo getLineInfo(int n2) {
        return this.getLineInfo(n2, false);
    }

    private String getFileName(LineInfo lineInfo) {
        return lineInfo.fileName != null ? lineInfo.fileName : this.files.elementAt(lineInfo.fileIndex);
    }

    public CobolInfo getLineInfo(int n2, boolean bl) {
        CobolInfo cobolInfo = null;
        LineInfo lineInfo = null;
        int n3 = this.lines.size();
        for (int i2 = 0; i2 < n3; ++i2) {
            LineInfo lineInfo2 = this.lines.elementAt(i2);
            if (n2 >= lineInfo2.javaLine && n2 < lineInfo2.javaLine + lineInfo2.repeat) {
                cobolInfo = new CobolInfo(lineInfo2.cobLine + n2 - lineInfo2.javaLine, this.getFileName(lineInfo2), lineInfo2.fileNum, lineInfo2.fileIndex);
                break;
            }
            if (n2 < lineInfo2.javaLine) {
                if (bl || lineInfo == null) break;
                cobolInfo = new CobolInfo(lineInfo.cobLine + (lineInfo.repeat - 1), this.getFileName(lineInfo), lineInfo.fileNum, lineInfo.fileIndex);
                break;
            }
            lineInfo = lineInfo2;
        }
        if (cobolInfo == null && !bl) {
            cobolInfo = lineInfo != null ? new CobolInfo(lineInfo.cobLine + lineInfo.repeat - 1, this.getFileName(lineInfo), lineInfo.fileNum, lineInfo.fileIndex) : new CobolInfo(n2, this.javaFile, 0, 0);
        }
        return cobolInfo;
    }

    public String getFileName() {
        return this.fileName;
    }

    public Vector<String[]> getCopyStatements() {
        return this.copyStmts;
    }

    public Vector<String> getFileNames() {
        return this.files;
    }

    public Map<String, byte[]> getCopyResources() {
        return this.copyResources;
    }

    public int getSmapFormat() {
        return this.newFormat;
    }

    static {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        String string = "isCOBOLSourceDebugExtension";
        hashMap.put("SourceDebugExtension", 0);
        hashMap.put("isCOBOLSourceDebugExtension", 1);
        hashMap.put("isCOBOLSourceDebugExtension2", 2);
        hashMap.put("isCOBOLSourceDebugExtension3", 3);
        hashMap.put("isCOBOLSourceDebugExtension4", 4);
        hashMap.put("isCOBOLSourceDebugExtension5", 5);
        hashMap.put("isCOBOLSourceDebugExtension6", 6);
        formats = Collections.unmodifiableMap(hashMap);
    }

    private class LineInfo {
        public final int cobLine;
        public final int repeat;
        public final int javaLine;
        public final int fileNum;
        public final String fileName;
        public final int fileIndex;

        public LineInfo(int n2, int n3, int n4, int n5) {
            this.cobLine = n2;
            this.repeat = n4;
            this.javaLine = n5;
            this.fileIndex = n3;
            this.fileNum = n3;
            this.fileName = null;
        }

        public LineInfo(String string, int n2) {
            int n3;
            char[] cArray = string.toCharArray();
            int n4 = cArray.length;
            int n5 = 0;
            for (n3 = 0; n3 < n4 && cArray[n3] >= '0' && cArray[n3] <= '9'; ++n3) {
                n5 = n5 * 10 + (cArray[n3] - 48);
            }
            this.cobLine = n5;
            if (n3 < n4 && cArray[n3] == '#') {
                n5 = 0;
                ++n3;
                while (n3 < n4 && cArray[n3] >= '0' && cArray[n3] <= '9') {
                    n5 = n5 * 10 + (cArray[n3] - 48);
                    ++n3;
                }
                this.fileNum = n5;
            } else {
                this.fileNum = n2;
            }
            String string2 = (String)SMAPReader.this.files.elementAt(this.fileNum);
            int n6 = string2.lastIndexOf(44);
            if (n6 >= 0) {
                this.fileIndex = Integer.parseInt(string2.substring(n6 + 1));
                string2 = string2.substring(0, n6);
            } else {
                this.fileIndex = 0;
            }
            this.fileName = string2;
            if (n3 < n4 && cArray[n3] == ',') {
                n5 = 0;
                ++n3;
                while (n3 < n4 && cArray[n3] >= '0' && cArray[n3] <= '9') {
                    n5 = n5 * 10 + (cArray[n3] - 48);
                    ++n3;
                }
                this.repeat = n5;
            } else {
                this.repeat = 1;
            }
            if (n3 < n4 && cArray[n3] == ':') {
                n5 = 0;
                ++n3;
                while (n3 < n4 && cArray[n3] >= '0' && cArray[n3] <= '9') {
                    n5 = n5 * 10 + (cArray[n3] - 48);
                    ++n3;
                }
                this.javaLine = n5;
            } else {
                this.javaLine = 0;
            }
        }
    }

    public static class CobolInfo {
        public final int line;
        public final String fileName;
        public final int fileNum;
        public final int fileIndex;

        private CobolInfo(int n2, String string, int n3, int n4) {
            this.line = n2;
            this.fileName = string;
            this.fileNum = n3;
            this.fileIndex = n4;
        }
    }
}

