/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.rts;

import com.iscobol.rts.RtsUtil;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class SOAPEnvelopeParser
extends DefaultHandler {
    public static final String NAMESPACE1 = "http://schemas.xmlsoap.org/soap/envelope/";
    public static final String NAMESPACE2 = "http://www.w3.org/2003/05/soap-envelope";
    private static final int ST_ERR_INVALID_ENVELOPE = -1;
    private static final int ST_END_OK = 0;
    private static final int ST_START = 1;
    private static final int ST_ENVELOPE = 2;
    private static final int ST_BODY = 3;
    private int status = 1;
    private String methName;
    private String methURI;

    public SOAPEnvelopeParser(InputStream inputStream) throws IOException, ParserConfigurationException, SAXException {
        SAXParserFactory sAXParserFactory = RtsUtil.newSAXParserFactory();
        sAXParserFactory.setNamespaceAware(true);
        SAXParser sAXParser = sAXParserFactory.newSAXParser();
        sAXParser.parse(inputStream, (DefaultHandler)this);
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (this.status <= 0) {
            return;
        }
        if (this.status == 3) {
            this.methName = string2;
            this.methURI = string;
            this.status = 0;
        } else if ("Envelope".equalsIgnoreCase(string2) && this.isEnvelopeNS(string)) {
            this.status = this.status != 1 ? -1 : 2;
        } else if ("Body".equalsIgnoreCase(string2) && this.isEnvelopeNS(string)) {
            this.status = this.status != 2 ? -1 : 3;
        }
        if ("Body".equalsIgnoreCase(string2) && this.isEnvelopeNS(string)) {
            this.status = 3;
        }
    }

    private boolean isEnvelopeNS(String string) {
        return NAMESPACE1.equals(string) || NAMESPACE2.equals(string);
    }

    public String getMethodName() {
        return this.methName;
    }

    public String getMethodURI() {
        return this.methURI;
    }
}

