/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.rts;

import com.iscobol.rts.Config;
import com.iscobol.rts.IPicAnyLength;
import com.iscobol.rts.SortKey;
import com.iscobol.rts.VarType;

public class SortKeyItem
implements VarType {
    private static boolean littleEndian = Config.b(".little_endian", Config.e);
    private static final int[] zonedCS = new int[256];
    public final boolean descending;
    public final int type;
    private int offset;
    public final int size;
    public final int digits;
    private int signumOffset;
    private int compStart;
    private int compEnd;
    private int compInc;
    private SortKey parent;
    private IPicAnyLength anyLength;

    public SortKeyItem(boolean bl, int n2, IPicAnyLength iPicAnyLength, SortKey sortKey) {
        this(bl, n2, 0, 0, 0, sortKey);
        this.anyLength = iPicAnyLength;
    }

    public SortKeyItem(boolean bl, int n2, int n3, int n4, int n5, SortKey sortKey) {
        this.descending = bl;
        this.size = n4;
        this.digits = n5;
        this.parent = sortKey;
        this.setOffset(n3);
        this.compInc = 1;
        switch (n2) {
            case 0: 
            case 1: 
            case 7: 
            case 9: 
            case 10: 
            case 12: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 22: {
                this.type = n2;
                break;
            }
            case 15: {
                this.signumOffset = 0;
                this.type = this.size == 8 ? 99 : 15;
                if (!littleEndian) break;
                this.compStart = this.offset + this.size - 1;
                this.compEnd = this.offset - 1;
                this.compInc = -1;
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 8: {
                this.signumOffset = this.offset + this.size - 1;
                this.type = n2;
                break;
            }
            case 4: 
            case 5: 
            case 11: {
                this.signumOffset = this.offset;
                this.type = n2;
                break;
            }
            case 13: 
            case 14: {
                if (littleEndian) {
                    this.compStart = this.offset + this.size - 1;
                    this.compEnd = this.offset - 1;
                    this.compInc = -1;
                    this.signumOffset = this.offset;
                }
                this.signumOffset = this.compStart;
                this.type = n2;
                break;
            }
            default: {
                this.type = n2;
            }
        }
    }

    public int getOffset() {
        return this.offset;
    }

    private void setOffset(int n2) {
        this.compStart = this.offset = n2;
        this.compEnd = this.offset + this.size;
    }

    public void removeOffset(int n2) {
        if (this.anyLength == null) {
            this.offset -= n2;
            this.compStart -= n2;
            this.compEnd -= n2;
            this.signumOffset -= n2;
        }
    }

    private static boolean isPositive(byte by) {
        switch (by) {
            case 43: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 123: {
                return true;
            }
        }
        return false;
    }

    private int zoncmp(byte[] byArray, byte[] byArray2) {
        for (int i2 = this.compStart; i2 != this.compEnd; i2 += this.compInc) {
            int n2 = zonedCS[byArray[i2] & 0xFF] - zonedCS[byArray2[i2] & 0xFF];
            if (n2 == 0) continue;
            return n2;
        }
        return 0;
    }

    private int zoncmp(byte[] byArray, boolean bl, byte[] byArray2, boolean bl2) {
        if (bl) {
            if (bl2) {
                return -this.zoncmp(byArray, byArray2);
            }
            return -1;
        }
        if (!bl2) {
            return this.zoncmp(byArray, byArray2);
        }
        return 1;
    }

    private int memcmp(byte[] byArray, byte[] byArray2) {
        for (int i2 = this.compStart; i2 != this.compEnd; i2 += this.compInc) {
            int n2 = this.parent.colSeq[byArray[i2] & 0xFF] - this.parent.colSeq[byArray2[i2] & 0xFF];
            if (n2 == 0) continue;
            return n2;
        }
        return 0;
    }

    private int memcmpal(byte[] byArray, byte[] byArray2) {
        int n2 = byArray.length < byArray2.length ? byArray.length : byArray2.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3 = this.parent.colSeq[byArray[i2] & 0xFF] - this.parent.colSeq[byArray2[i2] & 0xFF];
            if (n3 == 0) continue;
            return n3;
        }
        return byArray.length - byArray2.length;
    }

    private int memcmp(byte[] byArray, boolean bl, byte[] byArray2, boolean bl2) {
        if (bl) {
            if (bl2) {
                return -this.memcmp(byArray, byArray2);
            }
            return -1;
        }
        if (!bl2) {
            return this.memcmp(byArray, byArray2);
        }
        return 1;
    }

    private int bincmp(byte[] byArray, boolean bl, byte[] byArray2, boolean bl2) {
        if (bl) {
            if (bl2) {
                return this.memcmp(byArray, byArray2);
            }
            return -1;
        }
        if (!bl2) {
            return this.memcmp(byArray, byArray2);
        }
        return 1;
    }

    private float toFloat(byte[] byArray) {
        int n2;
        int n3 = this.offset;
        if (littleEndian) {
            n2 = byArray[n3++] & 0xFF;
            n2 |= (byArray[n3++] & 0xFF) << 8;
            n2 |= (byArray[n3++] & 0xFF) << 16;
            n2 |= (byArray[n3++] & 0xFF) << 24;
        } else {
            n2 = (byArray[n3++] & 0xFF) << 24;
            n2 |= (byArray[n3++] & 0xFF) << 16;
            n2 |= (byArray[n3++] & 0xFF) << 8;
            n2 |= byArray[n3] & 0xFF;
        }
        return Float.intBitsToFloat(n2);
    }

    private double toDouble(byte[] byArray) {
        long l2;
        int n2 = this.offset;
        if (littleEndian) {
            l2 = (long)byArray[n2++] & 0xFFL;
            l2 |= ((long)byArray[n2++] & 0xFFL) << 8;
            l2 |= ((long)byArray[n2++] & 0xFFL) << 16;
            l2 |= ((long)byArray[n2++] & 0xFFL) << 24;
            l2 |= ((long)byArray[n2++] & 0xFFL) << 32;
            l2 |= ((long)byArray[n2++] & 0xFFL) << 40;
            l2 |= ((long)byArray[n2++] & 0xFFL) << 48;
            l2 |= ((long)byArray[n2] & 0xFFL) << 56;
        } else {
            l2 = ((long)byArray[n2++] & 0xFFL) << 56;
            l2 |= ((long)byArray[n2++] & 0xFFL) << 48;
            l2 |= ((long)byArray[n2++] & 0xFFL) << 40;
            l2 |= ((long)byArray[n2++] & 0xFFL) << 32;
            l2 |= ((long)byArray[n2++] & 0xFFL) << 24;
            l2 |= ((long)byArray[n2++] & 0xFFL) << 16;
            l2 |= ((long)byArray[n2++] & 0xFFL) << 8;
            l2 |= (long)byArray[n2] & 0xFFL;
        }
        return Double.longBitsToDouble(l2);
    }

    public int compare(int n2, int n3) {
        return this.compare(this.anyLength.intIAt(n2).getBytes(), this.anyLength.intIAt(n3).getBytes());
    }

    public int compare(byte[] byArray, byte[] byArray2) {
        int n2;
        switch (this.type) {
            default: {
                n2 = this.memcmp(byArray, byArray2);
                break;
            }
            case 16: {
                if (this.anyLength != null) {
                    n2 = this.memcmpal(byArray, byArray2);
                    break;
                }
                n2 = this.memcmp(byArray, byArray2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = this.zoncmp(byArray, !SortKeyItem.isPositive(byArray[this.signumOffset]), byArray2, !SortKeyItem.isPositive(byArray2[this.signumOffset]));
                break;
            }
            case 6: 
            case 8: {
                n2 = this.memcmp(byArray, (byArray[this.signumOffset] & 0xF) == 13, byArray2, (byArray2[this.signumOffset] & 0xF) == 13);
                break;
            }
            case 11: 
            case 13: {
                n2 = this.bincmp(byArray, (byArray[this.signumOffset] & 0x80) != 0, byArray2, (byArray2[this.signumOffset] & 0x80) != 0);
                break;
            }
            case 99: {
                double d2 = this.toDouble(byArray) - this.toDouble(byArray2);
                if (d2 > 0.0) {
                    n2 = 1;
                    break;
                }
                if (d2 < 0.0) {
                    n2 = -1;
                    break;
                }
                n2 = 0;
                break;
            }
            case 15: {
                float f2 = this.toFloat(byArray) - this.toFloat(byArray2);
                n2 = f2 > 0.0f ? 1 : (f2 < 0.0f ? -1 : 0);
            }
        }
        if (this.descending) {
            return -n2;
        }
        return n2;
    }

    public boolean isAnyLength() {
        return this.anyLength != null;
    }

    static {
        for (int i2 = 0; i2 < zonedCS.length; ++i2) {
            SortKeyItem.zonedCS[i2] = i2;
        }
        SortKeyItem.zonedCS[123] = 48;
        SortKeyItem.zonedCS[65] = 49;
        SortKeyItem.zonedCS[66] = 50;
        SortKeyItem.zonedCS[67] = 51;
        SortKeyItem.zonedCS[68] = 52;
        SortKeyItem.zonedCS[69] = 53;
        SortKeyItem.zonedCS[70] = 54;
        SortKeyItem.zonedCS[71] = 55;
        SortKeyItem.zonedCS[72] = 56;
        SortKeyItem.zonedCS[73] = 57;
    }
}

