/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.rts;

import com.iscobol.rts.Config;
import com.iscobol.rts.IscobolClass;
import com.iscobol.rts.IscobolRuntimeException;
import com.iscobol.rts.RuntimeErrorsNumbers;
import com.iscobol.rts.RuntimeProperties;

public class Version
implements RuntimeErrorsNumbers {
    public static final int major = RuntimeProperties.getVersionNumber();
    public static final int minor = RuntimeProperties.getReleaseNumber();
    public static final int spack = RuntimeProperties.getSpNumber();
    static final int build = RuntimeProperties.getBuildMainNumber();
    public static final String csVersion = "96";

    public static void main(String[] stringArray) {
        System.out.println(Config.a(".runtime.version", "version unknown"));
        System.out.println("DB " + Config.a(".file.index.version", "version unknown"));
        System.out.println("C/S Version " + Config.a(".runtime.cs.version", "c/s version unknown") + ", F/S Version " + Config.a(".runtime.fs.version", "f/s version unknown") + ", UID Version " + Version.getUIDVersion());
        if (stringArray.length > 0) {
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                try {
                    Class<?> clazz;
                    Object obj;
                    if (stringArray[i2].endsWith(".class")) {
                        stringArray[i2] = stringArray[i2].substring(0, stringArray[i2].length() - 6);
                    }
                    if ((obj = (clazz = Class.forName(stringArray[i2])).newInstance()) instanceof IscobolClass) {
                        IscobolClass iscobolClass = (IscobolClass)obj;
                        System.out.println(stringArray[i2] + " version#" + iscobolClass.iscobolVersion() + " require#" + iscobolClass.iscobolRequired());
                        continue;
                    }
                    System.out.println(stringArray[i2] + " not Iscobol object");
                    continue;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    System.out.println(classNotFoundException);
                    continue;
                }
                catch (InstantiationException instantiationException) {
                    System.out.println(instantiationException);
                    continue;
                }
                catch (IllegalAccessException illegalAccessException) {
                    System.out.println(illegalAccessException);
                }
            }
            System.exit(0);
        }
    }

    public static String getVersion() {
        return RuntimeProperties.getFullVersionNumber();
    }

    public static String getCsVersion() {
        return csVersion;
    }

    public static long getUIDVersion() {
        try {
            return Class.forName("com.iscobol.debugger.DebuggerConstants").getField("DEBUGGER_SERIAL_VERSION_UID").getLong(null);
        }
        catch (Exception exception) {
            return 0L;
        }
    }

    public static void checkVersion(IscobolClass iscobolClass) {
        if (iscobolClass.iscobolVersion() < 261 || iscobolClass.iscobolRequired() > build) {
            throw new IscobolRuntimeException(13, "rts=" + RuntimeProperties.getFullVersionNumber() + ",obj=" + iscobolClass.iscobolVersion());
        }
    }
}

