/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.rts;

import com.iscobol.rts.ICobolVar;
import com.iscobol.rts.IXMLAttributes;
import com.iscobol.rts.IscobolRuntimeException;
import com.iscobol.rts.RtsUtil;
import com.iscobol.rts.XMLException;
import java.io.IOException;
import java.io.StringReader;
import java.lang.reflect.Method;
import java.util.Enumeration;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;

public abstract class XMLParseGenerate
extends DefaultHandler
implements LexicalHandler {
    static final int START_OF_DOCUMENT = 0;
    static final int VERSION_INFORMATION = 1;
    static final int ENCODING_DECLARATION = 2;
    static final int STANDALONE_DECLARATION = 3;
    static final int DOCUMENT_TYPE_DECLARATION = 4;
    static final int COMMENT = 5;
    static final int START_OF_ELEMENT = 6;
    static final int ATTRIBUTE_NAME = 7;
    static final int ATTRIBUTE_CHARACTERS = 8;
    static final int ATTRIBUTE_CHARACTER = 9;
    static final int ATTRIBUTE_NATIONAL_CHARACTER = 10;
    static final int END_OF_ELEMENT = 11;
    static final int PROCESSING_INSTRUCTION_TARGET = 12;
    static final int PROCESSING_INSTRUCTION_DATA = 13;
    static final int CONTENT_CHARACTERS = 14;
    static final int CONTENT_CHARACTER = 15;
    static final int CONTENT_NATIONAL_CHARACTER = 16;
    static final int START_OF_CDATA_SECTION = 17;
    static final int END_OF_CDATA_SECTION = 18;
    static final int UNKNOWN_REFERENCE_IN_ATTRIBUTE = 19;
    static final int UNKNOWN_REFERENCE_IN_CONTENT = 20;
    static final int END_OF_DOCUMENT = 21;
    static final int EXCEPTION = 22;
    static final byte[][] events = new byte[][]{"START-OF-DOCUMENT             ".getBytes(), "VERSION-INFORMATION           ".getBytes(), "ENCODING-DECLARATION          ".getBytes(), "STANDALONE-DECLARATION        ".getBytes(), "DOCUMENT-TYPE-DECLARATION     ".getBytes(), "COMMENT                       ".getBytes(), "START-OF-ELEMENT              ".getBytes(), "ATTRIBUTE-NAME                ".getBytes(), "ATTRIBUTE-CHARACTERS          ".getBytes(), "ATTRIBUTE-CHARACTER           ".getBytes(), "ATTRIBUTE-NATIONAL-CHARACTER  ".getBytes(), "END-OF-ELEMENT                ".getBytes(), "PROCESSING-INSTRUCTION-TARGET ".getBytes(), "PROCESSING-INSTRUCTION-DATA   ".getBytes(), "CONTENT-CHARACTERS            ".getBytes(), "CONTENT-CHARACTER             ".getBytes(), "CONTENT-NATIONAL-CHARACTER    ".getBytes(), "START-OF-CDATA-SECTION        ".getBytes(), "END-OF-CDATA-SECTION          ".getBytes(), "UNKNOWN-REFERENCE-IN-ATTRIBUTE".getBytes(), "UNKNOWN-REFERENCE-IN-CONTENT  ".getBytes(), "END-OF-DOCUMENT               ".getBytes(), "EXCEPTION                     ".getBytes()};
    private final boolean versionOn = false;
    private final boolean standaloneOn = false;
    private final ICobolVar code;
    private final ICobolVar event;
    private final ICobolVar text;
    private final ICobolVar errmsg;
    private String source;
    private final SAXException stopParsing = new SAXException("");
    private SAXParser saxParser;
    private String version;
    private String encoding;
    private String standalone;

    public XMLParseGenerate(ICobolVar iCobolVar, ICobolVar iCobolVar2, ICobolVar iCobolVar3, ICobolVar iCobolVar4, ICobolVar iCobolVar5) {
        this.source = iCobolVar.toStringNoGui();
        this.code = iCobolVar2;
        this.event = iCobolVar3;
        this.text = iCobolVar4;
        this.errmsg = iCobolVar5;
    }

    public void parse() {
        SAXParserFactory sAXParserFactory = RtsUtil.newSAXParserFactory();
        try {
            this.saxParser = sAXParserFactory.newSAXParser();
            this.saxParser.getXMLReader().setProperty("http://xml.org/sax/properties/lexical-handler", this);
            this.saxParser.parse(new InputSource(new StringReader(this.source)), (DefaultHandler)this);
        }
        catch (IOException iOException) {
            throw new IscobolRuntimeException(iOException);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new IscobolRuntimeException(parserConfigurationException);
        }
        catch (SAXException sAXException) {
            Exception exception = sAXException.getException();
            if (exception == null) {
                exception = sAXException;
            }
            if (exception instanceof SAXException) {
                throw new XMLException(exception);
            }
            throw new IscobolRuntimeException(exception);
        }
    }

    public abstract void processing();

    private void progProcess(int n2) throws SAXException {
        this.code.set(n2);
        this.processing();
        n2 = this.code.toint();
        if (n2 == -1) {
            throw this.stopParsing;
        }
    }

    private void setStandalone() {
        if (this.standalone == null) {
            try {
                this.standalone = this.saxParser.getXMLReader().getFeature("http://xml.org/sax/features/is-standalone") ? "yes" : "no";
            }
            catch (Throwable throwable) {
                this.standalone = "unknown";
            }
        }
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        Method method;
        try {
            method = locator.getClass().getDeclaredMethod("getXMLVersion", null);
            this.version = method.invoke((Object)locator, null).toString();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            method = locator.getClass().getDeclaredMethod("getEncoding", null);
            this.encoding = method.invoke((Object)locator, null).toString();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public void startDocument() throws SAXException {
        super.startDocument();
        this.event.set(events[0]);
        this.text.set(this.source);
        this.progProcess(0);
        if (this.encoding != null) {
            this.event.set(events[2]);
            this.text.set(this.encoding);
            this.progProcess(0);
        }
    }

    @Override
    public void notationDecl(String string, String string2, String string3) throws SAXException {
        super.notationDecl(string, string2, string3);
    }

    @Override
    public void unparsedEntityDecl(String string, String string2, String string3, String string4) throws SAXException {
        super.notationDecl(string, string2, string3);
    }

    @Override
    public void endDocument() throws SAXException {
        this.text.set("");
        this.event.set(events[21]);
        this.progProcess(0);
    }

    @Override
    public void startPrefixMapping(String string, String string2) throws SAXException {
        super.startPrefixMapping(string, string2);
    }

    @Override
    public void endPrefixMapping(String string) throws SAXException {
        super.endPrefixMapping(string);
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        this.setStandalone();
        this.text.set(string3);
        this.event.set(events[6]);
        this.progProcess(0);
        int n2 = attributes.getLength();
        if (n2 > 0) {
            for (int i2 = 0; i2 < n2; ++i2) {
                this.text.set(attributes.getQName(i2));
                this.event.set(events[7]);
                this.progProcess(0);
                this.text.set(attributes.getValue(i2));
                this.event.set(events[8]);
                this.progProcess(0);
            }
        }
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
        this.text.set(string3);
        this.event.set(events[11]);
        this.progProcess(0);
    }

    @Override
    public void characters(char[] cArray, int n2, int n3) throws SAXException {
        int n4;
        for (n4 = 0; n4 < n3 && Character.isWhitespace(cArray[n4 + n2]); ++n4) {
        }
        if (n4 == n3) {
            return;
        }
        if (n3 == 2 && cArray[n2] >= '\ud800' && cArray[n2] <= '\udbff') {
            this.event.set(events[16]);
        } else if (n3 == 1 && (cArray[n2] == '&' || cArray[n2] == '\'' || cArray[n2] == '\"' || cArray[n2] == '<' || cArray[n2] == '>')) {
            this.event.set(events[15]);
        } else {
            this.event.set(events[14]);
        }
        this.text.set(new String(cArray, n2, n3));
        this.progProcess(0);
    }

    @Override
    public void ignorableWhitespace(char[] cArray, int n2, int n3) throws SAXException {
        super.ignorableWhitespace(cArray, n2, n3);
    }

    @Override
    public void processingInstruction(String string, String string2) throws SAXException {
        this.text.set(string);
        this.event.set(events[12]);
        this.progProcess(0);
        this.text.set(string2);
        this.event.set(events[13]);
        this.progProcess(0);
    }

    @Override
    public void skippedEntity(String string) throws SAXException {
        this.skippedEntity(string);
    }

    void procException(SAXParseException sAXParseException, int n2) throws SAXException {
        String string = System.getProperty("line.separator", "\n");
        int n3 = string.length();
        int n4 = sAXParseException.getLineNumber();
        int n5 = sAXParseException.getColumnNumber();
        int n6 = 0;
        for (int i2 = 1; i2 < n4 && (n6 = this.source.indexOf(string, n6)) >= 0; ++i2) {
            n6 += n3;
        }
        n6 += n5;
        if (--n6 > 0) {
            if (n6 < this.source.length()) {
                this.text.set(this.source.substring(0, n6));
            } else {
                this.text.set(this.source);
            }
        } else {
            this.text.set("");
        }
        this.errmsg.set("(" + n4 + ":" + n5 + ") " + sAXParseException.getMessage());
        this.event.set(events[22]);
        this.progProcess(n2);
        if (this.code.toint() != 0 && n2 < 100) {
            throw new SAXException(sAXParseException);
        }
    }

    @Override
    public void warning(SAXParseException sAXParseException) throws SAXException {
        this.procException(sAXParseException, 1);
    }

    @Override
    public void error(SAXParseException sAXParseException) throws SAXException {
        this.procException(sAXParseException, 10);
    }

    @Override
    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        this.procException(sAXParseException, 100);
    }

    @Override
    public void comment(char[] cArray, int n2, int n3) throws SAXException {
        this.setStandalone();
        this.text.set(new String(cArray, n2, n3));
        this.event.set(events[5]);
        this.progProcess(0);
    }

    @Override
    public void startCDATA() throws SAXException {
        this.setStandalone();
        this.text.set("<![CDATA[");
        this.event.set(events[17]);
        this.progProcess(0);
    }

    @Override
    public void endCDATA() throws SAXException {
        this.text.set("]]>");
        this.event.set(events[18]);
        this.progProcess(0);
    }

    @Override
    public void startEntity(String string) throws SAXException {
    }

    @Override
    public void endEntity(String string) throws SAXException {
    }

    @Override
    public void startDTD(String string, String string2, String string3) throws SAXException {
        this.setStandalone();
        if (string2 != null) {
            if (string3 != null) {
                this.text.set("<!DOCTYPE " + string + " PUBLIC \"" + string2 + "\" \"" + string3 + "\">'");
            } else {
                this.text.set("<!DOCTYPE " + string + " PUBLIC \"" + string2 + "\">'");
            }
        } else if (string3 != null) {
            this.text.set("<!DOCTYPE " + string + " SYSTEM \"" + string3 + "\">'");
        } else {
            this.text.set("<!DOCTYPE " + string + ">'");
        }
        this.event.set(events[4]);
        this.progProcess(0);
    }

    @Override
    public void endDTD() throws SAXException {
    }

    public static void generate(ICobolVar iCobolVar, ICobolVar iCobolVar2, ICobolVar iCobolVar3) {
        XMLParseGenerate.generate(iCobolVar, iCobolVar2, null, iCobolVar3, null);
    }

    public static void generate(ICobolVar iCobolVar, ICobolVar iCobolVar2, int[] nArray, ICobolVar iCobolVar3) {
        XMLParseGenerate.generate(iCobolVar, iCobolVar2, nArray, iCobolVar3, null);
    }

    public static void generate(ICobolVar iCobolVar, ICobolVar iCobolVar2, int[] nArray, ICobolVar iCobolVar3, ICobolVar iCobolVar4) {
        StringBuffer stringBuffer = new StringBuffer();
        XMLParseGenerate.scanElement(iCobolVar2, null, stringBuffer, "", nArray);
        iCobolVar.set(stringBuffer.toString(), false);
        int n2 = iCobolVar.length();
        int n3 = stringBuffer.length();
        if (n3 > n2) {
            n3 = n2;
        }
        if (iCobolVar3 != null) {
            iCobolVar3.set(n3);
        }
        if (stringBuffer.length() > iCobolVar.length()) {
            if (iCobolVar4 != null) {
                iCobolVar4.set(400);
            }
            throw new XMLException(new SAXException("Buffer overflow"));
        }
        if (iCobolVar4 != null) {
            iCobolVar4.set(0);
        }
    }

    private static String myTrim(ICobolVar iCobolVar) {
        String string = iCobolVar.toStringNoGui();
        for (int i2 = string.length() - 1; i2 >= 0; --i2) {
            if (string.charAt(i2) == ' ') continue;
            return string.substring(0, i2 + 1);
        }
        return " ";
    }

    private static void scanElement(ICobolVar iCobolVar, int[] nArray, StringBuffer stringBuffer, String string, int[] nArray2) {
        int[] nArray3 = iCobolVar.getDimensions();
        if (nArray == null) {
            if (nArray3 == null) {
                XMLParseGenerate.writeElement(iCobolVar, nArray, stringBuffer, string, nArray2);
            } else {
                int n2;
                int n3 = n2 = nArray2 == null ? 0 : nArray2.length;
                if (nArray3.length > n2) {
                    iCobolVar.getLastDimension();
                    nArray = new int[n2 + 1];
                    int n4 = 1;
                    while (n4 <= nArray3[n2]) {
                        nArray[n2] = n4++;
                        XMLParseGenerate.scanElement(iCobolVar, nArray, stringBuffer, string, nArray2);
                    }
                } else {
                    XMLParseGenerate.writeElement(iCobolVar, nArray2, stringBuffer, string, nArray2);
                }
            }
        } else if (nArray.length == nArray3.length) {
            XMLParseGenerate.writeElement(iCobolVar, nArray, stringBuffer, string, nArray2);
        } else {
            int n5;
            int[] nArray4 = new int[nArray3.length];
            for (n5 = 0; n5 < nArray.length; ++n5) {
                nArray4[n5] = nArray[n5];
            }
            nArray = nArray4;
            n5 = 1;
            while (n5 <= nArray3[nArray3.length - 1]) {
                nArray[nArray3.length - 1] = n5++;
                XMLParseGenerate.scanElement(iCobolVar, nArray, stringBuffer, string, nArray2);
            }
        }
    }

    private static void writeElement(ICobolVar iCobolVar, int[] nArray, StringBuffer stringBuffer, String string, int[] nArray2) {
        String string2;
        IXMLAttributes iXMLAttributes = iCobolVar.getIXMLAttributes();
        Enumeration enumeration = iCobolVar.getChildren();
        if (iXMLAttributes == null || (string2 = iXMLAttributes.getIdentifier()) == null) {
            string2 = iCobolVar.getName();
        }
        if ("FILLER".equals(string2)) {
            return;
        }
        if (enumeration != null && enumeration.hasMoreElements()) {
            stringBuffer.append(string);
            stringBuffer.append("<");
            stringBuffer.append(string2);
            stringBuffer.append(">");
            enumeration = iCobolVar.getChildren();
            while (enumeration.hasMoreElements()) {
                ICobolVar iCobolVar2 = (ICobolVar)enumeration.nextElement();
                XMLParseGenerate.scanElement(iCobolVar2, nArray, stringBuffer, string + "", nArray2);
            }
            stringBuffer.append(string);
        } else {
            int n2;
            String string3 = nArray == null ? XMLParseGenerate.myTrim(iCobolVar) : XMLParseGenerate.myTrim(iCobolVar.intIAt(nArray));
            int n3 = string3.length();
            StringBuffer stringBuffer2 = null;
            block8: for (n2 = 0; n2 < n3; ++n2) {
                char c2 = string3.charAt(n2);
                switch (c2) {
                    case '<': {
                        if (stringBuffer2 == null) {
                            stringBuffer2 = new StringBuffer(string3.substring(0, n2));
                        }
                        stringBuffer2.append("&lt;");
                        continue block8;
                    }
                    case '&': {
                        if (stringBuffer2 == null) {
                            stringBuffer2 = new StringBuffer(string3.substring(0, n2));
                        }
                        stringBuffer2.append("&amp;");
                        continue block8;
                    }
                    case '>': {
                        if (stringBuffer2 == null) {
                            stringBuffer2 = new StringBuffer(string3.substring(0, n2));
                        }
                        stringBuffer2.append("&gt;");
                        continue block8;
                    }
                    case '\"': {
                        if (stringBuffer2 == null) {
                            stringBuffer2 = new StringBuffer(string3.substring(0, n2));
                        }
                        stringBuffer2.append("&quot;");
                        continue block8;
                    }
                    case '\'': {
                        if (stringBuffer2 == null) {
                            stringBuffer2 = new StringBuffer(string3.substring(0, n2));
                        }
                        stringBuffer2.append("&apos;");
                        continue block8;
                    }
                    default: {
                        if (c2 < ' ') break block8;
                        if (stringBuffer2 == null) continue block8;
                        stringBuffer2.append(c2);
                    }
                }
            }
            if (n2 < n3) {
                stringBuffer2 = new StringBuffer();
                string2 = "hex." + string2;
                byte[] byArray = iCobolVar.getBytes();
                for (n2 = 0; n2 < byArray.length; ++n2) {
                    int n4 = byArray[n2] & 0xFF;
                    if (n4 < 16) {
                        stringBuffer2.append("0");
                    }
                    stringBuffer2.append(Integer.toHexString(n4).toUpperCase());
                }
                string3 = stringBuffer2.toString();
            } else if (stringBuffer2 != null) {
                string3 = stringBuffer2.toString();
            }
            stringBuffer.append(string);
            stringBuffer.append("<");
            stringBuffer.append(string2);
            stringBuffer.append(">");
            stringBuffer.append(string3);
        }
        stringBuffer.append("</");
        stringBuffer.append(string2);
        stringBuffer.append(">");
    }
}

