/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.rts;

import com.iscobol.rts.Base64;
import com.iscobol.rts.Config;
import com.iscobol.rts.Factory;
import com.iscobol.rts.ICobolVar;
import com.iscobol.rts.INumericVar;
import com.iscobol.rts.IPicNumEdit;
import com.iscobol.rts.IXMLAttributes;
import com.iscobol.rts.IscobolRuntimeException;
import com.iscobol.rts.RtsUtil;
import com.iscobol.types.CobolNum;
import com.iscobol.types.CobolVar;
import com.iscobol.types.PicX;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Stack;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.DefaultHandler;

public class XMLStream
extends DefaultHandler {
    static final int XML_SUCCESS = 1;
    static final int XML_BAD_ARGUMENT = -1;
    protected ICobolVar xmlVar;
    private XmlNode xmlRoot;
    protected PrintWriter out;
    private Map<String, String> writeNsPrefixes;
    protected boolean omitEmptyElements = true;
    protected boolean initializeOnRead;
    protected boolean rtrim;
    protected boolean resolveRefs;
    private int prog;
    private Map<String, String> globalNamespaces = new HashMap<String, String>();
    private List<DeferredElement> deferredElements = new ArrayList<DeferredElement>();
    protected Stack<Node> varStack;
    private Node last;
    private TransformerHandler hd;
    private Properties outputProperties;
    private boolean mtomEnabled;
    private Map<String, ICobolVar> mtomItems = new HashMap<String, ICobolVar>();
    private String schemaLocation;
    private boolean writeSchemaLocation;
    private boolean addLineFeed;
    private final boolean isInXmlFile;
    private XmlNode startNode;
    private int startNodeIndex = 1;
    private boolean startNodeAttr;

    public XMLStream(ICobolVar iCobolVar) {
        this(iCobolVar, false, false);
    }

    public XMLStream(CobolVar cobolVar) {
        this((ICobolVar)cobolVar, false, false);
    }

    public XMLStream(CobolVar cobolVar, boolean bl, boolean bl2) {
        this((ICobolVar)cobolVar, bl, bl2);
    }

    public XMLStream(ICobolVar iCobolVar, boolean bl, boolean bl2) {
        if (!(bl || iCobolVar != null && iCobolVar.getIXMLAttributes() != null)) {
            throw new IllegalArgumentException(iCobolVar.getName());
        }
        this.xmlVar = iCobolVar;
        this.isInXmlFile = bl;
        this.addLineFeed = bl2;
    }

    public final int readFromFile(String string) {
        return this.read(string, null);
    }

    public final int readFromFile(String string, String string2) {
        return this.read(string, string2);
    }

    public final int read(String string) {
        return this.read(string, null);
    }

    public final int read(String string, String string2) {
        InputStream inputStream;
        if (string != null) {
            try {
                inputStream = new FileInputStream(string.trim());
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new IscobolRuntimeException(130, fileNotFoundException.getMessage());
            }
        } else {
            inputStream = System.in;
        }
        return this.readFromStream(inputStream, string2);
    }

    public final int readFromString(String string) {
        return this.read(new StringReader(string));
    }

    public final int readFromString(String string, String string2) {
        return this.read(new StringReader(string));
    }

    public final int readFromStream(InputStream inputStream) {
        return this.readFromStream(inputStream, null);
    }

    public final int readFromStream(InputStream inputStream, String string) {
        if (string != null) {
            return this.read(new InputStreamReader(inputStream, Charset.forName(string)));
        }
        return this.read(inputStream);
    }

    public boolean isOk() {
        return this.varStack != null && this.varStack.isEmpty();
    }

    protected int read(InputStream inputStream) {
        Object object;
        this.readConfiguration();
        InputStream inputStream2 = null;
        if (this.resolveRefs) {
            object = new XMLReferenceResolver(new InputStreamReader(inputStream));
            inputStream = inputStream2 = ((XMLReferenceResolver)object).resolveReferencesIS();
        }
        if (this.initializeOnRead) {
            this.xmlVar.initialize(null, null, true);
        }
        this.last = null;
        this.varStack = new Stack();
        this.pushNode(this.xmlVar, null, null);
        object = RtsUtil.newSAXParserFactory();
        ((SAXParserFactory)object).setNamespaceAware(true);
        try {
            SAXParser sAXParser = ((SAXParserFactory)object).newSAXParser();
            InputSource inputSource = new InputSource(inputStream);
            sAXParser.parse(inputSource, (DefaultHandler)this);
            if (inputStream2 != null) {
                inputStream2.close();
            }
        }
        catch (IOException iOException) {
            throw new IscobolRuntimeException(iOException);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new IscobolRuntimeException(parserConfigurationException);
        }
        catch (SAXException sAXException) {
            if (sAXException.getException() != null) {
                throw new IscobolRuntimeException(sAXException.getException());
            }
            throw new IscobolRuntimeException(sAXException);
        }
        return 1;
    }

    protected int read(Reader reader) {
        Object object;
        this.readConfiguration();
        Reader reader2 = null;
        if (this.resolveRefs) {
            object = new XMLReferenceResolver(reader);
            reader = reader2 = ((XMLReferenceResolver)object).resolveReferences();
        }
        if (this.initializeOnRead) {
            this.xmlVar.initialize(null, null, true);
        }
        this.last = null;
        this.varStack = new Stack();
        this.pushNode(this.xmlVar, null, null);
        object = RtsUtil.newSAXParserFactory();
        ((SAXParserFactory)object).setNamespaceAware(true);
        try {
            SAXParser sAXParser = ((SAXParserFactory)object).newSAXParser();
            InputSource inputSource = new InputSource(reader);
            sAXParser.parse(inputSource, (DefaultHandler)this);
            if (reader2 != null) {
                reader2.close();
            }
        }
        catch (IOException iOException) {
            throw new IscobolRuntimeException(iOException);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new IscobolRuntimeException(parserConfigurationException);
        }
        catch (SAXException sAXException) {
            if (sAXException.getException() != null) {
                throw new IscobolRuntimeException(sAXException.getException());
            }
            throw new IscobolRuntimeException(sAXException);
        }
        return 1;
    }

    private boolean tagcmp(IXMLAttributes iXMLAttributes, Attributes attributes, int n2) {
        String string;
        String string2 = iXMLAttributes.getNamespace();
        String string3 = iXMLAttributes.getIdentifier();
        String string4 = attributes.getURI(n2);
        String string5 = attributes.getLocalName(n2);
        int n3 = string3.indexOf(58);
        if (n3 >= 0 && (string = this.globalNamespaces.get(string3.substring(0, n3))) != null) {
            string2 = string;
            string3 = string3.substring(n3 + 1);
        }
        return string3.equalsIgnoreCase(string5) && string2.equals(string4);
    }

    private boolean tagcmp(String string, String string2, Node node) {
        String string3;
        String string4 = node.name;
        String string5 = node.uri;
        int n2 = string4.indexOf(58);
        if (n2 >= 0 && (string3 = this.globalNamespaces.get(string4.substring(0, n2))) != null) {
            string5 = string3;
            string4 = string4.substring(n2 + 1);
        }
        return string2.equalsIgnoreCase(string4) && string.equals(string5);
    }

    private boolean tagcmp(String string, String string2, IXMLAttributes iXMLAttributes) {
        String string3;
        String string4 = iXMLAttributes.getIdentifier();
        String string5 = iXMLAttributes.getNamespace();
        int n2 = string4.indexOf(58);
        if (n2 >= 0 && (string3 = this.globalNamespaces.get(string4.substring(0, n2))) != null) {
            string5 = string3;
            string4 = string4.substring(n2 + 1);
        }
        return string2.equalsIgnoreCase(string4) && string.equals(string5);
    }

    protected void pushNode(ICobolVar iCobolVar, int[] nArray, Attributes attributes) {
        IXMLAttributes iXMLAttributes = iCobolVar.getIXMLAttributes();
        Enumeration enumeration = iCobolVar.getChildren();
        int[] nArray2 = iCobolVar.getDimensions();
        if (nArray2 != null) {
            if (nArray == null) {
                nArray = new int[]{1};
            } else if (nArray.length != nArray2.length) {
                for (int i2 = 0; i2 < nArray.length; ++i2) {
                    nArray2[i2] = nArray[i2];
                }
                nArray2[nArray.length] = 1;
                nArray = nArray2;
            }
        }
        if (!(iXMLAttributes == null || iXMLAttributes.isCDATA() || iXMLAttributes.isProcessingInstruction() || iXMLAttributes.isAttribute())) {
            Object object;
            Object object2;
            Node node = this.newNode(iCobolVar, nArray, iXMLAttributes.getNamespace(), iXMLAttributes.getIdentifier());
            if (attributes != null) {
                node.attrs = new Attrs(attributes);
            }
            if (enumeration.hasMoreElements()) {
                enumeration = iCobolVar.getChildren();
                while (enumeration.hasMoreElements()) {
                    ICobolVar iCobolVar2 = (ICobolVar)enumeration.nextElement();
                    IXMLAttributes iXMLAttributes2 = iCobolVar2.getIXMLAttributes();
                    if (iXMLAttributes2 != null && !iXMLAttributes.isCDATA() && !iXMLAttributes.isProcessingInstruction()) {
                        if (iXMLAttributes2.isAttribute()) {
                            if (iXMLAttributes2.isFinal()) {
                                if (iXMLAttributes2.getIdentifier().startsWith("xmlns:")) {
                                    object2 = iXMLAttributes2.getIdentifier().substring(6);
                                    object = iCobolVar2.toStringNoGui();
                                    this.globalNamespaces.put((String)object2, (String)object);
                                    node.namespaces.put(object2, object);
                                }
                                node.finalAttr.addElement(iCobolVar2);
                                node.attrCount.addElement(new int[1]);
                                continue;
                            }
                            iXMLAttributes2.clear();
                            node.varAttr.addElement(iCobolVar2);
                            continue;
                        }
                        node.next.addElement(iCobolVar2);
                        continue;
                    }
                    if (node.data != null || !iXMLAttributes.isFinal() && iCobolVar2 == iXMLAttributes.getIdentifierVar()) continue;
                    node.data = iCobolVar2;
                }
            } else if (node.data == null) {
                node.data = iCobolVar;
            }
            if (this.isInXmlFile) {
                object2 = (XmlNode)node;
                if (this.xmlRoot == null) {
                    this.xmlRoot = object2;
                } else if (!this.varStack.isEmpty()) {
                    object = (XmlNode)this.varStack.peek();
                    ((XmlNode)object).children.addElement((XmlNode)object2);
                    ((XmlNode)object2).parent = object;
                }
            }
            this.varStack.push(node);
        }
    }

    private void set(ICobolVar iCobolVar, int[] nArray, String string) {
        this.set(iCobolVar, nArray, string, null);
    }

    private void set(ICobolVar iCobolVar, int[] nArray, String string, boolean[] blArray) {
        Object[] objectArray;
        ICobolVar iCobolVar2 = this.getVar(iCobolVar, nArray);
        if (iCobolVar2 == null) {
            return;
        }
        boolean bl = false;
        if (blArray != null) {
            if (blArray[1]) {
                objectArray = Base64.decode(string.getBytes());
                if (objectArray != null) {
                    iCobolVar2.set((byte[])objectArray);
                }
            } else if (blArray[2]) {
                iCobolVar2.set(RtsUtil.hexToBytes(string));
            } else if (blArray[3]) {
                boolean bl2 = Boolean.parseBoolean(string);
                if (iCobolVar2 instanceof INumericVar) {
                    iCobolVar2.set(bl2 ? 1 : 0);
                } else {
                    iCobolVar2.set("" + bl2);
                }
            } else {
                bl = true;
            }
        } else {
            bl = true;
        }
        if (bl) {
            if (iCobolVar2 instanceof IPicNumEdit) {
                objectArray = new boolean[1];
                iCobolVar2.set(CobolNum.valueOf(string, iCobolVar2.isDecimalPointComma(), (boolean[])objectArray));
                if (objectArray[0] != 0) {
                    iCobolVar2.set(string);
                }
            } else {
                iCobolVar2.set(string);
            }
        }
    }

    private ICobolVar getVar(ICobolVar iCobolVar, int[] nArray) {
        ICobolVar iCobolVar2 = null;
        if (nArray == null) {
            iCobolVar2 = iCobolVar;
        } else {
            try {
                iCobolVar2 = iCobolVar.intIAt(nArray);
            }
            catch (IscobolRuntimeException iscobolRuntimeException) {
                if (iscobolRuntimeException.getErrNum() != 1) {
                    throw iscobolRuntimeException;
                }
                System.out.print("XMLOutOfBound " + iCobolVar.getName() + "[");
                for (int i2 = 0; i2 < nArray.length; ++i2) {
                    System.out.print("" + nArray[i2] + " ");
                }
                System.out.println("]");
            }
        }
        return iCobolVar2;
    }

    @Override
    public void startDocument() throws SAXException {
        super.startDocument();
    }

    @Override
    public void endDocument() throws SAXException {
        super.endDocument();
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        Object object;
        int n2;
        if (this.isInXmlFile && this.schemaLocation == null) {
            for (n2 = 0; n2 < attributes.getLength(); ++n2) {
                if (!"schemaLocation".equals(attributes.getLocalName(n2)) && !"noNamespaceSchemaLocation".equals(attributes.getLocalName(n2)) || !"http://www.w3.org/2001/XMLSchema-instance".equals(attributes.getURI(n2))) continue;
                this.schemaLocation = attributes.getValue(n2);
                break;
            }
        }
        if (this.varStack.isEmpty()) {
            throw new SAXException("Empty stack on start element " + string3);
        }
        Node node = this.varStack.peek();
        if (this.isInXmlFile) {
            Attrs attrs = new Attrs(attributes);
            object = new BaseNode(string, string2);
            if (node.attrs != null) {
                ((BaseNode)object).attrs = attrs;
            } else {
                node.attrs = attrs;
            }
            ((XmlNode)node).xmlChildren.addElement((BaseNode)object);
        }
        if (this.last != null && this.tagcmp(string, string2, this.last)) {
            this.varStack.push(this.last);
            ICobolVar iCobolVar = this.last.var.getIParent();
            if (iCobolVar != null && this.last.var.getDimensions() != iCobolVar.getDimensions()) {
                this.last.clearData();
                int n3 = this.last.dim.length - 1;
                this.last.dim[n3] = this.last.dim[n3] + 1;
                this.last.sted = false;
                this.last = null;
                this.startElement(string, string2, string3, attributes);
            }
        } else if (!node.sted && this.tagcmp(string, string2, node) || !node.xml.isFinal()) {
            block1: for (n2 = 0; n2 < attributes.getLength(); ++n2) {
                IXMLAttributes iXMLAttributes;
                ICobolVar iCobolVar;
                int n4;
                for (n4 = 0; n4 < node.finalAttr.size(); ++n4) {
                    iCobolVar = node.finalAttr.elementAt(n4);
                    iXMLAttributes = iCobolVar.getIXMLAttributes();
                    if (!this.tagcmp(iXMLAttributes, attributes, n2)) continue;
                    this.set(iCobolVar, node.dim, attributes.getValue(n2));
                    int[] nArray = node.attrCount.elementAt(n4);
                    nArray[0] = this.incrCount(iXMLAttributes, node.dim, nArray[0]);
                    break;
                }
                if (n4 < node.finalAttr.size()) continue;
                for (n4 = 0; n4 < node.varAttr.size(); ++n4) {
                    iCobolVar = node.varAttr.elementAt(n4);
                    iXMLAttributes = iCobolVar.getIXMLAttributes();
                    if (iXMLAttributes.getIdentifier().length() != 0) continue;
                    iXMLAttributes.setIdentifier(attributes.getLocalName(n2));
                    boolean bl = false;
                    Enumeration enumeration = iCobolVar.getChildren();
                    while (enumeration.hasMoreElements()) {
                        ICobolVar iCobolVar2 = (ICobolVar)enumeration.nextElement();
                        if (iCobolVar2 == iXMLAttributes.getIdentifierVar()) continue;
                        this.set(iCobolVar2, node.dim, attributes.getValue(n2));
                        bl = true;
                        break;
                    }
                    if (bl) continue block1;
                    this.set(iCobolVar, node.dim, attributes.getValue(n2));
                    continue block1;
                }
            }
            if (!node.xml.isFinal()) {
                node.xml.setIdentifier(string2);
                node.xml.setNamespace(string);
                if (node.next.size() > 0) {
                    this.pushNode(node.next.elementAt(0), node.dim, null);
                }
            }
            node.count = this.incrCount(node.xml, node.dim, node.count);
            node.sted = true;
        } else if (this.resolveRefs) {
            object = new HashMap();
            String string4 = "";
            if (node.dim != null) {
                for (int i2 = 0; i2 < node.dim.length; ++i2) {
                    string4 = string4 + node.dim[i2] + " ";
                }
            }
            for (n2 = 0; n2 < node.next.size(); ++n2) {
                int[] nArray;
                int[] nArray2;
                ICobolVar iCobolVar = node.next.elementAt(n2);
                IXMLAttributes iXMLAttributes = iCobolVar.getIXMLAttributes();
                if (!this.tagcmp(string, string2, iXMLAttributes) && iXMLAttributes.isFinal()) continue;
                if (this.isOccurs(iCobolVar)) {
                    this.pushChildNode(string2, string3, node, string, attributes, iXMLAttributes, iCobolVar);
                    break;
                }
                if (!string4.equals(node.dimStr)) {
                    node.counters.clear();
                    node.dimStr = string4;
                }
                if ((nArray2 = (int[])object.get(string2)) == null) {
                    nArray2 = new int[1];
                    object.put(string2, nArray2);
                }
                if ((nArray = node.counters.get(string2)) == null) {
                    nArray = new int[1];
                    node.counters.put(string2, nArray);
                }
                if (nArray2[0] == nArray[0]) {
                    this.pushChildNode(string2, string3, node, string, attributes, iXMLAttributes, iCobolVar);
                    nArray[0] = nArray[0] + 1;
                    break;
                }
                nArray2[0] = nArray2[0] + 1;
            }
            if (n2 >= node.next.size()) {
                PicX picX = new PicX("");
                picX.setIdentifier(new PicX(string2), false);
                picX.setNamespace(new PicX(string), false);
                this.pushNode(picX, null, attributes);
                this.startElement(string, string2, string3, attributes);
            }
        } else {
            for (n2 = node.next.size() - 1; n2 >= 0; --n2) {
                ICobolVar iCobolVar = node.next.elementAt(n2);
                IXMLAttributes iXMLAttributes = iCobolVar.getIXMLAttributes();
                if (!this.tagcmp(string, string2, iXMLAttributes) && iXMLAttributes.isFinal()) continue;
                this.pushChildNode(string2, string3, node, string, attributes, iXMLAttributes, iCobolVar);
                break;
            }
            if (n2 < 0) {
                object = new PicX("");
                ((CobolVar)object).setIdentifier(new PicX(string2), false);
                ((CobolVar)object).setNamespace(new PicX(string), false);
                this.pushNode((ICobolVar)object, null, attributes);
                this.startElement(string, string2, string3, attributes);
            }
        }
        this.last = null;
    }

    private void pushChildNode(String string, String string2, Node node, String string3, Attributes attributes, IXMLAttributes iXMLAttributes, ICobolVar iCobolVar) throws SAXException {
        if (!iXMLAttributes.isFinal()) {
            iXMLAttributes.setIdentifier(string);
            iXMLAttributes.setNamespace(string3);
        }
        this.pushNode(iCobolVar, node.dim, attributes);
        this.startElement(string3, string, string2, attributes);
    }

    @Override
    public void characters(char[] cArray, int n2, int n3) throws SAXException {
        if (this.varStack.isEmpty()) {
            throw new SAXException("Empty stack on characters, last=" + this.last);
        }
        Node node = this.varStack.peek();
        node.cdata.append(cArray, n2, n3);
    }

    private boolean isOccurs(ICobolVar iCobolVar) {
        int[] nArray = iCobolVar.getDimensions();
        if (nArray != null) {
            ICobolVar iCobolVar2 = iCobolVar.getIParent();
            int[] nArray2 = iCobolVar2 != null ? iCobolVar2.getDimensions() : null;
            if (nArray2 != null) {
                return nArray2.length < nArray.length;
            }
            return true;
        }
        return false;
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
        boolean[] blArray;
        ICobolVar iCobolVar;
        if (this.varStack.isEmpty()) {
            throw new SAXException("Empty stack on end element " + string3);
        }
        Node node = this.varStack.pop();
        Object object = node.namespaces.keySet().iterator();
        while (object.hasNext()) {
            this.globalNamespaces.remove(object.next());
        }
        if (this.mtomEnabled && this.mtomItems != null && "Include".equals(string2) && "http://www.w3.org/2004/08/xop/include".equals(string) && node.attrs != null && (object = node.attrs.getValue("href")) != null && ((String)object).startsWith("cid:") && (iCobolVar = this.mtomItems.get(((String)object).substring(4))) != null && !this.varStack.isEmpty()) {
            ICobolVar iCobolVar2;
            Node node2 = this.varStack.peek();
            blArray = null;
            if (node2.xml != null) {
                blArray = XMLStream.getFlags(node2.xml);
            }
            if (blArray != null && (blArray[1] || blArray[2]) && node2.data != null && (iCobolVar2 = this.getVar(node2.data, node2.dim)) != null) {
                iCobolVar2.set(iCobolVar.getBytes());
                node2.data = null;
                return;
            }
        }
        if (!this.resolveRefs || this.isOccurs(node.var)) {
            this.last = node;
        }
        if (node.data != null) {
            blArray = null;
            if (node.xml != null) {
                blArray = XMLStream.getFlags(node.xml);
            }
            this.set(node.data, node.dim, node.cdata.toString(), blArray);
        }
    }

    public void setOutputProperty(String string, String string2) {
        if (this.outputProperties == null) {
            this.outputProperties = new Properties();
        }
        this.outputProperties.setProperty(string.trim(), string2.trim());
    }

    public void setPrintWriter(PrintWriter printWriter) {
        this.out = printWriter;
        this.createTransformerHandler();
    }

    public final void setOutputStream(OutputStream outputStream) {
        this.setOutputStream(outputStream, null);
    }

    public void setOutputStream(OutputStream outputStream, String string) {
        PrintWriter printWriter = string != null ? new PrintWriter(new OutputStreamWriter(outputStream, Charset.forName(string))) : new PrintWriter(outputStream);
        this.setPrintWriter(printWriter);
    }

    public final void setFileName(String string) {
        this.setFileName(string, null);
    }

    public void setFileName(String string, String string2) {
        if (string != null) {
            try {
                if (string2 != null) {
                    this.out = new PrintWriter(string.trim(), string2);
                }
                this.out = new PrintWriter(string.trim());
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new IscobolRuntimeException(130, fileNotFoundException.getMessage());
            }
            catch (IOException iOException) {
                throw new IscobolRuntimeException(133, iOException.getMessage());
            }
        } else {
            this.out = new PrintWriter(System.out);
        }
        this.createTransformerHandler();
    }

    private void createTransformerHandler() {
        SAXTransformerFactory sAXTransformerFactory = (SAXTransformerFactory)SAXTransformerFactory.newInstance();
        try {
            int n2 = Config.a(".xmlstream.indent_number", -1);
            if (n2 >= 0) {
                try {
                    sAXTransformerFactory.setAttribute("indent-number", String.valueOf(n2));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    System.err.println(illegalArgumentException);
                }
            } else if (this.addLineFeed) {
                n2 = 0;
            }
            this.hd = sAXTransformerFactory.newTransformerHandler();
            Transformer transformer = this.hd.getTransformer();
            if (n2 >= 0) {
                transformer.setOutputProperty("indent", "yes");
            }
            if (this.outputProperties != null) {
                transformer.setOutputProperties(this.outputProperties);
            }
            if (this.isInXmlFile) {
                transformer.setOutputProperty("omit-xml-declaration", "yes");
            }
            StreamResult streamResult = new StreamResult(this.out);
            this.hd.setResult(streamResult);
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            throw new IscobolRuntimeException(transformerConfigurationException);
        }
    }

    public TransformerHandler getTransformerHandler() {
        return this.hd;
    }

    public PrintWriter getPrintWriter() {
        if (this.out == null) {
            this.setOutputStream(System.out);
        }
        return this.out;
    }

    public final int write(String string) {
        return this.write(string, false, null);
    }

    public final int write(String string, String string2) {
        return this.write(string, false, string2);
    }

    public int write(String string, boolean bl, String string2) {
        this.setFileName(string, string2);
        return this.internalWrite(bl);
    }

    public final int writeToFile(String string) {
        return this.write(string, false, null);
    }

    public final int writeToFile(String string, String string2) {
        return this.write(string, false, string2);
    }

    public final int writeToFile(String string, boolean bl) {
        return this.write(string, bl, null);
    }

    public final int writeToFile(String string, boolean bl, String string2) {
        return this.write(string, bl, string2);
    }

    public final int writeToStream(OutputStream outputStream) {
        return this.writeToStream(outputStream, false, null);
    }

    public final int writeToStream(OutputStream outputStream, boolean bl) {
        return this.writeToStream(outputStream, bl, null);
    }

    public int writeToStream(OutputStream outputStream, boolean bl, String string) {
        this.setOutputStream(outputStream, string);
        return this.internalWrite(bl);
    }

    public final int writeToPrintWriter(PrintWriter printWriter) {
        return this.writeToPrintWriter(printWriter, false);
    }

    public final int writeToPrintWriter(PrintWriter printWriter, boolean bl) {
        this.setPrintWriter(printWriter);
        return this.internalWrite(bl);
    }

    public final int writeToStringBuffer(StringBuffer stringBuffer) {
        return this.writeToStringBuffer(stringBuffer, false);
    }

    public int writeToStringBuffer(StringBuffer stringBuffer, boolean bl) {
        StringWriter stringWriter = new StringWriter();
        int n2 = this.writeToPrintWriter(new PrintWriter(stringWriter), bl);
        stringBuffer.append(stringWriter.toString());
        return n2;
    }

    protected void readConfiguration() {
        this.omitEmptyElements = !this.isInXmlFile && Config.b(".xmlstream.omit_empty_elements", true);
        this.rtrim = this.isInXmlFile || Config.b(".xmlstream.rtrim", false);
        this.resolveRefs = Config.b(".xmlstream.resolve_references", false);
        this.mtomEnabled = Config.b("iscobol.http.mtom_enabled", false);
        this.initializeOnRead = Config.b(".xmlstream.initialize_on_read", false);
    }

    public final int write() {
        return this.internalWrite(false);
    }

    public final int writeQualified() {
        return this.internalWrite(true);
    }

    protected int internalWrite(boolean bl) {
        try {
            if (this.isInXmlFile && this.schemaLocation != null) {
                this.writeSchemaLocation = true;
            }
            if (bl) {
                this.writeNsPrefixes = new LinkedHashMap<String, String>();
                this.fillNsPrefixTable(this.xmlVar);
            }
            this.readConfiguration();
            if (this.out == null) {
                this.setOutputStream(System.out);
            }
            try {
                this.hd.startDocument();
                this.scanElement(this.xmlRoot, this.xmlVar, null, null, 1, 0);
                this.hd.endDocument();
            }
            catch (SAXException sAXException) {
                throw new IscobolRuntimeException(sAXException);
            }
        }
        finally {
            this.writeNsPrefixes = null;
            if (this.out != null) {
                this.out.close();
            }
            this.out = null;
        }
        return 1;
    }

    private void fillNsPrefixTable(ICobolVar iCobolVar) {
        String string;
        IXMLAttributes iXMLAttributes = iCobolVar.getIXMLAttributes();
        if (iXMLAttributes != null && !iXMLAttributes.isAttribute() && (string = iXMLAttributes.getNamespace()) != null && string.length() > 0 && this.writeNsPrefixes.get(string) == null) {
            this.writeNsPrefixes.put(string, "ns" + (this.writeNsPrefixes.size() + 1));
        }
        Enumeration enumeration = iCobolVar.getChildren();
        while (enumeration.hasMoreElements()) {
            this.fillNsPrefixTable((ICobolVar)enumeration.nextElement());
        }
    }

    private void scanElement(XmlNode xmlNode, ICobolVar iCobolVar, int[] nArray, boolean[] blArray, int n2, int n3) throws SAXException {
        if (xmlNode != null) {
            iCobolVar = xmlNode.var;
        }
        int[] nArray2 = iCobolVar.getDimensions();
        if (nArray == null) {
            if (nArray2 == null) {
                this.writeElement(xmlNode, iCobolVar, nArray, blArray, n2, n3);
            } else {
                nArray = new int[1];
                int n4 = iCobolVar.getLastDimension();
                int n5 = 1;
                while (n5 <= n4) {
                    nArray[0] = n5++;
                    this.scanElement(xmlNode, iCobolVar, nArray, blArray, n2, n3 + 1);
                }
            }
        } else if (nArray.length == nArray2.length) {
            this.writeElement(xmlNode, iCobolVar, nArray, blArray, n2, n3);
        } else {
            int n6;
            int[] nArray3 = new int[nArray2.length];
            for (n6 = 0; n6 < nArray.length; ++n6) {
                nArray3[n6] = nArray[n6];
            }
            nArray = nArray3;
            n6 = this.getDimension(iCobolVar, nArray, nArray2[nArray2.length - 1]);
            int n7 = 1;
            while (n7 <= n6) {
                nArray[nArray2.length - 1] = n7++;
                this.scanElement(xmlNode, iCobolVar, nArray, blArray, n2, n3 + 1);
            }
        }
    }

    protected int getDimension(ICobolVar iCobolVar, int[] nArray, int n2) {
        if (this.omitEmptyElements && nArray.length > 1 && iCobolVar.isInDynamicTable()) {
            int[] nArray2 = new int[nArray.length - 1];
            System.arraycopy(nArray, 0, nArray2, 0, nArray2.length);
            n2 = iCobolVar.getDynamicCapacity(nArray2, true);
        }
        return n2;
    }

    private boolean isEmpty0(String string) {
        if (this.rtrim) {
            string = string.trim();
        }
        return string.length() == 0;
    }

    protected boolean isEmpty(ICobolVar iCobolVar, int[] nArray) {
        Enumeration enumeration = iCobolVar.getChildren();
        if (!enumeration.hasMoreElements()) {
            int[] nArray2 = iCobolVar.getDimensions();
            if (nArray2 == null) {
                return this.isEmpty0(iCobolVar.toStringNoGui());
            }
            if (nArray == null) {
                return nArray2[0] == 0;
            }
            if (nArray.length == nArray2.length) {
                return this.isEmpty0(iCobolVar.intIAt(nArray).toStringNoGui());
            }
            if (nArray.length < nArray2.length) {
                int[] nArray3 = new int[nArray.length + 1];
                System.arraycopy(nArray, 0, nArray3, 0, nArray.length);
                int n2 = iCobolVar.isInDynamicTable() ? iCobolVar.getDynamicCapacity(nArray, true) : nArray2[nArray.length];
                int n3 = 1;
                while (n3 <= n2) {
                    nArray3[nArray.length] = n3++;
                    if (this.isEmpty(iCobolVar, nArray3)) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        while (enumeration.hasMoreElements()) {
            ICobolVar iCobolVar2 = (ICobolVar)enumeration.nextElement();
            if (this.isEmpty(iCobolVar2, nArray)) continue;
            return false;
        }
        return true;
    }

    private void writeElement(XmlNode xmlNode, ICobolVar iCobolVar, int[] nArray, boolean[] blArray, int n2, int n3) throws SAXException {
        this.writeElement(xmlNode, iCobolVar, nArray, blArray, n2, n3, new AttributesImpl());
    }

    private void writeElement(XmlNode xmlNode, ICobolVar iCobolVar, int[] nArray, boolean[] blArray, int n2, int n3, AttributesImpl attributesImpl) throws SAXException {
        if (xmlNode != null) {
            this.writeElement(xmlNode, nArray, blArray, n2, n3, attributesImpl);
        } else {
            this.writeElement(iCobolVar, nArray, blArray, n2, n3, attributesImpl);
            if (this.resolveRefs && n2 == 3) {
                while (!this.deferredElements.isEmpty()) {
                    this.deferredElements.remove(0).write();
                }
            }
        }
    }

    private static boolean[] getFlags(IXMLAttributes iXMLAttributes) {
        return new boolean[]{iXMLAttributes.isRaw(), iXMLAttributes.isBase64Binary(), iXMLAttributes.isHexBinary(), iXMLAttributes.isBoolean()};
    }

    private static boolean[] getFlags(boolean[] blArray, IXMLAttributes iXMLAttributes) {
        return new boolean[]{blArray[0] || iXMLAttributes.isRaw(), blArray[1] || iXMLAttributes.isBase64Binary(), blArray[2] || iXMLAttributes.isHexBinary(), blArray[3] || iXMLAttributes.isBoolean()};
    }

    private void writeElement(ICobolVar iCobolVar, int[] nArray, boolean[] blArray, int n2, int n3, AttributesImpl attributesImpl) throws SAXException {
        block22: {
            boolean bl;
            String string;
            IXMLAttributes iXMLAttributes;
            block24: {
                String string2;
                String string3;
                IXMLAttributes iXMLAttributes2;
                ICobolVar iCobolVar2;
                Enumeration enumeration;
                block23: {
                    int n4;
                    String string4;
                    Object object;
                    enumeration = iCobolVar.getChildren();
                    iXMLAttributes = iCobolVar.getIXMLAttributes();
                    if (iXMLAttributes == null || iXMLAttributes.isCDATA() || iXMLAttributes.isProcessingInstruction()) break block22;
                    if (iXMLAttributes.isAttribute()) {
                        return;
                    }
                    if (this.writeSchemaLocation) {
                        attributesImpl.addAttribute(null, "xsi", "xmlns:xsi", "CDATA", "http://www.w3.org/2001/XMLSchema-instance");
                        attributesImpl.addAttribute("http://www.w3.org/2001/XMLSchema-instance", "noNamespaceSchemaLocation", "xsi:noNamespaceSchemaLocation", "CDATA", this.schemaLocation);
                        this.writeSchemaLocation = false;
                    }
                    string = iXMLAttributes.getNamespace();
                    blArray = blArray == null ? XMLStream.getFlags(iXMLAttributes) : XMLStream.getFlags(blArray, iXMLAttributes);
                    bl = false;
                    enumeration = iCobolVar.getChildren();
                    while (enumeration.hasMoreElements()) {
                        iCobolVar2 = (ICobolVar)enumeration.nextElement();
                        iXMLAttributes2 = iCobolVar2.getIXMLAttributes();
                        string3 = "";
                        if (iXMLAttributes2 == null || !iXMLAttributes2.isAttribute()) continue;
                        object = iCobolVar2.getChildren();
                        while (object.hasMoreElements()) {
                            iCobolVar2 = (ICobolVar)object.nextElement();
                        }
                        if (nArray != null && nArray.length == iCobolVar2.getDimensions().length) {
                            iCobolVar2 = iCobolVar2.intIAt(nArray);
                        }
                        if ((string3 = iCobolVar2.toStringNoGui()).length() <= 0) continue;
                        String string5 = iXMLAttributes2.getIdentifier();
                        string4 = iXMLAttributes2.getNamespace();
                        if (this.resolveRefs && n2 == 1 && string5.startsWith("xmlns:")) {
                            this.globalNamespaces.put(string5.substring(6), string3);
                        }
                        if (string4.length() > 0 && !string4.equals(string)) {
                            if ("http://www.w3.org/XML/1998/namespace".equals(string4)) {
                                attributesImpl.addAttribute(string4, string5, "xml:" + string5, "CDATA", string3);
                                continue;
                            }
                            if ("http://www.w3.org/2000/xmlns/".equals(string4)) {
                                attributesImpl.addAttribute(string4, string5, "xmlns:" + string5, "CDATA", string3);
                                continue;
                            }
                            string2 = "ns" + ++this.prog;
                            attributesImpl.addAttribute("", "", "xmlns:" + string2, "CDATA", string4);
                            attributesImpl.addAttribute(string4, string5, string2 + ":" + string5, "CDATA", string3);
                            continue;
                        }
                        attributesImpl.addAttribute(string4, string5, string5, "CDATA", string3);
                    }
                    if (!(!this.resolveRefs || n2 != 1 || ((String)(object = iXMLAttributes.getIdentifier())).endsWith("Envelope") && (n4 = ((String)object).indexOf(58)) >= 0 && "http://schemas.xmlsoap.org/soap/envelope/".equals(this.globalNamespaces.get(((String)object).substring(0, n4))))) {
                        this.resolveRefs = false;
                    }
                    if (this.writeNsPrefixes != null && n2 == 1 && !this.resolveRefs) {
                        for (String string6 : this.writeNsPrefixes.keySet()) {
                            string4 = this.writeNsPrefixes.get(string6);
                            attributesImpl.addAttribute("", "", "xmlns:" + string4, "CDATA", string6);
                        }
                    }
                    if (attributesImpl.getLength() > 0) {
                        this.hd_startElement(iXMLAttributes, string, attributesImpl);
                        bl = true;
                    }
                    if ((enumeration = iCobolVar.getChildren()).hasMoreElements()) break block23;
                    iXMLAttributes2 = iCobolVar.getIXMLAttributes();
                    if (nArray != null && iCobolVar.getDimensions() == null) break block24;
                    object = nArray == null ? iCobolVar : iCobolVar.intIAt(nArray);
                    string3 = object.toStringNoGui();
                    if (this.omitEmptyElements && this.isEmpty0(string3)) break block24;
                    if (!bl) {
                        this.hd_startElement(iXMLAttributes, string, attributesImpl);
                        bl = true;
                    }
                    this.characters((ICobolVar)object, iXMLAttributes, string, string3, iXMLAttributes2, blArray);
                    break block24;
                }
                while (enumeration.hasMoreElements()) {
                    int n5;
                    iCobolVar2 = (ICobolVar)enumeration.nextElement();
                    iXMLAttributes2 = iCobolVar2.getIXMLAttributes();
                    if (iXMLAttributes2 == null || iXMLAttributes2.isCDATA() || iXMLAttributes2.isProcessingInstruction()) {
                        if (nArray != null && iCobolVar2.getDimensions() == null) continue;
                        ICobolVar iCobolVar3 = nArray == null ? iCobolVar2 : iCobolVar2.intIAt(nArray);
                        string3 = iCobolVar3.toStringNoGui();
                        if (this.omitEmptyElements && this.isEmpty0(string3)) continue;
                        if (!bl) {
                            this.hd_startElement(iXMLAttributes, string, attributesImpl);
                            bl = true;
                        }
                        this.characters(iCobolVar3, iXMLAttributes, string, string3, iXMLAttributes2, blArray);
                        continue;
                    }
                    if (iXMLAttributes2.isAttribute()) continue;
                    String string7 = iXMLAttributes2.getIdentifier();
                    boolean bl2 = this.resolveRefs && n3 > 0 && string7.endsWith("Array") && (n5 = string7.indexOf(58)) >= 0 && "http://schemas.xmlsoap.org/soap/encoding/".equals(this.globalNamespaces.get(string7.substring(0, n5)));
                    string2 = null;
                    boolean[] blArray2 = blArray == null ? XMLStream.getFlags(iXMLAttributes2) : XMLStream.getFlags(blArray, iXMLAttributes2);
                    if (!bl) {
                        if (this.omitEmptyElements && this.isEmpty(iCobolVar, nArray)) {
                            return;
                        }
                        if (bl2) {
                            string2 = "itemId" + ++this.prog;
                            attributesImpl.addAttribute("", "", "href", "CDATA", "#" + string2);
                        }
                        this.hd_startElement(iXMLAttributes, string, attributesImpl);
                        bl = true;
                    }
                    if (bl2) {
                        this.deferredElements.add(new DeferredElement(iCobolVar2, nArray, blArray2, string2));
                        continue;
                    }
                    this.scanElement(null, iCobolVar2, nArray, blArray2, n2 + 1, n3);
                }
            }
            if (bl) {
                this.hd_endElement(iXMLAttributes, string);
            }
        }
    }

    private void writeElement(XmlNode xmlNode, int[] nArray, boolean[] blArray, int n2, int n3, AttributesImpl attributesImpl) throws SAXException {
        IXMLAttributes iXMLAttributes;
        Vector<ICobolVar> vector;
        ICobolVar iCobolVar = xmlNode.var;
        Vector<XmlNode> vector2 = xmlNode.newChildren;
        if (vector2 == null) {
            vector2 = new Vector();
        }
        if ((vector = xmlNode.newAttr) == null) {
            vector = new Vector();
            if (xmlNode == this.xmlRoot) {
                vector.addAll(xmlNode.varAttr);
                vector.addAll(xmlNode.finalAttr);
            }
        }
        if ((iXMLAttributes = xmlNode.xml) != null && !iXMLAttributes.isCDATA() && !iXMLAttributes.isProcessingInstruction()) {
            Object object;
            String string;
            IXMLAttributes iXMLAttributes2;
            ICobolVar iCobolVar2;
            int n4;
            if (iXMLAttributes.isAttribute()) {
                return;
            }
            String string2 = iXMLAttributes.getNamespace();
            if (this.writeSchemaLocation) {
                attributesImpl.addAttribute(null, "xsi", "xmlns:xsi", "CDATA", "http://www.w3.org/2001/XMLSchema-instance");
                if (string2 != null && string2.length() > 0) {
                    attributesImpl.addAttribute("http://www.w3.org/2001/XMLSchema-instance", "schemaLocation", "xsi:schemaLocation", "CDATA", string2 + " " + this.schemaLocation);
                } else {
                    attributesImpl.addAttribute("http://www.w3.org/2001/XMLSchema-instance", "noNamespaceSchemaLocation", "xsi:noNamespaceSchemaLocation", "CDATA", this.schemaLocation);
                }
                this.writeSchemaLocation = false;
            }
            blArray = blArray == null ? XMLStream.getFlags(iXMLAttributes) : XMLStream.getFlags(blArray, iXMLAttributes);
            boolean bl = false;
            int n5 = vector.size();
            for (n4 = 0; n4 < n5; ++n4) {
                iCobolVar2 = vector.elementAt(n4);
                iXMLAttributes2 = iCobolVar2.getIXMLAttributes();
                string = "";
                if (iXMLAttributes2 == null || !iXMLAttributes2.isAttribute() || (string = iCobolVar2.toStringNoGui()).length() <= 0) continue;
                object = iXMLAttributes2.getIdentifier();
                String string3 = iXMLAttributes2.getNamespace();
                attributesImpl.addAttribute(string3, (String)object, (String)object, "CDATA", Factory.rightTrim(string));
            }
            if (attributesImpl.getLength() > 0) {
                this.hd_startElement(iXMLAttributes, string2, attributesImpl);
                bl = true;
            }
            if ((n5 = vector2.size()) == 0) {
                iXMLAttributes2 = iCobolVar.getIXMLAttributes();
                string = iCobolVar.toStringNoGui();
                if (!this.omitEmptyElements || !this.isEmpty0(string)) {
                    if (!bl) {
                        this.hd_startElement(iXMLAttributes, string2, attributesImpl);
                        bl = true;
                    }
                    this.characters(iCobolVar, iXMLAttributes, string2, string, iXMLAttributes2, blArray);
                }
            } else {
                for (n4 = 0; n4 < n5; ++n4) {
                    XmlNode xmlNode2 = vector2.elementAt(n4);
                    iCobolVar2 = xmlNode2.var;
                    iXMLAttributes2 = xmlNode2.xml;
                    if (iXMLAttributes2 == null || iXMLAttributes2.isCDATA() || iXMLAttributes2.isProcessingInstruction()) {
                        string = iCobolVar.toStringNoGui();
                        if (this.omitEmptyElements && this.isEmpty0(string)) continue;
                        if (!bl) {
                            this.hd_startElement(iXMLAttributes, string2, attributesImpl);
                            bl = true;
                        }
                        this.characters(iCobolVar, iXMLAttributes, string2, string, iXMLAttributes2, blArray);
                        continue;
                    }
                    object = blArray == null ? (Object)XMLStream.getFlags(iXMLAttributes2) : (Object)XMLStream.getFlags(blArray, iXMLAttributes2);
                    if (!bl) {
                        if (this.omitEmptyElements && this.isEmpty(iCobolVar, nArray)) {
                            return;
                        }
                        this.hd_startElement(iXMLAttributes, string2, attributesImpl);
                        bl = true;
                    }
                    this.scanElement(xmlNode2, null, nArray, (boolean[])object, n2 + 1, n3);
                }
            }
            if (bl) {
                this.hd_endElement(iXMLAttributes, string2);
            }
        }
    }

    private void characters(ICobolVar iCobolVar, IXMLAttributes iXMLAttributes, String string, String string2, IXMLAttributes iXMLAttributes2, boolean[] blArray) throws SAXException {
        if (this.mtomEnabled && blArray != null && (blArray[1] || blArray[2])) {
            AttributesImpl attributesImpl = new AttributesImpl();
            String string3 = "attachment-" + (this.mtomItems.size() + 1);
            this.mtomItems.put(string3, iCobolVar);
            attributesImpl.addAttribute("", "", "href", "CDATA", "cid:" + string3);
            this.hd.startElement("http://www.w3.org/2004/08/xop/include", "Include", "Include", attributesImpl);
            this.hd_endElement(iXMLAttributes, string);
        } else {
            this.characters(string2, iCobolVar.getBytes(), iXMLAttributes2, blArray, iCobolVar instanceof INumericVar);
        }
    }

    private void hd_startElement(IXMLAttributes iXMLAttributes, String string, AttributesImpl attributesImpl) throws SAXException {
        String string2;
        String string3 = iXMLAttributes.getIdentifier();
        if (this.writeNsPrefixes != null) {
            if (string != null && string.length() > 0) {
                string2 = this.writeNsPrefixes.get(string) + ":" + string3;
                string = "";
            } else {
                string2 = string3;
            }
        } else {
            string2 = string3;
            if (iXMLAttributes.hasExplicitNs() && "".equals(string)) {
                attributesImpl.addAttribute(string, string3, "xmlns", "CDATA", "");
            }
        }
        this.hd.startElement(string, string3, string2, attributesImpl);
    }

    private void hd_endElement(IXMLAttributes iXMLAttributes, String string) throws SAXException {
        String string2;
        String string3 = iXMLAttributes.getIdentifier();
        if (this.writeNsPrefixes != null) {
            if (string != null && string.length() > 0) {
                string2 = this.writeNsPrefixes.get(string) + ":" + string3;
                string = "";
            } else {
                string2 = string3;
            }
        } else {
            string2 = string3;
        }
        this.hd.endElement(string, string3, string2);
    }

    private void characters(String string, byte[] byArray, IXMLAttributes iXMLAttributes, boolean[] blArray, boolean bl) throws SAXException {
        int n2;
        int n3 = 0;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        if (blArray != null) {
            bl2 = blArray[0];
            bl3 = blArray[1];
            bl4 = blArray[2];
            bl5 = blArray[3];
        }
        if (this.rtrim) {
            if (bl3 || bl4) {
                n3 = byArray.length;
                for (n2 = byArray.length - 1; n2 >= 0 && byArray[n2] == 32; --n2) {
                    --n3;
                }
            } else {
                string = Factory.rightTrim(string);
            }
        } else if (bl3 || bl4) {
            n3 = byArray.length;
        }
        if (bl2) {
            this.hd.processingInstruction("javax.xml.transform.disable-output-escaping", null);
            this.hd.characters(string.toCharArray(), 0, string.length());
            this.hd.processingInstruction("javax.xml.transform.enable-output-escaping", null);
        } else if (bl3) {
            string = new String(Base64.encode(byArray, 0, n3));
            this.hd.characters(string.toCharArray(), 0, string.length());
        } else if (bl4) {
            string = RtsUtil.bytesToHex(byArray, 0, n3);
            this.hd.characters(string.toCharArray(), 0, string.length());
        } else if (bl5) {
            if (bl) {
                try {
                    n2 = Integer.parseInt(string);
                    string = n2 != 0 ? "true" : "false";
                }
                catch (NumberFormatException numberFormatException) {
                    string = "false";
                }
            } else {
                string = "" + Boolean.parseBoolean(string.trim());
            }
            this.hd.characters(string.toCharArray(), 0, string.length());
        } else if (iXMLAttributes != null && iXMLAttributes.isCDATA()) {
            this.hd.startCDATA();
            this.hd.characters(string.toCharArray(), 0, string.length());
            this.hd.endCDATA();
        } else if (iXMLAttributes != null && iXMLAttributes.isProcessingInstruction()) {
            string = "<?" + string + "?>";
            this.hd.processingInstruction("javax.xml.transform.disable-output-escaping", null);
            this.hd.characters(string.toCharArray(), 0, string.length());
            this.hd.processingInstruction("javax.xml.transform.enable-output-escaping", null);
        } else {
            this.hd.characters(string.toCharArray(), 0, string.length());
        }
    }

    public Map<String, ICobolVar> getMtomItems() {
        return this.mtomItems;
    }

    public void setMtomItems(Map<String, ICobolVar> map) {
        this.mtomItems = map;
    }

    public String getSchemaLocation() {
        return this.schemaLocation;
    }

    public void setSchemaLocation(String string) {
        this.schemaLocation = string;
    }

    public boolean startKey(ICobolVar iCobolVar, int n2) {
        IXMLAttributes iXMLAttributes;
        if (!this.isInXmlFile || this.xmlRoot == null || (iXMLAttributes = iCobolVar.getIXMLAttributes()) == null || n2 < 1) {
            return false;
        }
        XmlNode xmlNode = this.findNode(this.xmlRoot, iCobolVar, iXMLAttributes.isAttribute());
        if (xmlNode != null) {
            this.startNode = xmlNode;
            this.startNodeIndex = n2;
            this.startNodeAttr = iXMLAttributes.isAttribute();
            return true;
        }
        return false;
    }

    public boolean rewriteKey(ICobolVar iCobolVar) {
        IXMLAttributes iXMLAttributes;
        if (!this.isInXmlFile || this.xmlRoot == null || (iXMLAttributes = iCobolVar.getIXMLAttributes()) == null) {
            return false;
        }
        XmlNode xmlNode = this.findNode(this.xmlRoot, iCobolVar, iXMLAttributes.isAttribute());
        if (xmlNode != null) {
            Vector<XmlNode> vector = new Vector<XmlNode>();
            XmlNode xmlNode2 = xmlNode;
            while (xmlNode2 != this.xmlRoot) {
                vector.add(0, xmlNode2);
                xmlNode2 = xmlNode2.parent;
            }
            xmlNode2 = (XmlNode)this.modifyNode(this.xmlRoot, vector, 0, iCobolVar, iXMLAttributes.isAttribute(), false);
            if (!iXMLAttributes.isAttribute()) {
                this.addNewChildren(xmlNode2, iCobolVar);
            }
            return true;
        }
        return false;
    }

    public boolean deleteKey(ICobolVar iCobolVar) {
        IXMLAttributes iXMLAttributes;
        if (!this.isInXmlFile || this.xmlRoot == null || (iXMLAttributes = iCobolVar.getIXMLAttributes()) == null) {
            return false;
        }
        XmlNode xmlNode = this.findNode(this.xmlRoot, iCobolVar, iXMLAttributes.isAttribute());
        if (xmlNode != null) {
            Vector<XmlNode> vector = new Vector<XmlNode>();
            XmlNode xmlNode2 = xmlNode;
            while (xmlNode2 != this.xmlRoot) {
                vector.add(0, xmlNode2);
                xmlNode2 = xmlNode2.parent;
            }
            this.modifyNode(this.xmlRoot, vector, 0, iCobolVar, iXMLAttributes.isAttribute(), true);
            return true;
        }
        return false;
    }

    public boolean writeKey(ICobolVar iCobolVar, boolean bl) {
        IXMLAttributes iXMLAttributes;
        if (!this.isInXmlFile || this.xmlRoot == null || (iXMLAttributes = iCobolVar.getIXMLAttributes()) == null) {
            return false;
        }
        boolean bl2 = iXMLAttributes.isAttribute();
        XmlNode xmlNode = this.findNode(this.xmlRoot, iCobolVar, bl2);
        if (xmlNode != null) {
            Vector<XmlNode> vector = new Vector<XmlNode>();
            XmlNode xmlNode2 = xmlNode;
            while (xmlNode2 != this.xmlRoot) {
                vector.add(0, xmlNode2);
                xmlNode2 = xmlNode2.parent;
            }
            xmlNode2 = (XmlNode)this.addNode(this.xmlRoot, vector, 0, iCobolVar, bl2);
            if (bl && !bl2) {
                this.addNewChildren(xmlNode2, iCobolVar);
            }
            return true;
        }
        return false;
    }

    private Node modifyNode(XmlNode xmlNode, Vector<XmlNode> vector, int n2, ICobolVar iCobolVar, boolean bl, boolean bl2) {
        XmlNode xmlNode2 = vector.elementAt(n2);
        int n3 = vector.size() - 1;
        if (bl) {
            ++n3;
        }
        if (n2 < n3) {
            Object object;
            int n4;
            String string = xmlNode2.xml.getIdentifier();
            if (xmlNode.newChildren == null) {
                xmlNode.newChildren = new Vector();
            }
            for (n4 = xmlNode.newChildren.size() - 1; n4 >= 0; --n4) {
                object = xmlNode.newChildren.elementAt(n4);
                if (((XmlNode)object).xml.getIdentifier().equals(string)) break;
            }
            if (n4 >= 0) {
                xmlNode2 = xmlNode.newChildren.elementAt(n4);
                if (bl && n2 == n3 - 1) {
                    if (xmlNode2.newAttr != null) {
                        object = iCobolVar.getIXMLAttributes().getIdentifier();
                        for (n4 = xmlNode2.newAttr.size() - 1; n4 >= 0; --n4) {
                            if (!xmlNode2.newAttr.elementAt(n4).getIXMLAttributes().getIdentifier().equals(object)) continue;
                            if (bl2) {
                                xmlNode2.newAttr.removeElementAt(n4);
                                break;
                            }
                            xmlNode2.newAttr.setElementAt(iCobolVar.xmlClone(), n4);
                            break;
                        }
                    }
                    return null;
                }
                return this.modifyNode(xmlNode2, vector, n2 + 1, iCobolVar, bl, bl2);
            }
            return null;
        }
        if (xmlNode.newChildren != null) {
            String string = iCobolVar.getIXMLAttributes().getIdentifier();
            for (int i2 = xmlNode.newChildren.size() - 1; i2 >= 0; --i2) {
                if (!xmlNode.newChildren.elementAt((int)i2).xml.getIdentifier().equals(string)) continue;
                if (bl2) {
                    xmlNode.newChildren.removeElementAt(i2);
                    return null;
                }
                xmlNode2 = this.newXmlNode(iCobolVar.xmlClone());
                xmlNode.newChildren.setElementAt(xmlNode2, i2);
                return xmlNode2;
            }
        }
        return null;
    }

    private Node addNode(XmlNode xmlNode, Vector<XmlNode> vector, int n2, ICobolVar iCobolVar, boolean bl) {
        XmlNode xmlNode2 = vector.elementAt(n2);
        int n3 = vector.size() - 1;
        if (bl) {
            ++n3;
        }
        if (n2 < n3) {
            int n4;
            String string = xmlNode2.xml.getIdentifier();
            if (xmlNode.newChildren == null) {
                xmlNode.newChildren = new Vector();
            }
            for (n4 = xmlNode.newChildren.size() - 1; n4 >= 0; --n4) {
                XmlNode xmlNode3 = xmlNode.newChildren.elementAt(n4);
                if (xmlNode3.xml.getIdentifier().equals(string)) break;
            }
            if (n4 >= 0) {
                xmlNode2 = xmlNode.newChildren.elementAt(n4);
            } else {
                xmlNode2 = this.newXmlNode(xmlNode2.var.xmlClone());
                xmlNode.newChildren.addElement(xmlNode2);
            }
            if (bl && n2 == n3 - 1) {
                if (xmlNode2.newAttr == null) {
                    xmlNode2.newAttr = new Vector();
                }
                xmlNode2.newAttr.addElement(iCobolVar.xmlClone());
                return null;
            }
            return this.addNode(xmlNode2, vector, n2 + 1, iCobolVar, bl);
        }
        if (xmlNode.newChildren == null) {
            xmlNode.newChildren = new Vector();
        }
        xmlNode2 = this.newXmlNode(iCobolVar.xmlClone());
        xmlNode.newChildren.addElement(xmlNode2);
        return xmlNode2;
    }

    private void addNewChildren(XmlNode xmlNode, ICobolVar iCobolVar) {
        if (xmlNode.newAttr == null) {
            xmlNode.newAttr = new Vector();
        }
        for (ICobolVar iCobolVar2 : xmlNode.varAttr) {
            xmlNode.newAttr.addElement(iCobolVar2.xmlClone());
        }
        for (ICobolVar iCobolVar2 : xmlNode.finalAttr) {
            xmlNode.newAttr.addElement(iCobolVar2.xmlClone());
        }
        Enumeration enumeration = iCobolVar.getChildren();
        while (enumeration.hasMoreElements()) {
            ICobolVar iCobolVar2;
            iCobolVar2 = (ICobolVar)enumeration.nextElement();
            XmlNode xmlNode2 = this.newXmlNode(iCobolVar2.xmlClone());
            xmlNode.newChildren.addElement(xmlNode2);
            this.addNewChildren(xmlNode2, iCobolVar2);
        }
    }

    public int readKey(ICobolVar iCobolVar) {
        if (this.readKey(iCobolVar, this.startNode, this.startNodeIndex, this.startNodeAttr)) {
            return this.startNodeIndex++;
        }
        return 0;
    }

    private boolean readKey(ICobolVar iCobolVar, XmlNode xmlNode, int n2, boolean bl) {
        IXMLAttributes iXMLAttributes;
        if (!this.isInXmlFile || this.xmlRoot == null || (iXMLAttributes = iCobolVar.getIXMLAttributes()) == null) {
            return false;
        }
        XmlNode xmlNode2 = this.findNode(this.xmlRoot, iCobolVar, iXMLAttributes.isAttribute());
        if (xmlNode2 != null) {
            if (xmlNode2 != xmlNode) {
                xmlNode = xmlNode2;
                n2 = 1;
                bl = iXMLAttributes.isAttribute();
            }
            if (bl) {
                if (n2 <= xmlNode.attrs.getLength()) {
                    iXMLAttributes.setIdentifier(xmlNode.attrs.getLocalName(n2 - 1));
                    boolean bl2 = false;
                    Enumeration enumeration = iCobolVar.getChildren();
                    while (enumeration.hasMoreElements()) {
                        ICobolVar iCobolVar2 = (ICobolVar)enumeration.nextElement();
                        if (iCobolVar2 == iXMLAttributes.getIdentifierVar()) continue;
                        this.set(iCobolVar2, xmlNode2.dim, xmlNode.attrs.getValue(n2 - 1));
                        bl2 = true;
                        break;
                    }
                    if (!bl2) {
                        this.set(iCobolVar, xmlNode2.dim, xmlNode.attrs.getValue(n2 - 1));
                    }
                    return true;
                }
            } else if (n2 <= xmlNode.xmlChildren.size()) {
                IXMLAttributes iXMLAttributes2;
                ICobolVar iCobolVar3;
                BaseNode baseNode = xmlNode.xmlChildren.elementAt(n2 - 1);
                iXMLAttributes.setIdentifier(baseNode.name);
                boolean bl3 = false;
                Enumeration enumeration = iCobolVar.getChildren();
                while (enumeration.hasMoreElements()) {
                    iCobolVar3 = (ICobolVar)enumeration.nextElement();
                    iXMLAttributes2 = iCobolVar3.getIXMLAttributes();
                    if (iCobolVar3 == iXMLAttributes.getIdentifierVar() || iXMLAttributes2 != null && iXMLAttributes2.isAttribute()) continue;
                    this.set(iCobolVar3, xmlNode2.dim, xmlNode.cdata.toString());
                    bl3 = true;
                    break;
                }
                if (!bl3) {
                    this.set(iCobolVar, xmlNode2.dim, xmlNode.cdata.toString());
                }
                enumeration = iCobolVar.getChildren();
                block2: while (enumeration.hasMoreElements()) {
                    iCobolVar3 = (ICobolVar)enumeration.nextElement();
                    iXMLAttributes2 = iCobolVar3.getIXMLAttributes();
                    if (iXMLAttributes2 == null) continue;
                    if (iXMLAttributes2.isAttribute()) {
                        int n3 = xmlNode.attrs.getLength();
                        for (int i2 = 0; i2 < n3; ++i2) {
                            if (!xmlNode.attrs.getLocalName(i2).equals(iXMLAttributes2.getIdentifier())) continue;
                            this.set(iCobolVar3, xmlNode2.dim, xmlNode.attrs.getValue(i2));
                            continue block2;
                        }
                        continue;
                    }
                    this.readKey(iCobolVar3, null, 1, false);
                }
                return true;
            }
        }
        return false;
    }

    private XmlNode findNode(XmlNode xmlNode, ICobolVar iCobolVar, boolean bl) {
        if (bl) {
            for (ICobolVar object : xmlNode.finalAttr) {
                if (object != iCobolVar) continue;
                return xmlNode;
            }
            for (ICobolVar iCobolVar2 : xmlNode.varAttr) {
                if (iCobolVar2 != iCobolVar) continue;
                return xmlNode;
            }
        } else if (xmlNode.var == iCobolVar) {
            return xmlNode;
        }
        for (XmlNode xmlNode2 : xmlNode.children) {
            XmlNode xmlNode3 = this.findNode(xmlNode2, iCobolVar, bl);
            if (xmlNode3 == null) continue;
            return xmlNode3;
        }
        return null;
    }

    private int incrCount(IXMLAttributes iXMLAttributes, int[] nArray, int n2) {
        ++n2;
        ICobolVar iCobolVar = iXMLAttributes.getCount();
        if (iCobolVar != null) {
            if (nArray != null && nArray.length > 1) {
                int[] nArray2 = new int[nArray.length - 1];
                System.arraycopy(nArray, 0, nArray2, 0, nArray2.length);
                iCobolVar = iCobolVar.intIAt(nArray2);
            }
            iCobolVar.set(n2);
        }
        return n2;
    }

    private Node newNode(ICobolVar iCobolVar, int[] nArray, String string, String string2) {
        if (this.isInXmlFile) {
            return new XmlNode(iCobolVar, nArray, string, string2);
        }
        return new Node(iCobolVar, nArray, string, string2);
    }

    private XmlNode newXmlNode(ICobolVar iCobolVar) {
        return new XmlNode(iCobolVar, null, null, null);
    }

    private static class XmlNode
    extends Node {
        Vector<BaseNode> xmlChildren = new Vector();
        XmlNode parent;
        final Vector<XmlNode> children = new Vector();
        Vector<XmlNode> newChildren;
        Vector<ICobolVar> newAttr;

        XmlNode(String string, String string2) {
            super(null, null, string, string2);
        }

        XmlNode(ICobolVar iCobolVar, int[] nArray, String string, String string2) {
            super(iCobolVar, nArray, string, string2);
        }
    }

    private static class Node
    extends BaseNode {
        StringBuffer cdata = new StringBuffer();
        final ICobolVar var;
        final int[] dim;
        final Vector<ICobolVar> finalAttr = new Vector();
        final Vector<ICobolVar> varAttr = new Vector();
        final Vector<ICobolVar> next = new Vector();
        ICobolVar data;
        final IXMLAttributes xml;
        boolean sted;
        Map namespaces = new HashMap();
        Map<String, int[]> counters = new HashMap<String, int[]>();
        String dimStr = "";
        int count;
        final Vector<int[]> attrCount = new Vector();

        Node(ICobolVar iCobolVar, int[] nArray, String string, String string2) {
            super(string, string2);
            this.var = iCobolVar;
            this.dim = nArray;
            this.xml = iCobolVar.getIXMLAttributes();
        }

        void clearData() {
            this.cdata = new StringBuffer();
        }
    }

    private static class BaseNode {
        final String uri;
        final String name;
        Attrs attrs;

        BaseNode(String string, String string2) {
            this.uri = string;
            this.name = string2;
        }
    }

    private static class Attrs {
        final String[] names;
        final String[] values;

        Attrs(Attributes attributes) {
            if (attributes != null) {
                int n2 = attributes.getLength();
                this.names = new String[n2];
                this.values = new String[n2];
                for (int i2 = 0; i2 < n2; ++i2) {
                    this.names[i2] = attributes.getLocalName(i2);
                    this.values[i2] = attributes.getValue(i2);
                }
            } else {
                this.names = new String[0];
                this.values = new String[0];
            }
        }

        int getLength() {
            return this.names.length;
        }

        String getLocalName(int n2) {
            return this.names[n2];
        }

        String getValue(int n2) {
            return this.values[n2];
        }

        String getValue(String string) {
            for (int i2 = 0; i2 < this.names.length; ++i2) {
                if (!this.names[i2].equals(string)) continue;
                return this.values[i2];
            }
            return null;
        }
    }

    private class DeferredElement {
        ICobolVar var;
        int[] dim;
        boolean[] flags;
        String href;

        DeferredElement(ICobolVar iCobolVar, int[] nArray, boolean[] blArray, String string) {
            this.var = iCobolVar;
            if (nArray != null) {
                this.dim = new int[nArray.length];
                System.arraycopy(nArray, 0, this.dim, 0, nArray.length);
            }
            this.flags = blArray;
            this.href = string;
        }

        void write() throws SAXException {
            AttributesImpl attributesImpl = new AttributesImpl();
            attributesImpl.addAttribute("", "", "id", "CDATA", this.href);
            XMLStream.this.writeElement(null, this.var, this.dim, this.flags, 5, 0, attributesImpl);
        }
    }

    private static class XMLReferenceResolver {
        private Document document;

        XMLReferenceResolver(Reader reader) {
            DocumentBuilderFactory documentBuilderFactory = RtsUtil.newDocumentBuilderFactory();
            try {
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                InputSource inputSource = new InputSource(reader);
                this.document = documentBuilder.parse(inputSource);
            }
            catch (ParserConfigurationException parserConfigurationException) {
                throw new IscobolRuntimeException(parserConfigurationException);
            }
            catch (SAXException sAXException) {
                throw new IscobolRuntimeException(sAXException);
            }
            catch (IOException iOException) {
                throw new IscobolRuntimeException(iOException);
            }
        }

        InputStream resolveReferencesIS() {
            Element element = this.document.getDocumentElement();
            this.resolveReferences(element, new int[]{0});
            TransformerFactory transformerFactory = SAXTransformerFactory.newInstance();
            try {
                Transformer transformer = transformerFactory.newTransformer();
                DOMSource dOMSource = new DOMSource(this.document);
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                StreamResult streamResult = new StreamResult(new OutputStreamWriter(byteArrayOutputStream));
                transformer.transform(dOMSource, streamResult);
                byteArrayOutputStream.close();
                return new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
            }
            catch (IOException iOException) {
                throw new IscobolRuntimeException(iOException);
            }
            catch (TransformerException transformerException) {
                throw new IscobolRuntimeException(transformerException);
            }
        }

        Reader resolveReferences() {
            Element element = this.document.getDocumentElement();
            this.resolveReferences(element, new int[]{0});
            TransformerFactory transformerFactory = SAXTransformerFactory.newInstance();
            try {
                Transformer transformer = transformerFactory.newTransformer();
                DOMSource dOMSource = new DOMSource(this.document);
                StringWriter stringWriter = new StringWriter();
                StreamResult streamResult = new StreamResult(stringWriter);
                transformer.transform(dOMSource, streamResult);
                return new StringReader(stringWriter.toString());
            }
            catch (TransformerException transformerException) {
                throw new IscobolRuntimeException(transformerException);
            }
        }

        void resolveReferences(Element element, int[] nArray) {
            int n2;
            Object object;
            org.w3c.dom.Node node;
            Object object2;
            String string = element.getAttribute("href");
            if (string != null && string.startsWith("#")) {
                string = string.substring(1);
                object2 = new int[nArray.length];
                System.arraycopy(nArray, 0, object2, 0, nArray.length);
                node = this.getElementById((Element)element.getParentNode(), string, (int[])object2);
                if (node != null) {
                    node.removeAttribute("id");
                    object = node.getTagName();
                    n2 = ((String)object).indexOf(58);
                    if (n2 >= 0) {
                        object = ((String)object).substring(n2 + 1);
                        this.document.renameNode(node, null, (String)object);
                    }
                    element.getParentNode().replaceChild(node, element);
                    this.resolveReferences((Element)node, nArray);
                }
            }
            object2 = element.getChildNodes();
            object = new int[nArray.length + 1];
            System.arraycopy(nArray, 0, object, 0, nArray.length);
            for (n2 = 0; n2 < object2.getLength(); ++n2) {
                object[nArray.length] = n2;
                node = object2.item(n2);
                if (node.getNodeType() != 1) continue;
                this.resolveReferences((Element)node, (int[])object);
            }
        }

        Element getElementById(Element element, String string, int[] nArray) {
            NodeList nodeList = element.getChildNodes();
            int n2 = nodeList.getLength();
            for (int i2 = nArray[nArray.length - 1] + 1; i2 < n2; ++i2) {
                Element element2;
                org.w3c.dom.Node node = nodeList.item(i2);
                if (node.getNodeType() != 1 || (element2 = this.getElementById((Element)node, string)) == null) continue;
                return element2;
            }
            int[] nArray2 = new int[nArray.length - 1];
            System.arraycopy(nArray, 0, nArray2, 0, nArray2.length);
            return this.getElementById((Element)element.getParentNode(), string, nArray2);
        }

        Element getElementById(Element element, String string) {
            if (string.equals(element.getAttribute("id"))) {
                return element;
            }
            NodeList nodeList = element.getChildNodes();
            int n2 = nodeList.getLength();
            for (int i2 = 0; i2 < n2; ++i2) {
                Element element2;
                org.w3c.dom.Node node = nodeList.item(i2);
                if (node.getNodeType() != 1 || (element2 = this.getElementById((Element)node, string)) == null) continue;
                return element2;
            }
            return null;
        }
    }
}

