/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.rts.print;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.awt.print.PageFormat;
import java.text.DateFormat;
import java.util.Date;

public class AutoHeaderFooter {
    private Font font = new Font("default", 0, 12);
    private Color color = Color.black;
    private final String[] header;
    private final String[] footer;
    private final int totPages;
    private final String reportName;
    Rectangle2D imgArea;
    private String timestamp;

    public AutoHeaderFooter(String[] stringArray, String[] stringArray2, int n2, String string, Font font) {
        this.header = stringArray;
        this.footer = stringArray2;
        this.totPages = n2;
        this.reportName = string;
        this.font = font != null ? font : new Font("default", 0, 12);
    }

    public void print(Graphics2D graphics2D, PageFormat pageFormat, int n2) {
        graphics2D.setFont(this.font);
        graphics2D.setColor(this.color);
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        if (this.imgArea == null) {
            this.imgArea = new Rectangle2D.Double(0.0, 0.0, pageFormat.getImageableWidth(), pageFormat.getImageableHeight());
        }
        double d2 = 1.0;
        double d3 = fontMetrics.getAscent();
        double d4 = this.imgArea.getHeight();
        if (this.header != null) {
            this.print(graphics2D, this.header, d2, d3, n2);
        }
        d3 = d4 - (double)fontMetrics.getDescent();
        if (this.footer != null) {
            this.print(graphics2D, this.footer, d2, d3, n2);
        }
    }

    private void print(Graphics2D graphics2D, String[] stringArray, double d2, double d3, int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        float f2 = (float)this.imgArea.getX();
        float f3 = (float)this.imgArea.getY();
        float f4 = (float)this.imgArea.getWidth();
        block11: for (int i2 = 0; i2 < stringArray.length; ++i2) {
            if (stringArray[i2].length() == 2) {
                if (stringArray[i2].charAt(0) == '&') {
                    switch (stringArray[i2].charAt(1)) {
                        case 'P': {
                            stringBuffer.append(this.totPages);
                            break;
                        }
                        case 'p': {
                            stringBuffer.append(n2);
                            break;
                        }
                        case 'd': {
                            DateFormat dateFormat = DateFormat.getDateInstance(3);
                            stringBuffer.append(dateFormat.format(new Date()));
                            break;
                        }
                        case 'D': {
                            DateFormat dateFormat = DateFormat.getDateInstance(1);
                            stringBuffer.append(dateFormat.format(new Date()));
                            break;
                        }
                        case 'T': {
                            DateFormat dateFormat;
                            if (this.timestamp == null) {
                                dateFormat = DateFormat.getTimeInstance(2);
                                this.timestamp = dateFormat.format(new Date());
                            }
                            stringBuffer.append(this.timestamp);
                            break;
                        }
                        case 'b': {
                            if (bl) continue block11;
                            if (stringBuffer.length() > 0) {
                                graphics2D.drawString(stringBuffer.toString(), (int)(d2 - (double)f2), (int)(d3 - (double)f3));
                            }
                            bl = true;
                            stringBuffer.delete(0, stringBuffer.length());
                            break;
                        }
                        case 'w': {
                            break;
                        }
                        case 'u': {
                            if (this.reportName == null) continue block11;
                            stringBuffer.append(this.reportName);
                            break;
                        }
                        case '&': {
                            stringBuffer.append('&');
                            break;
                        }
                        default: {
                            stringBuffer.append('?');
                            break;
                        }
                    }
                    continue;
                }
                stringBuffer.append(stringArray[i2]);
                continue;
            }
            stringBuffer.append(stringArray[i2]);
        }
        if (stringBuffer.length() > 0 && bl) {
            FontMetrics fontMetrics = graphics2D.getFontMetrics();
            d2 = f4 - (float)fontMetrics.stringWidth(stringBuffer.toString()) - 1.0f;
        }
        graphics2D.drawString(stringBuffer.toString(), (int)(d2 - (double)f2), (int)(d3 - (double)f3));
    }
}

