/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.rts.print;

import com.iscobol.gui.GuiFactory;
import com.iscobol.rts.print.PrintCommand;
import com.iscobol.rts.print.PrintContext;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.print.PageFormat;
import java.io.IOException;
import java.io.RandomAccessFile;

public class DrawGraph
extends PrintCommand {
    public static final double ARC_COEFF = (double)0.1f;
    public static final int RECTANGLE = 1;
    public static final int ROUND_RECTANGLE = 2;
    public static final int LINE = 3;
    public static final int SHAPE_MASK = 15;
    public static final int FILL_ONLY = 16;
    public static final int SHADE_NO = 1;
    public static final int SHADE_YES = 2;
    private final int shape;
    private final double startX;
    private final double startY;
    private final double stopX;
    private final double stopY;
    private final byte shade;
    private final boolean cells;

    public DrawGraph(GuiFactory guiFactory, int n2, double d2, double d3, double d4, double d5, boolean bl, String string) {
        super(guiFactory, 5);
        this.shape = n2;
        if (n2 == 3) {
            this.startX = d2;
            this.stopX = d4;
            this.startY = d3;
            this.stopY = d5;
        } else {
            if (d2 <= d4) {
                this.startX = d2;
                this.stopX = d4;
            } else {
                this.startX = d4;
                this.stopX = d2;
            }
            if (d3 <= d5) {
                this.startY = d3;
                this.stopY = d5;
            } else {
                this.startY = d5;
                this.stopY = d3;
            }
        }
        this.cells = bl;
        this.shade = string == null || string.trim().length() == 0 ? (byte)0 : ("YES".equals(string) ? (byte)2 : (byte)1);
    }

    DrawGraph(GuiFactory guiFactory, RandomAccessFile randomAccessFile) throws IOException {
        super(guiFactory, 5);
        this.shape = randomAccessFile.readInt();
        this.startX = randomAccessFile.readDouble();
        this.startY = randomAccessFile.readDouble();
        this.stopX = randomAccessFile.readDouble();
        this.stopY = randomAccessFile.readDouble();
        this.cells = randomAccessFile.readBoolean();
        this.shade = randomAccessFile.readByte();
    }

    @Override
    void toFile(RandomAccessFile randomAccessFile) throws IOException {
        randomAccessFile.writeInt(this.shape);
        randomAccessFile.writeDouble(this.startX);
        randomAccessFile.writeDouble(this.startY);
        randomAccessFile.writeDouble(this.stopX);
        randomAccessFile.writeDouble(this.stopY);
        randomAccessFile.writeBoolean(this.cells);
        randomAccessFile.writeByte(this.shade);
    }

    @Override
    public boolean testPrint(PrintContext printContext, Graphics2D graphics2D, PageFormat pageFormat) {
        return this.print(printContext, null, pageFormat);
    }

    @Override
    public boolean print(PrintContext printContext, Graphics2D graphics2D, PageFormat pageFormat) {
        if (graphics2D != null) {
            if (this.cells) {
                FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
                TextLayout textLayout = new TextLayout("0", graphics2D.getFont(), fontRenderContext);
                float f2 = DrawGraph.getCellHeight(printContext, textLayout);
                float f3 = textLayout.getAdvance();
                double d2 = Math.min((this.stopX - this.startX) * (double)f3, (this.stopY - this.startY) * (double)f2) * (double)0.1f;
                DrawGraph.draw(graphics2D, this.shape, this.startX * (double)f3, this.startY * (double)f2, this.stopX * (double)f3, this.stopY * (double)f2, d2, d2, this.shade, printContext);
            } else {
                double d3 = Math.min(this.stopX - this.startX, this.stopY - this.startY) * (double)0.1f;
                DrawGraph.draw(graphics2D, this.shape, this.startX, this.startY, this.stopX, this.stopY, d3, d3, this.shade, printContext);
            }
        }
        return true;
    }

    private static void draw(Graphics2D graphics2D, int n2, double d2, double d3, double d4, double d5, double d6, double d7, byte by, PrintContext printContext) {
        Shape shape = null;
        Color color = graphics2D.getColor();
        boolean bl = (n2 & 0x10) == 0;
        switch (n2 &= 0xF) {
            case 1: {
                shape = new Rectangle2D.Double(d2, d3, d4 - d2, d5 - d3);
                break;
            }
            case 2: {
                shape = new RoundRectangle2D.Double(d2, d3, d4 - d2, d5 - d3, d6, d7);
                break;
            }
            case 3: {
                shape = new Line2D.Double(d2, d3, d4, d5);
                break;
            }
        }
        if (shape != null) {
            if (by != 1) {
                Paint paint;
                if (by == 2 && printContext.boxShade != null) {
                    graphics2D.setPaint(printContext.boxShade);
                    graphics2D.fill(shape);
                } else if (!(printContext.graphBrush == null || printContext.graphBrush.getPaint() == null || (paint = printContext.graphBrush.getPaint()) instanceof Color && ((Color)paint).getAlpha() <= 0)) {
                    graphics2D.setPaint(printContext.graphBrush.getPaint());
                    graphics2D.fill(shape);
                }
            }
            if (bl) {
                if (printContext.graphPen != null) {
                    if (printContext.graphPen.getStroke() != null) {
                        graphics2D.setStroke(printContext.graphPen.getStroke());
                        graphics2D.setColor(printContext.graphPen.getColor());
                        graphics2D.draw(shape);
                    }
                } else {
                    graphics2D.setColor(new Color(0, 0, 0));
                    graphics2D.draw(shape);
                }
            }
        }
        graphics2D.setColor(color);
    }
}

