/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.rts.print;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.TexturePaint;
import java.awt.image.BufferedImage;
import java.io.Serializable;

public class GraphBrush
implements Serializable,
Cloneable {
    public static final int SOLID = 0;
    public static final int NULL = 1;
    public static final int BDIAGONAL = 2;
    public static final int CROSS = 3;
    public static final int DIAGCROSS = 4;
    public static final int FDIAGONAL = 5;
    public static final int HORIZONTAL = 6;
    public static final int VERTICAL = 7;
    public static final int DKGRAY = 8;
    public static final int GRAY = 9;
    public static final int LTGRAY = 10;
    private Paint brush;
    private Color color;

    public GraphBrush(int n2, Color color) {
        switch (n2) {
            default: {
                break;
            }
            case 0: {
                this.brush = color;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                Rectangle rectangle = new Rectangle(0, 0, 5, 5);
                BufferedImage bufferedImage = new BufferedImage(5, 5, 1);
                Graphics2D graphics2D = bufferedImage.createGraphics();
                graphics2D.setColor(Color.white);
                graphics2D.fill(rectangle);
                graphics2D.setColor(color);
                switch (n2) {
                    case 2: {
                        graphics2D.drawLine(0, 4, 4, 0);
                        break;
                    }
                    case 3: {
                        graphics2D.drawLine(0, 2, 4, 2);
                        graphics2D.drawLine(2, 0, 2, 4);
                        break;
                    }
                    case 4: {
                        graphics2D.drawLine(0, 0, 4, 4);
                        graphics2D.drawLine(0, 4, 4, 0);
                        break;
                    }
                    case 5: {
                        graphics2D.drawLine(0, 0, 4, 4);
                        break;
                    }
                    case 6: {
                        graphics2D.drawLine(0, 2, 4, 2);
                        break;
                    }
                    case 7: {
                        graphics2D.drawLine(2, 0, 2, 4);
                    }
                }
                this.brush = new TexturePaint(bufferedImage, rectangle);
                break;
            }
            case 8: {
                this.brush = Color.darkGray;
                break;
            }
            case 9: {
                this.brush = Color.gray;
                break;
            }
            case 10: {
                this.brush = Color.lightGray;
            }
        }
    }

    public Paint getPaint() {
        return this.brush;
    }
}

