/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.rts.print;

import com.iscobol.gui.Events;
import com.iscobol.gui.FontAttribute;
import com.iscobol.gui.RemoteFontComponent;
import com.iscobol.gui.ScreenUtility;
import com.iscobol.gui.client.AppFactoryImpl;
import com.iscobol.gui.server.FontCmp;
import com.iscobol.rts.IscobolSystem;
import com.iscobol.rts.MixingCharAndBytesException;
import com.iscobol.rts.RuntimeErrorsNumbers;
import com.iscobol.rts.UserHandles;
import com.iscobol.rts.print.RemotePrintCommandFactory;
import com.iscobol.rts.print.RemoteSpoolPrinter;
import com.iscobol.rts.print.ServerSpoolPrinter;
import com.iscobol.rts.print.SpoolPrinterInterface;
import com.iscobol.rts.print.SpoolPrinterList;
import java.awt.Point;
import java.io.IOException;
import java.io.Writer;
import java.util.Hashtable;
import java.util.Map;
import java.util.StringTokenizer;
import javax.print.attribute.Size2DSyntax;

public class LocalSpoolPrinter
extends Writer
implements RuntimeErrorsNumbers,
SpoolPrinterInterface {
    public static final int BUFFER_CHAR_SIZE = Short.MAX_VALUE;
    public static final int CHAR_COPY_WTRMRK = 31743;
    public static final int BUFFER_BYTE_SIZE = 65535;
    public static final int BYTE_COPY_WTRMRK = 64511;
    public static final int BUFFER_BYTE_X_SIZE = 65535;
    public static final int BYTE_X_COPY_WTRMRK = 64511;
    private byte[] byteBuffer;
    private char[] charNBuffer;
    private byte[] charXBuffer;
    private int bIdx;
    private int cIdx;
    private int bxIdx;
    private final int id;
    private SpoolPrinterInterface sp;
    private boolean serverSide;

    public LocalSpoolPrinter(int n2, boolean bl, LocalSpoolPrinter localSpoolPrinter) throws IOException {
        this.id = n2;
        this.serverSide = bl;
        if (this.serverSide) {
            this.sp = new ServerSpoolPrinter(new AppFactoryImpl().newGuiFactory(), null);
            if (localSpoolPrinter != null && localSpoolPrinter.isServerSide()) {
                ((ServerSpoolPrinter)this.sp).setAttrs((ServerSpoolPrinter)localSpoolPrinter.sp);
            }
        } else {
            int n3 = -1;
            RemotePrintCommandFactory remotePrintCommandFactory = null;
            if (localSpoolPrinter != null && !localSpoolPrinter.isServerSide()) {
                if (localSpoolPrinter.sp instanceof RemotePrintCommandFactory) {
                    remotePrintCommandFactory = (RemotePrintCommandFactory)localSpoolPrinter.sp;
                    n3 = ((RemoteSpoolPrinter)remotePrintCommandFactory.target).getTheObjectId();
                } else {
                    n3 = ((RemoteSpoolPrinter)localSpoolPrinter.sp).getTheObjectId();
                }
            }
            this.sp = ScreenUtility.getGuiFactory().getSpoolPrinter(n3);
            if (IscobolSystem.isAS()) {
                this.sp = new RemotePrintCommandFactory(this.sp, remotePrintCommandFactory);
            }
        }
    }

    public LocalSpoolPrinter(int n2, boolean bl, boolean bl2, boolean bl3, String string, boolean bl4, Events events, boolean bl5, LocalSpoolPrinter localSpoolPrinter) throws IOException {
        this.id = n2;
        this.serverSide = bl5;
        if (this.serverSide) {
            this.sp = new ServerSpoolPrinter(new AppFactoryImpl().newGuiFactory(), events);
            if (localSpoolPrinter != null && localSpoolPrinter.isServerSide()) {
                ((ServerSpoolPrinter)this.sp).setAttrs((ServerSpoolPrinter)localSpoolPrinter.sp);
            }
            ((ServerSpoolPrinter)this.sp).setAttrs(bl, bl2, bl3, string, bl4);
        } else {
            int n3 = -1;
            RemotePrintCommandFactory remotePrintCommandFactory = null;
            if (localSpoolPrinter != null && !localSpoolPrinter.isServerSide()) {
                if (localSpoolPrinter.sp instanceof RemotePrintCommandFactory) {
                    remotePrintCommandFactory = (RemotePrintCommandFactory)localSpoolPrinter.sp;
                    n3 = ((RemoteSpoolPrinter)remotePrintCommandFactory.target).getTheObjectId();
                } else {
                    n3 = ((RemoteSpoolPrinter)localSpoolPrinter.sp).getTheObjectId();
                }
            }
            this.sp = ScreenUtility.getGuiFactory().getSpoolPrinter(bl, bl2, bl3, string, bl4, events, n3);
            if (IscobolSystem.isAS()) {
                this.sp = new RemotePrintCommandFactory(this.sp, remotePrintCommandFactory);
            }
        }
    }

    public int getId() {
        return this.id;
    }

    @Override
    public boolean setup() throws IOException {
        return this.sp.setup();
    }

    @Override
    public double[] setup(double d2, double d3, double d4, double d5) throws IOException {
        return this.sp.setup(d2, d3, d4, d5);
    }

    @Override
    public void setFont(Map map) throws IOException {
        this.myFlush();
        this.sp.setFont(map);
    }

    @Override
    public void setFont(int n2) throws IOException {
        this.myFlush();
        this.sp.setFont(n2);
    }

    @Override
    public Point getPageLayout(Hashtable hashtable) throws IOException {
        this.myFlush();
        return this.sp.getPageLayout(hashtable);
    }

    @Override
    public void setMargins(double d2, double d3, double d4, double d5, int n2) throws IOException {
        this.myFlush();
        this.sp.setMargins(d2, d3, d4, d5, n2);
    }

    @Override
    public double[] getMargins(int n2) throws IOException {
        this.myFlush();
        return this.sp.getMargins(n2);
    }

    @Override
    public void setColor(int n2, int n3, int n4, int n5) throws IOException {
        this.myFlush();
        this.sp.setColor(n2, n3, n4, n5);
    }

    @Override
    public void setBackground(int n2, int n3, int n4, int n5) throws IOException {
        this.myFlush();
        this.sp.setBackground(n2, n3, n4, n5);
    }

    @Override
    public void setLinesPerPage(int n2) throws IOException {
        this.myFlush();
        this.sp.setLinesPerPage(n2);
    }

    @Override
    public void printBitmap(int n2, double d2, double d3, int n3, double d4, double d5, int n4) throws IOException {
        this.myFlush();
        this.sp.printBitmap(n2, d2, d3, n3, d4, d5, n4);
    }

    @Override
    public void drawGraph(int n2, double d2, double d3, double d4, double d5, int n3, String string) throws IOException {
        this.myFlush();
        this.sp.drawGraph(n2, d2, d3, d4, d5, n3, string);
    }

    @Override
    public void setBoxShade(int n2, int n3, int n4, int n5) throws IOException {
        this.myFlush();
        this.sp.setBoxShade(n2, n3, n4, n5);
    }

    @Override
    public void setGraphPen(int n2, double d2, int n3, int n4, int n5, int n6) throws IOException {
        this.myFlush();
        this.sp.setGraphPen(n2, d2, n3, n4, n5, n6);
    }

    @Override
    public void setGraphPenPt(int n2, double d2, int n3, int n4, int n5, int n6) throws IOException {
        this.myFlush();
        this.sp.setGraphPenPt(n2, d2, n3, n4, n5, n6);
    }

    @Override
    public void setGraphBrush(int n2, int n3, int n4, int n5, int n6) throws IOException {
        this.myFlush();
        this.sp.setGraphBrush(n2, n3, n4, n5, n6);
    }

    @Override
    public void setDataColumns(int[] nArray) throws IOException {
        this.myFlush();
        this.sp.setDataColumns(nArray);
    }

    @Override
    public void setPageColumn(boolean bl, double d2, double d3, double d4, int n2, int n3, char c2, boolean bl2) throws IOException {
        this.myFlush();
        this.sp.setPageColumn(bl, d2, d3, d4, n2, n3, c2, bl2);
    }

    @Override
    public void clearPageColumn() throws IOException {
        this.myFlush();
        this.sp.clearPageColumn();
    }

    @Override
    public void setCursor(double d2, double d3, double[] dArray, double[] dArray2, int n2, int n3, byte by) throws IOException {
        this.myFlush();
        this.sp.setCursor(d2, d3, dArray, dArray2, n2, n3, by);
    }

    @Override
    public int getNoPrinters() throws IOException {
        return this.sp.getNoPrinters();
    }

    @Override
    public int getCurrPrinter() throws IOException {
        return this.sp.getCurrPrinter();
    }

    @Override
    public boolean setPrinter(String string) throws IOException {
        return this.sp.setPrinter(string);
    }

    @Override
    public boolean setPrinter(int n2) throws IOException {
        return this.sp.setPrinter(n2);
    }

    @Override
    public void setOrientation(int n2) throws IOException {
        this.myFlush();
        this.sp.setOrientation(n2);
    }

    @Override
    public int getOrientation() throws IOException {
        this.myFlush();
        return this.sp.getOrientation();
    }

    @Override
    public void setQuality(int n2) throws IOException {
        this.myFlush();
        this.sp.setQuality(n2);
    }

    @Override
    public int getQuality() throws IOException {
        this.myFlush();
        return this.sp.getQuality();
    }

    @Override
    public void setJobName(String string, String string2) throws IOException {
        this.sp.setJobName(string, string2);
    }

    @Override
    public String getPrinterName(int n2) throws IOException {
        return this.sp.getPrinterName(n2);
    }

    @Override
    public int getPrinterNumber(String string) throws IOException {
        return this.sp.getPrinterNumber(string);
    }

    @Override
    public String getPrinterURI(int n2) throws IOException {
        return this.sp.getPrinterURI(n2);
    }

    @Override
    public boolean isPrinterDefault(int n2) throws IOException {
        return this.sp.isPrinterDefault(n2);
    }

    @Override
    public int getColorSupport(int n2) throws IOException {
        return this.sp.getColorSupport(n2);
    }

    @Override
    public int getCurrOrientation() throws IOException {
        return this.sp.getCurrOrientation();
    }

    @Override
    public int getCurrCopies() throws IOException {
        return this.sp.getCurrCopies();
    }

    @Override
    public void setCurrCopies(int n2) throws IOException {
        this.sp.setCurrCopies(n2);
    }

    @Override
    public boolean hasDuplexPrinting() throws IOException {
        return this.sp.hasDuplexPrinting();
    }

    @Override
    public void setDuplexPrinting(int n2) throws IOException {
        this.sp.setDuplexPrinting(n2);
    }

    @Override
    public int getDuplexPrinting() throws IOException {
        return this.sp.getDuplexPrinting();
    }

    @Override
    public String getJobName() throws IOException {
        return this.sp.getJobName();
    }

    @Override
    public boolean setMediaSize(int n2) throws IOException {
        this.myFlush();
        return this.sp.setMediaSize(n2);
    }

    @Override
    public boolean setCustomMediaSize(float f2, float f3, int n2) throws IOException {
        this.myFlush();
        return this.sp.setCustomMediaSize(f2, f3, n2);
    }

    @Override
    public int getCurrMediaSize() throws IOException {
        this.myFlush();
        return this.sp.getCurrMediaSize();
    }

    @Override
    public Size2DSyntax getCurrMediaSize2D() throws IOException {
        this.myFlush();
        return this.sp.getCurrMediaSize2D();
    }

    @Override
    public boolean setMediaTray(int n2) throws IOException {
        this.myFlush();
        return this.sp.setMediaTray(n2);
    }

    @Override
    public int getMediaTray() throws IOException {
        this.myFlush();
        return this.sp.getMediaTray();
    }

    @Override
    public void setChromaticity(int n2) throws IOException {
        this.myFlush();
        this.sp.setChromaticity(n2);
    }

    @Override
    public int getChromaticity() throws IOException {
        this.myFlush();
        return this.sp.getChromaticity();
    }

    @Override
    public void setCollate(int n2) throws IOException {
        this.myFlush();
        this.sp.setCollate(n2);
    }

    @Override
    public int getCollate() throws IOException {
        this.myFlush();
        return this.sp.getCollate();
    }

    @Override
    public void reset() throws IOException {
        this.myFlush();
        this.sp.reset();
    }

    @Override
    public int[] getCurrPrinterCapabilities() throws IOException {
        this.myFlush();
        return this.sp.getCurrPrinterCapabilities();
    }

    @Override
    public Hashtable getFontMetrics(Hashtable hashtable) throws IOException {
        this.myFlush();
        return this.sp.getFontMetrics(hashtable);
    }

    @Override
    public void setPitch(char c2, float f2) throws IOException {
        this.myFlush();
        this.sp.setPitch(c2, f2);
    }

    @Override
    public void setDefaultUnits(int n2) throws IOException {
        this.myFlush();
        this.sp.setDefaultUnits(n2);
    }

    @Override
    public void newPage() throws IOException {
        this.myFlush();
        this.sp.newPage();
    }

    @Override
    public void textOut(byte[] byArray, int n2, int n3) throws IOException {
        this.myFlush();
        this.sp.textOut(byArray, n2, n3);
    }

    @Override
    public void printAt(String string, float f2, float f3, float f4, boolean bl, char c2, byte by, boolean bl2) throws IOException {
        this.myFlush();
        this.sp.printAt(string, f2, f3, f4, bl, c2, by, bl2);
    }

    @Override
    public int[][] getMedia4Printer(String string) throws IOException {
        return this.sp.getMedia4Printer(string);
    }

    @Override
    public boolean isServerSide() throws IOException {
        return this.serverSide;
    }

    public void setServerFont(int n2) throws IOException {
        if (this.serverSide) {
            this.myFlush();
            ServerSpoolPrinter serverSpoolPrinter = (ServerSpoolPrinter)this.sp;
            serverSpoolPrinter.setFont(serverSpoolPrinter.getFont(n2, true));
        }
    }

    @Override
    public void setAttribute(String string, String string2) throws IOException {
        this.sp.setAttribute(string, string2);
    }

    @Override
    public boolean hasPrinted() throws IOException {
        return this.sp.hasPrinted();
    }

    @Override
    public void cancelJob() throws IOException {
        this.sp.cancelJob();
    }

    private void myFlush() throws IOException {
        if (this.cIdx > 0) {
            if (this.cIdx < 31743) {
                char[] cArray = new char[this.cIdx];
                System.arraycopy(this.charNBuffer, 0, cArray, 0, this.cIdx);
                this.sp.write(cArray);
            } else {
                this.sp.write(this.charNBuffer, 0, this.cIdx);
            }
            this.cIdx = 0;
        } else if (this.bIdx > 0) {
            if (this.bIdx < 64511) {
                byte[] byArray = new byte[this.bIdx];
                System.arraycopy(this.byteBuffer, 0, byArray, 0, this.bIdx);
                this.sp.write(byArray);
            } else {
                this.sp.write(this.byteBuffer, 0, this.bIdx);
            }
            this.bIdx = 0;
        } else if (this.bxIdx > 0) {
            if (this.bxIdx < 64511) {
                byte[] byArray = new byte[this.bxIdx];
                System.arraycopy(this.charXBuffer, 0, byArray, 0, this.bxIdx);
                this.sp.writeBytes(byArray);
            } else {
                this.sp.writeBytes(this.charXBuffer, 0, this.bxIdx);
            }
            this.bxIdx = 0;
        }
    }

    @Override
    public void close() throws IOException {
        this.myFlush();
        this.byteBuffer = null;
        this.charNBuffer = null;
        this.charXBuffer = null;
        this.sp.close();
        SpoolPrinterList.get().removeSpoolPrinter(this.id);
    }

    @Override
    public IOException printAndClose() throws IOException {
        this.myFlush();
        this.byteBuffer = null;
        this.charNBuffer = null;
        this.charXBuffer = null;
        return this.sp.printAndClose();
    }

    @Override
    public void flush() throws IOException {
        this.myFlush();
        this.sp.flush();
    }

    @Override
    public void write(char[] cArray) throws IOException {
        this.write(cArray, 0, cArray.length);
    }

    @Override
    public void write(char[] cArray, int n2, int n3) throws IOException {
        if (this.byteBuffer != null) {
            throw new MixingCharAndBytesException(3);
        }
        if (this.charXBuffer != null) {
            throw new MixingCharAndBytesException(4);
        }
        if (n3 > Short.MAX_VALUE) {
            this.myFlush();
            this.sp.write(cArray, n2, n3);
        } else if (this.charNBuffer == null) {
            this.charNBuffer = new char[Short.MAX_VALUE];
        } else if (this.cIdx + n3 > Short.MAX_VALUE) {
            this.myFlush();
        }
        System.arraycopy(cArray, n2, this.charNBuffer, this.cIdx, n3);
        this.cIdx += n3;
    }

    @Override
    public void write(int n2) throws IOException {
        this.write(new char[]{(char)n2});
    }

    @Override
    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    @Override
    public void write(byte[] byArray, int n2, int n3) throws IOException {
        if (this.charNBuffer != null) {
            throw new MixingCharAndBytesException(1);
        }
        if (this.charXBuffer != null) {
            throw new MixingCharAndBytesException(2);
        }
        if (n3 > 65535) {
            this.myFlush();
            this.sp.write(byArray, n2, n3);
        } else if (this.byteBuffer == null) {
            this.byteBuffer = new byte[65535];
        } else if (this.bIdx + n3 > 65535) {
            this.myFlush();
        }
        System.arraycopy(byArray, n2, this.byteBuffer, this.bIdx, n3);
        this.bIdx += n3;
    }

    @Override
    public void write(byte by) throws IOException {
        this.write(new byte[]{by});
    }

    @Override
    public void writeBytes(byte[] byArray) throws IOException {
        this.writeBytes(byArray, 0, byArray.length);
    }

    @Override
    public void writeBytes(byte[] byArray, int n2, int n3) throws IOException {
        if (this.charNBuffer != null) {
            throw new MixingCharAndBytesException(6);
        }
        if (this.byteBuffer != null) {
            throw new MixingCharAndBytesException(5);
        }
        if (n3 > 65535) {
            this.myFlush();
            this.sp.writeBytes(byArray, n2, n3);
        } else if (this.charXBuffer == null) {
            this.charXBuffer = new byte[65535];
        } else if (this.bxIdx + n3 > 65535) {
            this.myFlush();
        }
        System.arraycopy(byArray, n2, this.charXBuffer, this.bxIdx, n3);
        this.bxIdx += n3;
    }

    public static QPrinterAttrs handleDashQPrinter(String string) {
        QPrinterAttrs qPrinterAttrs = new QPrinterAttrs();
        if (string.length() > 0) {
            Hashtable<FontAttribute, String> hashtable = null;
            if (string.indexOf(59) < 0) {
                qPrinterAttrs.name = string;
            } else {
                String string2 = null;
                String string3 = null;
                StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
                qPrinterAttrs.name = stringTokenizer.nextToken();
                while (stringTokenizer.hasMoreElements()) {
                    string3 = stringTokenizer.nextToken();
                    int n2 = string3.indexOf(61);
                    if (n2 <= 0 || n2 >= string3.length() - 1) continue;
                    string2 = string3.substring(0, n2).toUpperCase();
                    string3 = string3.substring(n2 + 1, string3.length());
                    if ("DIRECT".equalsIgnoreCase(string2)) {
                        if (!"ON".equalsIgnoreCase(string3)) continue;
                        qPrinterAttrs.direct = true;
                        while (stringTokenizer.hasMoreElements()) {
                            stringTokenizer.nextToken();
                        }
                        continue;
                    }
                    if ("FONT".equals(string2)) {
                        if (hashtable == null) {
                            hashtable = new Hashtable<FontAttribute, String>();
                        }
                        hashtable.put(FontAttribute.FAMILY, string3.trim());
                        continue;
                    }
                    if ("PITCH".equals(string2)) {
                        try {
                            Float f2 = new Float(string3);
                            if (hashtable == null) {
                                hashtable = new Hashtable();
                            }
                            hashtable.put(FontAttribute.SIZE, (String)((Object)f2));
                        }
                        catch (NumberFormatException numberFormatException) {}
                        continue;
                    }
                    if ("LINES".equals(string2)) {
                        try {
                            int n3;
                            qPrinterAttrs.linesPerPage = n3 = Integer.parseInt(string3);
                        }
                        catch (NumberFormatException numberFormatException) {}
                        continue;
                    }
                    if ("ORIENTATION".equals(string2)) {
                        try {
                            int n4;
                            qPrinterAttrs.orientation = n4 = Integer.parseInt(string3);
                        }
                        catch (NumberFormatException numberFormatException) {}
                        continue;
                    }
                    if (!"COPY".equals(string2)) continue;
                    try {
                        int n5;
                        qPrinterAttrs.currCopies = n5 = Integer.parseInt(string3);
                    }
                    catch (NumberFormatException numberFormatException) {
                    }
                }
                if (hashtable != null && !qPrinterAttrs.direct) {
                    qPrinterAttrs.fontAttrs = hashtable;
                }
            }
        }
        return qPrinterAttrs;
    }

    @Override
    public void setPreview(boolean bl) throws IOException {
        this.sp.setPreview(bl);
    }

    @Override
    public void setPDF(boolean bl) throws IOException {
        this.sp.setPDF(bl);
    }

    @Override
    public void updatePrinters() throws IOException {
        this.sp.updatePrinters();
    }

    @Override
    public void setHeaderFooter(String string, String string2, int n2) throws IOException {
        this.sp.setHeaderFooter(string, string2, n2);
    }

    @Override
    public void setReportName(String string) throws IOException {
        this.sp.setReportName(string);
    }

    public void sendCommands() throws IOException {
        if (this.sp instanceof RemotePrintCommandFactory) {
            ((RemotePrintCommandFactory)this.sp).sendCommands();
        }
    }

    public static class QPrinterAttrs {
        public boolean direct;
        public String name;
        public int linesPerPage = Integer.MIN_VALUE;
        public int orientation = Integer.MIN_VALUE;
        public int currCopies = Integer.MIN_VALUE;
        public Hashtable fontAttrs;

        public void copyTo(LocalSpoolPrinter localSpoolPrinter) {
            try {
                localSpoolPrinter.setPrinter(this.name);
                if (this.linesPerPage != Integer.MIN_VALUE) {
                    localSpoolPrinter.setLinesPerPage(this.linesPerPage);
                }
                if (this.orientation != Integer.MIN_VALUE) {
                    localSpoolPrinter.setOrientation(this.orientation);
                }
                if (this.currCopies != Integer.MIN_VALUE) {
                    localSpoolPrinter.setCurrCopies(this.currCopies);
                }
                if (this.fontAttrs != null) {
                    RemoteFontComponent remoteFontComponent = ScreenUtility.getGuiFactory().getFont(this.fontAttrs, 0, 0, true);
                    if (localSpoolPrinter.isServerSide()) {
                        int n2 = UserHandles.ssetId(new FontCmp(remoteFontComponent, this.fontAttrs));
                        localSpoolPrinter.setFont(n2);
                        UserHandles.free(n2);
                    } else {
                        localSpoolPrinter.setFont(remoteFontComponent.getTheObjectId());
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

