/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.rts.print;

import com.iscobol.rts.print.SpoolPrinter;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.print.DocFlavor;
import javax.print.DocPrintJob;
import javax.print.PrintService;
import javax.print.ServiceUIFactory;
import javax.print.attribute.Attribute;
import javax.print.attribute.AttributeSet;
import javax.print.attribute.EnumSyntax;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.PrintServiceAttribute;
import javax.print.attribute.PrintServiceAttributeSet;
import javax.print.attribute.standard.Chromaticity;
import javax.print.attribute.standard.Media;
import javax.print.attribute.standard.MediaSizeName;
import javax.print.attribute.standard.MediaTray;
import javax.print.attribute.standard.OrientationRequested;
import javax.print.attribute.standard.PrintQuality;
import javax.print.attribute.standard.SheetCollate;
import javax.print.attribute.standard.Sides;
import javax.print.event.PrintServiceAttributeListener;

public class MyPrintService
implements Serializable,
PrintService {
    private static final Map<Class, EnumSyntax[]> SUPPORTED_ATTRIBUTE_VALUES = new HashMap<Class, EnumSyntax[]>();
    private static final Map<Class, EnumSyntax> DEFAULT_ATTRIBUTE_VALUES = new HashMap<Class, EnumSyntax>();
    private String name;
    private PrintServiceAttributeSet psas;
    private Class[] sac;
    private DocFlavor[] sdf;
    private PrintRequestAttributeSet printAttributes;

    private static void putValues(Class clazz, EnumSyntax enumSyntax) throws UnsupportedOperationException {
        block2: {
            DEFAULT_ATTRIBUTE_VALUES.put(clazz, enumSyntax);
            try {
                Method method = enumSyntax.getClass().getDeclaredMethod("getEnumValueTable", new Class[0]);
                method.setAccessible(true);
                SUPPORTED_ATTRIBUTE_VALUES.put(clazz, (EnumSyntax[])method.invoke((Object)enumSyntax, new Object[0]));
            }
            catch (Exception exception) {
                if (!"java.lang.reflect.InaccessibleObjectException".equals(exception.getClass().getName())) break block2;
                throw new UnsupportedOperationException();
            }
        }
    }

    public MyPrintService(PrintService printService) {
        this.name = printService.getName();
        this.psas = printService.getAttributes();
        this.sac = printService.getSupportedAttributeCategories();
        this.sdf = printService.getSupportedDocFlavors();
    }

    @Override
    public void addPrintServiceAttributeListener(PrintServiceAttributeListener printServiceAttributeListener) {
    }

    @Override
    public DocPrintJob createPrintJob() {
        return null;
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof MyPrintService) {
            return this.name.equals(((MyPrintService)object).name);
        }
        return false;
    }

    public PrintServiceAttribute getAttribute(Class clazz) {
        Attribute attribute = this.psas.get(clazz);
        return attribute instanceof PrintServiceAttribute ? (PrintServiceAttribute)attribute : null;
    }

    @Override
    public PrintServiceAttributeSet getAttributes() {
        return this.psas;
    }

    public Object getDefaultAttributeValue(Class clazz) {
        return DEFAULT_ATTRIBUTE_VALUES.get(clazz);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public ServiceUIFactory getServiceUIFactory() {
        return null;
    }

    public Class[] getSupportedAttributeCategories() {
        return this.sac;
    }

    public Object getSupportedAttributeValues(Class clazz, DocFlavor docFlavor, AttributeSet attributeSet) {
        return SUPPORTED_ATTRIBUTE_VALUES.get(clazz);
    }

    @Override
    public DocFlavor[] getSupportedDocFlavors() {
        return this.sdf;
    }

    @Override
    public AttributeSet getUnsupportedAttributes(DocFlavor docFlavor, AttributeSet attributeSet) {
        return null;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    public boolean isAttributeCategorySupported(Class clazz) {
        for (Class clazz2 : this.sac) {
            if (clazz2 != clazz) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isAttributeValueSupported(Attribute attribute, DocFlavor docFlavor, AttributeSet attributeSet) {
        return false;
    }

    @Override
    public boolean isDocFlavorSupported(DocFlavor docFlavor) {
        if (docFlavor != null) {
            for (DocFlavor docFlavor2 : this.sdf) {
                if (!docFlavor2.equals(docFlavor)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void removePrintServiceAttributeListener(PrintServiceAttributeListener printServiceAttributeListener) {
    }

    public PrintRequestAttributeSet getPrintAttributes() {
        return this.printAttributes;
    }

    public void setPrintAttributes(PrintRequestAttributeSet printRequestAttributeSet) {
        this.printAttributes = printRequestAttributeSet;
    }

    static {
        try {
            MyPrintService.putValues(OrientationRequested.class, OrientationRequested.PORTRAIT);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            SUPPORTED_ATTRIBUTE_VALUES.put(OrientationRequested.class, new OrientationRequested[]{OrientationRequested.PORTRAIT, OrientationRequested.LANDSCAPE, OrientationRequested.REVERSE_PORTRAIT, OrientationRequested.REVERSE_LANDSCAPE});
        }
        try {
            MyPrintService.putValues(Media.class, SpoolPrinter.getDefaultLocaleMediaSizeName());
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            SUPPORTED_ATTRIBUTE_VALUES.put(Media.class, new MediaSizeName[]{MediaSizeName.ISO_A0, MediaSizeName.ISO_A1, MediaSizeName.ISO_A2, MediaSizeName.ISO_A3, MediaSizeName.ISO_A4, MediaSizeName.ISO_A5, MediaSizeName.ISO_A6, MediaSizeName.ISO_A7, MediaSizeName.ISO_A8, MediaSizeName.ISO_A9, MediaSizeName.ISO_A10, MediaSizeName.ISO_B0, MediaSizeName.ISO_B1, MediaSizeName.ISO_B2, MediaSizeName.ISO_B3, MediaSizeName.ISO_B4, MediaSizeName.ISO_B5, MediaSizeName.ISO_B6, MediaSizeName.ISO_B7, MediaSizeName.ISO_B8, MediaSizeName.ISO_B9, MediaSizeName.ISO_B10, MediaSizeName.JIS_B0, MediaSizeName.JIS_B1, MediaSizeName.JIS_B2, MediaSizeName.JIS_B3, MediaSizeName.JIS_B4, MediaSizeName.JIS_B5, MediaSizeName.JIS_B6, MediaSizeName.JIS_B7, MediaSizeName.JIS_B8, MediaSizeName.JIS_B9, MediaSizeName.JIS_B10, MediaSizeName.ISO_C0, MediaSizeName.ISO_C1, MediaSizeName.ISO_C2, MediaSizeName.ISO_C3, MediaSizeName.ISO_C4, MediaSizeName.ISO_C5, MediaSizeName.ISO_C6, MediaSizeName.NA_LETTER, MediaSizeName.NA_LEGAL, MediaSizeName.EXECUTIVE, MediaSizeName.LEDGER, MediaSizeName.TABLOID, MediaSizeName.INVOICE, MediaSizeName.FOLIO, MediaSizeName.QUARTO, MediaSizeName.JAPANESE_POSTCARD, MediaSizeName.JAPANESE_DOUBLE_POSTCARD, MediaSizeName.A, MediaSizeName.B, MediaSizeName.C, MediaSizeName.D, MediaSizeName.E, MediaSizeName.ISO_DESIGNATED_LONG, MediaSizeName.ITALY_ENVELOPE, MediaSizeName.MONARCH_ENVELOPE, MediaSizeName.PERSONAL_ENVELOPE, MediaSizeName.NA_NUMBER_9_ENVELOPE, MediaSizeName.NA_NUMBER_10_ENVELOPE, MediaSizeName.NA_NUMBER_11_ENVELOPE, MediaSizeName.NA_NUMBER_12_ENVELOPE, MediaSizeName.NA_NUMBER_14_ENVELOPE, MediaSizeName.NA_6X9_ENVELOPE, MediaSizeName.NA_7X9_ENVELOPE, MediaSizeName.NA_9X11_ENVELOPE, MediaSizeName.NA_9X12_ENVELOPE, MediaSizeName.NA_10X13_ENVELOPE, MediaSizeName.NA_10X14_ENVELOPE, MediaSizeName.NA_10X15_ENVELOPE, MediaSizeName.NA_5X7, MediaSizeName.NA_8X10});
        }
        try {
            MyPrintService.putValues(PrintQuality.class, PrintQuality.NORMAL);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            SUPPORTED_ATTRIBUTE_VALUES.put(PrintQuality.class, new PrintQuality[]{PrintQuality.DRAFT, PrintQuality.NORMAL, PrintQuality.HIGH});
        }
        try {
            MyPrintService.putValues(Chromaticity.class, Chromaticity.COLOR);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            SUPPORTED_ATTRIBUTE_VALUES.put(Chromaticity.class, new Chromaticity[]{Chromaticity.MONOCHROME, Chromaticity.COLOR});
        }
        try {
            MyPrintService.putValues(SheetCollate.class, SheetCollate.UNCOLLATED);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            SUPPORTED_ATTRIBUTE_VALUES.put(SheetCollate.class, new SheetCollate[]{SheetCollate.UNCOLLATED, SheetCollate.COLLATED});
        }
        try {
            MyPrintService.putValues(Sides.class, Sides.ONE_SIDED);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            SUPPORTED_ATTRIBUTE_VALUES.put(Sides.class, new Sides[]{Sides.ONE_SIDED, Sides.TWO_SIDED_LONG_EDGE, Sides.TWO_SIDED_SHORT_EDGE});
        }
        try {
            MyPrintService.putValues(MediaTray.class, MediaTray.MAIN);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            SUPPORTED_ATTRIBUTE_VALUES.put(MediaTray.class, new MediaTray[]{MediaTray.TOP, MediaTray.MIDDLE, MediaTray.BOTTOM, MediaTray.ENVELOPE, MediaTray.MANUAL, MediaTray.LARGE_CAPACITY, MediaTray.MAIN, MediaTray.SIDE});
        }
    }
}

