/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.rts.print;

import com.iscobol.rts.File;
import com.iscobol.rts.OSValidator;
import com.iscobol.rts.RtsUtil;
import com.iscobol.rts.print.AttrTable;
import com.iscobol.rts.print.PDFFontMapper;
import com.iscobol.rts.print.RTL;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.FontFactory;
import com.lowagie.text.PageSize;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.DefaultFontMapper;
import com.lowagie.text.pdf.FontMapper;
import com.lowagie.text.pdf.MappedRandomAccessFile;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfPrinterGraphics2D;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import javax.print.attribute.PrintRequestAttributeSet;
import javax.print.attribute.standard.Media;
import javax.print.attribute.standard.MediaPrintableArea;
import javax.print.attribute.standard.MediaSize;
import javax.print.attribute.standard.MediaSizeName;
import javax.print.attribute.standard.OrientationRequested;
import javax.print.attribute.standard.PageRanges;

public class PDF {
    public static final int PDFCRYPT_NO = 0;
    public static final int PDFCRYPT_STD_40 = 1;
    public static final int PDFCRYPT_STD_128 = 2;
    public static final int PDFCRYPT_AES_128 = 3;
    public static final int PDFCRYPT_TYPE_MASK = 7;
    public static final int PDFCRYPT_NO_METADATA = 8;
    public static final int PDFCRYPT_EMBEDDED_FILES_ONLY = 16;
    public static final int PDFCRYPT_MODE_MASK = 255;
    public static final int PDFCRYPT_ALLOW_PRINTING = 256;
    public static final int PDFCRYPT_ALLOW_MODIFY_CONTENT = 512;
    public static final int PDFCRYPT_ALLOW_COPY = 1024;
    public static final int PDFCRYPT_ALLOW_MODIFY_ANNOT = 2048;
    public static final int PDFCRYPT_ALLOW_FILL_IN = 4096;
    public static final int PDFCRYPT_ALLOW_SCREENREADERS = 8192;
    public static final int PDFCRYPT_ALLOW_ASSEMBLY = 16384;
    public static final int PDFCRYPT_DEGRADED_PRINTING = 32768;
    private Printable prn;
    private PageFormat pf;
    private PrinterJob pj;
    private String fileName;
    private int nPages;

    public PDF(Printable printable, PageFormat pageFormat, PrinterJob printerJob, String string, int n2) {
        this.prn = printable;
        this.pf = pageFormat;
        this.pj = printerJob;
        this.fileName = string;
        this.nPages = n2;
    }

    /*
     * WARNING - void declaration
     */
    public boolean doPrint(PrintRequestAttributeSet printRequestAttributeSet, AttrTable attrTable, MediaSize mediaSize) throws IOException {
        Object object2;
        MediaPrintableArea mediaPrintableArea = (MediaPrintableArea)printRequestAttributeSet.get(MediaPrintableArea.class);
        Media media = (Media)printRequestAttributeSet.get(Media.class);
        MediaSize mediaSize2 = mediaSize != null ? mediaSize : (media != null && media instanceof MediaSizeName ? MediaSize.getMediaSizeForName((MediaSizeName)media) : new MediaSize(PageSize.A4.width() / 72.0f, PageSize.A4.height() / 72.0f, 25400));
        float f2 = mediaSize2.getX(25400) * 72.0f;
        float f3 = mediaSize2.getY(25400) * 72.0f;
        float f4 = mediaPrintableArea.getX(25400) * 72.0f;
        float f5 = mediaPrintableArea.getY(25400) * 72.0f;
        float f6 = f2 - mediaPrintableArea.getWidth(25400) * 72.0f - f4;
        float f7 = f3 - mediaPrintableArea.getHeight(25400) * 72.0f - f5;
        OrientationRequested orientationRequested = (OrientationRequested)printRequestAttributeSet.get(OrientationRequested.class);
        if (orientationRequested != null && orientationRequested.equals(OrientationRequested.LANDSCAPE)) {
            float f8 = f2;
            f2 = f3;
            f3 = f8;
        }
        PDFFontMapper pDFFontMapper = new PDFFontMapper(attrTable.get("FONT_DEFAULT"));
        FontFactory.registerDirectories();
        Set<java.io.File> set = PDF.getFolders(attrTable.get("FONT_FOLDER"));
        Set<java.io.File> set2 = PDF.getFolders(attrTable.get("FONT_FOLDER_EMBED"));
        if (set != null) {
            if (set2 != null) {
                set.removeAll(set2);
            }
        } else if (set2 == null) {
            if (OSValidator.isMac()) {
                set2 = PDF.getFolders("/Library/Fonts");
            } else if (OSValidator.isLinux()) {
                set2 = PDF.getFolders("/usr/shared/fonts");
            } else if (OSValidator.isWindows()) {
                set2 = PDF.getFolders("C:\\Windows\\Fonts");
            }
        }
        if (set != null) {
            object2 = Charset.defaultCharset().name();
            for (java.io.File file : set) {
                if (!file.exists() || !file.isDirectory()) continue;
                PDF.insertDirectory(pDFFontMapper, file);
            }
            Iterator iterator = pDFFontMapper.getMapper().keySet().iterator();
            while (iterator.hasNext()) {
                DefaultFontMapper.BaseFontParameters baseFontParameters = pDFFontMapper.getBaseFontParameters((String)iterator.next());
                if (baseFontParameters == null) continue;
                baseFontParameters.embedded = false;
                baseFontParameters.encoding = object2;
            }
        }
        if (set2 != null) {
            for (java.io.File file : set2) {
                if (!file.exists() || !file.isDirectory()) continue;
                PDF.insertDirectory(pDFFontMapper, file);
            }
        }
        object2 = new Document(new Rectangle(f2, f3), f4, f6, f5, f7);
        PageRanges pageRanges = (PageRanges)printRequestAttributeSet.get(PageRanges.class);
        if (pageRanges == null) {
            PageRanges pageRanges2 = new PageRanges(1, this.nPages > 0 ? this.nPages : 1);
        }
        boolean bl = false;
        TreeMap treeMap = null;
        try {
            void var18_26;
            PdfWriter pdfWriter = PdfWriter.getInstance((Document)object2, (OutputStream)new FileOutputStream(File.get(this.fileName)));
            String string = attrTable.get("TITLE");
            if (string != null) {
                object2.addTitle(string);
            }
            if ((string = attrTable.get("SUBJECT")) != null) {
                object2.addSubject(string);
            }
            if ((string = attrTable.get("KEYWORDS")) != null) {
                object2.addKeywords(string);
            }
            if ((string = attrTable.get("AUTHOR")) != null) {
                object2.addAuthor(string);
            }
            if ((string = attrTable.get("EXPIRES")) != null) {
                object2.addHeader("Expires", string);
            }
            if ((string = attrTable.get("JPEG")) != null) {
                try {
                    int n2 = Integer.parseInt(string);
                    if (n2 < 0) {
                        boolean bl2 = false;
                    } else if (n2 > 100) {
                        int n3 = 100;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if ((string = attrTable.get("ENCRYPTION")) != null) {
                int n4;
                try {
                    n4 = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {
                    n4 = 0;
                }
                int n5 = n4;
                if (n5 != 0) {
                    int n6;
                    switch (n5 & 7) {
                        default: {
                            n6 = 0;
                            break;
                        }
                        case 1: {
                            n6 = 0;
                            break;
                        }
                        case 2: {
                            n6 = 1;
                            break;
                        }
                        case 3: {
                            n6 = 2;
                        }
                    }
                    if (n6 != 0) {
                        byte[] byArray;
                        String string2 = attrTable.get("USER_PASSWORD");
                        String string3 = attrTable.get("OWNER_PASSWORD");
                        byte[] byArray2 = string2 != null ? string2.toString().getBytes() : null;
                        byte[] byArray3 = byArray = string3 != null ? string3.toString().getBytes() : null;
                        if ((n5 & 8) != 0) {
                            n6 |= 8;
                        }
                        if ((n5 & 0x10) != 0) {
                            n6 |= 0x18;
                        }
                        int n7 = 0;
                        if ((n5 & 0x100) != 0) {
                            n7 |= 0x804;
                        }
                        if ((n5 & 0x200) != 0) {
                            n7 |= 8;
                        }
                        if ((n5 & 0x400) != 0) {
                            n7 |= 0x10;
                        }
                        if ((n5 & 0x800) != 0) {
                            n7 |= 0x20;
                        }
                        if ((n5 & 0x1000) != 0) {
                            n7 |= 0x100;
                        }
                        if ((n5 & 0x2000) != 0) {
                            n7 |= 0x200;
                        }
                        if ((n5 & 0x4000) != 0) {
                            n7 |= 0x400;
                        }
                        if ((n5 & 0x8000) != 0) {
                            n7 |= 4;
                        }
                        pdfWriter.setEncryption(byArray2, byArray, n7, n6);
                    }
                }
            }
            if ((string = attrTable.get("PDFA")) != null) {
                if ("PDF/A-1A".equals(string.toUpperCase())) {
                    pdfWriter.setPDFXConformance(3);
                } else if ("PDF/A-1B".equals(string.toUpperCase())) {
                    pdfWriter.setPDFXConformance(4);
                }
                pdfWriter.createXmpMetadata();
            }
            object2.open();
            treeMap = new TreeMap(new Comparator(){

                public int compare(Object object, Object object2) {
                    return PDF.compare((Image[])object, (Image[])object2);
                }
            });
            int n8 = var18_26.next(-1);
            while (n8 >= 0) {
                void var19_33;
                PdfContentByte pdfContentByte = pdfWriter.getDirectContent();
                MyPdfPrinterGraphics2D myPdfPrinterGraphics2D = var19_33 > 0 ? new MyPdfPrinterGraphics2D(pdfContentByte, f2, f3, (FontMapper)pDFFontMapper, true, (float)var19_33 / 100.0f, this.pj) : new MyPdfPrinterGraphics2D(pdfContentByte, f2, f3, (FontMapper)pDFFontMapper, false, 0.0f, this.pj);
                myPdfPrinterGraphics2D.setImageMap(treeMap);
                try {
                    this.prn.print((Graphics)((Object)myPdfPrinterGraphics2D), this.pf, n8 - 1);
                }
                catch (PrinterException printerException) {
                    myPdfPrinterGraphics2D.drawString("" + printerException, 0, 0);
                }
                myPdfPrinterGraphics2D.dispose();
                object2.newPage();
                n8 = var18_26.next(n8);
            }
        }
        catch (DocumentException documentException) {
            throw new IOException("" + (Object)((Object)documentException));
        }
        finally {
            if (object2.isOpen()) {
                object2.close();
            }
        }
        return true;
    }

    private static Set<java.io.File> getFolders(String string) {
        if (string == null) {
            return null;
        }
        if ((string = string.trim()).length() == 0) {
            return null;
        }
        LinkedHashSet<java.io.File> linkedHashSet = new LinkedHashSet<java.io.File>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
        while (stringTokenizer.hasMoreTokens()) {
            linkedHashSet.add(new java.io.File(stringTokenizer.nextToken()));
        }
        return linkedHashSet;
    }

    private static void insertDirectory(PDFFontMapper pDFFontMapper, java.io.File file2) {
        pDFFontMapper.insertDirectory(file2.getAbsolutePath());
        for (java.io.File file3 : file2.listFiles(file -> file.isDirectory())) {
            PDF.insertDirectory(pDFFontMapper, file3);
        }
    }

    private static int compare(Image[] imageArray, Image[] imageArray2) {
        if (imageArray[0] != null) {
            if (imageArray2[0] != null) {
                int n2 = imageArray[0].hashCode() - imageArray2[0].hashCode();
                if (n2 != 0) {
                    return n2;
                }
                if (imageArray[1] != null) {
                    if (imageArray2[1] != null) {
                        return imageArray[1].hashCode() - imageArray2[1].hashCode();
                    }
                    return 1;
                }
                if (imageArray2[1] != null) {
                    return -1;
                }
                return 0;
            }
            return 1;
        }
        if (imageArray2[0] != null) {
            return -1;
        }
        return 0;
    }

    static {
        try {
            Class<?> clazz = Class.forName("java.nio.DirectByteBuffer");
            RtsUtil.openModule(clazz, MappedRandomAccessFile.class, "java.nio");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    static class MyPdfPrinterGraphics2D
    extends PdfPrinterGraphics2D {
        MyPdfPrinterGraphics2D(PdfContentByte pdfContentByte, float f2, float f3, FontMapper fontMapper, boolean bl, float f4, PrinterJob printerJob) {
            super(pdfContentByte, f2, f3, fontMapper, false, bl, f4, printerJob);
        }

        public void drawString(String string, float f2, float f3) {
            super.drawString(RTL.checkRTL(string), f2, f3);
        }
    }
}

