/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.rts.print;

import com.iscobol.rts.print.AutoHeaderFooter;
import com.iscobol.rts.print.PrintCommand;
import com.iscobol.rts.print.PrintCommandList;
import com.iscobol.rts.print.PrintContext;
import java.awt.Graphics2D;
import java.awt.print.PageFormat;
import java.io.Serializable;

public class Page
implements Serializable {
    private PrintContext pc;
    private PrintCommandList cmdList;
    long firstElement = -1L;
    long lastElement = -1L;
    int numElem = 0;

    Page(PrintContext printContext, PrintCommandList printCommandList) {
        this.pc = new PrintContext(printContext);
        this.cmdList = printCommandList;
    }

    void addItem(long l2) {
        this.lastElement = l2;
        if (this.firstElement < 0L) {
            this.firstElement = l2;
        }
        ++this.numElem;
    }

    int getItemNum() {
        return this.numElem;
    }

    PrintCommand getFirstItem() {
        if (this.cmdList != null) {
            return this.cmdList.getAt(this.firstElement);
        }
        return null;
    }

    void print(Graphics2D graphics2D, PageFormat pageFormat, AutoHeaderFooter autoHeaderFooter, int n2) {
        PrintContext printContext = new PrintContext(this.pc);
        graphics2D.setFont(printContext.font);
        graphics2D.setColor(printContext.color);
        printContext.frc = graphics2D.getFontRenderContext();
        if (this.firstElement < 0L) {
            return;
        }
        long l2 = this.firstElement;
        PrintCommand printCommand = this.cmdList.getAt(this.firstElement);
        while (l2 <= this.lastElement && printCommand != null) {
            printCommand.print(printContext, graphics2D, pageFormat);
            l2 = this.cmdList.getNextIdx();
            printCommand = this.cmdList.getNext();
        }
        if (autoHeaderFooter != null) {
            autoHeaderFooter.print(graphics2D, pageFormat, n2);
        }
    }

    public void finalize() {
    }
}

