/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.rts.print;

import com.iscobol.gui.GuiFactory;
import com.iscobol.rts.HandlesManager;
import java.awt.Font;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.Serializable;

public class PageColumn
implements Serializable,
Cloneable,
Comparable {
    public static final char ALIGN_NONE = ' ';
    public static final char ALIGN_LEFT = 'L';
    public static final char ALIGN_RIGHT = 'R';
    public static final char ALIGN_CENTER = 'C';
    public static final char ALIGN_DECIMAL = 'D';
    public static final char ALIGN_DECIMAL_SUPPRESS = 'S';
    private boolean pComma;
    private float start;
    private float indent;
    private float separation;
    private Font font;
    private int fontId = -1;
    private int unit;
    private char align;
    private boolean transparency;

    public PageColumn(GuiFactory guiFactory, HandlesManager handlesManager, boolean bl, float f2, float f3, float f4, Font font, int n2, char c2, boolean bl2) {
        this.pComma = bl;
        this.start = f2;
        this.indent = f3;
        this.separation = f4;
        this.font = font;
        if (this.font != null) {
            this.fontId = handlesManager.newHandle(this.font);
        }
        this.unit = n2;
        this.align = c2;
        this.transparency = bl2;
    }

    public PageColumn(GuiFactory guiFactory, HandlesManager handlesManager, RandomAccessFile randomAccessFile) throws IOException {
        this.pComma = randomAccessFile.readBoolean();
        this.start = randomAccessFile.readFloat();
        this.indent = randomAccessFile.readFloat();
        this.separation = randomAccessFile.readFloat();
        this.fontId = randomAccessFile.readInt();
        this.font = (Font)handlesManager.getObject(this.fontId);
        this.unit = randomAccessFile.readInt();
        this.align = randomAccessFile.readChar();
        this.transparency = randomAccessFile.readBoolean();
    }

    public int compareTo(Object object) {
        if (object instanceof PageColumn) {
            PageColumn pageColumn = (PageColumn)object;
            if (this.start < pageColumn.start) {
                return -1;
            }
            if (this.start > pageColumn.start) {
                return 1;
            }
            return 0;
        }
        return -1;
    }

    void toFile(RandomAccessFile randomAccessFile) throws IOException {
        randomAccessFile.writeBoolean(this.pComma);
        randomAccessFile.writeFloat(this.start);
        randomAccessFile.writeFloat(this.indent);
        randomAccessFile.writeFloat(this.separation);
        randomAccessFile.writeInt(this.fontId);
        randomAccessFile.writeInt(this.unit);
        randomAccessFile.writeChar(this.align);
        randomAccessFile.writeBoolean(this.transparency);
    }

    public boolean getPComma() {
        return this.pComma;
    }

    public float getStart() {
        return this.start;
    }

    public float getIndent() {
        return this.indent;
    }

    public float getSeparation() {
        return this.separation;
    }

    public Font getFont() {
        return this.font;
    }

    public int getUnit() {
        return this.unit;
    }

    public char getAlign() {
        return this.align;
    }

    public boolean getTransparency() {
        return this.transparency;
    }
}

