/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.rts.print;

import com.iscobol.gui.GuiFactory;
import com.iscobol.rts.print.PrintCommand;
import com.iscobol.rts.print.PrintContext;
import java.awt.Graphics2D;
import java.awt.font.TextLayout;
import java.awt.print.PageFormat;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.StringTokenizer;

public class PrintAt
extends PrintCommand {
    private String text;
    private float left;
    private float top;
    private float width;
    private char align;
    private boolean relativePos;
    private byte yStart;
    private boolean clipping;

    public PrintAt(GuiFactory guiFactory, String string, float f2, float f3, float f4, boolean bl, char c2, byte by, boolean bl2) {
        super(guiFactory, 16);
        this.text = string.trim();
        this.left = f2;
        this.top = f3;
        this.width = f4;
        this.relativePos = bl;
        this.align = c2;
        this.yStart = by;
        this.clipping = bl2;
    }

    public PrintAt(GuiFactory guiFactory, RandomAccessFile randomAccessFile) throws IOException {
        super(guiFactory, 12);
        this.text = randomAccessFile.readUTF();
        this.left = randomAccessFile.readFloat();
        this.top = randomAccessFile.readFloat();
        this.width = randomAccessFile.readFloat();
        this.relativePos = randomAccessFile.readBoolean();
        this.align = randomAccessFile.readChar();
        this.yStart = randomAccessFile.readByte();
        this.clipping = randomAccessFile.readBoolean();
    }

    @Override
    void toFile(RandomAccessFile randomAccessFile) throws IOException {
        randomAccessFile.writeUTF(this.text);
        randomAccessFile.writeFloat(this.left);
        randomAccessFile.writeFloat(this.top);
        randomAccessFile.writeFloat(this.width);
        randomAccessFile.writeBoolean(this.relativePos);
        randomAccessFile.writeChar(this.align);
        randomAccessFile.writeByte(this.yStart);
        randomAccessFile.writeBoolean(this.clipping);
    }

    private final float getYOffs(TextLayout textLayout) {
        return PrintAt.getYOffs(this.yStart, textLayout);
    }

    @Override
    public boolean testPrint(PrintContext printContext, Graphics2D graphics2D, PageFormat pageFormat) {
        return this.print(printContext, null, pageFormat);
    }

    private void myDraw(Graphics2D graphics2D, PrintContext printContext, TextLayout textLayout, String string, float f2, float f3, float f4) {
        switch (this.align) {
            case 'R': {
                f2 += f4;
                break;
            }
            case 'C': {
                f2 += f4 / 2.0f;
                break;
            }
        }
        PrintAt.drawString(graphics2D, printContext, textLayout, string.trim(), f2, f3);
    }

    @Override
    public boolean print(PrintContext printContext, Graphics2D graphics2D, PageFormat pageFormat) {
        TextLayout textLayout = new TextLayout(this.text, printContext.font, printContext.frc);
        float f2 = textLayout.getAscent() + textLayout.getDescent() + textLayout.getLeading();
        if (PrintAt.gtAtTolerance(printContext.pen.y + f2, pageFormat.getImageableHeight())) {
            return false;
        }
        if (graphics2D != null) {
            float f3 = this.relativePos ? printContext.pen.x + this.left : this.left;
            float f4 = this.relativePos ? printContext.pen.y + this.top : this.top;
            float f5 = this.getYOffs(textLayout);
            if (this.width > 0.0f) {
                float f6 = textLayout.getAdvance();
                if (f6 > this.width) {
                    StringTokenizer stringTokenizer = new StringTokenizer(this.text, " \t\n\r", true);
                    StringBuffer stringBuffer = new StringBuffer();
                    StringBuffer stringBuffer2 = new StringBuffer();
                    int n2 = 0;
                    while (stringTokenizer.hasMoreTokens()) {
                        float f7;
                        String string = stringTokenizer.nextToken();
                        stringBuffer2.append(string);
                        textLayout = new TextLayout(stringBuffer2.toString(), printContext.font, printContext.frc);
                        f6 = textLayout.getAdvance();
                        if (f7 > this.width) {
                            if (stringBuffer.length() == 0) {
                                this.myDraw(graphics2D, printContext, textLayout, stringBuffer2.toString(), f3, f4 + f5, this.width - f6);
                                stringBuffer2.setLength(0);
                            } else {
                                textLayout = new TextLayout(stringBuffer.toString(), printContext.font, printContext.frc);
                                f6 = textLayout.getAdvance();
                                this.myDraw(graphics2D, printContext, textLayout, stringBuffer.toString(), f3, f4 + f5, this.width - f6);
                                stringBuffer.setLength(0);
                                stringBuffer2.setLength(0);
                                stringBuffer.append(string);
                                stringBuffer2.append(string);
                            }
                            f4 += f2;
                            printContext.pen.y += f2;
                            if (this.clipping) {
                                break;
                            }
                        } else {
                            stringBuffer.append(string);
                        }
                        ++n2;
                    }
                    if (stringBuffer.length() > 0 && !this.clipping) {
                        textLayout = new TextLayout(stringBuffer.toString(), printContext.font, printContext.frc);
                        f6 = textLayout.getAdvance();
                        this.myDraw(graphics2D, printContext, textLayout, stringBuffer.toString(), f3, f4 + f5, this.width - f6);
                    }
                } else {
                    this.myDraw(graphics2D, printContext, textLayout, this.text, f3, f4 + f5, this.width - f6);
                }
            } else {
                this.myDraw(graphics2D, printContext, textLayout, this.text, f3, f4 + this.getYOffs(textLayout), 0.0f);
            }
        }
        printContext.pen.x = this.width > 0.0f ? (printContext.pen.x += this.width) : (printContext.pen.x += textLayout.getAdvance());
        return true;
    }
}

