/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.rts.print;

import com.iscobol.gui.GuiFactory;
import com.iscobol.rts.HandlesManager;
import com.iscobol.rts.print.PrintCommand;
import com.iscobol.rts.print.PrintContext;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.print.PageFormat;
import java.io.IOException;
import java.io.RandomAccessFile;

public class PrintBitmap
extends PrintCommand {
    private Image bitmap;
    private int imageId;
    private double row;
    private double col;
    private double height;
    private double width;
    private boolean locCells;
    private boolean sizeCells;

    public PrintBitmap(GuiFactory guiFactory, HandlesManager handlesManager, Image image, double d2, double d3, boolean bl, double d4, double d5, boolean bl2) {
        super(guiFactory, 4);
        this.bitmap = image;
        if (this.bitmap != null) {
            this.imageId = handlesManager.newHandle(this.bitmap);
        }
        this.row = d2;
        this.col = d3;
        this.locCells = bl;
        this.height = d4;
        this.width = d5;
        this.sizeCells = bl2;
    }

    PrintBitmap(GuiFactory guiFactory, HandlesManager handlesManager, RandomAccessFile randomAccessFile) throws IOException {
        super(guiFactory, 4);
        this.imageId = randomAccessFile.readInt();
        this.bitmap = (Image)handlesManager.getObject(this.imageId);
        this.row = randomAccessFile.readDouble();
        this.col = randomAccessFile.readDouble();
        this.locCells = randomAccessFile.readBoolean();
        this.height = randomAccessFile.readDouble();
        this.width = randomAccessFile.readDouble();
        this.sizeCells = randomAccessFile.readBoolean();
    }

    @Override
    void toFile(RandomAccessFile randomAccessFile) throws IOException {
        randomAccessFile.writeInt(this.imageId);
        randomAccessFile.writeDouble(this.row);
        randomAccessFile.writeDouble(this.col);
        randomAccessFile.writeBoolean(this.locCells);
        randomAccessFile.writeDouble(this.height);
        randomAccessFile.writeDouble(this.width);
        randomAccessFile.writeBoolean(this.sizeCells);
    }

    @Override
    public boolean testPrint(PrintContext printContext, Graphics2D graphics2D, PageFormat pageFormat) {
        return this.print(printContext, null, pageFormat);
    }

    @Override
    public boolean print(PrintContext printContext, Graphics2D graphics2D, PageFormat pageFormat) {
        if (graphics2D != null) {
            if (this.locCells || this.sizeCells) {
                FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
                TextLayout textLayout = new TextLayout("0", graphics2D.getFont(), fontRenderContext);
                float f2 = PrintBitmap.getCellHeight(printContext, textLayout);
                float f3 = textLayout.getAdvance();
                if (this.locCells) {
                    if (this.sizeCells) {
                        PrintBitmap.draw(graphics2D, this.bitmap, this.col * (double)f3, this.row * (double)f2, this.width * (double)f3, this.height * (double)f2);
                    } else {
                        PrintBitmap.draw(graphics2D, this.bitmap, this.col * (double)f3, this.row * (double)f2, this.width, this.height);
                    }
                } else if (this.sizeCells) {
                    PrintBitmap.draw(graphics2D, this.bitmap, this.col, this.row, this.width * (double)f3, this.height * (double)f2);
                }
            } else {
                PrintBitmap.draw(graphics2D, this.bitmap, this.col, this.row, this.width, this.height);
            }
        }
        return true;
    }

    private static void draw(Graphics2D graphics2D, Image image, double d2, double d3, double d4, double d5) {
        if (image == null) {
            return;
        }
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.translate(d2, d3);
        if (d5 == 0.0 && d4 == 0.0) {
            graphics2D.drawImage(image, affineTransform, null);
            return;
        }
        double d6 = image.getWidth(null);
        double d7 = image.getHeight(null);
        if (d6 == d4 && d7 == d5) {
            graphics2D.drawImage(image, affineTransform, null);
            return;
        }
        if (d5 == 0.0 ^ d4 == 0.0) {
            if (d5 == 0.0) {
                d5 = d4 * (d7 / d6);
            } else if (d4 == 0.0) {
                d4 = d5 * (d6 / d7);
            }
        }
        affineTransform.scale(d4 / d6, d5 / d7);
        graphics2D.drawImage(image, affineTransform, null);
    }
}

