/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.rts.print;

import com.iscobol.gui.GuiFactory;
import com.iscobol.gui.client.AbstractGuiFactoryImpl;
import com.iscobol.rts.IscobolRuntimeException;
import com.iscobol.rts.RuntimeErrorsNumbers;
import com.iscobol.rts.print.DrawGraph;
import com.iscobol.rts.print.PrintAt;
import com.iscobol.rts.print.PrintBitmap;
import com.iscobol.rts.print.PrintBitmapSrv;
import com.iscobol.rts.print.PrintBytes;
import com.iscobol.rts.print.PrintCommandList;
import com.iscobol.rts.print.PrintContext;
import com.iscobol.rts.print.PrintNewLine;
import com.iscobol.rts.print.PrintString;
import com.iscobol.rts.print.SetBackground;
import com.iscobol.rts.print.SetBoxShade;
import com.iscobol.rts.print.SetColor;
import com.iscobol.rts.print.SetCursor;
import com.iscobol.rts.print.SetDataColumns;
import com.iscobol.rts.print.SetFont;
import com.iscobol.rts.print.SetGraphBrush;
import com.iscobol.rts.print.SetGraphPen;
import com.iscobol.rts.print.SetNewPage;
import com.iscobol.rts.print.SetPageColumns;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.font.TextLayout;
import java.awt.geom.Rectangle2D;
import java.awt.print.PageFormat;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.RandomAccessFile;
import java.io.Serializable;

public abstract class PrintCommand
implements RuntimeErrorsNumbers,
Serializable {
    private static final long serialVersionUID = 1L;
    private int cmd;
    protected static final int CMD_NOOP = 0;
    protected static final int CMD_PRINT_STRING = 1;
    protected static final int CMD_SET_FONT = 2;
    protected static final int CMD_SET_COLOR = 3;
    protected static final int CMD_PRINT_BITMAP = 4;
    protected static final int CMD_DRAW_GRAPH = 5;
    protected static final int CMD_SET_GRAPH_PEN = 6;
    protected static final int CMD_SET_GRAPH_BRUSH = 7;
    protected static final int CMD_SET_DATA_COLUMNS = 8;
    protected static final int CMD_SET_PAGE_COLUMNS = 9;
    protected static final int CMD_SET_NEW_PAGE = 10;
    protected static final int CMD_SET_CURSOR = 11;
    protected static final int CMD_SET_NEW_LINE = 12;
    protected static final int CMD_SET_LINES_PER_PAGE = 13;
    protected static final int CMD_PRINT_BITMAP_SRV = 14;
    protected static final int CMD_PRINT_BYTES = 15;
    protected static final int CMD_PRINT_AT = 16;
    protected static final int CMD_SET_BACKGROUND = 17;
    protected static final int CMD_SET_BOX_SHADE = 18;
    protected transient AbstractGuiFactoryImpl gf;
    public static final byte YO_DEFAULT = 0;
    public static final byte YO_BASELINE = 1;
    public static final byte YO_TOP = 2;
    public static final byte YO_DESCENT = 3;
    public static final byte YO_BOTTOM = 4;

    protected PrintCommand(GuiFactory guiFactory) {
        this.gf = (AbstractGuiFactoryImpl)guiFactory;
    }

    protected PrintCommand(GuiFactory guiFactory, int n2) {
        this.gf = (AbstractGuiFactoryImpl)guiFactory;
        this.cmd = n2;
    }

    public abstract boolean testPrint(PrintContext var1, Graphics2D var2, PageFormat var3);

    public abstract boolean print(PrintContext var1, Graphics2D var2, PageFormat var3);

    public boolean addMeToPage() {
        return true;
    }

    static PrintCommand read(PrintCommandList printCommandList) throws IOException {
        PrintCommand printCommand;
        int n2 = printCommandList.inOut.readInt();
        switch (n2) {
            case 0: {
                printCommand = null;
                break;
            }
            case 17: {
                printCommand = new SetBackground((GuiFactory)printCommandList.gf, printCommandList.inOut);
                break;
            }
            case 16: {
                printCommand = new PrintAt((GuiFactory)printCommandList.gf, printCommandList.inOut);
                break;
            }
            case 15: {
                printCommand = new PrintBytes((GuiFactory)printCommandList.gf, printCommandList.inOut);
                break;
            }
            case 1: {
                printCommand = new PrintString((GuiFactory)printCommandList.gf, printCommandList.inOut);
                break;
            }
            case 3: {
                printCommand = new SetColor((GuiFactory)printCommandList.gf, printCommandList.inOut);
                break;
            }
            case 5: {
                printCommand = new DrawGraph((GuiFactory)printCommandList.gf, printCommandList.inOut);
                break;
            }
            case 4: {
                printCommand = new PrintBitmap(printCommandList.gf, printCommandList.locHandles, printCommandList.inOut);
                break;
            }
            case 6: {
                printCommand = new SetGraphPen((GuiFactory)printCommandList.gf, printCommandList.inOut);
                break;
            }
            case 7: {
                printCommand = new SetGraphBrush((GuiFactory)printCommandList.gf, printCommandList.inOut);
                break;
            }
            case 18: {
                printCommand = new SetBoxShade((GuiFactory)printCommandList.gf, printCommandList.inOut);
                break;
            }
            case 10: {
                printCommand = new SetNewPage((GuiFactory)printCommandList.gf, printCommandList.inOut);
                break;
            }
            case 11: {
                printCommand = new SetCursor((GuiFactory)printCommandList.gf, printCommandList.inOut);
                break;
            }
            case 12: {
                printCommand = new PrintNewLine((GuiFactory)printCommandList.gf, printCommandList.inOut);
                break;
            }
            case 8: {
                SetDataColumns setDataColumns = new SetDataColumns((GuiFactory)printCommandList.gf, printCommandList.inOut);
                printCommand = setDataColumns;
                printCommandList.classDataCols = setDataColumns.getCols();
                break;
            }
            case 9: {
                printCommand = new SetPageColumns(printCommandList.gf, printCommandList.locHandles, printCommandList.inOut);
                break;
            }
            case 2: {
                printCommand = new SetFont((GuiFactory)printCommandList.gf, printCommandList.locHandles, printCommandList.inOut);
                break;
            }
            case 14: {
                printCommand = new PrintBitmapSrv((GuiFactory)printCommandList.gf, printCommandList.inOut);
                break;
            }
            default: {
                byte[] byArray = new byte[printCommandList.inOut.readInt()];
                printCommandList.inOut.read(byArray);
                ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byArray));
                try {
                    printCommand = (PrintCommand)objectInputStream.readObject();
                    break;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new IscobolRuntimeException(3, " [" + classNotFoundException + "]");
                }
            }
        }
        return printCommand;
    }

    static void write(PrintCommand printCommand, RandomAccessFile randomAccessFile) throws IOException {
        randomAccessFile.writeInt(printCommand.cmd);
        switch (printCommand.cmd) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                printCommand.toFile(randomAccessFile);
                break;
            }
            default: {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
                objectOutputStream.writeObject(printCommand);
                byte[] byArray = byteArrayOutputStream.toByteArray();
                randomAccessFile.writeInt(byArray.length);
                randomAccessFile.write(byArray);
            }
        }
    }

    protected static float getYOffs(byte by, TextLayout textLayout) {
        switch (by) {
            default: {
                return textLayout.getAscent();
            }
            case 1: {
                return 0.0f;
            }
            case 3: {
                return textLayout.getDescent();
            }
            case 4: 
        }
        return -textLayout.getDescent();
    }

    void toFile(RandomAccessFile randomAccessFile) throws IOException {
        throw new IscobolRuntimeException(3, " [" + this.getClass() + "]");
    }

    protected static float getCellHeight(PrintContext printContext, TextLayout textLayout) {
        if (printContext.advancing > 0.0f) {
            return printContext.advancing;
        }
        return PrintCommand.getHeight(textLayout);
    }

    static boolean gtAtTolerance(float f2, double d2) {
        return (double)f2 > d2 * 1.000001;
    }

    static float getHeight(TextLayout textLayout) {
        return textLayout.getAscent() + textLayout.getDescent() + textLayout.getLeading();
    }

    static void drawString(Graphics2D graphics2D, PrintContext printContext, TextLayout textLayout, String string, float f2, float f3) {
        PrintCommand.drawString(graphics2D, null, printContext, textLayout, string, f2, f3);
    }

    static void drawString(Graphics2D graphics2D, Font font, PrintContext printContext, TextLayout textLayout, String string, float f2, float f3) {
        if (graphics2D != null) {
            graphics2D.setFont(font != null ? font : printContext.font);
            if (printContext.isBackgroundSet()) {
                float f4 = PrintCommand.getHeight(textLayout) + 1.0f;
                Rectangle2D.Float float_ = new Rectangle2D.Float(f2, f3 - f4 + textLayout.getDescent(), textLayout.getAdvance() + 1.0f, f4);
                graphics2D.setColor(printContext.background);
                graphics2D.fill(float_);
                graphics2D.setColor(printContext.color);
            }
            graphics2D.drawString(string, f2, f3);
        }
    }
}

