/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.rts.print;

import com.iscobol.gui.GuiFactory;
import com.iscobol.gui.client.AbstractGuiFactoryImpl;
import com.iscobol.rts.Config;
import com.iscobol.rts.HandlesManager;
import com.iscobol.rts.IscobolRuntimeException;
import com.iscobol.rts.RuntimeErrorsNumbers;
import com.iscobol.rts.print.PageColumn;
import com.iscobol.rts.print.PrintCommand;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Vector;

public class PrintCommandList
implements RuntimeErrorsNumbers {
    private long nextIdx = 0L;
    private Vector vec;
    private int numElem = 0;
    private File file;
    RandomAccessFile inOut;
    private boolean onFile;
    AbstractGuiFactoryImpl gf;
    final HandlesManager locHandles = new HandlesManager();
    PageColumn[] classPageCols;
    int[] classDataCols;

    public PrintCommandList(GuiFactory guiFactory, boolean bl) {
        this.gf = (AbstractGuiFactoryImpl)guiFactory;
        this.onFile = bl;
        if (this.onFile) {
            try {
                this.file = File.createTempFile("picobol_prn", null);
                this.file.deleteOnExit();
                this.inOut = new RandomAccessFile(this.file, "rw");
            }
            catch (IOException iOException) {
                throw new IscobolRuntimeException(8, iOException.toString());
            }
        } else {
            this.vec = new Vector();
        }
    }

    public PrintCommandList(GuiFactory guiFactory) {
        this(guiFactory, !Config.b("iscobol.print.memory", false));
    }

    long addItem(PrintCommand printCommand) {
        long l2 = 0L;
        if (this.onFile) {
            try {
                l2 = this.inOut.length();
                this.inOut.seek(l2);
                PrintCommand.write(printCommand, this.inOut);
                this.nextIdx = this.inOut.getFilePointer();
            }
            catch (IOException iOException) {
                throw new IscobolRuntimeException(8, this.file.getPath() + ": " + iOException.toString());
            }
        } else {
            this.vec.addElement(printCommand);
            ++this.nextIdx;
            l2 = this.numElem;
        }
        ++this.numElem;
        return l2;
    }

    PrintCommand getNext() {
        PrintCommand printCommand = null;
        if (this.onFile) {
            try {
                printCommand = PrintCommand.read(this);
                this.nextIdx = this.inOut.getFilePointer();
            }
            catch (EOFException eOFException) {
            }
            catch (IOException iOException) {
                throw new IscobolRuntimeException(8, this.file.getPath() + ": " + iOException.toString());
            }
        } else {
            try {
                printCommand = (PrintCommand)this.vec.elementAt((int)this.nextIdx++);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                --this.nextIdx;
            }
        }
        return printCommand;
    }

    int getItemNum() {
        return this.numElem;
    }

    public void finalize() {
        if (this.onFile) {
            try {
                this.inOut.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.file.delete();
        }
    }

    PrintCommand getFirst() {
        return this.getAt(0L);
    }

    PrintCommand getAt(long l2) {
        PrintCommand printCommand = null;
        if (this.onFile) {
            try {
                this.inOut.seek(l2);
            }
            catch (IOException iOException) {
                throw new IscobolRuntimeException(8, this.file.getPath() + ": " + iOException.toString());
            }
        }
        try {
            this.nextIdx = l2;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        printCommand = this.getNext();
        return printCommand;
    }

    long getNextIdx() {
        return this.nextIdx;
    }
}

