/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.rts.print;

import com.iscobol.gui.GuiFactory;
import com.iscobol.rts.print.PageColumn;
import com.iscobol.rts.print.PrintCommand;
import com.iscobol.rts.print.PrintContext;
import com.iscobol.types.CobolVar;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.print.PageFormat;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;

public abstract class PrintData
extends PrintCommand {
    protected final Data data;
    protected final int len;
    protected final byte yStart;

    public PrintData(GuiFactory guiFactory, Data data, byte by, int n2) {
        super(guiFactory, n2);
        this.data = data;
        this.len = data.length();
        this.yStart = by;
    }

    public PrintData(GuiFactory guiFactory, RandomAccessFile randomAccessFile, int n2) throws IOException {
        super(guiFactory, n2);
        this.data = new Data(randomAccessFile);
        this.len = this.data.length();
        this.yStart = randomAccessFile.readByte();
    }

    @Override
    void toFile(RandomAccessFile randomAccessFile) throws IOException {
        this.data.write(randomAccessFile);
        randomAccessFile.writeByte(this.yStart);
    }

    @Override
    public boolean testPrint(PrintContext printContext, Graphics2D graphics2D, PageFormat pageFormat) {
        return this.print(printContext, null, pageFormat);
    }

    @Override
    public boolean print(PrintContext printContext, Graphics2D graphics2D, PageFormat pageFormat) {
        if (printContext.pgCols == null && printContext.dataCols == null) {
            return this.printPlain(printContext, graphics2D, pageFormat);
        }
        return this.printColumns(printContext, graphics2D, pageFormat);
    }

    private float getYOffs(TextLayout textLayout) {
        return PrintData.getYOffs(this.yStart, textLayout);
    }

    public boolean printPlain(PrintContext printContext, Graphics2D graphics2D, PageFormat pageFormat) {
        if (this.data.text != null && this.data.text.length() > 0) {
            TextLayout textLayout = new TextLayout(this.data.text, printContext.font, printContext.frc);
            if (PrintData.gtAtTolerance(printContext.pen.y + textLayout.getAscent() + textLayout.getDescent() + textLayout.getLeading(), pageFormat.getImageableHeight())) {
                return false;
            }
            if (graphics2D != null) {
                PrintData.drawString(graphics2D, printContext, textLayout, this.data.text, printContext.pen.x, printContext.pen.y + this.getYOffs(textLayout));
            }
            printContext.pen.x += textLayout.getAdvance();
        }
        return true;
    }

    public boolean printColumns(PrintContext printContext, Graphics2D graphics2D, PageFormat pageFormat) {
        TextLayout textLayout = new TextLayout("0", printContext.font, printContext.frc);
        if (PrintData.gtAtTolerance(printContext.pen.y + textLayout.getAscent() + textLayout.getDescent() + textLayout.getLeading(), pageFormat.getImageableHeight())) {
            return false;
        }
        printContext.pen.y += this.getYOffs(textLayout);
        if (graphics2D != null) {
            int n2 = 1;
            int n3 = 9999;
            if (printContext.pgCols == null) {
                n3 = printContext.dataCols[0];
                this.printColumn(printContext, graphics2D, pageFormat, n2, n3, null, null);
            } else {
                Arrays.sort(printContext.pgCols);
                for (int i2 = 0; i2 < printContext.pgCols.length; ++i2) {
                    PageColumn pageColumn;
                    try {
                        n3 = printContext.dataCols[i2];
                    }
                    catch (NullPointerException nullPointerException) {
                        n3 = 9999;
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        n3 = 9999;
                    }
                    try {
                        pageColumn = printContext.pgCols[i2 + 1];
                    }
                    catch (NullPointerException nullPointerException) {
                        pageColumn = null;
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        pageColumn = null;
                    }
                    if (n3 <= n2) continue;
                    this.printColumn(printContext, graphics2D, pageFormat, n2, n3, printContext.pgCols[i2], pageColumn);
                    n2 = n3;
                }
            }
        }
        printContext.pen.y -= this.getYOffs(textLayout);
        return true;
    }

    public boolean printColumn(PrintContext printContext, Graphics2D graphics2D, PageFormat pageFormat, int n2, int n3, PageColumn pageColumn, PageColumn pageColumn2) {
        block27: {
            TextLayout textLayout;
            String string;
            Font font;
            double d2;
            double d3;
            block29: {
                block28: {
                    int n4 = this.data.length();
                    if (n2 > n4 || n2 >= n3) break block27;
                    d3 = printContext.pen.x;
                    d2 = printContext.pen.y;
                    font = printContext.font;
                    float f2 = 0.0f;
                    float f3 = 0.0f;
                    int n5 = 32;
                    boolean bl = true;
                    double d4 = 1.0;
                    if (pageColumn != null) {
                        if (pageColumn.getFont() != null) {
                            font = pageColumn.getFont();
                        }
                        d4 = PrintData.getFactor(pageColumn.getUnit(), font, printContext.frc);
                        d3 = (double)pageColumn.getStart() * d4 + (double)pageColumn.getIndent() * d4;
                    }
                    if (n4 < n3) {
                        if (this.data.bytes != null) {
                            try {
                                string = new String(this.data.bytes, n2 - 1, this.data.bytes_length - n2 + 1, Data.encoding);
                            }
                            catch (UnsupportedEncodingException unsupportedEncodingException) {
                                string = "";
                            }
                        } else {
                            string = this.data.text.substring(n2 - 1);
                        }
                    } else if (this.data.bytes != null) {
                        try {
                            string = new String(this.data.bytes, n2 - 1, n3 - n2, Data.encoding);
                        }
                        catch (UnsupportedEncodingException unsupportedEncodingException) {
                            string = "";
                        }
                    } else {
                        string = this.data.text.substring(n2 - 1, n3 - 1);
                    }
                    double d5 = 0.0;
                    if (pageColumn == null) break block28;
                    switch (pageColumn.getAlign()) {
                        case 'C': 
                        case 'D': 
                        case 'L': 
                        case 'R': 
                        case 'S': {
                            string = string.trim();
                            if (string.length() != 0) break;
                            string = " ";
                            break;
                        }
                    }
                    textLayout = new TextLayout(string, font, printContext.frc);
                    switch (pageColumn.getAlign()) {
                        case 'L': {
                            d5 = PrintData.endColumn(printContext, pageFormat, pageColumn, pageColumn2, d4);
                            while (d3 + (double)textLayout.getAdvance() - d5 > 1.0 && string.length() > 1) {
                                string = string.substring(0, string.length() - 1);
                                textLayout = new TextLayout(string, font, printContext.frc);
                            }
                            break block29;
                        }
                        case 'C': {
                            textLayout = new TextLayout(string, font, printContext.frc);
                            d5 = PrintData.endColumn(printContext, pageFormat, pageColumn, pageColumn2, d4);
                            while (d3 + (double)textLayout.getAdvance() - d5 > 1.0 && string.length() > 1) {
                                string = string.substring(0, string.length() - 1);
                                textLayout = new TextLayout(string, font, printContext.frc);
                            }
                            d3 += (d5 - d3 - (double)textLayout.getAdvance()) / 2.0;
                            break;
                        }
                        case 'D': 
                        case 'S': {
                            int n6 = pageColumn.getPComma() ? 44 : 46;
                            int n7 = string.indexOf(n6);
                            if (n7 >= 0 && n7 + 1 < string.length()) {
                                String string2 = string.substring(n7 + 1);
                                double d6 = (double)pageColumn.getSeparation() * d4;
                                textLayout = new TextLayout(string2, font, printContext.frc);
                                while ((double)textLayout.getAdvance() - d6 > 1.0 && string2.length() > 1) {
                                    string2 = string2.substring(0, string2.length() - 1);
                                    textLayout = new TextLayout(string2, font, printContext.frc);
                                }
                                string = pageColumn.getAlign() == 'S' ? string.substring(0, n7) + " " : string.substring(0, n7 + 1);
                                if (!((double)textLayout.getAdvance() - d6 > 1.0)) {
                                    d5 = PrintData.endColumn(printContext, pageFormat, pageColumn, pageColumn2, d4);
                                    PrintData.drawString(graphics2D, font, printContext, textLayout, string2, (float)d5, (float)d2);
                                }
                            }
                        }
                        case 'R': {
                            textLayout = new TextLayout(string, font, printContext.frc);
                            d5 = PrintData.endColumn(printContext, pageFormat, pageColumn, pageColumn2, d4);
                            while (d3 + (double)textLayout.getAdvance() - d5 > 1.0 && string.length() > 1) {
                                string = string.substring(1, string.length());
                                textLayout = new TextLayout(string, font, printContext.frc);
                            }
                            d3 = d5 - (double)textLayout.getAdvance();
                            break;
                        }
                    }
                    break block29;
                }
                textLayout = new TextLayout(string, font, printContext.frc);
            }
            PrintData.drawString(graphics2D, font, printContext, textLayout, string, (float)d3, (float)d2);
            return true;
        }
        return false;
    }

    private static double endColumn(PrintContext printContext, PageFormat pageFormat, PageColumn pageColumn, PageColumn pageColumn2, double d2) {
        double d3;
        if (pageColumn2 != null) {
            double d4 = (double)pageColumn2.getStart() * PrintData.getFactor(pageColumn2.getUnit(), pageColumn2.getFont() == null ? printContext.font : pageColumn2.getFont(), printContext.frc);
            d3 = d4 - (double)pageColumn.getSeparation() * d2;
        } else {
            d3 = pageFormat.getImageableWidth() - (double)pageColumn.getSeparation() * d2;
        }
        return d3;
    }

    private static double getFactor(int n2, Font font, FontRenderContext fontRenderContext) {
        double d2;
        switch (n2) {
            case 1: {
                TextLayout textLayout = new TextLayout("0", font, fontRenderContext);
                d2 = textLayout.getAdvance();
                break;
            }
            case 2: {
                d2 = 72.0;
                break;
            }
            case 3: {
                d2 = 28.34645652770996;
                break;
            }
            default: {
                d2 = 1.0;
            }
        }
        return d2;
    }

    public static class Data
    implements Serializable {
        private static final long serialVersionUID = 1L;
        static final String encoding = CobolVar.encoding;
        private String text;
        private byte[] bytes;
        private int bytes_length;

        public Data(String string) {
            this.text = string;
            this.bytes_length = 0;
        }

        public Data(byte[] byArray, int n2, int n3) {
            if (n2 == 0) {
                this.bytes = byArray;
            } else {
                this.bytes = new byte[n3];
                System.arraycopy(byArray, n2, this.bytes, 0, n3);
            }
            this.bytes_length = n3;
            try {
                this.text = new String(this.bytes, 0, this.bytes_length, encoding);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                this.text = "";
            }
        }

        public Data(RandomAccessFile randomAccessFile) throws IOException {
            this.read(randomAccessFile);
        }

        public String getText() {
            return this.text;
        }

        public byte[] getBytes() {
            return this.bytes;
        }

        public String toString() {
            return this.text;
        }

        public int length() {
            return this.bytes != null ? this.bytes_length : this.text.length();
        }

        private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
            this.write(objectOutputStream);
        }

        private void write(DataOutput dataOutput) throws IOException {
            dataOutput.writeBoolean(this.bytes != null);
            if (this.bytes != null) {
                dataOutput.writeInt(this.bytes_length);
                for (int i2 = 0; i2 < this.bytes_length; ++i2) {
                    dataOutput.writeByte(this.bytes[i2]);
                }
            } else {
                dataOutput.writeUTF(this.text);
            }
        }

        private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            this.read(objectInputStream);
        }

        private void read(DataInput dataInput) throws IOException, ClassNotFoundException {
            boolean bl = dataInput.readBoolean();
            if (bl) {
                this.bytes_length = dataInput.readInt();
                this.bytes = new byte[this.bytes_length];
                for (int i2 = 0; i2 < this.bytes_length; ++i2) {
                    this.bytes[i2] = dataInput.readByte();
                }
                try {
                    this.text = new String(this.bytes, encoding);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    this.text = "";
                }
            } else {
                this.text = dataInput.readUTF();
            }
        }

        public void write(RandomAccessFile randomAccessFile) throws IOException {
            this.write((DataOutput)randomAccessFile);
        }

        public void read(RandomAccessFile randomAccessFile) throws IOException {
            try {
                this.read((DataInput)randomAccessFile);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
    }
}

