/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.rts.print;

import com.lowagie.text.pdf.ArabicLigaturizer;
import java.text.Bidi;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class RTL {
    private static final Map<Character, Character> MIRRORED_CHARS;

    private RTL() {
    }

    public static String checkRTL(String string) {
        char[] cArray = string.toCharArray();
        if (Bidi.requiresBidi(cArray, 0, cArray.length)) {
            try {
                return RTL.shapeRTLString(cArray);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return string;
    }

    private static char mirroredChar(char c2) {
        Character c3 = MIRRORED_CHARS.get(Character.valueOf(c2));
        return c3 != null ? c3.charValue() : c2;
    }

    private static String shapeRTLString(char[] cArray) throws Exception {
        Bidi bidi = new Bidi(cArray, 0, null, 0, cArray.length, -2);
        int n2 = bidi.getRunCount();
        byte[] byArray = new byte[n2];
        Object[] objectArray = new Integer[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            byArray[i2] = (byte)bidi.getRunLevel(i2);
            objectArray[i2] = i2;
        }
        Bidi.reorderVisually(byArray, 0, objectArray, 0, n2);
        StringBuffer stringBuffer = new StringBuffer();
        for (int i3 = 0; i3 < n2; ++i3) {
            int n3;
            int n4 = (Integer)objectArray[i3];
            int n5 = bidi.getRunStart(n4);
            int n6 = bidi.getRunLimit(n4);
            char[] cArray2 = new char[n6 - n5];
            int n7 = ArabicLigaturizer.arabic_shape((char[])cArray, (int)n5, (int)cArray2.length, (char[])cArray2, (int)0, (int)cArray2.length, (int)0);
            if ((byArray[n4] & 1) == 1) {
                for (n3 = n7 - 1; n3 >= 0; --n3) {
                    stringBuffer.append(RTL.mirroredChar(cArray2[n3]));
                }
                continue;
            }
            for (n3 = 0; n3 < n7; ++n3) {
                stringBuffer.append(cArray2[n3]);
            }
        }
        while (Character.isWhitespace(stringBuffer.charAt(0))) {
            stringBuffer.deleteCharAt(0);
        }
        return stringBuffer.toString();
    }

    static {
        HashMap<Character, Character> hashMap = new HashMap<Character, Character>();
        hashMap.put(Character.valueOf('('), Character.valueOf(')'));
        hashMap.put(Character.valueOf(')'), Character.valueOf('('));
        hashMap.put(Character.valueOf('<'), Character.valueOf('>'));
        hashMap.put(Character.valueOf('>'), Character.valueOf('<'));
        hashMap.put(Character.valueOf('['), Character.valueOf(']'));
        hashMap.put(Character.valueOf(']'), Character.valueOf('['));
        hashMap.put(Character.valueOf('{'), Character.valueOf('}'));
        hashMap.put(Character.valueOf('}'), Character.valueOf('{'));
        hashMap.put(Character.valueOf('\u00ab'), Character.valueOf('\u00bb'));
        hashMap.put(Character.valueOf('\u00bb'), Character.valueOf('\u00ab'));
        hashMap.put(Character.valueOf('\u0f3a'), Character.valueOf('\u0f3b'));
        hashMap.put(Character.valueOf('\u0f3b'), Character.valueOf('\u0f3a'));
        hashMap.put(Character.valueOf('\u0f3c'), Character.valueOf('\u0f3d'));
        hashMap.put(Character.valueOf('\u0f3d'), Character.valueOf('\u0f3c'));
        hashMap.put(Character.valueOf('\u169b'), Character.valueOf('\u169c'));
        hashMap.put(Character.valueOf('\u169c'), Character.valueOf('\u169b'));
        hashMap.put(Character.valueOf('\u2039'), Character.valueOf('\u203a'));
        hashMap.put(Character.valueOf('\u203a'), Character.valueOf('\u2039'));
        hashMap.put(Character.valueOf('\u2045'), Character.valueOf('\u2046'));
        hashMap.put(Character.valueOf('\u2046'), Character.valueOf('\u2045'));
        hashMap.put(Character.valueOf('\u207d'), Character.valueOf('\u207e'));
        hashMap.put(Character.valueOf('\u207e'), Character.valueOf('\u207d'));
        hashMap.put(Character.valueOf('\u208d'), Character.valueOf('\u208e'));
        hashMap.put(Character.valueOf('\u208e'), Character.valueOf('\u208d'));
        hashMap.put(Character.valueOf('\u2208'), Character.valueOf('\u220b'));
        hashMap.put(Character.valueOf('\u2209'), Character.valueOf('\u220c'));
        hashMap.put(Character.valueOf('\u220a'), Character.valueOf('\u220d'));
        hashMap.put(Character.valueOf('\u220b'), Character.valueOf('\u2208'));
        hashMap.put(Character.valueOf('\u220c'), Character.valueOf('\u2209'));
        hashMap.put(Character.valueOf('\u220d'), Character.valueOf('\u220a'));
        hashMap.put(Character.valueOf('\u2215'), Character.valueOf('\u29f5'));
        hashMap.put(Character.valueOf('\u223c'), Character.valueOf('\u223d'));
        hashMap.put(Character.valueOf('\u223d'), Character.valueOf('\u223c'));
        hashMap.put(Character.valueOf('\u2243'), Character.valueOf('\u22cd'));
        hashMap.put(Character.valueOf('\u2252'), Character.valueOf('\u2253'));
        hashMap.put(Character.valueOf('\u2253'), Character.valueOf('\u2252'));
        hashMap.put(Character.valueOf('\u2254'), Character.valueOf('\u2255'));
        hashMap.put(Character.valueOf('\u2255'), Character.valueOf('\u2254'));
        hashMap.put(Character.valueOf('\u2264'), Character.valueOf('\u2265'));
        hashMap.put(Character.valueOf('\u2265'), Character.valueOf('\u2264'));
        hashMap.put(Character.valueOf('\u2266'), Character.valueOf('\u2267'));
        hashMap.put(Character.valueOf('\u2267'), Character.valueOf('\u2266'));
        hashMap.put(Character.valueOf('\u2268'), Character.valueOf('\u2269'));
        hashMap.put(Character.valueOf('\u2269'), Character.valueOf('\u2268'));
        hashMap.put(Character.valueOf('\u226a'), Character.valueOf('\u226b'));
        hashMap.put(Character.valueOf('\u226b'), Character.valueOf('\u226a'));
        hashMap.put(Character.valueOf('\u226e'), Character.valueOf('\u226f'));
        hashMap.put(Character.valueOf('\u226f'), Character.valueOf('\u226e'));
        hashMap.put(Character.valueOf('\u2270'), Character.valueOf('\u2271'));
        hashMap.put(Character.valueOf('\u2271'), Character.valueOf('\u2270'));
        hashMap.put(Character.valueOf('\u2272'), Character.valueOf('\u2273'));
        hashMap.put(Character.valueOf('\u2273'), Character.valueOf('\u2272'));
        hashMap.put(Character.valueOf('\u2274'), Character.valueOf('\u2275'));
        hashMap.put(Character.valueOf('\u2275'), Character.valueOf('\u2274'));
        hashMap.put(Character.valueOf('\u2276'), Character.valueOf('\u2277'));
        hashMap.put(Character.valueOf('\u2277'), Character.valueOf('\u2276'));
        hashMap.put(Character.valueOf('\u2278'), Character.valueOf('\u2279'));
        hashMap.put(Character.valueOf('\u2279'), Character.valueOf('\u2278'));
        hashMap.put(Character.valueOf('\u227a'), Character.valueOf('\u227b'));
        hashMap.put(Character.valueOf('\u227b'), Character.valueOf('\u227a'));
        hashMap.put(Character.valueOf('\u227c'), Character.valueOf('\u227d'));
        hashMap.put(Character.valueOf('\u227d'), Character.valueOf('\u227c'));
        hashMap.put(Character.valueOf('\u227e'), Character.valueOf('\u227f'));
        hashMap.put(Character.valueOf('\u227f'), Character.valueOf('\u227e'));
        hashMap.put(Character.valueOf('\u2280'), Character.valueOf('\u2281'));
        hashMap.put(Character.valueOf('\u2281'), Character.valueOf('\u2280'));
        hashMap.put(Character.valueOf('\u2282'), Character.valueOf('\u2283'));
        hashMap.put(Character.valueOf('\u2283'), Character.valueOf('\u2282'));
        hashMap.put(Character.valueOf('\u2284'), Character.valueOf('\u2285'));
        hashMap.put(Character.valueOf('\u2285'), Character.valueOf('\u2284'));
        hashMap.put(Character.valueOf('\u2286'), Character.valueOf('\u2287'));
        hashMap.put(Character.valueOf('\u2287'), Character.valueOf('\u2286'));
        hashMap.put(Character.valueOf('\u2288'), Character.valueOf('\u2289'));
        hashMap.put(Character.valueOf('\u2289'), Character.valueOf('\u2288'));
        hashMap.put(Character.valueOf('\u228a'), Character.valueOf('\u228b'));
        hashMap.put(Character.valueOf('\u228b'), Character.valueOf('\u228a'));
        hashMap.put(Character.valueOf('\u228f'), Character.valueOf('\u2290'));
        hashMap.put(Character.valueOf('\u2290'), Character.valueOf('\u228f'));
        hashMap.put(Character.valueOf('\u2291'), Character.valueOf('\u2292'));
        hashMap.put(Character.valueOf('\u2292'), Character.valueOf('\u2291'));
        hashMap.put(Character.valueOf('\u2298'), Character.valueOf('\u29b8'));
        hashMap.put(Character.valueOf('\u22a2'), Character.valueOf('\u22a3'));
        hashMap.put(Character.valueOf('\u22a3'), Character.valueOf('\u22a2'));
        hashMap.put(Character.valueOf('\u22a6'), Character.valueOf('\u2ade'));
        hashMap.put(Character.valueOf('\u22a8'), Character.valueOf('\u2ae4'));
        hashMap.put(Character.valueOf('\u22a9'), Character.valueOf('\u2ae3'));
        hashMap.put(Character.valueOf('\u22ab'), Character.valueOf('\u2ae5'));
        hashMap.put(Character.valueOf('\u22b0'), Character.valueOf('\u22b1'));
        hashMap.put(Character.valueOf('\u22b1'), Character.valueOf('\u22b0'));
        hashMap.put(Character.valueOf('\u22b2'), Character.valueOf('\u22b3'));
        hashMap.put(Character.valueOf('\u22b3'), Character.valueOf('\u22b2'));
        hashMap.put(Character.valueOf('\u22b4'), Character.valueOf('\u22b5'));
        hashMap.put(Character.valueOf('\u22b5'), Character.valueOf('\u22b4'));
        hashMap.put(Character.valueOf('\u22b6'), Character.valueOf('\u22b7'));
        hashMap.put(Character.valueOf('\u22b7'), Character.valueOf('\u22b6'));
        hashMap.put(Character.valueOf('\u22c9'), Character.valueOf('\u22ca'));
        hashMap.put(Character.valueOf('\u22ca'), Character.valueOf('\u22c9'));
        hashMap.put(Character.valueOf('\u22cb'), Character.valueOf('\u22cc'));
        hashMap.put(Character.valueOf('\u22cc'), Character.valueOf('\u22cb'));
        hashMap.put(Character.valueOf('\u22cd'), Character.valueOf('\u2243'));
        hashMap.put(Character.valueOf('\u22d0'), Character.valueOf('\u22d1'));
        hashMap.put(Character.valueOf('\u22d1'), Character.valueOf('\u22d0'));
        hashMap.put(Character.valueOf('\u22d6'), Character.valueOf('\u22d7'));
        hashMap.put(Character.valueOf('\u22d7'), Character.valueOf('\u22d6'));
        hashMap.put(Character.valueOf('\u22d8'), Character.valueOf('\u22d9'));
        hashMap.put(Character.valueOf('\u22d9'), Character.valueOf('\u22d8'));
        hashMap.put(Character.valueOf('\u22da'), Character.valueOf('\u22db'));
        hashMap.put(Character.valueOf('\u22db'), Character.valueOf('\u22da'));
        hashMap.put(Character.valueOf('\u22dc'), Character.valueOf('\u22dd'));
        hashMap.put(Character.valueOf('\u22dd'), Character.valueOf('\u22dc'));
        hashMap.put(Character.valueOf('\u22de'), Character.valueOf('\u22df'));
        hashMap.put(Character.valueOf('\u22df'), Character.valueOf('\u22de'));
        hashMap.put(Character.valueOf('\u22e0'), Character.valueOf('\u22e1'));
        hashMap.put(Character.valueOf('\u22e1'), Character.valueOf('\u22e0'));
        hashMap.put(Character.valueOf('\u22e2'), Character.valueOf('\u22e3'));
        hashMap.put(Character.valueOf('\u22e3'), Character.valueOf('\u22e2'));
        hashMap.put(Character.valueOf('\u22e4'), Character.valueOf('\u22e5'));
        hashMap.put(Character.valueOf('\u22e5'), Character.valueOf('\u22e4'));
        hashMap.put(Character.valueOf('\u22e6'), Character.valueOf('\u22e7'));
        hashMap.put(Character.valueOf('\u22e7'), Character.valueOf('\u22e6'));
        hashMap.put(Character.valueOf('\u22e8'), Character.valueOf('\u22e9'));
        hashMap.put(Character.valueOf('\u22e9'), Character.valueOf('\u22e8'));
        hashMap.put(Character.valueOf('\u22ea'), Character.valueOf('\u22eb'));
        hashMap.put(Character.valueOf('\u22eb'), Character.valueOf('\u22ea'));
        hashMap.put(Character.valueOf('\u22ec'), Character.valueOf('\u22ed'));
        hashMap.put(Character.valueOf('\u22ed'), Character.valueOf('\u22ec'));
        hashMap.put(Character.valueOf('\u22f0'), Character.valueOf('\u22f1'));
        hashMap.put(Character.valueOf('\u22f1'), Character.valueOf('\u22f0'));
        hashMap.put(Character.valueOf('\u22f2'), Character.valueOf('\u22fa'));
        hashMap.put(Character.valueOf('\u22f3'), Character.valueOf('\u22fb'));
        hashMap.put(Character.valueOf('\u22f4'), Character.valueOf('\u22fc'));
        hashMap.put(Character.valueOf('\u22f6'), Character.valueOf('\u22fd'));
        hashMap.put(Character.valueOf('\u22f7'), Character.valueOf('\u22fe'));
        hashMap.put(Character.valueOf('\u22fa'), Character.valueOf('\u22f2'));
        hashMap.put(Character.valueOf('\u22fb'), Character.valueOf('\u22f3'));
        hashMap.put(Character.valueOf('\u22fc'), Character.valueOf('\u22f4'));
        hashMap.put(Character.valueOf('\u22fd'), Character.valueOf('\u22f6'));
        hashMap.put(Character.valueOf('\u22fe'), Character.valueOf('\u22f7'));
        hashMap.put(Character.valueOf('\u2308'), Character.valueOf('\u2309'));
        hashMap.put(Character.valueOf('\u2309'), Character.valueOf('\u2308'));
        hashMap.put(Character.valueOf('\u230a'), Character.valueOf('\u230b'));
        hashMap.put(Character.valueOf('\u230b'), Character.valueOf('\u230a'));
        hashMap.put(Character.valueOf('\u2329'), Character.valueOf('\u232a'));
        hashMap.put(Character.valueOf('\u232a'), Character.valueOf('\u2329'));
        hashMap.put(Character.valueOf('\u2768'), Character.valueOf('\u2769'));
        hashMap.put(Character.valueOf('\u2769'), Character.valueOf('\u2768'));
        hashMap.put(Character.valueOf('\u276a'), Character.valueOf('\u276b'));
        hashMap.put(Character.valueOf('\u276b'), Character.valueOf('\u276a'));
        hashMap.put(Character.valueOf('\u276c'), Character.valueOf('\u276d'));
        hashMap.put(Character.valueOf('\u276d'), Character.valueOf('\u276c'));
        hashMap.put(Character.valueOf('\u276e'), Character.valueOf('\u276f'));
        hashMap.put(Character.valueOf('\u276f'), Character.valueOf('\u276e'));
        hashMap.put(Character.valueOf('\u2770'), Character.valueOf('\u2771'));
        hashMap.put(Character.valueOf('\u2771'), Character.valueOf('\u2770'));
        hashMap.put(Character.valueOf('\u2772'), Character.valueOf('\u2773'));
        hashMap.put(Character.valueOf('\u2773'), Character.valueOf('\u2772'));
        hashMap.put(Character.valueOf('\u2774'), Character.valueOf('\u2775'));
        hashMap.put(Character.valueOf('\u2775'), Character.valueOf('\u2774'));
        hashMap.put(Character.valueOf('\u27c3'), Character.valueOf('\u27c4'));
        hashMap.put(Character.valueOf('\u27c4'), Character.valueOf('\u27c3'));
        hashMap.put(Character.valueOf('\u27c5'), Character.valueOf('\u27c6'));
        hashMap.put(Character.valueOf('\u27c6'), Character.valueOf('\u27c5'));
        hashMap.put(Character.valueOf('\u27c8'), Character.valueOf('\u27c9'));
        hashMap.put(Character.valueOf('\u27c9'), Character.valueOf('\u27c8'));
        hashMap.put(Character.valueOf('\u27cb'), Character.valueOf('\u27cd'));
        hashMap.put(Character.valueOf('\u27cd'), Character.valueOf('\u27cb'));
        hashMap.put(Character.valueOf('\u27d5'), Character.valueOf('\u27d6'));
        hashMap.put(Character.valueOf('\u27d6'), Character.valueOf('\u27d5'));
        hashMap.put(Character.valueOf('\u27dd'), Character.valueOf('\u27de'));
        hashMap.put(Character.valueOf('\u27de'), Character.valueOf('\u27dd'));
        hashMap.put(Character.valueOf('\u27e2'), Character.valueOf('\u27e3'));
        hashMap.put(Character.valueOf('\u27e3'), Character.valueOf('\u27e2'));
        hashMap.put(Character.valueOf('\u27e4'), Character.valueOf('\u27e5'));
        hashMap.put(Character.valueOf('\u27e5'), Character.valueOf('\u27e4'));
        hashMap.put(Character.valueOf('\u27e6'), Character.valueOf('\u27e7'));
        hashMap.put(Character.valueOf('\u27e7'), Character.valueOf('\u27e6'));
        hashMap.put(Character.valueOf('\u27e8'), Character.valueOf('\u27e9'));
        hashMap.put(Character.valueOf('\u27e9'), Character.valueOf('\u27e8'));
        hashMap.put(Character.valueOf('\u27ea'), Character.valueOf('\u27eb'));
        hashMap.put(Character.valueOf('\u27eb'), Character.valueOf('\u27ea'));
        hashMap.put(Character.valueOf('\u27ec'), Character.valueOf('\u27ed'));
        hashMap.put(Character.valueOf('\u27ed'), Character.valueOf('\u27ec'));
        hashMap.put(Character.valueOf('\u27ee'), Character.valueOf('\u27ef'));
        hashMap.put(Character.valueOf('\u27ef'), Character.valueOf('\u27ee'));
        hashMap.put(Character.valueOf('\u2983'), Character.valueOf('\u2984'));
        hashMap.put(Character.valueOf('\u2984'), Character.valueOf('\u2983'));
        hashMap.put(Character.valueOf('\u2985'), Character.valueOf('\u2986'));
        hashMap.put(Character.valueOf('\u2986'), Character.valueOf('\u2985'));
        hashMap.put(Character.valueOf('\u2987'), Character.valueOf('\u2988'));
        hashMap.put(Character.valueOf('\u2988'), Character.valueOf('\u2987'));
        hashMap.put(Character.valueOf('\u2989'), Character.valueOf('\u298a'));
        hashMap.put(Character.valueOf('\u298a'), Character.valueOf('\u2989'));
        hashMap.put(Character.valueOf('\u298b'), Character.valueOf('\u298c'));
        hashMap.put(Character.valueOf('\u298c'), Character.valueOf('\u298b'));
        hashMap.put(Character.valueOf('\u298d'), Character.valueOf('\u2990'));
        hashMap.put(Character.valueOf('\u298e'), Character.valueOf('\u298f'));
        hashMap.put(Character.valueOf('\u298f'), Character.valueOf('\u298e'));
        hashMap.put(Character.valueOf('\u2990'), Character.valueOf('\u298d'));
        hashMap.put(Character.valueOf('\u2991'), Character.valueOf('\u2992'));
        hashMap.put(Character.valueOf('\u2992'), Character.valueOf('\u2991'));
        hashMap.put(Character.valueOf('\u2993'), Character.valueOf('\u2994'));
        hashMap.put(Character.valueOf('\u2994'), Character.valueOf('\u2993'));
        hashMap.put(Character.valueOf('\u2995'), Character.valueOf('\u2996'));
        hashMap.put(Character.valueOf('\u2996'), Character.valueOf('\u2995'));
        hashMap.put(Character.valueOf('\u2997'), Character.valueOf('\u2998'));
        hashMap.put(Character.valueOf('\u2998'), Character.valueOf('\u2997'));
        hashMap.put(Character.valueOf('\u29b8'), Character.valueOf('\u2298'));
        hashMap.put(Character.valueOf('\u29c0'), Character.valueOf('\u29c1'));
        hashMap.put(Character.valueOf('\u29c1'), Character.valueOf('\u29c0'));
        hashMap.put(Character.valueOf('\u29c4'), Character.valueOf('\u29c5'));
        hashMap.put(Character.valueOf('\u29c5'), Character.valueOf('\u29c4'));
        hashMap.put(Character.valueOf('\u29cf'), Character.valueOf('\u29d0'));
        hashMap.put(Character.valueOf('\u29d0'), Character.valueOf('\u29cf'));
        hashMap.put(Character.valueOf('\u29d1'), Character.valueOf('\u29d2'));
        hashMap.put(Character.valueOf('\u29d2'), Character.valueOf('\u29d1'));
        hashMap.put(Character.valueOf('\u29d4'), Character.valueOf('\u29d5'));
        hashMap.put(Character.valueOf('\u29d5'), Character.valueOf('\u29d4'));
        hashMap.put(Character.valueOf('\u29d8'), Character.valueOf('\u29d9'));
        hashMap.put(Character.valueOf('\u29d9'), Character.valueOf('\u29d8'));
        hashMap.put(Character.valueOf('\u29da'), Character.valueOf('\u29db'));
        hashMap.put(Character.valueOf('\u29db'), Character.valueOf('\u29da'));
        hashMap.put(Character.valueOf('\u29f5'), Character.valueOf('\u2215'));
        hashMap.put(Character.valueOf('\u29f8'), Character.valueOf('\u29f9'));
        hashMap.put(Character.valueOf('\u29f9'), Character.valueOf('\u29f8'));
        hashMap.put(Character.valueOf('\u29fc'), Character.valueOf('\u29fd'));
        hashMap.put(Character.valueOf('\u29fd'), Character.valueOf('\u29fc'));
        hashMap.put(Character.valueOf('\u2a2b'), Character.valueOf('\u2a2c'));
        hashMap.put(Character.valueOf('\u2a2c'), Character.valueOf('\u2a2b'));
        hashMap.put(Character.valueOf('\u2a2d'), Character.valueOf('\u2a2e'));
        hashMap.put(Character.valueOf('\u2a2e'), Character.valueOf('\u2a2d'));
        hashMap.put(Character.valueOf('\u2a34'), Character.valueOf('\u2a35'));
        hashMap.put(Character.valueOf('\u2a35'), Character.valueOf('\u2a34'));
        hashMap.put(Character.valueOf('\u2a3c'), Character.valueOf('\u2a3d'));
        hashMap.put(Character.valueOf('\u2a3d'), Character.valueOf('\u2a3c'));
        hashMap.put(Character.valueOf('\u2a64'), Character.valueOf('\u2a65'));
        hashMap.put(Character.valueOf('\u2a65'), Character.valueOf('\u2a64'));
        hashMap.put(Character.valueOf('\u2a79'), Character.valueOf('\u2a7a'));
        hashMap.put(Character.valueOf('\u2a7a'), Character.valueOf('\u2a79'));
        hashMap.put(Character.valueOf('\u2a7d'), Character.valueOf('\u2a7e'));
        hashMap.put(Character.valueOf('\u2a7e'), Character.valueOf('\u2a7d'));
        hashMap.put(Character.valueOf('\u2a7f'), Character.valueOf('\u2a80'));
        hashMap.put(Character.valueOf('\u2a80'), Character.valueOf('\u2a7f'));
        hashMap.put(Character.valueOf('\u2a81'), Character.valueOf('\u2a82'));
        hashMap.put(Character.valueOf('\u2a82'), Character.valueOf('\u2a81'));
        hashMap.put(Character.valueOf('\u2a83'), Character.valueOf('\u2a84'));
        hashMap.put(Character.valueOf('\u2a84'), Character.valueOf('\u2a83'));
        hashMap.put(Character.valueOf('\u2a8b'), Character.valueOf('\u2a8c'));
        hashMap.put(Character.valueOf('\u2a8c'), Character.valueOf('\u2a8b'));
        hashMap.put(Character.valueOf('\u2a91'), Character.valueOf('\u2a92'));
        hashMap.put(Character.valueOf('\u2a92'), Character.valueOf('\u2a91'));
        hashMap.put(Character.valueOf('\u2a93'), Character.valueOf('\u2a94'));
        hashMap.put(Character.valueOf('\u2a94'), Character.valueOf('\u2a93'));
        hashMap.put(Character.valueOf('\u2a95'), Character.valueOf('\u2a96'));
        hashMap.put(Character.valueOf('\u2a96'), Character.valueOf('\u2a95'));
        hashMap.put(Character.valueOf('\u2a97'), Character.valueOf('\u2a98'));
        hashMap.put(Character.valueOf('\u2a98'), Character.valueOf('\u2a97'));
        hashMap.put(Character.valueOf('\u2a99'), Character.valueOf('\u2a9a'));
        hashMap.put(Character.valueOf('\u2a9a'), Character.valueOf('\u2a99'));
        hashMap.put(Character.valueOf('\u2a9b'), Character.valueOf('\u2a9c'));
        hashMap.put(Character.valueOf('\u2a9c'), Character.valueOf('\u2a9b'));
        hashMap.put(Character.valueOf('\u2aa1'), Character.valueOf('\u2aa2'));
        hashMap.put(Character.valueOf('\u2aa2'), Character.valueOf('\u2aa1'));
        hashMap.put(Character.valueOf('\u2aa6'), Character.valueOf('\u2aa7'));
        hashMap.put(Character.valueOf('\u2aa7'), Character.valueOf('\u2aa6'));
        hashMap.put(Character.valueOf('\u2aa8'), Character.valueOf('\u2aa9'));
        hashMap.put(Character.valueOf('\u2aa9'), Character.valueOf('\u2aa8'));
        hashMap.put(Character.valueOf('\u2aaa'), Character.valueOf('\u2aab'));
        hashMap.put(Character.valueOf('\u2aab'), Character.valueOf('\u2aaa'));
        hashMap.put(Character.valueOf('\u2aac'), Character.valueOf('\u2aad'));
        hashMap.put(Character.valueOf('\u2aad'), Character.valueOf('\u2aac'));
        hashMap.put(Character.valueOf('\u2aaf'), Character.valueOf('\u2ab0'));
        hashMap.put(Character.valueOf('\u2ab0'), Character.valueOf('\u2aaf'));
        hashMap.put(Character.valueOf('\u2ab3'), Character.valueOf('\u2ab4'));
        hashMap.put(Character.valueOf('\u2ab4'), Character.valueOf('\u2ab3'));
        hashMap.put(Character.valueOf('\u2abb'), Character.valueOf('\u2abc'));
        hashMap.put(Character.valueOf('\u2abc'), Character.valueOf('\u2abb'));
        hashMap.put(Character.valueOf('\u2abd'), Character.valueOf('\u2abe'));
        hashMap.put(Character.valueOf('\u2abe'), Character.valueOf('\u2abd'));
        hashMap.put(Character.valueOf('\u2abf'), Character.valueOf('\u2ac0'));
        hashMap.put(Character.valueOf('\u2ac0'), Character.valueOf('\u2abf'));
        hashMap.put(Character.valueOf('\u2ac1'), Character.valueOf('\u2ac2'));
        hashMap.put(Character.valueOf('\u2ac2'), Character.valueOf('\u2ac1'));
        hashMap.put(Character.valueOf('\u2ac3'), Character.valueOf('\u2ac4'));
        hashMap.put(Character.valueOf('\u2ac4'), Character.valueOf('\u2ac3'));
        hashMap.put(Character.valueOf('\u2ac5'), Character.valueOf('\u2ac6'));
        hashMap.put(Character.valueOf('\u2ac6'), Character.valueOf('\u2ac5'));
        hashMap.put(Character.valueOf('\u2acd'), Character.valueOf('\u2ace'));
        hashMap.put(Character.valueOf('\u2ace'), Character.valueOf('\u2acd'));
        hashMap.put(Character.valueOf('\u2acf'), Character.valueOf('\u2ad0'));
        hashMap.put(Character.valueOf('\u2ad0'), Character.valueOf('\u2acf'));
        hashMap.put(Character.valueOf('\u2ad1'), Character.valueOf('\u2ad2'));
        hashMap.put(Character.valueOf('\u2ad2'), Character.valueOf('\u2ad1'));
        hashMap.put(Character.valueOf('\u2ad3'), Character.valueOf('\u2ad4'));
        hashMap.put(Character.valueOf('\u2ad4'), Character.valueOf('\u2ad3'));
        hashMap.put(Character.valueOf('\u2ad5'), Character.valueOf('\u2ad6'));
        hashMap.put(Character.valueOf('\u2ad6'), Character.valueOf('\u2ad5'));
        hashMap.put(Character.valueOf('\u2ade'), Character.valueOf('\u22a6'));
        hashMap.put(Character.valueOf('\u2ae3'), Character.valueOf('\u22a9'));
        hashMap.put(Character.valueOf('\u2ae4'), Character.valueOf('\u22a8'));
        hashMap.put(Character.valueOf('\u2ae5'), Character.valueOf('\u22ab'));
        hashMap.put(Character.valueOf('\u2aec'), Character.valueOf('\u2aed'));
        hashMap.put(Character.valueOf('\u2aed'), Character.valueOf('\u2aec'));
        hashMap.put(Character.valueOf('\u2af7'), Character.valueOf('\u2af8'));
        hashMap.put(Character.valueOf('\u2af8'), Character.valueOf('\u2af7'));
        hashMap.put(Character.valueOf('\u2af9'), Character.valueOf('\u2afa'));
        hashMap.put(Character.valueOf('\u2afa'), Character.valueOf('\u2af9'));
        hashMap.put(Character.valueOf('\u2e02'), Character.valueOf('\u2e03'));
        hashMap.put(Character.valueOf('\u2e03'), Character.valueOf('\u2e02'));
        hashMap.put(Character.valueOf('\u2e04'), Character.valueOf('\u2e05'));
        hashMap.put(Character.valueOf('\u2e05'), Character.valueOf('\u2e04'));
        hashMap.put(Character.valueOf('\u2e09'), Character.valueOf('\u2e0a'));
        hashMap.put(Character.valueOf('\u2e0a'), Character.valueOf('\u2e09'));
        hashMap.put(Character.valueOf('\u2e0c'), Character.valueOf('\u2e0d'));
        hashMap.put(Character.valueOf('\u2e0d'), Character.valueOf('\u2e0c'));
        hashMap.put(Character.valueOf('\u2e1c'), Character.valueOf('\u2e1d'));
        hashMap.put(Character.valueOf('\u2e1d'), Character.valueOf('\u2e1c'));
        hashMap.put(Character.valueOf('\u2e20'), Character.valueOf('\u2e21'));
        hashMap.put(Character.valueOf('\u2e21'), Character.valueOf('\u2e20'));
        hashMap.put(Character.valueOf('\u2e22'), Character.valueOf('\u2e23'));
        hashMap.put(Character.valueOf('\u2e23'), Character.valueOf('\u2e22'));
        hashMap.put(Character.valueOf('\u2e24'), Character.valueOf('\u2e25'));
        hashMap.put(Character.valueOf('\u2e25'), Character.valueOf('\u2e24'));
        hashMap.put(Character.valueOf('\u2e26'), Character.valueOf('\u2e27'));
        hashMap.put(Character.valueOf('\u2e27'), Character.valueOf('\u2e26'));
        hashMap.put(Character.valueOf('\u2e28'), Character.valueOf('\u2e29'));
        hashMap.put(Character.valueOf('\u2e29'), Character.valueOf('\u2e28'));
        hashMap.put(Character.valueOf('\u3008'), Character.valueOf('\u3009'));
        hashMap.put(Character.valueOf('\u3009'), Character.valueOf('\u3008'));
        hashMap.put(Character.valueOf('\u300a'), Character.valueOf('\u300b'));
        hashMap.put(Character.valueOf('\u300b'), Character.valueOf('\u300a'));
        hashMap.put(Character.valueOf('\u300c'), Character.valueOf('\u300d'));
        hashMap.put(Character.valueOf('\u300d'), Character.valueOf('\u300c'));
        hashMap.put(Character.valueOf('\u300e'), Character.valueOf('\u300f'));
        hashMap.put(Character.valueOf('\u300f'), Character.valueOf('\u300e'));
        hashMap.put(Character.valueOf('\u3010'), Character.valueOf('\u3011'));
        hashMap.put(Character.valueOf('\u3011'), Character.valueOf('\u3010'));
        hashMap.put(Character.valueOf('\u3014'), Character.valueOf('\u3015'));
        hashMap.put(Character.valueOf('\u3015'), Character.valueOf('\u3014'));
        hashMap.put(Character.valueOf('\u3016'), Character.valueOf('\u3017'));
        hashMap.put(Character.valueOf('\u3017'), Character.valueOf('\u3016'));
        hashMap.put(Character.valueOf('\u3018'), Character.valueOf('\u3019'));
        hashMap.put(Character.valueOf('\u3019'), Character.valueOf('\u3018'));
        hashMap.put(Character.valueOf('\u301a'), Character.valueOf('\u301b'));
        hashMap.put(Character.valueOf('\u301b'), Character.valueOf('\u301a'));
        hashMap.put(Character.valueOf('\ufe59'), Character.valueOf('\ufe5a'));
        hashMap.put(Character.valueOf('\ufe5a'), Character.valueOf('\ufe59'));
        hashMap.put(Character.valueOf('\ufe5b'), Character.valueOf('\ufe5c'));
        hashMap.put(Character.valueOf('\ufe5c'), Character.valueOf('\ufe5b'));
        hashMap.put(Character.valueOf('\ufe5d'), Character.valueOf('\ufe5e'));
        hashMap.put(Character.valueOf('\ufe5e'), Character.valueOf('\ufe5d'));
        hashMap.put(Character.valueOf('\ufe64'), Character.valueOf('\ufe65'));
        hashMap.put(Character.valueOf('\ufe65'), Character.valueOf('\ufe64'));
        hashMap.put(Character.valueOf('\uff08'), Character.valueOf('\uff09'));
        hashMap.put(Character.valueOf('\uff09'), Character.valueOf('\uff08'));
        hashMap.put(Character.valueOf('\uff1c'), Character.valueOf('\uff1e'));
        hashMap.put(Character.valueOf('\uff1e'), Character.valueOf('\uff1c'));
        hashMap.put(Character.valueOf('\uff3b'), Character.valueOf('\uff3d'));
        hashMap.put(Character.valueOf('\uff3d'), Character.valueOf('\uff3b'));
        hashMap.put(Character.valueOf('\uff5b'), Character.valueOf('\uff5d'));
        hashMap.put(Character.valueOf('\uff5d'), Character.valueOf('\uff5b'));
        hashMap.put(Character.valueOf('\uff5f'), Character.valueOf('\uff60'));
        hashMap.put(Character.valueOf('\uff60'), Character.valueOf('\uff5f'));
        hashMap.put(Character.valueOf('\uff62'), Character.valueOf('\uff63'));
        hashMap.put(Character.valueOf('\uff63'), Character.valueOf('\uff62'));
        MIRRORED_CHARS = Collections.unmodifiableMap(hashMap);
    }
}

