/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.rts.print;

import com.iscobol.gui.GuiFactory;
import com.iscobol.rts.print.PrintCommand;
import com.iscobol.rts.print.PrintContext;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.print.PageFormat;
import java.io.IOException;
import java.io.RandomAccessFile;

public class SetBackground
extends PrintCommand {
    private Color color;

    public SetBackground(GuiFactory guiFactory, Color color) {
        super(guiFactory, 17);
        this.color = color;
    }

    public SetBackground(GuiFactory guiFactory, RandomAccessFile randomAccessFile) throws IOException {
        super(guiFactory, 3);
        int n2 = randomAccessFile.readInt();
        this.color = n2 == 0xFFFFFF ? null : new Color(n2, true);
    }

    @Override
    void toFile(RandomAccessFile randomAccessFile) throws IOException {
        if (this.color == null) {
            randomAccessFile.writeInt(0xFFFFFF);
        } else {
            randomAccessFile.writeInt(this.color.getRGB());
        }
    }

    @Override
    public boolean testPrint(PrintContext printContext, Graphics2D graphics2D, PageFormat pageFormat) {
        return this.print(printContext, graphics2D, pageFormat);
    }

    @Override
    public boolean print(PrintContext printContext, Graphics2D graphics2D, PageFormat pageFormat) {
        printContext.background = this.color;
        return true;
    }
}

