/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.rts.print;

import com.iscobol.gui.GuiFactory;
import com.iscobol.rts.print.PrintCommand;
import com.iscobol.rts.print.PrintContext;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.print.PageFormat;
import java.io.IOException;
import java.io.RandomAccessFile;

public class SetColor
extends PrintCommand {
    private Color color;

    public SetColor(GuiFactory guiFactory, Color color) {
        super(guiFactory, 3);
        this.color = color;
    }

    public SetColor(GuiFactory guiFactory, RandomAccessFile randomAccessFile) throws IOException {
        super(guiFactory, 3);
        this.color = new Color(randomAccessFile.readInt(), true);
    }

    @Override
    void toFile(RandomAccessFile randomAccessFile) throws IOException {
        randomAccessFile.writeInt(this.color.getRGB());
    }

    @Override
    public boolean testPrint(PrintContext printContext, Graphics2D graphics2D, PageFormat pageFormat) {
        return this.print(printContext, graphics2D, pageFormat);
    }

    @Override
    public boolean print(PrintContext printContext, Graphics2D graphics2D, PageFormat pageFormat) {
        graphics2D.setColor(this.color);
        printContext.color = this.color;
        return true;
    }
}

