/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.rts.print;

import com.iscobol.gui.GuiFactory;
import com.iscobol.rts.print.PrintCommand;
import com.iscobol.rts.print.PrintContext;
import java.awt.Graphics2D;
import java.awt.font.TextLayout;
import java.awt.print.PageFormat;
import java.io.IOException;
import java.io.RandomAccessFile;

public class SetCursor
extends PrintCommand {
    private static double lastX = 0.0;
    private static double lastY = 0.0;
    private static boolean lastCells = false;
    private double x;
    private double y;
    private boolean cells;
    private double prevX;
    private double prevY;
    private boolean prevCells;

    private void init(double d2, double d3, boolean bl) {
        this.prevX = lastX;
        this.prevY = lastY;
        this.prevCells = lastCells;
        lastX = this.x = d2;
        lastY = this.y = d3;
        lastCells = this.cells = bl;
    }

    public SetCursor(GuiFactory guiFactory, double d2, double d3, boolean bl) {
        super(guiFactory, 11);
        this.init(d2, d3, bl);
    }

    public SetCursor(GuiFactory guiFactory, RandomAccessFile randomAccessFile) throws IOException {
        super(guiFactory, 11);
        this.x = randomAccessFile.readDouble();
        this.y = randomAccessFile.readDouble();
        this.cells = randomAccessFile.readBoolean();
    }

    @Override
    void toFile(RandomAccessFile randomAccessFile) throws IOException {
        randomAccessFile.writeDouble(this.x);
        randomAccessFile.writeDouble(this.y);
        randomAccessFile.writeBoolean(this.cells);
    }

    @Override
    public boolean testPrint(PrintContext printContext, Graphics2D graphics2D, PageFormat pageFormat) {
        return this.print(printContext, null, pageFormat);
    }

    @Override
    public boolean print(PrintContext printContext, Graphics2D graphics2D, PageFormat pageFormat) {
        if (this.cells) {
            TextLayout textLayout = new TextLayout("0", printContext.font, printContext.frc);
            float f2 = SetCursor.getCellHeight(printContext, textLayout);
            float f3 = textLayout.getAdvance();
            printContext.pen.x = (float)(this.x * (double)f3);
            printContext.pen.y = (float)(this.y * (double)f2);
        } else {
            printContext.pen.x = (float)this.x;
            printContext.pen.y = (float)this.y;
        }
        return true;
    }

    public double getPrevX() {
        return this.prevX;
    }

    public double getPrevY() {
        return this.prevY;
    }

    public boolean getPrevCells() {
        return this.prevCells;
    }

    public static double getLastX() {
        return lastX;
    }

    public static double getLastY() {
        return lastY;
    }

    public static boolean getLastCells() {
        return lastCells;
    }
}

