/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.rts.print;

import com.iscobol.gui.GuiFactory;
import com.iscobol.rts.print.PrintCommand;
import com.iscobol.rts.print.PrintContext;
import java.awt.Graphics2D;
import java.awt.print.PageFormat;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.TreeSet;

public class SetDataColumns
extends PrintCommand {
    private int[] myCols;

    private static int[] normalizeAndSort(int[] nArray) {
        if (nArray == null || nArray.length == 0) {
            return null;
        }
        TreeSet<Integer> treeSet = new TreeSet<Integer>();
        for (int n2 : nArray) {
            if (n2 <= 1) continue;
            treeSet.add(n2);
        }
        if (treeSet.size() == 0) {
            return null;
        }
        if (treeSet.size() == 1) {
            return new int[]{(Integer)treeSet.iterator().next()};
        }
        int[] nArray2 = new int[treeSet.size()];
        int n3 = 0;
        for (Integer n4 : treeSet) {
            nArray2[n3++] = n4;
        }
        return nArray2;
    }

    public SetDataColumns(GuiFactory guiFactory, int[] nArray, int[] nArray2) {
        super(guiFactory, 8);
        if (nArray == null || nArray2 == null) {
            this.myCols = SetDataColumns.normalizeAndSort(nArray2);
        } else {
            int n2;
            this.myCols = new int[nArray.length + nArray2.length];
            for (n2 = 0; n2 < nArray.length; ++n2) {
                this.myCols[n2] = nArray[n2];
            }
            for (int i2 = 0; i2 < nArray2.length; ++i2) {
                this.myCols[n2] = nArray2[i2];
                ++n2;
            }
            this.myCols = SetDataColumns.normalizeAndSort(this.myCols);
        }
    }

    public SetDataColumns(GuiFactory guiFactory, RandomAccessFile randomAccessFile) throws IOException {
        super(guiFactory, 8);
        int n2 = randomAccessFile.readInt();
        if (n2 >= 0) {
            this.myCols = new int[n2];
            for (int i2 = 0; i2 < this.myCols.length; ++i2) {
                this.myCols[i2] = randomAccessFile.readInt();
            }
        }
    }

    @Override
    void toFile(RandomAccessFile randomAccessFile) throws IOException {
        if (this.myCols != null) {
            randomAccessFile.writeInt(this.myCols.length);
            for (int i2 = 0; i2 < this.myCols.length; ++i2) {
                randomAccessFile.writeInt(this.myCols[i2]);
            }
        } else {
            randomAccessFile.writeInt(-1);
        }
    }

    @Override
    public boolean testPrint(PrintContext printContext, Graphics2D graphics2D, PageFormat pageFormat) {
        return this.print(printContext, graphics2D, pageFormat);
    }

    @Override
    public boolean print(PrintContext printContext, Graphics2D graphics2D, PageFormat pageFormat) {
        printContext.dataCols = this.getCols();
        return true;
    }

    int[] getCols() {
        int[] nArray;
        if (this.myCols != null) {
            nArray = new int[this.myCols.length];
            System.arraycopy(this.myCols, 0, nArray, 0, this.myCols.length);
        } else {
            nArray = null;
        }
        return nArray;
    }
}

