/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.rts.print;

import com.iscobol.gui.GuiFactory;
import com.iscobol.rts.HandlesManager;
import com.iscobol.rts.print.PrintCommand;
import com.iscobol.rts.print.PrintContext;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.print.PageFormat;
import java.io.IOException;
import java.io.RandomAccessFile;

public class SetFont
extends PrintCommand {
    private Font font;
    private int fontId = -1;

    public SetFont(GuiFactory guiFactory, HandlesManager handlesManager, Font font) {
        super(guiFactory, 2);
        this.font = font;
        if (this.font != null) {
            this.fontId = handlesManager.getHandle(this.font);
        }
    }

    public SetFont(GuiFactory guiFactory, HandlesManager handlesManager, RandomAccessFile randomAccessFile) throws IOException {
        super(guiFactory, 2);
        this.fontId = randomAccessFile.readInt();
        this.font = (Font)handlesManager.getObject(this.fontId);
    }

    @Override
    void toFile(RandomAccessFile randomAccessFile) throws IOException {
        randomAccessFile.writeInt(this.fontId);
    }

    @Override
    public boolean testPrint(PrintContext printContext, Graphics2D graphics2D, PageFormat pageFormat) {
        return this.print(printContext, graphics2D, pageFormat);
    }

    @Override
    public boolean print(PrintContext printContext, Graphics2D graphics2D, PageFormat pageFormat) {
        graphics2D.setFont(this.font);
        printContext.font = this.font;
        printContext.frc = graphics2D.getFontRenderContext();
        return true;
    }
}

