/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.rts.print;

import com.iscobol.gui.GuiFactory;
import com.iscobol.rts.print.GraphBrush;
import com.iscobol.rts.print.PrintCommand;
import com.iscobol.rts.print.PrintContext;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.print.PageFormat;
import java.io.IOException;
import java.io.RandomAccessFile;

public class SetGraphBrush
extends PrintCommand {
    private Color color;
    private int style;
    private GraphBrush brush;

    public SetGraphBrush(GuiFactory guiFactory, int n2, Color color) {
        super(guiFactory, 7);
        this.style = n2;
        this.color = color == null ? new Color(0, 0, 0) : color;
        this.brush = new GraphBrush(n2, color);
    }

    public SetGraphBrush(GuiFactory guiFactory, RandomAccessFile randomAccessFile) throws IOException {
        super(guiFactory, 7);
        this.style = randomAccessFile.readInt();
        this.color = new Color(randomAccessFile.readInt(), true);
        this.brush = new GraphBrush(this.style, this.color);
    }

    @Override
    void toFile(RandomAccessFile randomAccessFile) throws IOException {
        randomAccessFile.writeInt(this.style);
        randomAccessFile.writeInt(this.color.getRGB());
    }

    @Override
    public boolean testPrint(PrintContext printContext, Graphics2D graphics2D, PageFormat pageFormat) {
        return this.print(printContext, graphics2D, pageFormat);
    }

    @Override
    public boolean print(PrintContext printContext, Graphics2D graphics2D, PageFormat pageFormat) {
        printContext.graphBrush = this.brush;
        return true;
    }
}

