/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.rts.print;

import com.iscobol.gui.GuiFactory;
import com.iscobol.rts.print.GraphPen;
import com.iscobol.rts.print.PrintCommand;
import com.iscobol.rts.print.PrintContext;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.print.PageFormat;
import java.io.IOException;
import java.io.RandomAccessFile;

public class SetGraphPen
extends PrintCommand {
    private Color color;
    private int style;
    private double width;
    private GraphPen pen;

    public SetGraphPen(GuiFactory guiFactory, int n2, double d2, Color color) {
        super(guiFactory, 6);
        this.style = n2;
        this.width = d2;
        this.color = color == null ? new Color(0, 0, 0) : color;
        this.pen = new GraphPen(n2, d2, color);
    }

    public SetGraphPen(GuiFactory guiFactory, RandomAccessFile randomAccessFile) throws IOException {
        super(guiFactory, 6);
        this.style = randomAccessFile.readInt();
        this.width = randomAccessFile.readDouble();
        this.color = new Color(randomAccessFile.readInt(), true);
        this.pen = new GraphPen(this.style, this.width, this.color);
    }

    @Override
    void toFile(RandomAccessFile randomAccessFile) throws IOException {
        randomAccessFile.writeInt(this.style);
        randomAccessFile.writeDouble(this.width);
        randomAccessFile.writeInt(this.color.getRGB());
    }

    @Override
    public boolean testPrint(PrintContext printContext, Graphics2D graphics2D, PageFormat pageFormat) {
        return this.print(printContext, graphics2D, pageFormat);
    }

    @Override
    public boolean print(PrintContext printContext, Graphics2D graphics2D, PageFormat pageFormat) {
        printContext.graphPen = this.pen;
        return true;
    }
}

