/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.rts.print;

import com.iscobol.gui.GuiFactory;
import com.iscobol.rts.print.PrintCommand;
import com.iscobol.rts.print.PrintContext;
import java.awt.Graphics2D;
import java.awt.font.TextLayout;
import java.awt.print.PageFormat;
import java.io.IOException;
import java.io.RandomAccessFile;

public class SetLinesPerPage
extends PrintCommand {
    private int lines;

    public SetLinesPerPage(GuiFactory guiFactory, int n2) {
        super(guiFactory, 13);
        this.lines = n2;
    }

    public SetLinesPerPage(GuiFactory guiFactory, RandomAccessFile randomAccessFile) throws IOException {
        super(guiFactory, 13);
        this.lines = randomAccessFile.readInt();
    }

    @Override
    void toFile(RandomAccessFile randomAccessFile) throws IOException {
        randomAccessFile.writeInt(this.lines);
    }

    @Override
    public boolean testPrint(PrintContext printContext, Graphics2D graphics2D, PageFormat pageFormat) {
        return this.print(printContext, graphics2D, pageFormat);
    }

    @Override
    public boolean print(PrintContext printContext, Graphics2D graphics2D, PageFormat pageFormat) {
        TextLayout textLayout = new TextLayout("0", printContext.font, printContext.frc);
        float f2 = textLayout.getAscent() + textLayout.getDescent() + textLayout.getLeading();
        printContext.advancing = (float)((pageFormat.getImageableHeight() - (double)f2) / (double)(this.lines - 1));
        return true;
    }
}

