/*
 * Decompiled with CFR 0.152.
 */
package com.iscobol.rts.print;

import com.iscobol.gui.GuiFactory;
import com.iscobol.rts.HandlesManager;
import com.iscobol.rts.print.PageColumn;
import com.iscobol.rts.print.PrintCommand;
import com.iscobol.rts.print.PrintContext;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.print.PageFormat;
import java.io.IOException;
import java.io.RandomAccessFile;

public class SetPageColumns
extends PrintCommand {
    private PageColumn[] myCols;

    public SetPageColumns(GuiFactory guiFactory, HandlesManager handlesManager, PageColumn[] pageColumnArray, boolean bl, double d2, double d3, double d4, Font font, int n2, char c2, boolean bl2) {
        super(guiFactory, 9);
        int n3;
        int n4 = pageColumnArray == null ? 0 : pageColumnArray.length;
        for (n3 = 0; n3 < n4 && ((double)pageColumnArray[n3].getStart() != d2 || pageColumnArray[n3].getUnit() != n2); ++n3) {
        }
        if (n3 == n4) {
            this.myCols = new PageColumn[n4 + 1];
            for (int i2 = 0; i2 < n4; ++i2) {
                this.myCols[i2] = pageColumnArray[i2];
            }
            this.myCols[n4] = new PageColumn(guiFactory, handlesManager, bl, (float)d2, (float)d3, (float)d4, font, n2, c2, bl2);
        } else {
            this.myCols = new PageColumn[n4];
            for (int i3 = 0; i3 < n4; ++i3) {
                this.myCols[i3] = pageColumnArray[i3];
            }
            this.myCols[n3] = new PageColumn(guiFactory, handlesManager, bl, (float)d2, (float)d3, (float)d4, font, n2, c2, bl2);
        }
    }

    public SetPageColumns(GuiFactory guiFactory) {
        super(guiFactory, 9);
        this.myCols = null;
    }

    public SetPageColumns(GuiFactory guiFactory, HandlesManager handlesManager, RandomAccessFile randomAccessFile) throws IOException {
        super(guiFactory, 9);
        int n2 = randomAccessFile.readInt();
        if (n2 >= 0) {
            this.myCols = new PageColumn[n2];
            for (int i2 = 0; i2 < this.myCols.length; ++i2) {
                this.myCols[i2] = new PageColumn(guiFactory, handlesManager, randomAccessFile);
            }
        }
    }

    @Override
    void toFile(RandomAccessFile randomAccessFile) throws IOException {
        if (this.myCols != null) {
            randomAccessFile.writeInt(this.myCols.length);
            for (int i2 = 0; i2 < this.myCols.length; ++i2) {
                this.myCols[i2].toFile(randomAccessFile);
            }
        } else {
            randomAccessFile.writeInt(-1);
        }
    }

    public PageColumn get(int n2) {
        if (n2 >= 0 && n2 < this.myCols.length) {
            return this.myCols[n2];
        }
        return null;
    }

    @Override
    public boolean testPrint(PrintContext printContext, Graphics2D graphics2D, PageFormat pageFormat) {
        return this.print(printContext, graphics2D, pageFormat);
    }

    @Override
    public boolean print(PrintContext printContext, Graphics2D graphics2D, PageFormat pageFormat) {
        printContext.pgCols = this.getCols();
        return true;
    }

    PageColumn[] getCols() {
        PageColumn[] pageColumnArray;
        if (this.myCols != null) {
            pageColumnArray = new PageColumn[this.myCols.length];
            System.arraycopy(this.myCols, 0, pageColumnArray, 0, this.myCols.length);
        } else {
            pageColumnArray = null;
        }
        return pageColumnArray;
    }
}

